"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageData = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _synopsis = require("../synopsis");
var _ui_metric = require("../../lib/ui_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/kibana_overview/public/components/manage_data/manage_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ManageData = ({
  addBasePath,
  features
}) => {
  const {
    services: {
      application
    }
  } = (0, _public.useKibana)();
  const minBreakpointM = (0, _eui.useEuiMinBreakpoint)('m');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, features.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl",
    "aria-hidden": "true",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 30
    }
  }) : null, features.length > 0 ? /*#__PURE__*/_react.default.createElement("section", {
    className: "kbnOverviewDataManage",
    "aria-labelledby": "kbnOverviewDataManage__title",
    "data-test-subj": "kbnOverviewDataManage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "kbnOverviewDataManage__title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibanaOverview.manageData.sectionTitle",
    defaultMessage: "Manage your data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, features.map(feature => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: feature.id,
    css: ({
      euiTheme
    }) => (0, _react2.css)({
      ':not(:only-child)': {
        [minBreakpointM]: {
          flex: `0 0 calc(50% - ${euiTheme.size.l})`
        }
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_synopsis.Synopsis, {
    id: feature.id,
    description: feature.description,
    iconType: feature.icon,
    title: feature.title,
    url: addBasePath(feature.path),
    wrapInPanel: true,
    onClick: () => {
      (0, _ui_metric.trackUiMetric)(_ui_metric.METRIC_TYPE.CLICK, `ingest_data_card_${feature.id}`);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 19
    }
  })))))) : null);
};
exports.ManageData = ManageData;
ManageData.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  features: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    title: _propTypes.default.string.isRequired,
    description: _propTypes.default.string.isRequired,
    icon: _propTypes.default.string.isRequired,
    path: _propTypes.default.string.isRequired,
    showOnHomePage: _propTypes.default.bool.isRequired,
    category: _propTypes.default.string.isRequired,
    order: _propTypes.default.number
  }).isRequired).isRequired
};