"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptsServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _orchestrator = require("./orchestrator");
var _saved_objects = require("./saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InterceptsServerPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "interceptsOrchestrator", void 0);
    this.initContext = initContext;
    this.logger = initContext.logger.get();
    this.config = initContext.config.get();
    if (this.config.enabled && initContext.node.roles.ui) {
      this.interceptsOrchestrator = new _orchestrator.InterceptsTriggerOrchestrator();
    }
  }
  setup(core, {
    usageCollection
  }) {
    var _this$interceptsOrche;
    // Always register saved objects unconditionally to ensure mappings are created
    // during setup, regardless of plugin configuration or node roles
    core.savedObjects.registerType(_saved_objects.interceptTriggerRecordSavedObject);
    core.savedObjects.registerType(_saved_objects.interceptInteractionUserRecordSavedObject);
    (_this$interceptsOrche = this.interceptsOrchestrator) === null || _this$interceptsOrche === void 0 ? void 0 : _this$interceptsOrche.setup(core, {
      logger: this.logger,
      kibanaVersion: this.initContext.env.packageInfo.version,
      usageCollection
    });
    return {};
  }
  start(core) {
    var _this$interceptsOrche2;
    const interceptOrchestratorStart = (_this$interceptsOrche2 = this.interceptsOrchestrator) === null || _this$interceptsOrche2 === void 0 ? void 0 : _this$interceptsOrche2.start(core);
    return {
      registerTriggerDefinition: interceptOrchestratorStart === null || interceptOrchestratorStart === void 0 ? void 0 : interceptOrchestratorStart.registerTriggerDefinition.bind(interceptOrchestratorStart)
    };
  }
  stop() {}
}
exports.InterceptsServerPlugin = InterceptsServerPlugin;