"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.styles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTERCEPT_ILLUSTRATION_WIDTH = 89; // Magic number was provided by Ryan

const styles = (euiTheme, staticAssetsHelper) => ({
  wrapper: (0, _react.css)`
    position: fixed;
    inline-size: 400px;
    max-block-size: auto;
    z-index: ${euiTheme.levels.toast};
    inset-inline-end: ${euiTheme.size.l};
    inset-block-end: ${euiTheme.size.xxl};

    ${_eui.euiCanAnimate} {
      animation: ${_eui.euiFlyoutSlideInRight} ${euiTheme.animation.normal}
        ${euiTheme.animation.resistance};
    }
  `,
  stepContentBox: (0, _react.css)`
    min-height: 112px;
    position: relative;
  `,
  startIllustration: (0, _react.css)`
    background: var(
      --intercept-background,
      url(${staticAssetsHelper.getPluginAssetHref('communication.svg')})
    );
    background-size: ${INTERCEPT_ILLUSTRATION_WIDTH}px 64px;
    background-repeat: no-repeat;
    background-position: top ${euiTheme.size.base} right ${euiTheme.size.base};
  `,
  startContentBox: (0, _react.css)({
    width: `calc(100% - ${INTERCEPT_ILLUSTRATION_WIDTH}px - ${euiTheme.size.base})`
  }),
  stepFooterBox: (0, _react.css)`
    border-top: ${euiTheme.border.thin};
  `
});
exports.styles = styles;