"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _full_screen_bg_css = require("@kbn/css-utils/public/full_screen_bg_css");
var _i18nReact = require("@kbn/i18n-react");
var _cluster_address_form = require("./cluster_address_form");
var _cluster_configuration_form = require("./cluster_configuration_form");
var _enrollment_token_form = require("./enrollment_token_form");
var _progress_indicator = require("./progress_indicator");
var _use_kibana = require("./use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/interactive_setup/public/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const App = ({
  onSuccess
}) => {
  const [page, setPage] = (0, _react2.useState)('token');
  const [cluster, setCluster] = (0, _react2.useState)();
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const state = (0, _useAsync.default)(() => http.get('/internal/interactive_setup/status'), [http]);
  const kbnFullScreenBgCss = (0, _full_screen_bg_css.useKbnFullScreenBgCss)();
  const theme = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = theme;
  const euiShadowM = (0, _eui.useEuiShadow)('m');
  if (state.loading) {
    return null;
  }
  if (!state.value || state.value.connectionStatus === 'configured' || !state.value.isSetupOnHold) {
    return /*#__PURE__*/_react2.default.createElement("pre", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "interactiveSetup.app.notReady",
      defaultMessage: "Kibana server is not ready yet.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: kbnFullScreenBgCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("header", {
    css: (0, _react.css)`
          position: relative;
          z-index: 10;
          padding: ${euiTheme.size.xl};
          text-align: center;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
            margin-bottom: ${euiTheme.size.xl};
            display: inline-block;
            ${euiShadowM};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "logoElastic",
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "interactiveSetup.app.pageTitle",
    defaultMessage: "Configure Elastic to get started",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          position: relative;
          z-index: 10;
          margin: auto;
          margin-bottom: ${euiTheme.size.xl};
          max-width: calc(${euiTheme.breakpoint.s}px - ${euiTheme.size.xl});
          padding-left: ${euiTheme.size.xl};
          padding-right: ${euiTheme.size.xl};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    hidden: page !== 'token',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_enrollment_token_form.EnrollmentTokenForm, {
    onCancel: () => setPage('manual'),
    onSuccess: () => setPage('success'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement("div", {
    hidden: page !== 'manual',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, cluster ? /*#__PURE__*/_react2.default.createElement(_cluster_configuration_form.ClusterConfigurationForm, (0, _extends2.default)({
    onCancel: () => setCluster(undefined),
    onSuccess: () => setPage('success')
  }, cluster, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react2.default.createElement(_cluster_address_form.ClusterAddressForm, {
    onCancel: () => setPage('token'),
    onSuccess: (result, values) => setCluster({
      host: values.host,
      authRequired: result.authRequired,
      certificateChain: result.certificateChain
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  })), page === 'success' && /*#__PURE__*/_react2.default.createElement(_progress_indicator.ProgressIndicator, {
    onSuccess: onSuccess,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 34
    }
  }))));
};
exports.App = App;