"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeownersList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/inspect_component/public/components/inspect/flyout/data_section/codeowners_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const CodeownersList = ({
  codeowners
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (codeowners.length === 0) {
    return null;
  }
  const listItems = codeowners.map(codeowner => ({
    label: codeowner,
    size: 's',
    href: `https://github.com/orgs/elastic/teams/${codeowner.slice('@elastic/'.length)}`,
    target: '_blank',
    css: (0, _react2.css)`
      margin-left: -${euiTheme.size.s};
    `
  }));
  const boldTextCss = (0, _react2.css)`
    font-weight: ${euiTheme.font.weight.bold};
  `;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: boldTextCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kbnInspectComponent.inspectFlyout.dataSection.codeownersTitle",
    defaultMessage: "Codeowners:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: listItems,
    color: "primary",
    size: "s",
    flush: true,
    "data-test-subj": "inspectFlyoutCodeownersList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
};
exports.CodeownersList = CodeownersList;