"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inputControlDeprecationBadge = void 0;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/visualizations-plugin/public");
var _rxjs = require("rxjs");
var _input_control_vis_type = require("./input_control_vis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACTION_DEPRECATION_BADGE = 'ACTION_INPUT_CONTROL_DEPRECATION_BADGE';
const isApiCompatible = api => Boolean((0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _public.apiHasVisualizeConfig)(api));
const compatibilityCheck = api => {
  return isApiCompatible(api) && (0, _presentationPublishing.getInheritedViewMode)(api) === 'edit' && api.getVis().type.name === _input_control_vis_type.INPUT_CONTROL_VIS_TYPE;
};
const inputControlDeprecationBadge = exports.inputControlDeprecationBadge = {
  id: ACTION_DEPRECATION_BADGE,
  type: ACTION_DEPRECATION_BADGE,
  disabled: true,
  getDisplayName: () => _i18n.i18n.translate('inputControl.deprecationBadgeAction.deprecationBadgeLabel', {
    defaultMessage: 'Deprecated'
  }),
  getIconType: () => 'warning',
  getDisplayNameTooltip: () => _i18n.i18n.translate('inputControl.deprecationBadgeAction.deprecationWarningDescription', {
    defaultMessage: 'Input controls are deprecated and will be removed in a future release. Use the new Controls to filter and interact with your dashboard data.'
  }),
  isCompatible: async ({
    embeddable
  }) => {
    return compatibilityCheck(embeddable);
  },
  couldBecomeCompatible: ({
    embeddable
  }) => {
    return isApiCompatible(embeddable) && embeddable.getVis().type.name === _input_control_vis_type.INPUT_CONTROL_VIS_TYPE;
  },
  getCompatibilityChangesSubject: ({
    embeddable
  }) => {
    var _getViewModeSubject;
    return isApiCompatible(embeddable) ? (_getViewModeSubject = (0, _presentationPublishing.getViewModeSubject)(embeddable)) === null || _getViewModeSubject === void 0 ? void 0 : _getViewModeSubject.pipe((0, _rxjs.map)(() => undefined)) : undefined;
  },
  execute: async () => {
    // do nothing
  }
};