"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CSV = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../../shared_imports");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _field_name_field = require("./common_fields/field_name_field");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/csv.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  minLengthField
} = _shared_imports.fieldValidators;

/**
 * Allow empty strings ('') to pass this validation.
 */
const isStringLengthOne = ({
  value
}) => {
  return typeof value === 'string' && value !== '' && value.length !== 1 ? {
    message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.separatorLengthError', {
      defaultMessage: 'Must be a single character.'
    })
  } : undefined;
};
const fieldsConfig = {
  /* Required fields config */
  target_fields: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.csvForm.targetFieldsFieldLabel', {
      defaultMessage: 'Target fields'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.csvForm.targetFieldsHelpText', {
      defaultMessage: 'Output fields. Extracted values are mapped to these fields.'
    }),
    validations: [{
      validator: minLengthField({
        length: 1,
        message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.csvForm.targetFieldRequiredError', {
          defaultMessage: 'A target fields value is required.'
        })
      })
    }]
  },
  /* Optional fields config */
  separator: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.separatorFieldLabel', {
      defaultMessage: 'Separator (optional)'
    }),
    validations: [{
      validator: isStringLengthOne
    }],
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.convertForm.separatorHelpText",
      defaultMessage: "Delimiter used in the CSV data. Defaults to {value}.",
      values: {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 26
          }
        }, ',')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    })
  },
  quote: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.quoteFieldLabel', {
      defaultMessage: 'Quote (optional)'
    }),
    validations: [{
      validator: isStringLengthOne
    }],
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.convertForm.quoteHelpText",
      defaultMessage: "Escape character used in the CSV data. Defaults to {value}.",
      values: {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 26
          }
        }, '"')
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    })
  },
  trim: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.csvForm.trimFieldLabel', {
      defaultMessage: 'Trim'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.csvForm.trimFieldHelpText', {
      defaultMessage: 'Remove whitespaces in unquoted CSV data.'
    })
  },
  empty_value: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.emptyValueFieldLabel', {
      defaultMessage: 'Empty value (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.convertForm.emptyValueFieldHelpText', {
      defaultMessage: 'Used to fill empty fields. If no value is provided, empty fields are skipped.'
    })
  }
};
const CSV = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.csvForm.fieldNameHelpText', {
      defaultMessage: 'Field containing CSV data.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.target_fields,
    component: _shared_imports.ComboBoxField,
    path: "fields.target_fields",
    "data-test-subj": "targetFieldsField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.separator,
    component: _shared_imports.Field,
    path: "fields.separator",
    "data-test-subj": "separatorValueField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.quote,
    component: _shared_imports.Field,
    path: "fields.quote",
    "data-test-subj": "quoteValueField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.trim,
    component: _shared_imports.ToggleField,
    path: "fields.trim",
    "data-test-subj": "trimSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.empty_value,
    component: _shared_imports.Field,
    path: "fields.empty_value",
    "data-test-subj": "emptyValueField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    defaultValue: true,
    serializer: _shared.from.undefinedIfValue(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }));
};
exports.CSV = CSV;