"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorFormContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../shared_imports");
var _edit_processor_form = require("./edit_processor_form");
var _add_processor_form = require("./add_processor_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processor_form.container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formOptions = {
  /**
   * This is important for allowing configuration of empty text fields in certain processors that
   * remove values from their inputs.
   */
  stripEmptyFields: false
};
const ProcessorFormContainer = ({
  processor,
  onFormUpdate,
  onSubmit,
  onClose,
  buttonRef,
  ...rest
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();

  // We need to keep track of the processor form state if the user
  // has made config changes, navigated between tabs (Configuration vs. Output)
  // and has not yet submitted the form
  const unsavedFormState = (0, _react.useRef)();
  const getProcessor = (0, _react.useCallback)(() => {
    let options;
    if (unsavedFormState !== null && unsavedFormState !== void 0 && unsavedFormState.current) {
      options = unsavedFormState.current;
    } else {
      var _processor$options;
      options = (_processor$options = processor === null || processor === void 0 ? void 0 : processor.options) !== null && _processor$options !== void 0 ? _processor$options : {};
    }
    return {
      ...processor,
      options
    };
  }, [processor, unsavedFormState]);
  const formSerializer = (0, _react.useCallback)(formState => {
    return {
      type: formState.type,
      fields: formState.customOptions ? {
        customOptions: formState.customOptions
      } : {
        ...formState.fields,
        // The description field is not editable in processor forms currently. We re-add it here or it will be
        // stripped.
        description: processor ? processor.options.description : undefined
      }
    };
  }, [processor]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      fields: getProcessor().options
    },
    serializer: formSerializer,
    options: formOptions
  });
  const {
    subscribe
  } = form;
  const handleSubmit = (0, _react.useCallback)(async (shouldCloseFlyout = true) => {
    const {
      isValid,
      data
    } = await form.submit();
    if (isValid) {
      const {
        type,
        fields: options
      } = data;
      unsavedFormState.current = options;
      onSubmit({
        type,
        options
      });
      if (shouldCloseFlyout) {
        onClose();
      }
    }
  }, [form, onClose, onSubmit]);
  const resetProcessors = (0, _react.useCallback)(() => {
    onSubmit({
      type: processor.type,
      options: (processor === null || processor === void 0 ? void 0 : processor.options) || {}
    });
  }, [onSubmit, processor]);
  (0, _react.useEffect)(() => {
    const subscription = subscribe(onFormUpdate);
    return subscription.unsubscribe;
  }, [onFormUpdate, subscribe]);
  if (processor) {
    return /*#__PURE__*/_react.default.createElement(_edit_processor_form.EditProcessorForm, (0, _extends2.default)({}, rest, {
      form: form,
      getProcessor: getProcessor,
      esDocsBasePath: services.documentation.getEsDocsBasePath(),
      closeFlyout: onClose,
      resetProcessors: resetProcessors,
      handleSubmit: handleSubmit,
      buttonRef: buttonRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_add_processor_form.AddProcessorForm, (0, _extends2.default)({}, rest, {
    form: form,
    esDocsBasePath: services.documentation.getEsDocsBasePath(),
    closeFlyout: onClose,
    handleSubmit: handleSubmit,
    buttonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 5
    }
  }));
};
exports.ProcessorFormContainer = ProcessorFormContainer;