"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSnapshotMetricsToMetricsAPIMetrics = void 0;
var _lodash = require("lodash");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _http_api = require("../../../../common/http_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformSnapshotMetricsToMetricsAPIMetrics = async snapshotRequest => {
  const inventoryModel = (0, _common.findInventoryModel)(snapshotRequest.nodeType);
  const aggregations = await inventoryModel.metrics.getAggregations({
    schema: snapshotRequest.schema
  });
  return snapshotRequest.metrics.map((metric, index) => {
    const aggregation = aggregations.get(metric.type);
    if (_http_api.SnapshotCustomMetricInputRT.is(metric)) {
      const isUniqueId = snapshotRequest.metrics.findIndex(m => _http_api.SnapshotCustomMetricInputRT.is(m) ? m.id === metric.id : false);
      const customId = isUniqueId ? metric.id : `custom_${index}`;
      if (metric.aggregation === 'rate') {
        return {
          id: customId,
          aggregations: (0, _common.networkTraffic)(customId, metric.field)
        };
      }
      return {
        id: customId,
        aggregations: {
          [customId]: {
            [metric.aggregation]: {
              field: metric.field
            }
          }
        }
      };
    }
    return {
      id: metric.type,
      aggregations: aggregation
    };
  }).filter(_lodash.identity);
};
exports.transformSnapshotMetricsToMetricsAPIMetrics = transformSnapshotMetricsToMetricsAPIMetrics;