"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSearchClient = void 0;
var _ui_settings_keys = require("@kbn/observability-plugin/common/ui_settings_keys");
var _exclude_tiers_query = require("@kbn/observability-utils-common/es/queries/exclude_tiers_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSearchClient = (requestContext, framework, request) => async opts => {
  var _opts$body, _opts$body2, _opts$body3;
  const {
    uiSettings
  } = await requestContext.core;
  const excludedDataTiers = await uiSettings.client.get(_ui_settings_keys.searchExcludedDataTiers);
  const excludedQuery = excludedDataTiers.length ? (0, _exclude_tiers_query.excludeTiersQuery)(excludedDataTiers) : undefined;
  return framework.callWithRequest(requestContext, 'search', {
    ...opts,
    body: {
      ...((_opts$body = opts.body) !== null && _opts$body !== void 0 ? _opts$body : {}),
      query: {
        bool: {
          ...((_opts$body2 = opts.body) !== null && _opts$body2 !== void 0 && _opts$body2.query ? {
            must: [(_opts$body3 = opts.body) === null || _opts$body3 === void 0 ? void 0 : _opts$body3.query]
          } : {}),
          filter: excludedQuery
        }
      }
    }
  }, request);
};
exports.createSearchClient = createSearchClient;