"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestPartialDataSearchResponse = void 0;
var _rxjs = require("rxjs");
var _use_observable = require("../../hooks/use_observable");
var _flatten_data_search_response = require("./flatten_data_search_response");
var _use_data_search_response_state = require("./use_data_search_response_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLatestPartialDataSearchResponse = requests$ => {
  const latestResponse$ = (0, _use_observable.useOperator)(requests$, flattenLatestDataSearchResponse);
  const {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    latestResponseData,
    latestResponseErrors,
    loaded,
    total
  } = (0, _use_data_search_response_state.useDataSearchResponseState)(latestResponse$);
  return {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    latestResponseData,
    latestResponseErrors,
    loaded,
    total
  };
};
exports.useLatestPartialDataSearchResponse = useLatestPartialDataSearchResponse;
const flattenLatestDataSearchResponse = (0, _rxjs.switchMap)(_flatten_data_search_response.flattenDataSearchResponseDescriptor);