"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _ebtTools = require("@kbn/ebt-tools");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Client which aggregate all the available telemetry tracking functions
 * for the Infra plugin
 */
class TelemetryClient {
  constructor(analytics) {
    (0, _defineProperty2.default)(this, "reportHostEntryClicked", ({
      hostname,
      cloud_provider: cloudProvider
    }) => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOSTS_ENTRY_CLICKED, {
        hostname,
        cloud_provider: cloudProvider !== null && cloudProvider !== void 0 ? cloudProvider : 'unknown'
      });
    });
    (0, _defineProperty2.default)(this, "reportHostFlyoutFilterRemoved", ({
      field_name: fieldName
    }) => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOST_FLYOUT_FILTER_REMOVED, {
        field_name: fieldName
      });
    });
    (0, _defineProperty2.default)(this, "reportHostFlyoutFilterAdded", ({
      field_name: fieldName
    }) => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOST_FLYOUT_FILTER_ADDED, {
        field_name: fieldName
      });
    });
    (0, _defineProperty2.default)(this, "reportHostsViewQuerySubmitted", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOSTS_VIEW_QUERY_SUBMITTED, params);
    });
    (0, _defineProperty2.default)(this, "reportAssetDetailsFlyoutViewed", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ASSET_DETAILS_FLYOUT_VIEWED, params);
    });
    (0, _defineProperty2.default)(this, "reportAssetDetailsPageViewed", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ASSET_DETAILS_PAGE_VIEWED, params);
    });
    (0, _defineProperty2.default)(this, "reportAssetDashboardLoaded", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ASSET_DASHBOARD_LOADED, params);
    });
    (0, _defineProperty2.default)(this, "reportPerformanceMetricEvent", (eventName, duration, innerEvents = {}, meta = {}) => {
      (0, _ebtTools.reportPerformanceMetricEvent)(this.analytics, {
        eventName,
        duration,
        meta,
        ...innerEvents
      });
    });
    (0, _defineProperty2.default)(this, "reportAddMetricsCalloutAddMetricsClicked", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ADD_METRICS_CALLOUT_ADD_METRICS_CLICKED, params);
    });
    (0, _defineProperty2.default)(this, "reportAddMetricsCalloutTryItClicked", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ADD_METRICS_CALLOUT_TRY_IT_CLICKED, params);
    });
    (0, _defineProperty2.default)(this, "reportAddMetricsCalloutLearnMoreClicked", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ADD_METRICS_CALLOUT_LEARN_MORE_CLICKED, params);
    });
    (0, _defineProperty2.default)(this, "reportAddMetricsCalloutDismissed", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ADD_METRICS_CALLOUT_DISMISSED, params);
    });
    (0, _defineProperty2.default)(this, "reportAnomalyDetectionSetup", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ANOMALY_DETECTION_SETUP, params);
    });
    (0, _defineProperty2.default)(this, "reportAnomalyDetectionDateFieldChange", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ANOMALY_DETECTION_DATE_FIELD_CHANGE, params);
    });
    (0, _defineProperty2.default)(this, "reportAnomalyDetectionPartitionFieldChange", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ANOMALY_DETECTION_PARTITION_FIELD_CHANGE, params);
    });
    (0, _defineProperty2.default)(this, "reportAnomalyDetectionFilterFieldChange", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.ANOMALY_DETECTION_FILTER_FIELD_CHANGE, params);
    });
    (0, _defineProperty2.default)(this, "reportSchemaSelectorInteraction", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.SCHEMA_SELECTOR_INTERACTION, params);
    });
    (0, _defineProperty2.default)(this, "reportMetricsExplorerCalloutViewInDiscoverClicked", params => {
      this.analytics.reportEvent(_types.InfraTelemetryEventTypes.METRICS_EXPLORER_CALLOUT_VIEW_IN_DISCOVER_CLICKED, params);
    });
    this.analytics = analytics;
  }
  reportHostsViewTotalHostCountRetrieved(params) {
    this.analytics.reportEvent(_types.InfraTelemetryEventTypes.HOST_VIEW_TOTAL_HOST_COUNT_RETRIEVED, params);
  }
}
exports.TelemetryClient = TelemetryClient;