"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaffleTimeContext = exports.useWaffleTime = exports.WaffleTimeStateRT = exports.WaffleTimeProvider = exports.WaffleTime = exports.DEFAULT_WAFFLE_TIME_STATE = void 0;
var _react = require("react");
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/pipeable");
var _Either = require("fp-ts/Either");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _function = require("fp-ts/function");
var _constate = _interopRequireDefault(require("constate"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana_timefilter_time = require("../../../../hooks/use_kibana_timefilter_time");
var _use_inventory_views = require("./use_inventory_views");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_WAFFLE_TIME_STATE = exports.DEFAULT_WAFFLE_TIME_STATE = {
  currentTime: Date.now(),
  isAutoReloading: false
};
function mapInventoryViewToState(savedView, defaultTime) {
  var _ref;
  const {
    time,
    autoReload
  } = savedView.attributes;
  return {
    currentTime: (_ref = time !== null && time !== void 0 ? time : defaultTime === null || defaultTime === void 0 ? void 0 : defaultTime.toDate().getTime()) !== null && _ref !== void 0 ? _ref : Date.now(),
    isAutoReloading: autoReload
  };
}
const useWaffleTime = () => {
  // INFO: We currently only use the "to" time, but in the future we may do more.
  const {
    currentView
  } = (0, _use_inventory_views.useInventoryViewsContext)();
  const [getTime] = (0, _use_kibana_timefilter_time.useKibanaTimefilterTime)({
    from: 'now',
    to: 'now'
  });
  const kibanaTime = _datemath.default.parse(getTime().to);
  const [urlState, setUrlState] = (0, _public.useUrlState)({
    defaultState: currentView ? mapInventoryViewToState(currentView, kibanaTime) : {
      ...DEFAULT_WAFFLE_TIME_STATE,
      currentTime: kibanaTime ? kibanaTime.toDate().getTime() : Date.now()
    },
    decodeUrlState,
    encodeUrlState,
    urlStateKey: 'waffleTime',
    writeDefaultState: true
  });
  const previousViewId = (0, _react.useRef)(currentView === null || currentView === void 0 ? void 0 : currentView.id);
  (0, _react.useEffect)(() => {
    if (currentView && currentView.id !== previousViewId.current) {
      setUrlState(mapInventoryViewToState(currentView));
      previousViewId.current = currentView.id;
    }
  }, [currentView, setUrlState]);
  const startAutoReload = (0, _react.useCallback)(() => {
    setUrlState(previous => ({
      ...previous,
      isAutoReloading: true,
      currentTime: Date.now()
    }));
  }, [setUrlState]);
  const stopAutoReload = (0, _react.useCallback)(() => {
    setUrlState(previous => ({
      ...previous,
      isAutoReloading: false
    }));
  }, [setUrlState]);
  const jumpToTime = (0, _react.useCallback)(time => {
    setUrlState(previous => ({
      ...previous,
      currentTime: time
    }));
  }, [setUrlState]);
  const currentTimeRange = (0, _react.useMemo)(() => ({
    from: urlState.currentTime - 1000 * 60 * 5,
    interval: '1m',
    to: urlState.currentTime
  }), [urlState.currentTime]);
  return {
    ...urlState,
    currentTimeRange,
    startAutoReload,
    stopAutoReload,
    jumpToTime,
    setWaffleTimeState: setUrlState
  };
};
exports.useWaffleTime = useWaffleTime;
const WaffleTimeStateRT = exports.WaffleTimeStateRT = rt.type({
  currentTime: rt.number,
  isAutoReloading: rt.boolean
});
const encodeUrlState = WaffleTimeStateRT.encode;
const decodeUrlState = value => (0, _pipeable.pipe)(WaffleTimeStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
const WaffleTime = exports.WaffleTime = (0, _constate.default)(useWaffleTime);
const [WaffleTimeProvider, useWaffleTimeContext] = WaffleTime;
exports.useWaffleTimeContext = useWaffleTimeContext;
exports.WaffleTimeProvider = WaffleTimeProvider;