"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaffleFiltersContext = exports.useWaffleFilters = exports.WaffleFiltersProvider = exports.WaffleFilters = exports.DEFAULT_WAFFLE_FILTERS_STATE = void 0;
var _esQuery = require("@kbn/es-query");
var _react = require("react");
var _pipeable = require("fp-ts/pipeable");
var _Either = require("fp-ts/Either");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _function = require("fp-ts/function");
var _constate = _interopRequireDefault(require("constate"));
var _public = require("@kbn/observability-shared-plugin/public");
var _rxjs = require("rxjs");
var _use_kibana = require("../../../../hooks/use_kibana");
var _inventory_views = require("../../../../../common/inventory_views");
var _use_alert_prefill = require("../../../../alerting/use_alert_prefill");
var _use_inventory_views = require("./use_inventory_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_WAFFLE_FILTERS_STATE = exports.DEFAULT_WAFFLE_FILTERS_STATE = {
  language: 'kuery',
  query: ''
};
function mapInventoryViewToState(savedView) {
  return {
    language: savedView.attributes.filterQuery.kind,
    query: savedView.attributes.filterQuery.expression
  };
}
const useWaffleFilters = () => {
  const {
    currentView
  } = (0, _use_inventory_views.useInventoryViewsContext)();
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    data: {
      query: {
        queryString: queryStringService
      }
    }
  } = services;
  const {
    inventoryPrefill: {
      setPrefillState
    }
  } = (0, _use_alert_prefill.useAlertPrefillContext)();
  const [urlState, setUrlState] = (0, _public.useUrlState)({
    defaultState: currentView ? mapInventoryViewToState(currentView) : DEFAULT_WAFFLE_FILTERS_STATE,
    decodeUrlState,
    encodeUrlState,
    urlStateKey: 'waffleFilter',
    writeDefaultState: true
  });
  const previousViewId = (0, _react.useRef)(currentView === null || currentView === void 0 ? void 0 : currentView.id);
  const isValidKuery = (0, _react.useCallback)(expression => {
    try {
      (0, _esQuery.fromKueryExpression)(expression);
    } catch (err) {
      return false;
    }
    return true;
  }, []);
  const applyFilterQuery = (0, _react.useCallback)(payload => {
    var _payload$query;
    const kuery = (_payload$query = payload.query) === null || _payload$query === void 0 ? void 0 : _payload$query.query;
    if (payload.query && isValidKuery(kuery)) {
      setUrlState({
        language: payload.query.language,
        query: kuery
      });
    }
  }, [isValidKuery, setUrlState]);
  (0, _react.useEffect)(() => {
    if (currentView && currentView.id !== previousViewId.current) {
      setUrlState(mapInventoryViewToState(currentView));
      previousViewId.current = currentView.id;
    }
  }, [currentView, setUrlState]);

  // sync up the query string service with the URL state
  (0, _react.useEffect)(() => {
    if (!(0, _fastDeepEqual.default)(queryStringService.getQuery(), urlState)) {
      queryStringService.setQuery(urlState);
    }
  }, [queryStringService, urlState]);

  // sync up the URL state with eventual changes made in the kuery bar
  (0, _react.useEffect)(() => {
    const subscription = new _rxjs.Subscription();
    queryStringService.clearQuery();
    subscription.add(queryStringService.getUpdates$().pipe((0, _rxjs.map)(() => queryStringService.getQuery()), (0, _rxjs.tap)(query => applyFilterQuery({
      query
    }))).subscribe());
    return () => {
      subscription.unsubscribe();
    };
  }, [queryStringService, applyFilterQuery]);
  (0, _react.useEffect)(() => {
    setPrefillState({
      kuery: urlState.query
    });
  }, [setPrefillState, urlState.query]);
  return {
    filterQuery: urlState,
    applyFilterQuery,
    setWaffleFiltersState: applyFilterQuery
  };
};
exports.useWaffleFilters = useWaffleFilters;
const encodeUrlState = _inventory_views.inventoryFiltersStateRT.encode;
const decodeUrlState = value => (0, _pipeable.pipe)(_inventory_views.inventoryFiltersStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
const WaffleFilters = exports.WaffleFilters = (0, _constate.default)(useWaffleFilters);
const [WaffleFiltersProvider, useWaffleFiltersContext] = WaffleFilters;
exports.useWaffleFiltersContext = useWaffleFiltersContext;
exports.WaffleFiltersProvider = WaffleFiltersProvider;