"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeline = useTimeline;
var _lodash = require("lodash");
var _react = require("react");
var _get_interval_in_seconds = require("../../../../../common/utils/get_interval_in_seconds");
var _use_snaphot = require("./use_snaphot");
var _use_waffle_options = require("./use_waffle_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_MINUTE = 60;
const ONE_HOUR = ONE_MINUTE * 60;
const ONE_DAY = ONE_HOUR * 24;
const ONE_WEEK = ONE_DAY * 7;
const ONE_MONTH = ONE_DAY * 30;
const getDisplayInterval = interval => {
  if (interval) {
    const intervalInSeconds = (0, _get_interval_in_seconds.getIntervalInSeconds)(interval);
    if (intervalInSeconds < 300) return '5m';
  }
  return interval;
};
const getTimeLengthFromInterval = interval => {
  if (interval) {
    const intervalInSeconds = (0, _get_interval_in_seconds.getIntervalInSeconds)(interval);
    // Get up to 288 datapoints based on interval
    const timeLength = intervalInSeconds <= ONE_MINUTE * 15 ? ONE_DAY : intervalInSeconds <= ONE_MINUTE * 35 ? ONE_DAY * 3 : intervalInSeconds <= ONE_HOUR * 2.5 ? ONE_WEEK : ONE_MONTH;
    return {
      timeLength,
      intervalInSeconds
    };
  } else {
    return {
      timeLength: 0,
      intervalInSeconds: 0
    };
  }
};
function useTimeline({
  kuery,
  metrics,
  nodeType,
  sourceId,
  currentTime,
  accountId,
  region,
  interval,
  shouldReload
}) {
  const {
    preferredSchema
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const displayInterval = (0, _react.useMemo)(() => getDisplayInterval(interval), [interval]);
  const timeLengthResult = (0, _react.useMemo)(() => getTimeLengthFromInterval(displayInterval), [displayInterval]);
  const {
    timeLength,
    intervalInSeconds
  } = timeLengthResult;
  const endTime = currentTime + intervalInSeconds * 1000;
  const startTime = currentTime - timeLength * 1000;
  const timerange = {
    interval: displayInterval !== null && displayInterval !== void 0 ? displayInterval : '',
    to: endTime,
    from: startTime,
    forceInterval: true
  };
  const {
    nodes,
    error,
    loading,
    reload
  } = (0, _use_snaphot.useSnapshot)({
    metrics,
    groupBy: null,
    currentTime,
    nodeType,
    timerange,
    kuery,
    sourceId,
    accountId,
    region,
    includeTimeseries: true,
    schema: preferredSchema
  }, {
    sendRequestImmediately: false
  });
  (0, _react.useEffect)(() => {
    if (shouldReload) {
      reload();
    }
  }, [reload, shouldReload]);
  const timeseries = nodes ? (0, _lodash.first)(nodes.map(node => {
    var _first;
    return (_first = (0, _lodash.first)(node.metrics)) === null || _first === void 0 ? void 0 : _first.timeseries;
  })) : null;
  return {
    error: error || null,
    loading: !interval ? true : loading,
    timeseries,
    startTime,
    endTime,
    reload
  };
}