"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupOfNodes = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _group_name = require("./group_name");
var _node = require("./node");
var _use_asset_details_flyout_url_state = require("../../hooks/use_asset_details_flyout_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/group_of_nodes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// custom comparison function for rendering the nodes to prevent unncessary rerendering
const isEqualGroupOfNodes = (prevProps, nextProps) => {
  const {
    bounds: prevBounds,
    group: prevGroup,
    ...prevPropsToCompare
  } = prevProps;
  const {
    bounds: nextBounds,
    group: nextGroup,
    ...nextPropsToCompare
  } = nextProps;
  const {
    nodes: prevNodes,
    ...prevGroupToCompare
  } = prevProps.group;
  const {
    nodes: nextNodes,
    ...nextGroupToCompare
  } = nextProps.group;
  return (0, _lodash.isEqual)(prevPropsToCompare, nextPropsToCompare) && (0, _lodash.isEqual)(prevGroupToCompare, nextGroupToCompare);
};
const GroupOfNodes = exports.GroupOfNodes = /*#__PURE__*/_react.default.memo(({
  group,
  options,
  formatter,
  onDrilldown,
  isChild = false,
  bounds,
  nodeType,
  currentTime,
  detailsItemId
}) => {
  const width = group.width > 200 ? group.width : 200;
  const [_, setFlyoutUrlState] = (0, _use_asset_details_flyout_url_state.useAssetDetailsFlyoutState)();
  return /*#__PURE__*/_react.default.createElement(GroupOfNodesContainer, {
    style: {
      width
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_group_name.GroupName, {
    group: group,
    onDrilldown: onDrilldown,
    isChild: isChild,
    options: options,
    nodeType: nodeType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(Nodes, {
    role: "list",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, group.width ? group.nodes.map(node => /*#__PURE__*/_react.default.createElement(_node.Node, {
    key: `${node.pathId}:${node.name}`,
    options: options,
    squareSize: group.squareSize,
    node: node,
    formatter: formatter,
    bounds: bounds,
    nodeType: nodeType,
    currentTime: currentTime,
    detailsItemId: detailsItemId,
    setFlyoutUrlState: setFlyoutUrlState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  })));
}, isEqualGroupOfNodes);
const GroupOfNodesContainer = _styled.default.div`
  margin: 0 10px;
`;
const Nodes = _styled.default.div`
  display: flex;
  background-color: rgba(0, 0, 0, 0.05);
  flex-wrap: wrap;
  justify-content: center;
  padding: 20px 10px 10px;
  border-radius: 4px;
  border: 1px solid ${props => props.theme.euiTheme.border.color};
  box-shadow: 0 1px 7px rgba(0, 0, 0, 0.1);
`;