"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostCountKpi = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/metrics-data-access-plugin/common");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _eui = require("@elastic/eui");
var _visualizations = require("../../../../../common/visualizations");
var _use_host_count = require("../../hooks/use_host_count");
var _use_unified_search = require("../../hooks/use_unified_search");
var _metric_chart_wrapper = require("../chart/metric_chart_wrapper");
var _lens = require("../../../../../components/lens");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/hosts/components/kpis/host_count_kpi.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HostCountKpi = () => {
  const inventoryModel = (0, _common.findInventoryModel)('host');
  const {
    count,
    loading
  } = (0, _use_host_count.useHostCountContext)();
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    value: formulas
  } = (0, _useAsync.default)(() => inventoryModel.metrics.getFormulas());
  const hostsCountChart = {
    id: 'hostsViewKPI-hostsCount',
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.hostCount.title', {
      defaultMessage: 'Hosts'
    })
  };
  const subtitle = searchCriteria.limit < count ? _i18n.i18n.translate('xpack.infra.hostsViewPage.kpi.subtitle.hostCount.limit', {
    defaultMessage: 'Limited to {limit}',
    values: {
      limit: searchCriteria.limit
    }
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_metric_chart_wrapper.MetricChartWrapper, (0, _extends2.default)({}, hostsCountChart, {
    style: {
      height: _visualizations.KPI_CHART_HEIGHT
    },
    value: count,
    subtitle: subtitle,
    toolTip: /*#__PURE__*/_react.default.createElement(_lens.TooltipContent, {
      formula: formulas === null || formulas === void 0 ? void 0 : formulas.get('hostCount').value,
      description: _visualizations.METRICS_TOOLTIP.hostCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }),
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }));
};
exports.HostCountKpi = HostCountKpi;