"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryCategoriesResults = void 0;
var _react = require("react");
var _use_tracked_promise = require("../../../hooks/use_tracked_promise");
var _get_top_log_entry_categories = require("./service_calls/get_top_log_entry_categories");
var _get_log_entry_category_datasets = require("./service_calls/get_log_entry_category_datasets");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryCategoriesResults = ({
  categoriesCount,
  filteredDatasets: filteredDatasets,
  endTime,
  onGetLogEntryCategoryDatasetsError,
  onGetTopLogEntryCategoriesError,
  logViewReference,
  idFormat,
  startTime
}) => {
  const [sortOptions, setSortOptions] = (0, _react.useState)({
    field: 'maximumAnomalyScore',
    direction: 'desc'
  });
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [topLogEntryCategories, setTopLogEntryCategories] = (0, _react.useState)([]);
  const [logEntryCategoryDatasets, setLogEntryCategoryDatasets] = (0, _react.useState)([]);
  const [getTopLogEntryCategoriesRequest, getTopLogEntryCategories] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      return await (0, _get_top_log_entry_categories.callGetTopLogEntryCategoriesAPI)({
        logViewReference,
        idFormat,
        startTime,
        endTime,
        categoryCount: categoriesCount,
        datasets: filteredDatasets,
        sort: sortOptions
      }, services.http.fetch);
    },
    onResolve: ({
      data: {
        categories
      }
    }) => {
      setTopLogEntryCategories(categories);
    },
    onReject: error => {
      if (error instanceof Error && !(error instanceof _use_tracked_promise.CanceledPromiseError) && onGetTopLogEntryCategoriesError) {
        onGetTopLogEntryCategoriesError(error);
      }
    }
  }, [categoriesCount, endTime, filteredDatasets, logViewReference.logViewId, startTime, sortOptions, idFormat]);
  const [getLogEntryCategoryDatasetsRequest, getLogEntryCategoryDatasets] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      return await (0, _get_log_entry_category_datasets.callGetLogEntryCategoryDatasetsAPI)({
        logViewReference,
        idFormat,
        startTime,
        endTime
      }, services.http.fetch);
    },
    onResolve: ({
      data: {
        datasets
      }
    }) => {
      setLogEntryCategoryDatasets(datasets);
    },
    onReject: error => {
      if (error instanceof Error && !(error instanceof _use_tracked_promise.CanceledPromiseError) && onGetLogEntryCategoryDatasetsError) {
        onGetLogEntryCategoryDatasetsError(error);
      }
    }
  }, [categoriesCount, endTime, logViewReference.logViewId, idFormat, startTime]);
  const isLoadingTopLogEntryCategories = (0, _react.useMemo)(() => getTopLogEntryCategoriesRequest.state === 'pending', [getTopLogEntryCategoriesRequest.state]);
  const isLoadingLogEntryCategoryDatasets = (0, _react.useMemo)(() => getLogEntryCategoryDatasetsRequest.state === 'pending', [getLogEntryCategoryDatasetsRequest.state]);
  const isLoading = (0, _react.useMemo)(() => isLoadingTopLogEntryCategories || isLoadingLogEntryCategoryDatasets, [isLoadingLogEntryCategoryDatasets, isLoadingTopLogEntryCategories]);
  return {
    getLogEntryCategoryDatasets,
    getTopLogEntryCategories,
    isLoading,
    isLoadingLogEntryCategoryDatasets,
    isLoadingTopLogEntryCategories,
    logEntryCategoryDatasets,
    topLogEntryCategories,
    sortOptions,
    changeSortOptions: setSortOptions
  };
};
exports.useLogEntryCategoriesResults = useLogEntryCategoriesResults;