"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeRangeMetadataContext = exports.useTimeRangeMetadata = exports.TimeRangeMetadataProvider = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _get_has_data = require("../../common/metrics_sources/get_has_data");
var _use_fetcher = require("./use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimeRangeMetadata = ({
  dataSource,
  kuery,
  filters,
  start,
  end,
  isInventoryView = false
}) => {
  const {
    data,
    refetch,
    status
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/metrics/source/time_range_metadata', {
      method: 'GET',
      query: {
        from: start,
        to: end,
        kuery,
        dataSource,
        filters,
        isInventoryView
      }
    });
    return (0, _ioTsUtils.decodeOrThrow)(_get_has_data.getTimeRangeMetadataResponseRT)(response);
  }, [start, end, kuery, filters, dataSource, isInventoryView], {
    reloadRequestTimeUpdateEnabled: false
  });
  (0, _react.useEffect)(() => {
    refetch();
  }, [refetch]);
  return {
    data,
    status
  };
};
exports.useTimeRangeMetadata = useTimeRangeMetadata;
const [TimeRangeMetadataProvider, useTimeRangeMetadataContext] = (0, _constate.default)(useTimeRangeMetadata);
exports.useTimeRangeMetadataContext = useTimeRangeMetadataContext;
exports.TimeRangeMetadataProvider = TimeRangeMetadataProvider;