"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMetricsBreadcrumbs = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../common/constants");
var _translations = require("../translations");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMetricsBreadcrumbs = extraCrumbs => {
  const {
    services: {
      serverless
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const appLinkProps = (0, _public.useLinkProps)({
    app: _constants.METRICS_APP
  });
  const breadcrumbs = [{
    ...appLinkProps,
    text: _translations.metricsTitle
  }, ...extraCrumbs];
  (0, _public.useBreadcrumbs)(breadcrumbs, {
    serverless
  });
};
exports.useMetricsBreadcrumbs = useMetricsBreadcrumbs;