"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKubernetesDashboardPromotion = void 0;
var _react = require("react");
var _use_installed_integration = require("./use_installed_integration");
var _use_time_range_metadata = require("./use_time_range_metadata");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKubernetesDashboardPromotion = nodeType => {
  const {
    data: timeRangeMetadata
  } = (0, _use_time_range_metadata.useTimeRangeMetadataContext)();
  const schemas = (0, _react.useMemo)(() => (timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas) || [], [timeRangeMetadata === null || timeRangeMetadata === void 0 ? void 0 : timeRangeMetadata.schemas]);
  const isPodNodeType = nodeType === 'pod';
  const hasEcsSchema = schemas.includes('ecs');
  const hasSemconvSchema = schemas.includes('semconv');
  const {
    isInstalled: hasEcsK8sIntegration,
    isLoading: isEcsLoading
  } = (0, _use_installed_integration.useInstalledIntegration)('kubernetes', isPodNodeType && hasEcsSchema);
  const {
    isInstalled: hasSemconvK8sIntegration,
    isLoading: isSemconvLoading
  } = (0, _use_installed_integration.useInstalledIntegration)('kubernetes_otel', isPodNodeType && hasSemconvSchema);
  return {
    hasEcsSchema,
    hasSemconvSchema,
    hasEcsK8sIntegration,
    hasSemconvK8sIntegration,
    isLoading: isEcsLoading || isSemconvLoading
  };
};
exports.useKubernetesDashboardPromotion = useKubernetesDashboardPromotion;