"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInstalledIntegration = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _use_kibana = require("./use_kibana");
var _use_fetcher = require("./use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInstalledIntegration = (packageName, enabled = true) => {
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    data,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(async () => {
    if (!enabled) {
      return undefined;
    }
    const response = await http.get(_common.epmRouteService.getInfoPath(packageName), {
      version: _common.API_VERSIONS.public.v1
    });
    return {
      name: response.item.name,
      status: response.item.status,
      version: response.item.version
    };
  }, [packageName, http, enabled], {
    autoFetch: enabled
  });
  return {
    data,
    isLoading: enabled && status === 'loading',
    isInstalled: (data === null || data === void 0 ? void 0 : data.status) === 'installed',
    error
  };
};
exports.useInstalledIntegration = useInstalledIntegration;