"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useViewLogInProviderContext = exports.useViewLogInContext = exports.ViewLogInContextProvider = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useViewLogInContext = props => {
  const [contextEntry, setContextEntry] = (0, _react.useState)();
  const {
    startTimestamp,
    endTimestamp,
    logViewReference
  } = props;
  return [{
    startTimestamp,
    endTimestamp,
    logViewReference,
    contextEntry
  }, {
    setContextEntry
  }];
};
exports.useViewLogInContext = useViewLogInContext;
const [ViewLogInContextProvider, useViewLogInProviderContext] = (0, _constate.default)(useViewLogInContext);
exports.useViewLogInProviderContext = useViewLogInProviderContext;
exports.ViewLogInContextProvider = ViewLogInContextProvider;