"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INTEGRATIONS = void 0;
exports.SupportedDataTooltipLink = SupportedDataTooltipLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/supported_data_tooltip_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INTEGRATIONS = exports.INTEGRATIONS = {
  host: {
    inventoryLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.hostIntegrationInfo', {
      defaultMessage: 'This view supports data from the OpenTelemetry and Elastic System Integration.'
    }),
    alertingLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.hostIntegrationInfoAlerting', {
      defaultMessage: 'This alert rule supports data from the OpenTelemetry and Elastic System Integration.'
    }),
    documentation: 'https://ela.st/infra-inventory-supported-data-hosts'
  },
  pod: {
    inventoryLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.kubernetesIntegrationInfo', {
      defaultMessage: 'This view supports data from the Kubernetes Integration.'
    }),
    alertingLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.kubernetesIntegrationInfoAlerting', {
      defaultMessage: 'This alert rule supports data from the Kubernetes Integration.'
    }),
    documentation: 'https://ela.st/infra-inventory-supported-data-k8s-pods'
  },
  container: {
    inventoryLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.dockerContainerIntegrationInfo', {
      defaultMessage: 'This view supports data from the Kubernetes, System and Docker Integrations.'
    }),
    alertingLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.dockerContainerIntegrationInfoAlerting', {
      defaultMessage: 'This alert rule supports data from the Kubernetes, System and Docker Integrations.'
    }),
    documentation: 'https://ela.st/infra-inventory-supported-data-containers'
  },
  awsEC2: {
    inventoryLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.awsEC2IntegrationInfo', {
      defaultMessage: 'This view supports data from the AWS EC2 Integration.'
    }),
    alertingLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.awsEC2IntegrationInfoAlerting', {
      defaultMessage: 'This alert rule supports data from the AWS EC2 Integration.'
    }),
    documentation: 'https://ela.st/infra-inventory-supported-data-aws-ec2'
  },
  awsRDS: {
    inventoryLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.awsRDSIntegrationInfo', {
      defaultMessage: 'This view supports data from the AWS RDS Integration.'
    }),
    alertingLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.awsRDSIntegrationInfoAlerting', {
      defaultMessage: 'This alert rule supports data from the AWS RDS Integration.'
    }),
    documentation: 'https://ela.st/infra-inventory-supported-data-aws-rds'
  },
  awsS3: {
    inventoryLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.awsS3IntegrationInfo', {
      defaultMessage: 'This view supports data from the AWS S3 Integration.'
    }),
    alertingLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.awsS3IntegrationInfoAlerting', {
      defaultMessage: 'This alert rule supports data from the AWS S3 Integration.'
    }),
    documentation: 'https://ela.st/infra-inventory-supported-data-aws-s3'
  },
  awsSQS: {
    inventoryLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.awsSQSIntegrationInfo', {
      defaultMessage: 'This view supports data from the AWS SQS Integration.'
    }),
    alertingLabel: _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.awsSQSIntegrationInfoAlerting', {
      defaultMessage: 'This alert rule supports data from the AWS SQS Integration.'
    }),
    documentation: 'https://ela.st/infra-inventory-supported-data-aws-sqs'
  }
};
function SupportedDataTooltipLink({
  nodeType = 'host',
  isAlertUI = false
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isAlertUI ? INTEGRATIONS[nodeType].alertingLabel : INTEGRATIONS[nodeType].inventoryLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "infraSupportedDataTooltipLink",
    href: INTEGRATIONS[nodeType].documentation,
    target: "_blank",
    external: true,
    css: {
      height: !isAlertUI ? euiTheme.size.xl : '30px',
      display: 'inline-flex',
      alignItems: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.infra.supportedDataTooltipLink.label', {
    defaultMessage: 'What data is supported?'
  })));
}