"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesAssetImage = KubernetesAssetImage;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/kubernetes_dashboard_promotion/kubernetes_asset_image.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const imageSets = {
  ecs: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('../../images/kubernetes_dashboards/ecs_light.svg'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('../../images/kubernetes_dashboards/ecs_dark.svg'))),
    alt: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.ecsImageAlt', {
      defaultMessage: 'ECS Kubernetes Dashboard image'
    })
  },
  semconv: {
    light: () => Promise.resolve().then(() => _interopRequireWildcard(require('../../images/kubernetes_dashboards/semconv_light.svg'))),
    dark: () => Promise.resolve().then(() => _interopRequireWildcard(require('../../images/kubernetes_dashboards/semconv_dark.svg'))),
    alt: _i18n.i18n.translate('xpack.infra.kubernetesDashboardPromotion.semconvImageAlt', {
      defaultMessage: 'OpenTelemetry Kubernetes Dashboard image'
    })
  }
};
function KubernetesAssetImage({
  type = 'ecs',
  ...props
}) {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const {
    alt,
    dark,
    light
  } = imageSets[type];
  const [imageSrc, setImageSrc] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    let isMounted = true;
    const dynamicImageImport = colorMode === 'LIGHT' ? light() : dark();
    dynamicImageImport.then(module => {
      if (isMounted) {
        setImageSrc(module.default);
      }
    });
    return () => {
      isMounted = false;
    };
  }, [colorMode, dark, light]);
  return imageSrc ? /*#__PURE__*/_react.default.createElement(_eui.EuiImage, (0, _extends2.default)({
    size: "s",
    alt: alt,
    src: imageSrc
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 21
    }
  })) : null;
}