"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/error_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ErrorCallout = ({
  error,
  titleOverride,
  messageOverride,
  hasDetailsModal = false,
  hasTryAgainButton = false,
  onTryAgainClick
}) => {
  const {
    services: {
      notifications
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const errorContent = getErrorContent(error);
  const title = titleOverride ? titleOverride : errorContent.title;
  const openDetails = () => {
    notifications.showErrorDialog({
      title,
      error
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 14
      }
    }, title),
    "data-test-subj": "hostsViewErrorCallout",
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, messageOverride ? /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 30
      }
    }, messageOverride) : errorContent.body, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, hasDetailsModal && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "hostsViewErrorDetailsButton",
      onClick: openDetails,
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.hostsViewPage.error.detailsButton",
      defaultMessage: "Error details",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 19
      }
    }))), hasTryAgainButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "hostsViewTryAgainButton",
      onClick: onTryAgainClick,
      iconType: "refresh",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.hostsViewPage.error.tryAgainButton",
      defaultMessage: "Try again",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 19
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  });
};
exports.ErrorCallout = ErrorCallout;
const getErrorContent = error => {
  if (error instanceof _esQuery.KQLSyntaxError) {
    return {
      title: _i18n.i18n.translate('xpack.infra.hostsViewPage.error.kqlErrorTitle', {
        defaultMessage: 'Invalid KQL expression'
      }),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsViewPage.error.kqlErrorMessage",
        defaultMessage: "We can't show any results because we couldn't apply your filter.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        transparentBackground: true,
        paddingSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 11
        }
      }, error.message))
    };
  }
  return {
    title: _i18n.i18n.translate('xpack.infra.hostsViewPage.error.unknownErrorTitle', {
      defaultMessage: 'An error occurred'
    }),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error.message)
  };
};