"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Profiling = Profiling;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _flamegraph = require("./flamegraph");
var _functions = require("./functions");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
var _error_prompt = require("./error_prompt");
var _threads = require("./threads");
var _description_callout = require("./description_callout");
var _popover = require("../common/popover");
var _use_date_picker = require("../../hooks/use_date_picker");
var _use_profiling_kuery = require("../../hooks/use_profiling_kuery");
var _use_request_observable = require("../../hooks/use_request_observable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/profiling/profiling.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Profiling() {
  const {
    isActiveTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    dateRange,
    setDateRange
  } = (0, _use_date_picker.useDatePickerContext)();
  const {
    fullKuery,
    customKuery,
    setCustomKuery
  } = (0, _use_profiling_kuery.useProfilingKuery)();
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    data,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    return callApi(`/api/infra/profiling/status`, {
      method: 'GET'
    });
  }, [], {
    requestObservable$: request$,
    autoFetch: isActiveTab('profiling')
  });
  const onSearchSubmit = (0, _react.useCallback)(({
    dateRange: range,
    query
  }) => {
    setDateRange(range);
    setCustomKuery(query);
  }, [setCustomKuery, setDateRange]);
  const onSearchRefresh = (0, _react.useCallback)(() => {
    setDateRange(dateRange);
  }, [dateRange, setDateRange]);
  const tabs = [{
    id: 'flamegraph',
    name: _i18n.i18n.translate('xpack.infra.profiling.flamegraphTabName', {
      defaultMessage: 'Flamegraph'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_flamegraph.Flamegraph, {
      kuery: fullKuery,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    })),
    append: /*#__PURE__*/_react.default.createElement(_popover.Popover, {
      iconSize: "s",
      iconColor: "subdued",
      icon: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.profiling.flamegraphInfoPopoverBody",
      defaultMessage: "See a visual representation of the functions that consume the most resources. Each rectangle represents a function. The rectangle width represents the time spent in the function, and the number of stacked rectangles represents the number of functions called to reach the current function. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraProfilingFlamegraphTabLearnMoreLink",
          href: "https://www.elastic.co/guide/en/observability/current/universal-profiling.html#profiling-flamegraphs-intro",
          external: true,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 82,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.infra.profiling.flamegraphTabLearnMoreLink', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 13
      }
    })))
  }, {
    id: 'functions',
    name: _i18n.i18n.translate('xpack.infra.tabs.profiling.functionsTabName', {
      defaultMessage: 'Top 10 Functions'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_functions.Functions, {
      kuery: fullKuery,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 11
      }
    })),
    append: /*#__PURE__*/_react.default.createElement(_popover.Popover, {
      iconSize: "s",
      iconColor: "subdued",
      icon: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.profiling.functionsInfoPopoverBody",
      defaultMessage: "Identify the most expensive lines of code on your host by looking at the most frequently sampled functions, broken down by CPU time, annualized CO2, and annualized cost estimates. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraProfilingFunctionsTabLearnMoreLink",
          href: "https://www.elastic.co/guide/en/observability/current/universal-profiling.html#profiling-functions-intro",
          external: true,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.infra.profiling.functionsTabLearnMoreLink', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 13
      }
    })))
  }, {
    id: 'threads',
    name: _i18n.i18n.translate('xpack.infra.tabs.profiling.threadsTabName', {
      defaultMessage: 'Threads'
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_threads.Threads, {
      kuery: fullKuery,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    })),
    append: /*#__PURE__*/_react.default.createElement(_popover.Popover, {
      iconSize: "s",
      iconColor: "subdued",
      icon: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.profiling.threadsInfoPopoverBody",
      defaultMessage: "Visualize profiling stacktraces grouped by process thread names. This view enables you to identify the top threads consuming CPU resources and allows you to drill down into the call stack of each thread, so you can quickly identify resource-intensive lines of code within the thread.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 13
      }
    })))
  }];
  if ((0, _use_fetcher.isPending)(status) && !data) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
          display: flex;
          justify-content: center;
        `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_error_prompt.ErrorPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (data === null || data === void 0 ? void 0 : data.has_setup) === false ? /*#__PURE__*/_react.default.createElement(_public.ProfilingEmptyState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.EmbeddableProfilingSearchBar, {
    kuery: customKuery,
    rangeFrom: dateRange.from,
    rangeTo: dateRange.to,
    onQuerySubmit: onSearchSubmit,
    onRefresh: onSearchRefresh,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_description_callout.DescriptionCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  })));
}