"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SteppedGradientLegendRT = exports.StepRuleRT = exports.StepLegendRT = exports.PALETTES = exports.OperatorRT = exports.LegendRT = exports.InfraWaffleMapRuleOperator = exports.InfraFormatterType = exports.GradientRuleRT = exports.GradientLegendRT = void 0;
var _i18n = require("@kbn/i18n");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OperatorRT = exports.OperatorRT = rt.keyof({
  gt: null,
  gte: null,
  lt: null,
  lte: null,
  eq: null
});
const PALETTES = exports.PALETTES = {
  status: _i18n.i18n.translate('xpack.infra.legendControls.palettes.status', {
    defaultMessage: 'Status'
  }),
  temperature: _i18n.i18n.translate('xpack.infra.legendControls.palettes.temperature', {
    defaultMessage: 'Temperature'
  }),
  cool: _i18n.i18n.translate('xpack.infra.legendControls.palettes.cool', {
    defaultMessage: 'Cool'
  }),
  warm: _i18n.i18n.translate('xpack.infra.legendControls.palettes.warm', {
    defaultMessage: 'Warm'
  }),
  positive: _i18n.i18n.translate('xpack.infra.legendControls.palettes.positive', {
    defaultMessage: 'Positive'
  }),
  negative: _i18n.i18n.translate('xpack.infra.legendControls.palettes.negative', {
    defaultMessage: 'Negative'
  })
};
const StepRuleRT = exports.StepRuleRT = rt.intersection([rt.type({
  value: rt.number,
  operator: OperatorRT,
  color: rt.string
}), rt.partial({
  label: rt.string
})]);
const StepLegendRT = exports.StepLegendRT = rt.type({
  type: rt.literal('step'),
  rules: rt.array(StepRuleRT)
});
const GradientRuleRT = exports.GradientRuleRT = rt.type({
  value: rt.number,
  color: rt.string
});
const GradientLegendRT = exports.GradientLegendRT = rt.type({
  type: rt.literal('gradient'),
  rules: rt.array(GradientRuleRT)
});
const SteppedGradientLegendRT = exports.SteppedGradientLegendRT = rt.type({
  type: rt.literal('steppedGradient'),
  rules: rt.array(GradientRuleRT)
});
const LegendRT = exports.LegendRT = rt.union([StepLegendRT, GradientLegendRT, SteppedGradientLegendRT]);
let InfraWaffleMapRuleOperator = exports.InfraWaffleMapRuleOperator = /*#__PURE__*/function (InfraWaffleMapRuleOperator) {
  InfraWaffleMapRuleOperator["gt"] = "gt";
  InfraWaffleMapRuleOperator["gte"] = "gte";
  InfraWaffleMapRuleOperator["lt"] = "lt";
  InfraWaffleMapRuleOperator["lte"] = "lte";
  InfraWaffleMapRuleOperator["eq"] = "eq";
  return InfraWaffleMapRuleOperator;
}({});
let InfraFormatterType = exports.InfraFormatterType = /*#__PURE__*/function (InfraFormatterType) {
  InfraFormatterType["number"] = "number";
  InfraFormatterType["abbreviatedNumber"] = "abbreviatedNumber";
  InfraFormatterType["bytes"] = "bytes";
  InfraFormatterType["bits"] = "bits";
  InfraFormatterType["percent"] = "percent";
  return InfraFormatterType;
}({});