"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Criterion = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../common/alerting/logs/log_threshold/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/log_threshold/components/expression_editor/criterion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const firstCriterionFieldPrefix = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.firstCriterionFieldPrefix', {
  defaultMessage: 'with'
});
const successiveCriterionFieldPrefix = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.successiveCriterionFieldPrefix', {
  defaultMessage: 'and'
});
const criterionFieldTitle = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.criterionFieldTitle', {
  defaultMessage: 'Field'
});
const criterionComparatorValueTitle = _i18n.i18n.translate('xpack.infra.logs.alertFlyout.criterionComparatorValueTitle', {
  defaultMessage: 'Comparison : Value'
});
const getCompatibleComparatorsForField = fieldInfo => {
  if ((fieldInfo === null || fieldInfo === void 0 ? void 0 : fieldInfo.type) === 'number') {
    return [{
      value: _types.Comparator.GT,
      text: _types.ComparatorToi18nMap[_types.Comparator.GT]
    }, {
      value: _types.Comparator.GT_OR_EQ,
      text: _types.ComparatorToi18nMap[_types.Comparator.GT_OR_EQ]
    }, {
      value: _types.Comparator.LT,
      text: _types.ComparatorToi18nMap[_types.Comparator.LT]
    }, {
      value: _types.Comparator.LT_OR_EQ,
      text: _types.ComparatorToi18nMap[_types.Comparator.LT_OR_EQ]
    }, {
      value: _types.Comparator.EQ,
      text: _types.ComparatorToi18nMap[`${_types.Comparator.EQ}:number`]
    }, {
      value: _types.Comparator.NOT_EQ,
      text: _types.ComparatorToi18nMap[`${_types.Comparator.NOT_EQ}:number`]
    }];
  } else if (fieldInfo !== null && fieldInfo !== void 0 && fieldInfo.aggregatable) {
    return [{
      value: _types.Comparator.EQ,
      text: _types.ComparatorToi18nMap[_types.Comparator.EQ]
    }, {
      value: _types.Comparator.NOT_EQ,
      text: _types.ComparatorToi18nMap[_types.Comparator.NOT_EQ]
    }];
  } else {
    return [{
      value: _types.Comparator.MATCH,
      text: _types.ComparatorToi18nMap[_types.Comparator.MATCH]
    }, {
      value: _types.Comparator.NOT_MATCH,
      text: _types.ComparatorToi18nMap[_types.Comparator.NOT_MATCH]
    }, {
      value: _types.Comparator.MATCH_PHRASE,
      text: _types.ComparatorToi18nMap[_types.Comparator.MATCH_PHRASE]
    }, {
      value: _types.Comparator.NOT_MATCH_PHRASE,
      text: _types.ComparatorToi18nMap[_types.Comparator.NOT_MATCH_PHRASE]
    }];
  }
};
const getFieldInfo = (fields, fieldName) => {
  return fields.find(field => {
    return field.name === fieldName;
  });
};
const Criterion = ({
  idx,
  fields,
  criterion,
  updateCriterion,
  removeCriterion,
  canDelete,
  errors
}) => {
  var _criterion$field, _ref, _ComparatorToi18nMap;
  const [isFieldPopoverOpen, setIsFieldPopoverOpen] = (0, _react.useState)(false);
  const [isComparatorPopoverOpen, setIsComparatorPopoverOpen] = (0, _react.useState)(false);
  const fieldOptions = (0, _react.useMemo)(() => {
    return fields.map(field => {
      return {
        label: field.name
      };
    });
  }, [fields]);
  const fieldInfo = (0, _react.useMemo)(() => {
    if (criterion.field) {
      return getFieldInfo(fields, criterion.field);
    } else {
      return undefined;
    }
  }, [fields, criterion]);
  const compatibleComparatorOptions = (0, _react.useMemo)(() => {
    return getCompatibleComparatorsForField(fieldInfo);
  }, [fieldInfo]);
  const handleFieldChange = (0, _react.useCallback)(([selectedOption]) => {
    if (!selectedOption) {
      updateCriterion(idx, {
        field: ''
      });
      return;
    }
    const fieldName = selectedOption.label;
    const nextFieldInfo = getFieldInfo(fields, fieldName);
    // If the field information we're dealing with has changed, reset the comparator and value.
    if ((fieldInfo === null || fieldInfo === void 0 ? void 0 : fieldInfo.type) !== (nextFieldInfo === null || nextFieldInfo === void 0 ? void 0 : nextFieldInfo.type) || (fieldInfo === null || fieldInfo === void 0 ? void 0 : fieldInfo.aggregatable) !== (nextFieldInfo === null || nextFieldInfo === void 0 ? void 0 : nextFieldInfo.aggregatable)) {
      const compatibleComparators = getCompatibleComparatorsForField(nextFieldInfo);
      updateCriterion(idx, {
        field: fieldName,
        comparator: compatibleComparators[0].value,
        value: undefined
      });
    } else {
      updateCriterion(idx, {
        field: fieldName
      });
    }
    setIsFieldPopoverOpen(false);
  }, [fieldInfo, fields, idx, updateCriterion]);
  const selectedField = criterion.field ? [{
    label: criterion.field
  }] : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "criterion-field",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: idx === 0 ? firstCriterionFieldPrefix : successiveCriterionFieldPrefix,
      uppercase: true,
      value: (_criterion$field = criterion.field) !== null && _criterion$field !== void 0 ? _criterion$field : 'a chosen field',
      isActive: isFieldPopoverOpen,
      color: errors.field.length === 0 ? 'success' : 'danger',
      onClick: e => {
        e.stopPropagation();
        setIsFieldPopoverOpen(!isFieldPopoverOpen);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 17
      }
    }),
    isOpen: isFieldPopoverOpen,
    closePopover: () => setIsFieldPopoverOpen(false),
    onClick: e => e.stopPropagation(),
    ownFocus: true,
    panelPaddingSize: "s",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 17
    }
  }, criterionFieldTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    style: {
      minWidth: '300px'
    }
    // @ts-expect-error upgrade typescript v5.1.6
    ,
    isInvalid: errors.field.length > 0,
    error: errors.field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox
  // @ts-expect-error upgrade typescript v5.1.6
  , {
    isInvalid: errors.field.length > 0,
    compressed: true,
    fullWidth: true,
    isClearable: false,
    singleSelection: {
      asPlainText: true
    },
    "aria-label": criterionFieldTitle,
    options: fieldOptions,
    selectedOptions: selectedField,
    onChange: handleFieldChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "criterion-comparator-value",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      description: criterion.comparator ? // @ts-expect-error upgrade typescript v5.4.5
      (_ref = (_ComparatorToi18nMap = _types.ComparatorToi18nMap[`${criterion.comparator}:${fieldInfo === null || fieldInfo === void 0 ? void 0 : fieldInfo.type}`]) !== null && _ComparatorToi18nMap !== void 0 ? _ComparatorToi18nMap : _types.ComparatorToi18nMap[criterion.comparator]) !== null && _ref !== void 0 ? _ref : '' : '',
      uppercase: true,
      value: criterion.value,
      isActive: isComparatorPopoverOpen,
      color: errors.comparator.length === 0 && errors.value.length === 0 ? 'success' : 'danger',
      onClick: e => {
        e.stopPropagation();
        setIsComparatorPopoverOpen(!isComparatorPopoverOpen);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 17
      }
    }),
    isOpen: isComparatorPopoverOpen,
    closePopover: () => setIsComparatorPopoverOpen(false),
    onClick: e => e.stopPropagation(),
    ownFocus: true,
    panelPaddingSize: "s",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 17
    }
  }, criterionComparatorValueTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid:
    // @ts-expect-error upgrade typescript v5.1.6
    errors.comparator.length > 0,
    error: errors.comparator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect
  // @ts-expect-error upgrade typescript v5.1.6
  , {
    isInvalid: errors.comparator.length > 0,
    "data-test-subj": "infraCriterionSelect",
    compressed: true,
    hasNoInitialSelection: criterion.comparator == null,
    value: criterion.comparator,
    onChange: e => updateCriterion(idx, {
      comparator: e.target.value
    }),
    options: compatibleComparatorOptions,
    "aria-label": _i18n.i18n.translate('xpack.infra.logs.alertFlyout.comparatorSelectAriaLabel', {
      defaultMessage: 'Comparison'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid:
    // @ts-expect-error upgrade typescript v5.1.6
    errors.value.length > 0,
    error: errors.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 21
    }
  }, (fieldInfo === null || fieldInfo === void 0 ? void 0 : fieldInfo.type) === 'number' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "infraCriterionFieldNumber",
    compressed: true,
    value: criterion.value,
    onChange: e => {
      const number = parseFloat(e.target.value);
      updateCriterion(idx, {
        value: (0, _lodash.isNumber)(number) && (0, _lodash.isFinite)(number) ? number : undefined
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "infraCriterionFieldText",
    compressed: true,
    value: criterion.value,
    onChange: e => updateCriterion(idx, {
      value: e.target.value
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 25
    }
  }))))))))), canDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraCriterionButton",
    "aria-label": _i18n.i18n.translate('xpack.infra.logs.alertFlyout.removeCondition', {
      defaultMessage: 'Remove condition'
    }),
    color: 'danger',
    iconType: 'trash',
    onClick: e => {
      e.stopPropagation();
      removeCriterion(idx);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 11
    }
  })));
};
exports.Criterion = Criterion;