"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CONTAINER_ID_FIELD", {
  enumerable: true,
  get: function () {
    return _common.CONTAINER_ID;
  }
});
exports.DEFAULT_METRICS_VIEW_ATTRIBUTES = void 0;
Object.defineProperty(exports, "HOST_NAME_FIELD", {
  enumerable: true,
  get: function () {
    return _common.HOST_NAME;
  }
});
exports.INFRA_ALERT_FEATURE_ID = exports.INFRA_ALERT_CONSUMERS = void 0;
Object.defineProperty(exports, "KUBERNETES_POD_UID_FIELD", {
  enumerable: true,
  get: function () {
    return _common.KUBERNETES_POD_UID;
  }
});
exports.fifteenMinutesInMilliseconds = exports.TOP_N = exports.TIMESTAMP_FIELD = exports.TIEBREAKER_FIELD = exports.SNAPSHOT_API_MAX_METRICS = exports.SCHEMA_SELECTOR_DOCS_LINK = exports.PROCESS_COMMANDLINE_FIELD = exports.O11Y_AAD_FIELDS = exports.METRICS_INDEX_PATTERN = exports.METRICS_FEATURE_ID = exports.METRICS_APP = exports.MESSAGE_FIELD = exports.MANDATORY_PROCESS_FIELDS_SEMCONV = exports.MANDATORY_PROCESS_FIELDS_ECS = exports.LOGS_INDEX_PATTERN = exports.LOGS_FEATURE_ID = exports.LOGS_APP = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/metrics-data-access-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRICS_INDEX_PATTERN = exports.METRICS_INDEX_PATTERN = 'metrics-*,metricbeat-*';
const LOGS_INDEX_PATTERN = exports.LOGS_INDEX_PATTERN = 'logs-*,filebeat-*,kibana_sample_data_logs*';
const METRICS_APP = exports.METRICS_APP = 'metrics';
const LOGS_APP = exports.LOGS_APP = 'logs';
const METRICS_FEATURE_ID = exports.METRICS_FEATURE_ID = _ruleDataUtils.AlertConsumers.INFRASTRUCTURE;
const INFRA_ALERT_FEATURE_ID = exports.INFRA_ALERT_FEATURE_ID = _ruleDataUtils.AlertConsumers.INFRASTRUCTURE;
const LOGS_FEATURE_ID = exports.LOGS_FEATURE_ID = _ruleDataUtils.AlertConsumers.LOGS;
const INFRA_ALERT_CONSUMERS = exports.INFRA_ALERT_CONSUMERS = [_ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.OBSERVABILITY, _ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.APM, _ruleDataUtils.AlertConsumers.ALERTS];
const TIMESTAMP_FIELD = exports.TIMESTAMP_FIELD = '@timestamp';
const TIEBREAKER_FIELD = exports.TIEBREAKER_FIELD = '_doc';

// processes
const TOP_N = exports.TOP_N = 10;
const MANDATORY_PROCESS_FIELDS_ECS = exports.MANDATORY_PROCESS_FIELDS_ECS = ['system.process.cpu.total.pct', 'system.process.memory.rss.pct', 'system.process.cpu.start_time', 'system.process.state', 'user.name', 'process.pid', 'process.command_line'];
const MANDATORY_PROCESS_FIELDS_SEMCONV = exports.MANDATORY_PROCESS_FIELDS_SEMCONV = ['process.pid', 'process.command_line', 'process.owner'];
const PROCESS_COMMANDLINE_FIELD = exports.PROCESS_COMMANDLINE_FIELD = 'process.command_line';

// logs
const MESSAGE_FIELD = exports.MESSAGE_FIELD = 'message';
const O11Y_AAD_FIELDS = exports.O11Y_AAD_FIELDS = ['cloud.*', 'host.*', 'orchestrator.*', 'container.*', 'labels.*', 'tags'];
const fifteenMinutesInMilliseconds = exports.fifteenMinutesInMilliseconds = 15 * 60 * 1000;
const DEFAULT_METRICS_VIEW_ATTRIBUTES = exports.DEFAULT_METRICS_VIEW_ATTRIBUTES = {
  name: 'Metrics View',
  timeFieldName: TIMESTAMP_FIELD
};
const SNAPSHOT_API_MAX_METRICS = exports.SNAPSHOT_API_MAX_METRICS = 20;
const SCHEMA_SELECTOR_DOCS_LINK = exports.SCHEMA_SELECTOR_DOCS_LINK = 'https://ela.st/schema-selector-hosts';