"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupedSearchQueryResponseRT = exports.ComparatorToi18nSymbolsMap = exports.ComparatorToi18nMap = exports.Comparator = exports.AlertStates = void 0;
Object.defineProperty(exports, "LOG_DOCUMENT_COUNT_RULE_TYPE_ID", {
  enumerable: true,
  get: function () {
    return _ruleDataUtils.LOG_THRESHOLD_ALERT_TYPE_ID;
  }
});
exports.timeUnitRT = exports.timeSizeRT = exports.ruleParamsRT = exports.ratioRuleParamsRT = exports.ratioCriteriaRT = exports.partialRuleParamsRT = exports.partialRatioRuleParamsRT = exports.partialRatioCriteriaRT = exports.partialCriterionRT = exports.partialCriteriaRT = exports.partialCountRuleParamsRT = exports.partialCountCriteriaRT = exports.isRatioRuleParams = exports.isRatioRule = exports.isOptimizedGroupedSearchQueryResponse = exports.isOptimizableGroupedThreshold = exports.hasGroupBy = exports.groupByRT = exports.getNumerator = exports.getDenominator = exports.criterionRT = exports.countRuleParamsRT = exports.countCriteriaRT = exports.UnoptimizedGroupedSearchQueryResponseRT = exports.UngroupedSearchQueryResponseRT = exports.ThresholdRT = exports.OptimizedGroupedSearchQueryResponseRT = void 0;
var _i18n = require("@kbn/i18n");
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("@kbn/logs-shared-plugin/common");
var _elasticsearch_runtime_types = require("../../../utils/elasticsearch_runtime_types");
var _ruleDataUtils = require("@kbn/rule-data-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThresholdTypeRT = rt.keyof({
  count: null,
  ratio: null
});
// Comparators //
let Comparator = exports.Comparator = /*#__PURE__*/function (Comparator) {
  Comparator["GT"] = "more than";
  Comparator["GT_OR_EQ"] = "more than or equals";
  Comparator["LT"] = "less than";
  Comparator["LT_OR_EQ"] = "less than or equals";
  Comparator["EQ"] = "equals";
  Comparator["NOT_EQ"] = "does not equal";
  Comparator["MATCH"] = "matches";
  Comparator["NOT_MATCH"] = "does not match";
  Comparator["MATCH_PHRASE"] = "matches phrase";
  Comparator["NOT_MATCH_PHRASE"] = "does not match phrase";
  return Comparator;
}({});
const ComparatorRT = rt.keyof({
  [Comparator.GT]: null,
  [Comparator.GT_OR_EQ]: null,
  [Comparator.LT]: null,
  [Comparator.LT_OR_EQ]: null,
  [Comparator.EQ]: null,
  [Comparator.NOT_EQ]: null,
  [Comparator.MATCH]: null,
  [Comparator.NOT_MATCH]: null,
  [Comparator.MATCH_PHRASE]: null,
  [Comparator.NOT_MATCH_PHRASE]: null
});

// Maps our comparators to i18n strings, some comparators have more specific wording
// depending on the field type the comparator is being used with.
const ComparatorToi18nMap = exports.ComparatorToi18nMap = {
  [Comparator.GT]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.gt', {
    defaultMessage: 'more than'
  }),
  [Comparator.GT_OR_EQ]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.gtOrEq', {
    defaultMessage: 'more than or equals'
  }),
  [Comparator.LT]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.lt', {
    defaultMessage: 'less than'
  }),
  [Comparator.LT_OR_EQ]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.ltOrEq', {
    defaultMessage: 'less than or equals'
  }),
  [Comparator.EQ]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.eq', {
    defaultMessage: 'is'
  }),
  [Comparator.NOT_EQ]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.notEq', {
    defaultMessage: 'is not'
  }),
  [`${Comparator.EQ}:number`]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.eqNumber', {
    defaultMessage: 'equals'
  }),
  [`${Comparator.NOT_EQ}:number`]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.notEqNumber', {
    defaultMessage: 'does not equal'
  }),
  [Comparator.MATCH]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.match', {
    defaultMessage: 'matches'
  }),
  [Comparator.NOT_MATCH]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.notMatch', {
    defaultMessage: 'does not match'
  }),
  [Comparator.MATCH_PHRASE]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.matchPhrase', {
    defaultMessage: 'matches phrase'
  }),
  [Comparator.NOT_MATCH_PHRASE]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.notMatchPhrase', {
    defaultMessage: 'does not match phrase'
  })
};
const ComparatorToi18nSymbolsMap = exports.ComparatorToi18nSymbolsMap = {
  [Comparator.GT]: '>',
  [Comparator.GT_OR_EQ]: '≥',
  [Comparator.LT]: '<',
  [Comparator.LT_OR_EQ]: '≤',
  [Comparator.EQ]: '=',
  [Comparator.NOT_EQ]: '≠',
  [`${Comparator.EQ}:number`]: '=',
  [`${Comparator.NOT_EQ}:number`]: '≠',
  // TODO: We could need to update the next messages to use symbols.
  [Comparator.MATCH]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.symbol.match', {
    defaultMessage: 'matches'
  }),
  [Comparator.NOT_MATCH]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.symbol.notMatch', {
    defaultMessage: 'does not match'
  }),
  [Comparator.MATCH_PHRASE]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.symbol.matchPhrase', {
    defaultMessage: 'matches phrase'
  }),
  [Comparator.NOT_MATCH_PHRASE]: _i18n.i18n.translate('xpack.infra.logs.alerting.comparator.symbol.notMatchPhrase', {
    defaultMessage: 'does not match phrase'
  })
};

// Alert parameters //
let AlertStates = exports.AlertStates = /*#__PURE__*/function (AlertStates) {
  AlertStates[AlertStates["OK"] = 0] = "OK";
  AlertStates[AlertStates["ALERT"] = 1] = "ALERT";
  AlertStates[AlertStates["NO_DATA"] = 2] = "NO_DATA";
  AlertStates[AlertStates["ERROR"] = 3] = "ERROR";
  return AlertStates;
}({});
const ThresholdRT = exports.ThresholdRT = rt.type({
  comparator: ComparatorRT,
  value: rt.number
});
const criterionRT = exports.criterionRT = rt.type({
  field: rt.string,
  comparator: ComparatorRT,
  value: rt.union([rt.string, rt.number])
});
const partialCriterionRT = exports.partialCriterionRT = rt.partial(criterionRT.props);
const countCriteriaRT = exports.countCriteriaRT = rt.array(criterionRT);
const partialCountCriteriaRT = exports.partialCountCriteriaRT = rt.array(partialCriterionRT);
const ratioCriteriaRT = exports.ratioCriteriaRT = rt.tuple([countCriteriaRT, countCriteriaRT]);
const partialRatioCriteriaRT = exports.partialRatioCriteriaRT = rt.tuple([partialCountCriteriaRT, partialCountCriteriaRT]);
const partialCriteriaRT = exports.partialCriteriaRT = rt.union([partialCountCriteriaRT, partialRatioCriteriaRT]);
const timeUnitRT = exports.timeUnitRT = rt.union([rt.literal('s'), rt.literal('m'), rt.literal('h'), rt.literal('d')]);
const timeSizeRT = exports.timeSizeRT = rt.number;
const groupByRT = exports.groupByRT = rt.array(rt.string);
const RequiredRuleParamsRT = rt.type({
  // NOTE: "count" would be better named as "threshold", but this would require a
  // migration of encrypted saved objects, so we'll keep "count" until it's problematic.
  count: ThresholdRT,
  timeUnit: timeUnitRT,
  timeSize: timeSizeRT,
  logView: _common.persistedLogViewReferenceRT // Alerts are only compatible with persisted Log Views
});
const partialRequiredRuleParamsRT = rt.partial(RequiredRuleParamsRT.props);
const OptionalRuleParamsRT = rt.partial({
  groupBy: groupByRT
});
const countRuleParamsRT = exports.countRuleParamsRT = rt.intersection([rt.type({
  criteria: countCriteriaRT,
  ...RequiredRuleParamsRT.props
}), rt.partial({
  ...OptionalRuleParamsRT.props
})]);
const partialCountRuleParamsRT = exports.partialCountRuleParamsRT = rt.intersection([rt.type({
  criteria: partialCountCriteriaRT,
  ...RequiredRuleParamsRT.props
}), rt.partial({
  ...OptionalRuleParamsRT.props
})]);
const ratioRuleParamsRT = exports.ratioRuleParamsRT = rt.intersection([rt.type({
  criteria: ratioCriteriaRT,
  ...RequiredRuleParamsRT.props
}), rt.partial({
  ...OptionalRuleParamsRT.props
})]);
const partialRatioRuleParamsRT = exports.partialRatioRuleParamsRT = rt.intersection([rt.type({
  criteria: partialRatioCriteriaRT,
  ...RequiredRuleParamsRT.props
}), rt.partial({
  ...OptionalRuleParamsRT.props
})]);
const ruleParamsRT = exports.ruleParamsRT = rt.union([countRuleParamsRT, ratioRuleParamsRT]);
const partialRuleParamsRT = exports.partialRuleParamsRT = rt.union([partialCountRuleParamsRT, partialRatioRuleParamsRT]);
const isRatioRule = criteria => {
  return criteria.length > 0 && Array.isArray(criteria[0]) ? true : false;
};
exports.isRatioRule = isRatioRule;
const isRatioRuleParams = params => {
  return isRatioRule(params.criteria);
};
exports.isRatioRuleParams = isRatioRuleParams;
const getNumerator = criteria => {
  return criteria[0];
};
exports.getNumerator = getNumerator;
const getDenominator = criteria => {
  return criteria[1];
};
exports.getDenominator = getDenominator;
const hasGroupBy = params => {
  const {
    groupBy
  } = params;
  return groupBy && groupBy.length > 0 ? true : false;
};

// Chart previews //
exports.hasGroupBy = hasGroupBy;
const chartPreviewHistogramBucket = rt.type({
  key: rt.number,
  doc_count: rt.number
});
const AdditionalContext = rt.type({
  hits: rt.type({
    hits: rt.array(rt.type({
      fields: rt.record(rt.string, rt.array(rt.unknown))
    }))
  })
});
const ChartPreviewBucketsRT = rt.partial({
  histogramBuckets: rt.type({
    buckets: rt.array(chartPreviewHistogramBucket)
  })
});
const additionalContextRT = rt.partial({
  additionalContext: AdditionalContext
});

// ES query responses //
const hitsRT = rt.type({
  total: rt.type({
    value: rt.number
  })
});
const bucketFieldsRT = rt.type({
  key: rt.record(rt.string, rt.string),
  doc_count: rt.number
});
const afterKeyRT = rt.partial({
  after_key: rt.record(rt.string, rt.string)
});
const UngroupedSearchQueryResponseRT = exports.UngroupedSearchQueryResponseRT = rt.intersection([_elasticsearch_runtime_types.commonSearchSuccessResponseFieldsRT, rt.intersection([rt.type({
  hits: hitsRT
}), rt.partial({
  aggregations: rt.intersection([ChartPreviewBucketsRT, additionalContextRT])
})])]);
const UnoptimizedGroupedSearchQueryResponseRT = exports.UnoptimizedGroupedSearchQueryResponseRT = rt.intersection([_elasticsearch_runtime_types.commonSearchSuccessResponseFieldsRT, rt.type({
  aggregations: rt.type({
    groups: rt.intersection([rt.type({
      buckets: rt.array(rt.type({
        ...bucketFieldsRT.props,
        filtered_results: rt.intersection([rt.type({
          doc_count: rt.number
        }), ChartPreviewBucketsRT, additionalContextRT])
      }))
    }), afterKeyRT])
  }),
  hits: hitsRT
})]);
const OptimizedGroupedSearchQueryResponseRT = exports.OptimizedGroupedSearchQueryResponseRT = rt.intersection([_elasticsearch_runtime_types.commonSearchSuccessResponseFieldsRT, rt.type({
  aggregations: rt.type({
    groups: rt.intersection([rt.type({
      buckets: rt.array(rt.intersection([bucketFieldsRT, ChartPreviewBucketsRT, additionalContextRT]))
    }), afterKeyRT])
  }),
  hits: hitsRT
})]);
const GroupedSearchQueryResponseRT = exports.GroupedSearchQueryResponseRT = rt.union([UnoptimizedGroupedSearchQueryResponseRT, OptimizedGroupedSearchQueryResponseRT]);
const isOptimizedGroupedSearchQueryResponse = response => {
  const result = response[0];
  return result && !Object.hasOwn(result, 'filtered_results');
};
exports.isOptimizedGroupedSearchQueryResponse = isOptimizedGroupedSearchQueryResponse;
const isOptimizableGroupedThreshold = (selectedComparator, selectedValue) => {
  if (selectedComparator === Comparator.GT) {
    return true;
  } else if (typeof selectedValue === 'number' && selectedComparator === Comparator.GT_OR_EQ && selectedValue > 0) {
    return true;
  } else {
    return false;
  }
};
exports.isOptimizableGroupedThreshold = isOptimizableGroupedThreshold;