"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhoenixProtoExporter = void 0;
var _exporterTraceOtlpProto = require("@opentelemetry/exporter-trace-otlp-proto");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This exporter exists because Phoenix /v1/traces responds with JSON
 * which is not spec-compliant. It will cause a warning to be logged.
 */
class PhoenixProtoExporter extends _exporterTraceOtlpProto.OTLPTraceExporter {
  constructor(config) {
    super(config);
    const serializer = this._delegate._serializer;
    const originalDeserializeResponse = serializer.deserializeResponse.bind(serializer);
    serializer.deserializeResponse = data => {
      if (data.toString() === '"{}"') {
        return undefined;
      }
      return originalDeserializeResponse(data);
    };
  }
}
exports.PhoenixProtoExporter = PhoenixProtoExporter;