"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConnectorsRoute = registerConnectorsRoute;
var _get_connector_list = require("../util/get_connector_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerConnectorsRoute({
  coreSetup,
  router
}) {
  router.get({
    path: '/internal/inference/connectors',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: {}
  }, async (_context, request, response) => {
    const actions = await coreSetup.getStartServices().then(([_coreStart, pluginsStart]) => pluginsStart.actions);
    const connectors = await (0, _get_connector_list.getConnectorList)({
      actions,
      request
    });
    return response.ok({
      body: {
        connectors
      }
    });
  });
}