"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInferenceClient = createInferenceClient;
var _chat_complete = require("../chat_complete");
var _create_output_api = require("../../common/output/create_output_api");
var _get_connector_by_id = require("../util/get_connector_by_id");
var _prompt = require("../prompt");
var _bind_client = require("../../common/inference_client/bind_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createInferenceClient({
  request,
  actions,
  logger,
  anonymizationRulesPromise,
  regexWorker,
  esClient
}) {
  const chatComplete = (0, _chat_complete.createChatCompleteApi)({
    request,
    actions,
    logger,
    anonymizationRulesPromise,
    regexWorker,
    esClient
  });
  const client = {
    chatComplete,
    prompt: (0, _prompt.createPromptApi)({
      request,
      actions,
      logger,
      anonymizationRulesPromise,
      regexWorker,
      esClient
    }),
    output: (0, _create_output_api.createOutputApi)(chatComplete),
    getConnectorById: async connectorId => {
      return await (0, _get_connector_by_id.getConnectorById)({
        connectorId,
        actions,
        request
      });
    },
    bindTo: options => {
      return (0, _bind_client.bindClient)(client, options);
    }
  };
  return client;
}