"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPromptRestApi = createPromptRestApi;
var _sseUtilsClient = require("@kbn/sse-utils-client");
var _rxjs = require("rxjs");
var _retry_with_exponential_backoff = require("../utils/retry_with_exponential_backoff");
var _error_retry_filter = require("../utils/error_retry_filter");
var _combine_signal = require("../utils/combine_signal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createPromptRestApi({
  fetch,
  signal
}) {
  return options => {
    const {
      abortSignal,
      maxRetries,
      metadata,
      modelName,
      retryConfiguration,
      stream,
      temperature,
      prompt: {
        input: inputSchema,
        ...prompt
      },
      input,
      connectorId,
      functionCalling,
      prevMessages,
      toolChoice
    } = options;
    const body = {
      connectorId,
      functionCalling,
      modelName,
      temperature,
      maxRetries,
      retryConfiguration: undefined,
      prompt,
      input,
      prevMessages,
      metadata,
      toolChoice
    };
    const validationResult = inputSchema.safeParse(input);
    function retry() {
      return (0, _retry_with_exponential_backoff.retryWithExponentialBackoff)({
        maxRetry: maxRetries,
        backoffMultiplier: retryConfiguration === null || retryConfiguration === void 0 ? void 0 : retryConfiguration.backoffMultiplier,
        errorFilter: (0, _error_retry_filter.getRetryFilter)(retryConfiguration === null || retryConfiguration === void 0 ? void 0 : retryConfiguration.retryOn),
        initialDelay: retryConfiguration === null || retryConfiguration === void 0 ? void 0 : retryConfiguration.initialDelay
      });
    }
    if (stream) {
      if (!validationResult.success) {
        return (0, _rxjs.throwError)(() => validationResult.error);
      }
      return (0, _rxjs.defer)(() => {
        return (0, _rxjs.from)(fetch(`/internal/inference/prompt/stream`, {
          method: 'POST',
          body: JSON.stringify(body),
          asResponse: true,
          rawResponse: true,
          signal: (0, _combine_signal.combineSignal)(signal, abortSignal)
        }).then(response => ({
          response: response.response
        })));
      }).pipe((0, _sseUtilsClient.httpResponseIntoObservable)(), retry());
    }
    if (!validationResult.success) {
      return Promise.reject(validationResult.error);
    }
    return (0, _rxjs.lastValueFrom)((0, _rxjs.defer)(() => {
      return (0, _rxjs.from)(fetch(`/internal/inference/prompt`, {
        method: 'POST',
        body: JSON.stringify(body),
        signal: (0, _combine_signal.combineSignal)(signal, abortSignal)
      }));
    }).pipe(retry()));
  };
}