"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGE_SIZE_OPTIONS = exports.IndexTablePagination = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxTablePersist = require("@kbn/shared-ux-table-persist");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/index_table/index_table_pagination.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PAGE_SIZE_OPTIONS = exports.PAGE_SIZE_OPTIONS = [10, 50, 100];
const IndexTablePagination = ({
  pager,
  pageChanged,
  pageSizeChanged,
  readURLParams,
  setURLParam
}) => {
  const {
    pageSize,
    onTableChange
  } = (0, _sharedUxTablePersist.useEuiTablePersist)({
    tableId: 'indices',
    initialPageSize: pager.itemsPerPage,
    pageSizeOptions: PAGE_SIZE_OPTIONS
  });
  const {
    pageSize: urlParamPageSize
  } = readURLParams();

  // Update local storage if there is a url param for page size
  if (PAGE_SIZE_OPTIONS.includes(urlParamPageSize) && urlParamPageSize !== pageSize) {
    onTableChange({
      page: {
        size: urlParamPageSize,
        index: pager.getCurrentPageIndex()
      }
    });
  }
  if (pageSize !== pager.itemsPerPage) {
    pageSizeChanged(pageSize);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTablePagination, {
    activePage: pager.getCurrentPageIndex(),
    itemsPerPage: pager.itemsPerPage,
    itemsPerPageOptions: PAGE_SIZE_OPTIONS,
    pageCount: pager.getTotalPages(),
    onChangeItemsPerPage: size => {
      setURLParam('pageSize', size);
      pageSizeChanged(size);
      onTableChange({
        page: {
          size,
          index: pager.getCurrentPageIndex()
        }
      });
    },
    onChangePage: pageIndex => {
      setURLParam('pageIndex', pageIndex);
      pageChanged(pageIndex);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.IndexTablePagination = IndexTablePagination;