"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexTable = void 0;
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _selectors = require("../../../../store/selectors");
var _actions = require("../../../../store/actions");
var _index_table = require("./index_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = (state, props) => {
  return {
    allIndices: (0, _selectors.getIndicesAsArray)(state),
    indices: (0, _selectors.getPageOfIndices)(state, props),
    pager: (0, _selectors.getPager)(state, props),
    filter: (0, _selectors.getFilter)(state),
    sortField: (0, _selectors.getSortField)(state),
    isSortAscending: (0, _selectors.isSortAscending)(state),
    indicesLoading: (0, _selectors.indicesLoading)(state),
    indicesError: (0, _selectors.indicesError)(state),
    toggleNameToVisibleMap: (0, _selectors.getTableState)(state).toggleNameToVisibleMap
  };
};
const mapDispatchToProps = dispatch => {
  return {
    filterChanged: filter => {
      dispatch((0, _actions.filterChanged)({
        filter
      }));
    },
    pageChanged: pageNumber => {
      dispatch((0, _actions.pageChanged)({
        pageNumber
      }));
    },
    pageSizeChanged: pageSize => {
      dispatch((0, _actions.pageSizeChanged)({
        pageSize
      }));
    },
    sortChanged: (sortField, isSortAscending) => {
      dispatch((0, _actions.sortChanged)({
        sortField,
        isSortAscending
      }));
    },
    toggleChanged: (toggleName, toggleValue) => {
      dispatch((0, _actions.toggleChanged)({
        toggleName,
        toggleValue
      }));
    },
    loadIndices: () => {
      dispatch((0, _actions.loadIndices)());
    },
    performExtensionAction: (requestMethod, successMessage, indexNames) => {
      dispatch((0, _actions.performExtensionAction)({
        requestMethod,
        successMessage,
        indexNames
      }));
    }
  };
};
const IndexTable = exports.IndexTable = (0, _reactRouterDom.withRouter)((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_index_table.IndexTable));