"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexActionsContextMenu = void 0;
var _reactRedux = require("react-redux");
var _index_actions_context_menu = require("./index_actions_context_menu");
var _actions = require("../../../../store/actions");
var _selectors = require("../../../../store/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = (state, ownProps) => {
  const indexStatusByName = {};
  const {
    indexNames
  } = ownProps;
  indexNames.forEach(indexName => {
    indexStatusByName[indexName] = (0, _selectors.getIndexStatusByIndexName)(state, indexName);
  });
  return {
    indexStatusByName,
    indices: (0, _selectors.getIndicesByName)(state, indexNames)
  };
};
const mapDispatchToProps = (dispatch, {
  indexNames
}) => {
  return {
    clearCacheIndices: () => {
      dispatch((0, _actions.clearCacheIndices)({
        indexNames
      }));
    },
    closeIndices: () => {
      dispatch((0, _actions.closeIndices)({
        indexNames
      }));
    },
    flushIndices: () => {
      dispatch((0, _actions.flushIndices)({
        indexNames
      }));
    },
    openIndices: () => {
      dispatch((0, _actions.openIndices)({
        indexNames
      }));
    },
    refreshIndices: () => {
      dispatch((0, _actions.refreshIndices)({
        indexNames
      }));
    },
    forcemergeIndices: maxNumSegments => {
      dispatch((0, _actions.forcemergeIndices)({
        indexNames,
        maxNumSegments
      }));
    },
    deleteIndices: () => {
      dispatch((0, _actions.deleteIndices)({
        indexNames
      }));
    },
    reloadIndices: () => {
      dispatch((0, _actions.reloadIndices)(indexNames));
    },
    performExtensionAction: (requestMethod, successMessage) => {
      dispatch((0, _actions.performExtensionAction)({
        requestMethod,
        successMessage,
        indexNames
      }));
    }
  };
};
const IndexActionsContextMenu = exports.IndexActionsContextMenu = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_index_actions_context_menu.IndexActionsContextMenu);