"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPageSettingsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lodash = _interopRequireDefault(require("lodash"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _services = require("../../../../services");
var _notification = require("../../../../services/notification");
var _flatten_object = require("../../../../lib/flatten_object");
var _edit_settings = require("../../../../lib/edit_settings");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_settings_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getEditableSettings = ({
  data,
  editableIndexSettings
}) => {
  const {
    defaults,
    settings
  } = data;
  // settings user has actually set
  const flattenedSettings = (0, _flatten_object.flattenObject)(settings);
  // settings with their defaults
  const flattenedDefaults = (0, _flatten_object.flattenObject)(defaults);
  const filteredDefaults = _lodash.default.pick(flattenedDefaults, _edit_settings.defaultsToDisplay);
  let newSettings = {
    ...filteredDefaults,
    ...flattenedSettings
  };
  if (editableIndexSettings === 'limited') {
    // only pick limited settings
    newSettings = _lodash.default.pick(newSettings, _edit_settings.limitedEditableSettings);
  } else {
    // remove read only settings
    _edit_settings.readOnlySettings.forEach(e => delete newSettings[e]);
  }
  const settingsString = JSON.stringify(newSettings, null, 2);
  return {
    originalSettings: newSettings,
    settingsString
  };
};
const DetailsPageSettingsContent = ({
  data,
  indexName,
  reloadIndexSettings,
  hasUpdateSettingsPrivilege
}) => {
  const [isEditMode, setIsEditMode] = (0, _react.useState)(false);
  const {
    config: {
      editableIndexSettings
    }
  } = (0, _app_context.useAppContext)();
  const onEditModeChange = event => {
    setUpdateError(null);
    setIsEditMode(event.target.checked);
  };
  const {
    originalSettings,
    settingsString
  } = getEditableSettings({
    data,
    editableIndexSettings
  });
  const [editableSettings, setEditableSettings] = (0, _react.useState)(settingsString);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [updateError, setUpdateError] = (0, _react.useState)(null);
  const resetChanges = (0, _react.useCallback)(() => {
    setUpdateError(null);
    setEditableSettings(settingsString);
  }, [settingsString]);
  const updateSettings = (0, _react.useCallback)(async () => {
    setUpdateError(null);
    setIsLoading(true);
    try {
      const editedSettings = JSON.parse(editableSettings);
      // don't set if the values have not changed
      Object.keys(originalSettings).forEach(key => {
        if (_lodash.default.isEqual(originalSettings[key], editedSettings[key])) {
          delete editedSettings[key];
        }
      });
      if (Object.keys(editedSettings).length !== 0) {
        const {
          error
        } = await (0, _services.updateIndexSettings)(indexName, editedSettings);
        if (error) {
          setIsLoading(false);
          setUpdateError(error);
        } else {
          setIsLoading(false);
          setIsEditMode(false);
          _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.indexDetails.settings.updateSuccessMessage', {
            defaultMessage: 'Successfully updated settings for index {indexName}',
            values: {
              indexName
            }
          }));
          reloadIndexSettings();
        }
      } else {
        setIsLoading(false);
        setIsEditMode(false);
        _notification.notificationService.showWarningToast(_i18n.i18n.translate('xpack.idxMgmt.indexDetails.settings.noChangeWarning', {
          defaultMessage: 'No settings changed'
        }));
      }
    } catch (e) {
      setIsLoading(false);
      setUpdateError({
        error: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.settings.updateError', {
          defaultMessage: 'Unable to update settings'
        })
      });
    }
  }, [originalSettings, editableSettings, indexName, reloadIndexSettings]);
  const settingsSchemaProperties = {};
  Object.keys(originalSettings).forEach(
  // allow any type of value
  setting => settingsSchemaProperties[setting] = {
    type: ['null', 'boolean', 'object', 'array', 'number', 'string']
  });
  return (
    /*#__PURE__*/
    // using "rowReverse" to keep the card on the left side to be on top of the code block on smaller screens
    _react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      direction: "rowReverse",
      css: (0, _react2.css)`
        height: 100%;
      `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      css: (0, _react2.css)`
          min-width: 400px;
        `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false,
      paddingSize: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pencil",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.settings.docsCardTitle",
      defaultMessage: "Edit index settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: /* for serverless search users hasUpdateSettingsPrivilege flag indicates if user has privilege to update index settings, for stack hasUpdateSettingsPrivilege would be undefined */
      hasUpdateSettingsPrivilege === false ? _i18n.i18n.translate('xpack.idxMgmt.indexDetails.settings.saveSettingsErrorMessage', {
        defaultMessage: 'You do not have permission to update index settings'
      }) : undefined,
      "data-test-subj": "indexDetailsSettingsEditModeSwitchToolTip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "indexDetailsSettingsEditModeSwitch",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.settings.editModeSwitchLabel",
        defaultMessage: "Edit mode",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 17
        }
      }),
      checked: isEditMode,
      onChange: onEditModeChange,
      disabled: hasUpdateSettingsPrivilege === false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "indexDetailsSettingsSave",
      fill: true,
      isDisabled: !isEditMode || !editableSettings || settingsString === editableSettings,
      isLoading: isLoading,
      onClick: updateSettings,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.settings.saveButtonLabel",
      defaultMessage: "Save changes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "indexDetailsSettingsResetChanges",
      isDisabled: !isEditMode || isLoading || settingsString === editableSettings,
      onClick: resetChanges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.settings.resetChangesButtonLabel",
      defaultMessage: "Reset changes",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 17
      }
    })))), updateError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.settings.saveSettingsErrorMessage', {
        defaultMessage: 'Unable to save settings'
      }),
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 15
      }
    }, updateError.message && /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 41
      }
    }, updateError.message))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "indexDetailsSettingsDocsLink",
      href: _services.documentationService.getSettingsDocumentationLink(),
      target: "_blank",
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.settings.docsCardLink",
      defaultMessage: "Learn more about settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 13
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 3,
      css: (0, _react2.css)`
          min-width: 600px;
        `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 9
      }
    }, isEditMode ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
      languageId: "json",
      editorDidMount: editor => {
        var _editor$getModel$uri$, _editor$getModel;
        _monaco.monaco.languages.json.jsonDefaults.setDiagnosticsOptions({
          validate: true,
          schemas: [{
            uri: (_editor$getModel$uri$ = (_editor$getModel = editor.getModel()) === null || _editor$getModel === void 0 ? void 0 : _editor$getModel.uri.toString()) !== null && _editor$getModel$uri$ !== void 0 ? _editor$getModel$uri$ : '',
            fileMatch: ['*'],
            schema: {
              type: 'object',
              properties: settingsSchemaProperties
            }
          }]
        });
      },
      value: editableSettings,
      "data-test-subj": "indexDetailsSettingsEditor",
      options: {
        lineNumbers: 'off',
        tabSize: 2,
        automaticLayout: true
      },
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.formWizard.stepSettings.fieldIndexSettingsAriaLabel', {
        defaultMessage: 'Index settings editor'
      }),
      onChange: setEditableSettings,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      isCopyable: true,
      "data-test-subj": "indexDetailsSettingsCodeBlock",
      css: (0, _react2.css)`
                height: 100%;
              `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 320,
        columnNumber: 13
      }
    }, JSON.stringify(data, null, 2)))))
  );
};
exports.DetailsPageSettingsContent = DetailsPageSettingsContent;