"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AliasesDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _overview_card = require("./overview_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/details_page/details_page_overview/aliases_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_VISIBLE_ALIASES = 3;
const AliasesDetails = ({
  aliases
}) => {
  const largeFontSize = (0, _eui.useEuiFontSize)('l').fontSize;
  const [isShowingAliases, setIsShowingAliases] = (0, _react.useState)(false);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!Array.isArray(aliases)) {
    return null;
  }
  const aliasesBadges = aliases.slice(0, MAX_VISIBLE_ALIASES).map(alias => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: alias,
    css: (0, _react2.css)`
        max-width: 250px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, alias));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_overview_card.OverviewCard, {
    "data-test-subj": "indexDetailsAliases",
    title: _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.aliases.cardTitle', {
      defaultMessage: 'Aliases'
    }),
    content: {
      left: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "baseline",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        css: (0, _react2.css)`
                    font-size: ${largeFontSize};
                  `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 17
        }
      }, aliases.length)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.aliases.aliasesCountLabel', {
        defaultMessage: '{aliases, plural, one {Alias} other {Aliases}}',
        values: {
          aliases: aliases.length
        }
      })))),
      right: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        size: "s",
        onClick: () => {
          setIsShowingAliases(true);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 13
        }
      }, "View all aliases")
    },
    footer: {
      left: /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 13
        }
      }, aliasesBadges, aliases.length > MAX_VISIBLE_ALIASES && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 17
        }
      }, "+", aliases.length - MAX_VISIBLE_ALIASES))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), isShowingAliases && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "aria-labelledby": flyoutTitleId,
    ownFocus: true,
    onClose: () => setIsShowingAliases(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.indexDetails.overviewTab.aliases.cardTitle', {
    defaultMessage: 'Aliases'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    maxWidth: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, aliases.map(alias => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    wrapText: true,
    key: alias,
    label: alias,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }))))));
};
exports.AliasesDetails = AliasesDetails;