"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultFlyoutProps = exports.EditFieldContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _ = require("../../../../../..");
var _shared_imports = require("../../../../shared_imports");
var _mappings_state_context = require("../../../../mappings_state_context");
var _lib = require("../../../../lib");
var _modal_confirmation_delete_fields = require("../modal_confirmation_delete_fields");
var _edit_field = require("./edit_field");
var _use_update_field = require("./use_update_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/fields/edit_field/edit_field_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// important to use css from @emotion/css, as @emotion/react version returns
// serialized styles instead of pure class names
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultFlyoutProps = exports.defaultFlyoutProps = {
  'data-test-subj': 'mappingsEditorFieldEdit',
  'aria-labelledby': 'mappingsEditorFieldEditTitle',
  className: (0, _css.css)({
    minWidth: '680px'
  }),
  maxWidth: 720
};
const EditFieldContainer = exports.EditFieldContainer = /*#__PURE__*/_react.default.memo(({
  exitEdit
}) => {
  const {
    fields,
    documentFields
  } = (0, _mappings_state_context.useMappingsState)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    updateField,
    modal
  } = (0, _use_update_field.useUpdateField)();
  const {
    services: {
      kibanaVersion
    }
  } = (0, _.useKibana)();
  const {
    status,
    fieldToEdit
  } = documentFields;
  const isEditing = status === 'editingField';
  const field = fields.byId[fieldToEdit];
  const formDefaultValue = (0, _react.useMemo)(() => {
    return {
      ...(field === null || field === void 0 ? void 0 : field.source)
    };
  }, [field === null || field === void 0 ? void 0 : field.source]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: formDefaultValue,
    serializer: _lib.fieldSerializer,
    deserializer: _lib.fieldDeserializer,
    options: {
      stripEmptyFields: false
    },
    id: 'edit-field'
  });
  const {
    subscribe
  } = form;
  (0, _react.useEffect)(() => {
    const subscription = subscribe(updatedFieldForm => {
      dispatch({
        type: 'fieldForm.update',
        value: updatedFieldForm
      });
    });
    return subscription.unsubscribe;
  }, [subscribe, dispatch]);
  const renderModal = () => {
    return modal.isOpen ? /*#__PURE__*/_react.default.createElement(_modal_confirmation_delete_fields.ModalConfirmationDeleteFields, (0, _extends2.default)({}, modal.props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 27
      }
    })) : null;
  };
  if (!isEditing) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.EditField, {
    form: form,
    field: field,
    allFields: fields.byId,
    exitEdit: exitEdit,
    updateField: updateField,
    kibanaVersion: kibanaVersion.get(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), renderModal());
});