"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lib = require("../../lib");
var _mappings_state_context = require("../../mappings_state_context");
var _shared_imports = require("../../shared_imports");
var _fields = require("./fields");
var _fields_json_editor = require("./fields_json_editor");
var _fields_tree_editor = require("./fields_tree_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/document_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const DocumentFields = exports.DocumentFields = /*#__PURE__*/_react.default.memo(({
  searchComponent,
  searchResultComponent,
  onCancelAddingNewFields,
  isAddingFields,
  semanticTextInfo,
  pendingFieldsRef
}) => {
  const {
    fields,
    documentFields
  } = (0, _mappings_state_context.useMappingsState)();
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const {
    editor: editorType
  } = documentFields;
  const isEditing = documentFields.status === 'editingField';
  const jsonEditorDefaultValue = (0, _react.useMemo)(() => {
    if (editorType === 'json') {
      return (0, _lib.deNormalize)(fields);
    }
  }, [editorType, fields]);
  const editor = editorType === 'json' ? /*#__PURE__*/_react.default.createElement(_fields_json_editor.DocumentFieldsJsonEditor, {
    defaultValue: jsonEditorDefaultValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_fields_tree_editor.DocumentFieldsTreeEditor, {
    onCancelAddingNewFields: onCancelAddingNewFields,
    isAddingFields: isAddingFields,
    semanticTextInfo: semanticTextInfo,
    pendingFieldsRef: pendingFieldsRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  });
  const exitEdit = (0, _react.useCallback)(() => {
    dispatch({
      type: 'documentField.changeStatus',
      value: 'idle'
    });
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    if (isEditing) {
      // Open the flyout with the <EditField /> content
      addContentToGlobalFlyout({
        id: 'mappingsEditField',
        Component: _fields.EditFieldContainer,
        props: {
          exitEdit
        },
        flyoutProps: {
          ..._fields.defaultFlyoutProps,
          onClose: exitEdit
        },
        cleanUpFunc: exitEdit
      });
    }
  }, [isEditing, addContentToGlobalFlyout, fields.byId, exitEdit]);
  (0, _react.useEffect)(() => {
    if (!isEditing) {
      removeContentFromGlobalFlyout('mappingsEditField');
      if (pendingFieldsRef !== null && pendingFieldsRef !== void 0 && pendingFieldsRef.current) pendingFieldsRef.current.focus();
    }
  }, [isEditing, removeContentFromGlobalFlyout, pendingFieldsRef]);
  (0, _react.useEffect)(() => {
    return () => {
      if (isEditing) {
        // When the component unmounts, exit edit mode.
        exitEdit();
      }
    };
  }, [isEditing, exitEdit]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "documentFields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, searchComponent, searchResultComponent ? searchResultComponent : editor);
});