"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatesSelector = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../shared_imports");
var _component_template_details = require("../component_template_details");
var _components = require("./components");
var _component_templates = require("./component_templates");
var _component_templates_selection = require("./component_templates_selection");
var _component_templates_context = require("../component_templates_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_selector/component_templates_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const useStyles = ({
  hasSelection
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    selector: (0, _react.css)`
      height: 480px;
    `,
    selection: (0, _react.css)`
      border: ${euiTheme.border.thin};
      border-radius: ${euiTheme.border.radius.medium};
      padding: 0 ${euiTheme.size.base} ${euiTheme.size.base};
      color: ${euiTheme.colors.darkShade};

      ${!hasSelection && (0, _react.css)`
        align-items: center;
        justify-content: center;
      `}
    `,
    selectionHeader: (0, _react.css)`
      background-color: ${euiTheme.colors.lightestShade};
      border-bottom: ${euiTheme.border.thin};
      color: ${euiTheme.colors.fullShade};
      height: ${euiTheme.size.xxl}; /* Height to align left and right column headers */
      line-height: ${euiTheme.size.xxl}; /* Height to align left and right column headers */
      font-size: ${euiTheme.size.m};
      margin-bottom: ${euiTheme.size.s};
      margin-left: calc(${euiTheme.size.base} * -1);
      margin-right: calc(${euiTheme.size.base} * -1);
      padding-left: ${euiTheme.size.base};
    `,
    selectionHeaderCount: (0, _react.css)`
      font-weight: 600;
    `,
    selectionContent: (0, _react.css)`
      mask-image: none;
    `
  };
};
const i18nTexts = {
  icons: {
    view: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.viewItemIconLabel', {
      defaultMessage: 'View'
    }),
    select: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.selectItemIconLabel', {
      defaultMessage: 'Select'
    }),
    remove: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesSelector.removeItemIconLabel', {
      defaultMessage: 'Remove'
    })
  }
};
const ComponentTemplatesSelector = ({
  onChange,
  defaultValue,
  onComponentsLoaded,
  docUri,
  emptyPrompt: {
    text,
    showCreateButton
  } = {}
}) => {
  const {
    data: components,
    isLoading,
    error
  } = (0, _component_templates_context.useApi)().useLoadComponentTemplates();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const [selectedComponent, setSelectedComponent] = (0, _react2.useState)(null);
  const [componentsSelected, setComponentsSelected] = (0, _react2.useState)([]);
  const isInitialized = (0, _react2.useRef)(false);
  const hasSelection = Object.keys(componentsSelected).length > 0;
  const hasComponents = components && components.length > 0 ? true : false;
  const styles = useStyles({
    hasSelection
  });
  const closeComponentTemplateDetails = () => {
    setSelectedComponent(null);
  };
  (0, _react2.useEffect)(() => {
    if (components) {
      if (defaultValue && defaultValue.length > 0 && componentsSelected.length === 0 && isInitialized.current === false) {
        // Once the components are fetched, we check the ones previously selected
        // from the prop "defaultValue" passed.
        const nextComponentsSelected = defaultValue.map(name => components.find(comp => comp.name === name)).filter(Boolean);

        // Add the non-existing templates from the "defaultValue" prop
        const missingDefaultComponents = defaultValue.filter(name => !components.find(comp => comp.name === name)).map(name => ({
          name,
          usedBy: [],
          hasMappings: false,
          hasAliases: false,
          hasSettings: false,
          isManaged: false
        }));
        setComponentsSelected([...nextComponentsSelected, ...missingDefaultComponents]);
        onChange([...nextComponentsSelected, ...missingDefaultComponents].map(({
          name
        }) => name));
        isInitialized.current = true;
      } else {
        onChange(componentsSelected.map(({
          name
        }) => name));
      }
    }
  }, [defaultValue, components, componentsSelected, onChange]);
  (0, _react2.useEffect)(() => {
    if (!isLoading && !error) {
      onComponentsLoaded(components !== null && components !== void 0 ? components : []);
    }
  }, [isLoading, error, components, onComponentsLoaded]);
  (0, _react2.useEffect)(() => {
    if (selectedComponent) {
      // Open the flyout with the Component Template Details content
      addContentToGlobalFlyout({
        id: 'componentTemplateDetails',
        Component: _component_template_details.ComponentTemplateDetailsFlyoutContent,
        props: {
          onClose: closeComponentTemplateDetails,
          componentTemplateName: selectedComponent
        },
        flyoutProps: {
          ..._component_template_details.defaultFlyoutProps,
          onClose: closeComponentTemplateDetails
        },
        cleanUpFunc: () => {
          setSelectedComponent(null);
        }
      });
    }
  }, [selectedComponent, addContentToGlobalFlyout]);
  (0, _react2.useEffect)(() => {
    if (!selectedComponent) {
      removeContentFromGlobalFlyout('componentTemplateDetails');
    }
  }, [selectedComponent, removeContentFromGlobalFlyout]);
  const onSelectionReorder = reorderedComponents => {
    setComponentsSelected(reorderedComponents);
  };
  const renderLoading = () => /*#__PURE__*/_react2.default.createElement(_shared_imports.SectionLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplatesSelector.loadingComponentsDescription",
    defaultMessage: "Loading component templates\u2026",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }));
  const renderError = () => /*#__PURE__*/_react2.default.createElement(_shared_imports.SectionError, {
    title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplatesSelector.loadingComponentsErrorMessage",
      defaultMessage: "Error loading components",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 9
      }
    }),
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  });
  const renderSelector = () => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: styles.selector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: styles.selection,
    "data-test-subj": "componentTemplatesSelection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 7
    }
  }, hasSelection ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.selectionHeader,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplatesSelector.selectionHeader.componentsSelectedLabel",
    defaultMessage: "Components selected: {count}",
    values: {
      count: /*#__PURE__*/_react2.default.createElement("span", {
        css: styles.selectionHeaderCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 26
        }
      }, componentsSelected.length)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react2.default.createElement("div", {
    css: styles.selectionContent,
    className: "eui-yScrollWithShadows",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_component_templates_selection.ComponentTemplatesSelection, {
    components: componentsSelected,
    onReorder: onSelectionReorder,
    listItemProps: {
      onViewDetail: component => {
        setSelectedComponent(component.name);
      },
      actions: [{
        label: i18nTexts.icons.remove,
        icon: 'minusInCircle',
        handler: component => {
          setComponentsSelected(prev => {
            return prev.filter(({
              name
            }) => component.name !== name);
          });
        }
      }]
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    textAlign: "center",
    "data-test-subj": "emptyPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplatesSelector.noComponentSelectedLabel-1",
    defaultMessage: "Add component template building blocks to this template.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplatesSelector.noComponentSelectedLabel-2",
    defaultMessage: "Component templates are applied in the order specified.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_component_templates.ComponentTemplates, {
    isLoading: isLoading,
    components: components !== null && components !== void 0 ? components : [],
    listItemProps: {
      onViewDetail: component => {
        setSelectedComponent(component.name);
      },
      actions: [{
        label: i18nTexts.icons.select,
        icon: 'plusInCircle',
        handler: component => {
          setComponentsSelected(prev => {
            return [...prev, component];
          });
        }
      }],
      isSelected: component => {
        return componentsSelected.find(({
          name
        }) => component.name === name) !== undefined;
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  })));
  if (isLoading) {
    return renderLoading();
  } else if (error) {
    return renderError();
  } else if (hasComponents) {
    return renderSelector();
  }

  // No components: render empty prompt
  const emptyPromptBody = /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }, text !== null && text !== void 0 ? text : /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplatesSelector.emptyPromptDescription",
    defaultMessage: "Components templates let you save index settings, mappings and aliases and inherit from them in index templates.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: docUri,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplatesSelector.emptyPromptLearnMoreLinkText",
    defaultMessage: "Learn more.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 11
    }
  }))));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "managementApp",
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplatesSelector.emptyPromptTitle",
      defaultMessage: "You don\u2019t have any components yet",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 329,
        columnNumber: 11
      }
    })),
    body: emptyPromptBody,
    actions: showCreateButton ? /*#__PURE__*/_react2.default.createElement(_components.CreateButtonPopOver, {
      anchorPosition: "downCenter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 35
      }
    }) : undefined,
    "data-test-subj": "emptyPrompt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 5
    }
  });
};
exports.ComponentTemplatesSelector = ComponentTemplatesSelector;