"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecatedPolicyBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/components/deprecated_policy_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const deprecatedPolicyTooltips = {
  badge: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.templateBadgeType.deprecatedLabel', {
    defaultMessage: 'Deprecated'
  }),
  badgeTooltip: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.templateBadgeType.deprecatedDescription', {
    defaultMessage: 'This policy is no longer supported and might be removed in a future release. Instead, use one of the other policies available or create a new one.'
  })
};
const DeprecatedPolicyBadge = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: deprecatedPolicyTooltips.badgeTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: "warning",
    "data-test-subj": "deprecatedPolicyBadge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, deprecatedPolicyTooltips.badge));
};
exports.DeprecatedPolicyBadge = DeprecatedPolicyBadge;