"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlTemplateList = UrlTemplateList;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _url_template_form = require("./url_template_form");
var _use_list_keys = require("./use_list_keys");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/graph/public/components/settings/url_template_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const generateId = (0, _eui.htmlIdGenerator)();
function UrlTemplateList({
  removeTemplate,
  saveTemplate,
  urlTemplates
}) {
  const [uncommittedForms, setUncommittedForms] = (0, _react.useState)([]);
  const getListKey = (0, _use_list_keys.useListKeys)(urlTemplates);
  function removeUncommittedForm(id) {
    setUncommittedForms(uncommittedForms.filter(formId => formId !== id));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.graph.drilldowns.description', {
    defaultMessage: 'Use drilldowns to link to other applications. The selected vertices become part of the URL.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }), urlTemplates.map((template, index) => /*#__PURE__*/_react.default.createElement(_url_template_form.UrlTemplateForm, {
    key: getListKey(template),
    id: getListKey(template),
    initialTemplate: template,
    onSubmit: newTemplate => {
      saveTemplate({
        index,
        template: newTemplate
      });
    },
    onRemove: () => {
      removeTemplate(template);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  })), uncommittedForms.map(id => /*#__PURE__*/_react.default.createElement(_url_template_form.UrlTemplateForm, {
    id: `accordion-new-${id}`,
    key: id,
    onSubmit: newTemplate => {
      saveTemplate({
        index: -1,
        template: newTemplate
      });
      removeUncommittedForm(id);
    },
    onRemove: removeUncommittedForm.bind(undefined, id),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "graphAddNewTemplate",
    onClick: () => {
      setUncommittedForms([...uncommittedForms, generateId()]);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.graph.templates.newTemplateFormLabel', {
    defaultMessage: 'Add drilldown'
  }))));
}