"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _router = require("./router");
var _check_license = require("../common/check_license");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/graph/public/application.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * These are dependencies of the Graph app besides the base dependencies
 * provided by the application service. Some of those still rely on non-shimmed
 * plugins in LP-world, but if they are migrated only the import path in the plugin
 * itself changes
 */

const renderApp = ({
  history,
  element,
  ...deps
}) => {
  const {
    chrome,
    capabilities,
    core
  } = deps;
  if (!capabilities.graph.save) {
    chrome.setBadge({
      text: _i18n.i18n.translate('xpack.graph.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('xpack.graph.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to save Graph workspaces'
      }),
      iconType: 'glasses'
    });
  }
  const licenseSubscription = deps.licensing.license$.subscribe(license => {
    const info = (0, _check_license.checkLicense)(license);
    const licenseAllowsToShowThisPage = info.showAppLink && info.enableAppLink;
    if (!licenseAllowsToShowThisPage) {
      if (info.message) {
        deps.core.notifications.toasts.addDanger(info.message);
      }

      // This has to happen in the next tick because otherwise the original navigation
      // bringing us to the graph app in the first place
      // never completes and the browser enters are redirect loop
      setTimeout(() => {
        deps.core.application.navigateToApp('home');
      }, 0);
    }
  });

  // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
  const unlistenParentHistory = history.listen(() => {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  const app = /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core,
    FormattedRelative: _i18nReact.FormattedRelative,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, (0, _router.graphRouter)(deps)));
  _reactDom.default.render(app, element);
  return () => {
    licenseSubscription.unsubscribe();
    unlistenParentHistory();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;