"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenAiSettingsApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _spacesUtils = require("@kbn/spaces-utils");
var _lodash = require("lodash");
var _enabled_features_context = require("../contexts/enabled_features_context");
var _use_kibana = require("../hooks/use_kibana");
var _go_to_spaces_button = require("./go_to_spaces_button");
var _use_genai_connectors = require("../hooks/use_genai_connectors");
var _get_elastic_managed_llm_connector = require("../utils/get_elastic_managed_llm_connector");
var _settings_context = require("../contexts/settings_context");
var _default_ai_connector = require("./default_ai_connector/default_ai_connector");
var _bottom_bar_actions = require("./bottom_bar_actions/bottom_bar_actions");
var _ai_assistant_visibility = require("./ai_assistant_visibility/ai_assistant_visibility");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/gen_ai_settings_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GenAiSettingsApp = ({
  setBreadcrumbs
}) => {
  var _application$capabili, _application$capabili2, _application$capabili3, _application$capabili4;
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    application,
    http,
    docLinks
  } = services;
  const {
    showSpacesIntegration,
    isPermissionsBased,
    showAiBreadcrumb,
    showAiAssistantsVisibilitySetting
  } = (0, _enabled_features_context.useEnabledFeatures)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    unsavedChanges,
    isSaving,
    cleanUnsavedChanges,
    saveAll
  } = (0, _settings_context.useSettingsContext)();
  const hasConnectorsAllPrivilege = ((_application$capabili = application.capabilities.actions) === null || _application$capabili === void 0 ? void 0 : _application$capabili.show) === true && ((_application$capabili2 = application.capabilities.actions) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.execute) === true && ((_application$capabili3 = application.capabilities.actions) === null || _application$capabili3 === void 0 ? void 0 : _application$capabili3.delete) === true && ((_application$capabili4 = application.capabilities.actions) === null || _application$capabili4 === void 0 ? void 0 : _application$capabili4.save) === true;
  const canManageSpaces = application.capabilities.management.kibana.spaces;
  const connectors = (0, _use_genai_connectors.useGenAiConnectors)();
  const hasElasticManagedLlm = (0, _get_elastic_managed_llm_connector.getElasticManagedLlmConnector)(connectors.connectors);
  (0, _react.useEffect)(() => {
    const breadcrumbs = [...(showAiBreadcrumb ? [{
      text: _i18n.i18n.translate('genAiSettings.breadcrumbs.ai', {
        defaultMessage: 'AI'
      })
    }] : []), {
      text: _i18n.i18n.translate('genAiSettings.breadcrumbs.genAiSettings', {
        defaultMessage: 'GenAI Settings'
      })
    }];
    setBreadcrumbs(breadcrumbs);
  }, [setBreadcrumbs, showAiBreadcrumb]);
  const handleNavigateToSpaces = (0, _react.useCallback)(() => {
    const basePath = http.basePath.get();
    const {
      spaceId
    } = (0, _spacesUtils.getSpaceIdFromPath)(basePath, http.basePath.serverBasePath);
    const spacesPath = `/kibana/spaces/edit/${spaceId}${isPermissionsBased ? '/roles' : ''}`;
    application.navigateToApp('management', {
      path: spacesPath,
      openInNewTab: true
    });
  }, [application, http.basePath, isPermissionsBased]);
  const connectorDescription = (0, _react.useMemo)(() => {
    var _docLinks$links, _docLinks$links$obser;
    if (!hasElasticManagedLlm) {
      return /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "genAiSettings.aiConnectorDescription",
        defaultMessage: `A large language model (LLM) is required to power the AI Assistant and AI-driven features in Elastic. In order to use the AI Assistant you must ${hasConnectorsAllPrivilege ? 'set up' : 'have'} a Generative AI connector. {manageConnectors}`,
        values: {
          manageConnectors: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: application.getUrlForApp('management', {
              path: 'insightsAndAlerting/triggersActionsConnectors/connectors'
            }),
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 106,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "genAiSettings.manage.connectors",
            defaultMessage: hasConnectorsAllPrivilege ? 'Manage connectors' : 'View connectors',
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 112,
              columnNumber: 19
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 11
        }
      }));
    }
    const showSpacesNote = showSpacesIntegration && canManageSpaces && hasConnectorsAllPrivilege;
    return /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.aiConnectorDescriptionWithLink",
      defaultMessage: `A large language model (LLM) is required to power the AI Assistant and AI-powered features. By default, Elastic uses its {elasticManagedLlm} connector ({link}) when no custom connectors are available. When available, Elastic uses the last used custom connector.${showSpacesNote ? ' Set up your own connectors or disable the AI Assistant from the {aiFeatureVisibility} setting below.' : ''} {manageConnectors}`,
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$obser = _docLinks$links.observability) === null || _docLinks$links$obser === void 0 ? void 0 : _docLinks$links$obser.elasticManagedLlmUsageCost,
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.additionalCostsLink",
          defaultMessage: "additional costs incur",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 143,
            columnNumber: 17
          }
        })),
        manageConnectors: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: application.getUrlForApp('management', {
            path: 'insightsAndAlerting/triggersActionsConnectors/connectors'
          }),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 150,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.manage.connectors",
          defaultMessage: "Manage connectors",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 156,
            columnNumber: 17
          }
        })),
        elasticManagedLlm: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 163,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.elasticManagedLlm",
          defaultMessage: "Elastic Managed LLM",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 164,
            columnNumber: 17
          }
        })),
        ...(showSpacesNote && {
          aiFeatureVisibility: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 172,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "genAiSettings.aiFeatureVisibilityText",
            defaultMessage: "AI feature visibility",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 173,
              columnNumber: 19
            }
          }))
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }));
  }, [hasElasticManagedLlm, hasConnectorsAllPrivilege, showSpacesIntegration, canManageSpaces, docLinks, application]);
  async function handleSave() {
    const needsReload = await saveAll();
    if (needsReload) {
      window.location.reload();
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "genAiSettingsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "genAiSettingsTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.genAiSettings.pageTitle",
    defaultMessage: "GenAI Settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    paddingSize: "none",
    css: {
      paddingTop: euiTheme.size.l
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    "data-test-subj": "connectorsSection",
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sparkles",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "connectorsTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.aiConnectorLabel",
      defaultMessage: "Default AI Connector",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 25
      }
    }))))),
    description: connectorDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_default_ai_connector.DefaultAIConnector, {
    connectors: connectors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 21
    }
  }))))), showSpacesIntegration && canManageSpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 58
    }
  }), showSpacesIntegration && canManageSpaces && /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    "data-test-subj": "aiFeatureVisibilitySection",
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": "aiFeatureVisibilityTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.aiFeatureVisibilityLabel",
      defaultMessage: "AI feature visibility",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 21
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 19
      }
    }, isPermissionsBased ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.solutionViewDescriptionLabel",
      defaultMessage: "Turn AI-powered features on or off (for custom roles only) on the {permissionsTab} in the {spaces} settings. Create custom roles at {rolesLink}.",
      values: {
        permissionsTab: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 269,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.permissionsTab",
          defaultMessage: "Permissions tab",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 270,
            columnNumber: 31
          }
        })),
        spaces: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 277,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.spacesLabel",
          defaultMessage: "Spaces",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 278,
            columnNumber: 31
          }
        })),
        rolesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: application.getUrlForApp('management', {
            path: '/security/roles'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 285,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.rolesLink",
          defaultMessage: "Stack Management > Roles",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 290,
            columnNumber: 31
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 23
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "genAiSettings.showAIAssistantDescriptionLabel",
      defaultMessage: "Enable or disable AI-powered features in {space} settings.",
      values: {
        space: /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 304,
            columnNumber: 29
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "genAiSettings.spacesLabel",
          defaultMessage: "Space",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 305,
            columnNumber: 31
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 23
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_go_to_spaces_button.GoToSpacesButton, {
    onNavigateToSpaces: handleNavigateToSpaces,
    navigateToPermissions: isPermissionsBased,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 19
    }
  }))), showAiAssistantsVisibilitySetting && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_ai_assistant_visibility.AIAssistantVisibility, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 17
    }
  }))))), !(0, _lodash.isEmpty)(unsavedChanges) && /*#__PURE__*/_react.default.createElement(_bottom_bar_actions.BottomBarActions, {
    isLoading: isSaving,
    onDiscardChanges: cleanUnsavedChanges,
    onSave: handleSave,
    saveLabel: _i18n.i18n.translate('xpack.gen_ai_settings.settings.saveButton', {
      defaultMessage: 'Save changes'
    }),
    unsavedChangesCount: Object.keys(unsavedChanges).length,
    appTestSubj: "genAiSettingsSaveBar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 9
    }
  }));
};
exports.GenAiSettingsApp = GenAiSettingsApp;