"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantVisibility = void 0;
var _react = _interopRequireDefault(require("react"));
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _settings_context = require("../../contexts/settings_context");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/ai_assistant_visibility/ai_assistant_visibility.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AIAssistantVisibility = () => {
  var _application$capabili;
  const {
    fields,
    handleFieldChange,
    unsavedChanges
  } = (0, _settings_context.useSettingsContext)();
  const {
    services: {
      settings,
      notifications,
      docLinks,
      application
    }
  } = (0, _use_kibana.useKibana)();
  const field = fields[_managementSettingsIds.AI_ASSISTANT_PREFERRED_AI_ASSISTANT_TYPE];
  if (!field) return null;
  const canEditAdvancedSettings = (_application$capabili = application.capabilities.advancedSettings) === null || _application$capabili === void 0 ? void 0 : _application$capabili.save;
  return /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
    links: docLinks.links.management,
    showDanger: message => notifications.toasts.addDanger(message),
    validateChange: (key, value) => settings.client.validateValue(key, value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRow, {
    field: field,
    isSavingEnabled: !!canEditAdvancedSettings,
    onFieldChange: handleFieldChange,
    unsavedChange: unsavedChanges[_managementSettingsIds.AI_ASSISTANT_PREFERRED_AI_ASSISTANT_TYPE],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }));
};
exports.AIAssistantVisibility = AIAssistantVisibility;