/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.fleet_bundle_jsonpfunction=self.fleet_bundle_jsonpfunction||[]).push([[575],{28707:(e,t,a)=>{a.r(t),a.d(t,{ALLOWED_JOB_CONTENT_TYPES:()=>s,AuthenticationExpiredError:()=>AuthenticationExpiredError,BrowserCouldNotLaunchError:()=>BrowserCouldNotLaunchError,BrowserScreenshotError:()=>BrowserScreenshotError,BrowserUnexpectedlyClosedError:()=>BrowserUnexpectedlyClosedError,CancellationToken:()=>CancellationToken,DisallowedOutgoingUrl:()=>DisallowedOutgoingUrl,EXPORT_TYPE_SCHEDULED:()=>x,EXPORT_TYPE_SINGLE:()=>f,ILM_POLICY_NAME:()=>S,INTERNAL_ROUTES:()=>B,InvalidLayoutParametersError:()=>InvalidLayoutParametersError,JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY:()=>E,JOB_STATUS:()=>F,KibanaShuttingDownError:()=>KibanaShuttingDownError,LICENSE_TYPE_BASIC:()=>r,LICENSE_TYPE_CLOUD_STANDARD:()=>u,LICENSE_TYPE_ENTERPRISE:()=>g,LICENSE_TYPE_GOLD:()=>d,LICENSE_TYPE_PLATINUM:()=>c,LICENSE_TYPE_TRIAL:()=>o,MissingAuthenticationError:()=>MissingAuthenticationError,PUBLIC_ROUTES:()=>N,PdfWorkerOutOfMemoryError:()=>PdfWorkerOutOfMemoryError,QueueTimeoutError:()=>QueueTimeoutError,REPORTING_EXPORT_TYPES:()=>h,REPORTING_FEATURE_ID:()=>m,REPORTING_MANAGEMENT_HOME:()=>j,REPORTING_MANAGEMENT_SCHEDULES:()=>b,REPORTING_REDIRECT_ALLOWED_LOCATOR_TYPES:()=>y,REPORTING_REDIRECT_APP:()=>k,REPORTING_REDIRECT_LOCATOR_STORE_KEY:()=>v,REPORT_TABLE_ID:()=>M,REPORT_TABLE_ROW_ID:()=>I,ReportingError:()=>ReportingError,ReportingSavedObjectNotFoundError:()=>ReportingSavedObjectNotFoundError,SCHEDULED_REPORT_VALID_LICENSES:()=>p,UI_SETTINGS_CUSTOM_PDF_LOGO:()=>l,UI_SETTINGS_DATEFORMAT_TZ:()=>i,UI_SETTINGS_SEARCH_INCLUDE_FROZEN:()=>n,UnknownError:()=>UnknownError,VisualReportingSoftDisabledError:()=>VisualReportingSoftDisabledError,buildKibanaPath:()=>O,byteSizeValueToNumber:()=>L,durationToNumber:()=>P,numberToDuration:()=>_});const s=["application/json","application/pdf","text/csv","image/png","text/plain"],n="search:includeFrozen",l="xpackReporting:customPdfLogo",i="dateFormat:tz",o="trial",r="basic",u="standard",d="gold",c="platinum",g="enterprise",p=[o,u,d,c,g],m="Reporting",f="single",x="scheduled",h=[f,x],E="xpack.reporting.jobCompletionNotifications",y=["DISCOVER_APP_LOCATOR","CANVAS_APP_LOCATOR","DASHBOARD_APP_LOCATOR","LENS_APP_LOCATOR","VISUALIZE_APP_LOCATOR"],k="/app/reportingRedirect",v="__REPORTING_REDIRECT_LOCATOR_STORE_KEY__",j="/app/management/insightsAndAlerting/reporting",b="/app/management/insightsAndAlerting/reporting/schedules",S="kibana-reporting";let F=function(e){return e.PENDING="pending",e.PROCESSING="processing",e.COMPLETED="completed",e.FAILED="failed",e.WARNINGS="completed_with_warnings",e}({});const M="reportJobListing",I="reportJobRow";var T=a(68915),w=a(75008);class ReportingError extends Error{constructor(e){super(),this.details=e}get message(){const e="ReportingError";return this.details?`${e}(code: ${this.code}) "${this.details}"`:`${e}(code: ${this.code})`}toString(){return this.message}}class InvalidLayoutParametersError extends ReportingError{get code(){return InvalidLayoutParametersError.code}}(0,T.default)(InvalidLayoutParametersError,"code","invalid_layout_parameters_error");class DisallowedOutgoingUrl extends ReportingError{get code(){return DisallowedOutgoingUrl.code}}(0,T.default)(DisallowedOutgoingUrl,"code","disallowed_outgoing_url_error");class AuthenticationExpiredError extends ReportingError{get code(){return AuthenticationExpiredError.code}}(0,T.default)(AuthenticationExpiredError,"code","authentication_expired_error");class MissingAuthenticationError extends ReportingError{get code(){return MissingAuthenticationError.code}}(0,T.default)(MissingAuthenticationError,"code","missing_authentication_header_error");class QueueTimeoutError extends ReportingError{get code(){return QueueTimeoutError.code}}(0,T.default)(QueueTimeoutError,"code","queue_timeout_error");class UnknownError extends ReportingError{get code(){return UnknownError.code}}(0,T.default)(UnknownError,"code","unknown_error");class PdfWorkerOutOfMemoryError extends ReportingError{get code(){return PdfWorkerOutOfMemoryError.code}humanFriendlyMessage(){return w.i18n.translate("reporting.common.pdfWorkerOutOfMemoryErrorMessage",{defaultMessage:"Can't generate a PDF due to insufficient memory. Try making a smaller PDF and retrying this report."})}}(0,T.default)(PdfWorkerOutOfMemoryError,"code","pdf_worker_out_of_memory_error");class BrowserCouldNotLaunchError extends ReportingError{get code(){return BrowserCouldNotLaunchError.code}humanFriendlyMessage(){return w.i18n.translate("reporting.common.browserCouldNotLaunchErrorMessage",{defaultMessage:"Can't generate screenshots because the browser did not launch. See the server logs for more information."})}}(0,T.default)(BrowserCouldNotLaunchError,"code","browser_could_not_launch_error");class BrowserUnexpectedlyClosedError extends ReportingError{get code(){return BrowserUnexpectedlyClosedError.code}}(0,T.default)(BrowserUnexpectedlyClosedError,"code","browser_unexpectedly_closed_error");class BrowserScreenshotError extends ReportingError{get code(){return BrowserScreenshotError.code}}(0,T.default)(BrowserScreenshotError,"code","browser_screenshot_error");class KibanaShuttingDownError extends ReportingError{get code(){return KibanaShuttingDownError.code}}(0,T.default)(KibanaShuttingDownError,"code","kibana_shutting_down_error");class VisualReportingSoftDisabledError extends ReportingError{get code(){return VisualReportingSoftDisabledError.code}humanFriendlyMessage(){return w.i18n.translate("reporting.common.cloud.insufficientSystemMemoryError",{defaultMessage:"Can't generate this report due to insufficient memory."})}}(0,T.default)(VisualReportingSoftDisabledError,"code","visual_reporting_soft_disabled_error");class ReportingSavedObjectNotFoundError extends ReportingError{get code(){return ReportingSavedObjectNotFoundError.code}}(0,T.default)(ReportingSavedObjectNotFoundError,"code","reporting_saved_object_not_found_error");var C=a(51783),A=a.n(C);const P=e=>"number"==typeof e?e:e.asMilliseconds(),_=e=>"number"==typeof e?A().duration(e,"milliseconds"):e,L=e=>"number"==typeof e?e:e.getValueInBytes();var D=a(30770);class CancellationToken{constructor(){(0,T.default)(this,"_isCancelled",void 0),(0,T.default)(this,"_callbacks",void 0),(0,T.default)(this,"on",(e=>{if(!(0,D.isFunction)(e))throw new Error("Expected callback to be a function");this._isCancelled?e():this._callbacks.push(e)})),(0,T.default)(this,"cancel",(()=>{this._isCancelled=!0,this._callbacks.forEach((e=>e()))})),this._isCancelled=!1,this._callbacks=[]}isCancelled(){return this._isCancelled}}const O=({basePath:e,appPath:t,spaceId:a})=>void 0===a||"default"===a.toLowerCase()?`${e}${t}`:`${e}/s/${a}${t}`,R="/internal/reporting",B={MIGRATE:{MIGRATE_ILM_POLICY:R+"/deprecations/migrate_ilm_policy",GET_ILM_POLICY_STATUS:R+"/ilm_policy_status"},DIAGNOSE:{BROWSER:R+"/diagnose/browser",SCREENSHOT:R+"/diagnose/screenshot"},JOBS:{COUNT:R+"/jobs/count",LIST:R+"/jobs/list",INFO_PREFIX:R+"/jobs/info",DELETE_PREFIX:R+"/jobs/delete",DOWNLOAD_PREFIX:R+"/jobs/download"},SCHEDULED:{LIST:R+"/scheduled/list",BULK_DISABLE:R+"/scheduled/bulk_disable"},HEALTH:R+"/_health",GENERATE_PREFIX:R+"/generate",SCHEDULE_PREFIX:R+"/schedule"},z="/api/reporting",N={GENERATE_PREFIX:z+"/generate",JOBS:{DOWNLOAD_PREFIX:z+"/jobs/download",DELETE_PREFIX:z+"/jobs/delete"}}},34127:(e,t,a)=>{a.r(t),a.d(t,{InternalApiClientProvider:()=>k,Job:()=>Job,ReportingAPIClient:()=>ReportingAPIClient,checkLicense:()=>w,jobCompletionNotifications:()=>E,useCheckIlmPolicyStatus:()=>b,useInternalApiClient:()=>v,useKibana:()=>A});var s=a(68915),n=a(51783),l=a.n(n),i=a(84286),o=a.n(i),r=a(81319),u=a(75008),d=a(28707),c=a(96791);const{COMPLETED:g,FAILED:p,PENDING:m,PROCESSING:f,WARNINGS:x}=d.JOB_STATUS;class Job{constructor(e){var t,a,n,l,i,o;(0,s.default)(this,"payload",void 0),(0,s.default)(this,"id",void 0),(0,s.default)(this,"index",void 0),(0,s.default)(this,"objectType",void 0),(0,s.default)(this,"title",void 0),(0,s.default)(this,"isDeprecated",void 0),(0,s.default)(this,"spaceId",void 0),(0,s.default)(this,"browserTimezone",void 0),(0,s.default)(this,"layout",void 0),(0,s.default)(this,"pagingStrategy",void 0),(0,s.default)(this,"version",void 0),(0,s.default)(this,"jobtype",void 0),(0,s.default)(this,"created_by",void 0),(0,s.default)(this,"created_at",void 0),(0,s.default)(this,"started_at",void 0),(0,s.default)(this,"completed_at",void 0),(0,s.default)(this,"status",void 0),(0,s.default)(this,"attempts",void 0),(0,s.default)(this,"max_attempts",void 0),(0,s.default)(this,"timeout",void 0),(0,s.default)(this,"kibana_name",void 0),(0,s.default)(this,"kibana_id",void 0),(0,s.default)(this,"size",void 0),(0,s.default)(this,"content_type",void 0),(0,s.default)(this,"csv_contains_formulas",void 0),(0,s.default)(this,"max_size_reached",void 0),(0,s.default)(this,"metrics",void 0),(0,s.default)(this,"warnings",void 0),(0,s.default)(this,"error_code",void 0),(0,s.default)(this,"locatorParams",void 0),(0,s.default)(this,"queue_time_ms",void 0),(0,s.default)(this,"execution_time_ms",void 0),(0,s.default)(this,"scheduled_report_id",void 0),this.id=e.id,this.index=e.index,this.payload=e.payload,this.jobtype=e.jobtype,this.objectType=e.payload.objectType,this.title=e.payload.title,this.layout=e.payload.layout,this.pagingStrategy=e.payload.pagingStrategy,this.version=e.payload.version,this.created_by=e.created_by,this.created_at=e.created_at,this.started_at=e.started_at,this.completed_at=e.completed_at,this.status=e.status,this.attempts=e.attempts,this.max_attempts=e.max_attempts,this.timeout=e.timeout,this.kibana_name=e.kibana_name,this.kibana_id=e.kibana_id,this.browserTimezone=e.payload.browserTimezone,this.size=null===(t=e.output)||void 0===t?void 0:t.size,this.content_type=null===(a=e.output)||void 0===a?void 0:a.content_type,this.isDeprecated=e.payload.isDeprecated||!1,this.spaceId=e.payload.spaceId,this.csv_contains_formulas=null===(n=e.output)||void 0===n?void 0:n.csv_contains_formulas,this.max_size_reached=null===(l=e.output)||void 0===l?void 0:l.max_size_reached,this.warnings=null===(i=e.output)||void 0===i?void 0:i.warnings,this.error_code=null===(o=e.output)||void 0===o?void 0:o.error_code,this.locatorParams=e.payload.locatorParams,this.metrics=e.metrics,this.queue_time_ms=e.queue_time_ms,this.execution_time_ms=e.execution_time_ms,this.scheduled_report_id=e.scheduled_report_id}isSearch(){return"search"===this.objectType}getStatusMessage(){const e=this.status;let t,a;return e===m?t=u.i18n.translate("reporting.jobStatusDetail.pendingStatusReachedText",{defaultMessage:"Waiting for job to process."}):e===f?t=u.i18n.translate("reporting.jobStatusDetail.attemptXofY",{defaultMessage:"Attempt {attempts} of {max_attempts}.",values:{attempts:this.attempts,max_attempts:this.max_attempts}}):this.getWarnings()?t=u.i18n.translate("reporting.jobStatusDetail.warningsText",{defaultMessage:"See report info for warnings."}):this.getError()&&(t=u.i18n.translate("reporting.jobStatusDetail.errorText",{defaultMessage:"See report info for error details."})),this.isDeprecated&&(a=(0,c.jsx)(r.EuiText,{size:"s"}," ",(0,c.jsx)(r.EuiTextColor,{color:"warning"},u.i18n.translate("reporting.jobStatusDetail.deprecatedText",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})))),t?(0,c.jsx)(o().Fragment,null,(0,c.jsx)(r.EuiText,{size:"s"},(0,c.jsx)(r.EuiTextColor,{color:"subdued"},t)),a||null):null}get prettyStatus(){var e;return null!==(e=h.get(this.status))&&void 0!==e?e:u.i18n.translate("reporting.jobStatusDetail.unknownText",{defaultMessage:"Unknown"})}get canLinkToKibanaApp(){return Boolean(this.locatorParams)}get isDownloadReady(){return this.status===d.JOB_STATUS.COMPLETED||this.status===d.JOB_STATUS.WARNINGS}get prettyJobTypeName(){switch(this.jobtype){case"printable_pdf":case"printable_pdf_v2":return u.i18n.translate("reporting.jobType.pdfOutputName",{defaultMessage:"PDF"});case"PNG":case"PNGV2":return u.i18n.translate("reporting.jobType.pngOutputName",{defaultMessage:"PNG"});case"csv_v2":case"csv_searchsource":return u.i18n.translate("reporting.jobType.csvOutputName",{defaultMessage:"CSV"});default:return}}get prettyTimeout(){if(null==this.timeout)return u.i18n.translate("reporting.jobStatusDetail.timeoutSecondsUnknown",{defaultMessage:"Unknown"});const e=this.timeout/1e3;return u.i18n.translate("reporting.jobStatusDetail.timeoutSeconds",{defaultMessage:"{timeout} seconds",values:{timeout:e}})}getCreatedAtDate(){return this.formatDate(this.created_at)}getCreatedBy(){return this.created_by||u.i18n.translate("reporting.jobCreatedBy.unknownUserPlaceholderText",{defaultMessage:"Unknown"})}getCreatedAtLabel(){return this.created_by?(0,c.jsx)(o().Fragment,null,(0,c.jsx)("div",null,this.formatDate(this.created_at)),(0,c.jsx)("span",null,this.created_by)):this.formatDate(this.created_at)}getError(){if(this.status===p)return this.warnings}getDeprecatedMessage(){if(this.isDeprecated)return u.i18n.translate("reporting.jobWarning.exportTypeDeprecated",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})}getWarnings(){var e;const t=[],a=this.getDeprecatedMessage();if(a&&t.push(a),this.csv_contains_formulas&&t.push(u.i18n.translate("reporting.jobWarning.csvContainsFormulas",{defaultMessage:"Your CSV contains characters that spreadsheet applications might interpret as formulas."})),this.max_size_reached&&t.push(u.i18n.translate("reporting.jobWarning.maxSizeReachedTooltip",{defaultMessage:"Your search reached the max size and contains partial data."})),this.status!==p&&null!==(e=this.warnings)&&void 0!==e&&e.length&&t.push(...this.warnings),t.length)return(0,c.jsx)("ul",null,t.map(((e,t)=>(0,c.jsx)("li",{key:`warning-key-${t}`},e))))}getPrettyStatusTimestamp(){return this.formatDate(this.getStatusTimestamp())}formatDate(e){try{return l()(e).format("YYYY-MM-DD @ hh:mm A")}catch(t){return e}}getStatusTimestamp(){const e=this.status;return e===f&&this.started_at?this.started_at:this.completed_at&&[g,p,x].includes(e)?this.completed_at:this.created_at}}const h=new Map([[m,u.i18n.translate("reporting.jobStatuses.pendingText",{defaultMessage:"Pending"})],[f,u.i18n.translate("reporting.jobStatuses.processingText",{defaultMessage:"Processing"})],[g,u.i18n.translate("reporting.jobStatuses.completedText",{defaultMessage:"Completed"})],[x,u.i18n.translate("reporting.jobStatuses.warningText",{defaultMessage:"Completed"})],[p,u.i18n.translate("reporting.jobStatuses.failedText",{defaultMessage:"Failed"})]]);function E(){return{getPendingJobIds:function(){const e=[];for(const t in localStorage)if(0===t.indexOf(d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY)){const a=t.replace(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-`,"");e.push(a)}return e},addPendingJobId:function(e){localStorage.setItem(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-${e}`,e)},setPendingJobIds:function(e){for(const e in localStorage)0===e.indexOf(d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY)&&localStorage.removeItem(e);for(let t=0;t<e.length;t++){const a=e[t];localStorage.setItem(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-${a}`,a)}}}}const y=(0,i.createContext)(void 0),k=({apiClient:e,http:t,children:a})=>(0,c.jsx)(y.Provider,{value:{http:t,apiClient:e}},a),v=()=>{const e=(0,i.useContext)(y);if(!e)throw new Error('"useInternalApiClient" can only be used inside of "InternalApiClientContext"');return e};var j=a(18744);const b=()=>{const{services:{http:e}}=A();return(0,j.useRequest)(e,{path:d.INTERNAL_ROUTES.MIGRATE.GET_ILM_POLICY_STATUS,method:"get"})};var S=a(47400),F=a(45995),M=a.n(F),I=a(20151),T=a(43721);class ReportingAPIClient{constructor(e,t,a){(0,s.default)(this,"http",void 0),(0,s.default)(this,"addPendingJobId",E().addPendingJobId),(0,s.default)(this,"getManagementLink",(()=>this.http.basePath.prepend(d.REPORTING_MANAGEMENT_HOME))),(0,s.default)(this,"getDownloadLink",(e=>this.getReportURL(e))),(0,s.default)(this,"getServerBasePath",(()=>this.http.basePath.serverBasePath)),this.uiSettings=t,this.kibanaVersion=a,this.http=e}getKibanaAppHref(e){const t=(0,I.stringify)({jobId:e.id,...e.scheduled_report_id?{scheduledReportId:e.scheduled_report_id}:{}});return`${(0,d.buildKibanaPath)({basePath:this.http.basePath.serverBasePath,spaceId:e.spaceId,appPath:d.REPORTING_REDIRECT_APP})}?${t}`}getReportURL(e){return this.http.basePath.prepend(`${d.INTERNAL_ROUTES.JOBS.DOWNLOAD_PREFIX}/${e}?${S.SX}=true`)}downloadReport(e){const t=this.getReportURL(e);window.open(t)}async deleteReport(e){return await this.http.delete(`${d.INTERNAL_ROUTES.JOBS.DELETE_PREFIX}/${e}`)}async list(e=0,t=50,a=[]){const s={page:e,size:t};return a.length>0&&(s.ids=a.slice(0,t).join(",")),(await this.http.get(d.INTERNAL_ROUTES.JOBS.LIST,{query:s,asSystemRequest:!0})).map((e=>new Job(e)))}async total(){return await this.http.get(d.INTERNAL_ROUTES.JOBS.COUNT,{asSystemRequest:!0})}async getError(e){var t;const a=await this.getInfo(e);return null!==(t=a.warnings)&&void 0!==t&&t[0]?a.warnings[0]:u.i18n.translate("reporting.apiClient.unknownError",{defaultMessage:"Report job {job} failed. Error unknown.",values:{job:e}})}async getInfo(e){const t=await this.http.get(`${d.INTERNAL_ROUTES.JOBS.INFO_PREFIX}/${e}`);return new Job(t)}async getScheduledReportInfo(e,t=0,a=50){const{data:s=[]}=await this.http.get(`${d.INTERNAL_ROUTES.SCHEDULED.LIST}`,{query:{page:t,size:a}});return s.find((t=>t.id===e))}async findForJobIds(e){return(await this.http.fetch(d.INTERNAL_ROUTES.JOBS.LIST,{query:{page:0,ids:e.join(",")},method:"GET"})).map((e=>new Job(e)))}getReportingPublicJobPath(e,t){const a=(0,I.stringify)({jobParams:M().encode(t)});return`${this.http.basePath.prepend(d.PUBLIC_ROUTES.GENERATE_PREFIX)}/${e}?${a}`}async createReportingShareJob(e,t){const a=M().encode(t),s=await this.http.post(`${d.INTERNAL_ROUTES.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:a})});if(null!=s&&s.job)return this.addPendingJobId(s.job.id),new Job(s.job)}async createReportingJob(e,t){const a=M().encode(t);try{const t=await this.http.post(`${d.INTERNAL_ROUTES.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:a})});if(null!=t&&t.job)return this.addPendingJobId(t.job.id),new Job(t.job)}catch(e){var s;throw T.error(e),new Error(`${null===(s=e.body)||void 0===s?void 0:s.message}`)}}getDecoratedJobParams(e){return{browserTimezone:"Browser"===this.uiSettings.get("dateFormat:tz")?l().tz.guess():this.uiSettings.get("dateFormat:tz"),version:this.kibanaVersion,...e}}verifyBrowser(){return this.http.get(d.INTERNAL_ROUTES.DIAGNOSE.BROWSER)}verifyScreenCapture(){return this.http.post(d.INTERNAL_ROUTES.DIAGNOSE.SCREENSHOT)}migrateReportingIndicesIlmPolicy(){return this.http.put(d.INTERNAL_ROUTES.MIGRATE.MIGRATE_ILM_POLICY)}}const w=e=>{switch(e.state){case"valid":default:return{showLinks:!0,enableLinks:!0,message:""};case"invalid":return{showLinks:!1,enableLinks:!1,message:"Your license does not support Reporting. Please upgrade your license."};case"unavailable":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because license information is not available at this time."};case"expired":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because your license has expired."}}};var C=a(20409);const A=()=>(0,C.useKibana)()},35575:(e,t,a)=>{a.d(t,{renderApp:()=>Ki,teardownFleet:()=>qi});var s=a(84286),n=a.n(s),l=a(22874),i=a.n(l),o=a(1493),r=a(30193),u=a(51155),d=a(3185),c=a(77880),g=a(81319),p=a(20482),m=a(75879),f=a(75008),x=a(13530),h=a(45692),E=a(44081),y=a(20409),k=a(15006),v=a(52137),j=a(13528),b=a(26333),S=a(22e3),F=a(66720),M=a(42413),I=a(92045),T=a(15004),w=a(1363),C=a(60547),A=a(26768),P=a.n(A),_=a(46787),L=a(83424);const D=P()(g.EuiFlyout).withConfig({displayName:"FlyoutWithHigherZIndex",componentId:"sc-1pwanx7-0"})(["z-index:",";"],(e=>e.theme.eui.euiZLevel5)),O=({onClose:e,as:t,...a})=>{const{notifications:l}=(0,u.WeA)(),i=(0,u.iO7)().fleet.allAgentPolicies,o=(0,b.I)(),[r,c]=(0,s.useState)((0,L.b)({namespace:o.defaultNamespace})),[p,x]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!0),y=(0,C.FS)(r,{allowedNamespacePrefixes:null==o?void 0:o.allowedNamespacePrefixes}),[k,v]=(0,s.useState)(!1),[j,S]=(0,s.useState)(!1),I=n().createElement(g.EuiFlyoutHeader,{hasBorder:!0,"aria-labelledby":"CreateAgentPolicyFlyoutTitle"},n().createElement(g.EuiTitle,{size:"m"},n().createElement("h2",{id:"CreateAgentPolicyFlyoutTitle","data-test-subj":"createAgentPolicyFlyoutTitle"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.flyoutTitle",defaultMessage:"Create agent policy"}))),n().createElement(g.EuiSpacer,{size:"m"}),n().createElement(g.EuiText,{size:"s"},n().createElement("p",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.flyoutTitleDescription",defaultMessage:"Agent policies are used to manage settings across a group of agents. You can add integrations to your agent policy to specify what data your agents collect. When you edit an agent policy, you can use Fleet to deploy updates to a specified group of agents."})))),T=n().createElement(g.EuiFlyoutBody,null,n().createElement(C.Kb,{agentPolicy:r,updateAgentPolicy:e=>{c({...r,...e})},withSysMonitoring:h,updateSysMonitoring:e=>E(e),validation:y,updateAdvancedSettingsHasErrors:v,setInvalidSpaceError:S})),w=(0,s.useMemo)((()=>(0,_.gF)(r,h)),[r,h]),A=n().createElement(g.EuiFlyoutFooter,null,n().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.cancelButtonLabel",defaultMessage:"Cancel"}))),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiFlexGroup,{gutterSize:"none"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(F.T_,{isDisabled:p||Object.keys(y).length>0||k||j,description:f.i18n.translate("xpack.fleet.createAgentPolicy.devtoolsRequestDescription",{defaultMessage:"This Kibana request creates a new agent policy."}),request:w})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButton,{fill:!0,isLoading:p,isDisabled:!i||p||Object.keys(y).length>0||k||j,onClick:async()=>{x(!0);try{const{data:t,error:a}=await(async()=>await(0,u.iF6)(r,{withSysMonitoring:h}))();x(!1),t?(l.toasts.addSuccess(f.i18n.translate("xpack.fleet.createAgentPolicy.successNotificationTitle",{defaultMessage:"Agent policy ''{name}'' created",values:{name:r.name}})),e(t.item)):l.toasts.addDanger(a?a.message:f.i18n.translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}catch(e){x(!1),l.toasts.addDanger(f.i18n.translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}},"data-test-subj":"createAgentPolicyFlyoutBtn"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.submitButtonLabel",defaultMessage:"Create agent policy"})))))));return n().createElement(D,(0,d.default)({onClose:()=>e()},a,{maxWidth:M.MW}),I,T,A)};var R=a(96791);const B=()=>{var e,t;(0,u.ifo)("policies_list");const{getPath:a}=(0,u.iEg)(),l=(0,u.iO7)().fleet.allAgentPolicies,i=M.mm,{agents:{enabled:r}}=(0,u.UKg)(),{urlParams:d,toUrlParams:c}=(0,u.zmo)(),{showAgentless:p}=(0,u.jXQ)(),[x,h]=(0,s.useState)(Array.isArray(d.kuery)?d.kuery[d.kuery.length-1]:null!==(e=d.kuery)&&void 0!==e?e:""),{pagination:E,pageSizeOptions:y,setPagination:k}=(0,u.WQC)(),{sorting:v,setSorting:j}=(0,u.KEg)({field:"updated_at",direction:"desc"}),b=(0,o.useHistory)(),S="create"in d,I=(0,s.useCallback)((e=>{if(e!==S)if(e)b.push(`${a("policies_list")}?${c({...d,create:null})}`);else{const{create:e,...t}=d;b.push(`${a("policies_list")}?${c(t)}`)}}),[a,b,S,c,d]),{isLoading:A,data:P,refetch:_}=(0,u.BOQ)({page:E.currentPage,perPage:E.pageSize,sortField:null==v?void 0:v.field,sortOrder:null==v?void 0:v.direction,kuery:(e=>{if(p)return e;const t=`NOT ${i}.supports_agentless:true`;return e.trim()?`(${t}) AND (${e})`:t})(x),withAgentCount:!0,full:!0}),L=(0,s.useMemo)((()=>{const e=[{field:"name",sortable:!0,name:f.i18n.translate("xpack.fleet.agentPolicyList.nameColumnTitle",{defaultMessage:"Name"}),width:"35%",render:(e,t)=>(0,R.jsx)(w.an,{policy:t,withDescription:!0})},{field:"updated_at",sortable:!0,name:f.i18n.translate("xpack.fleet.agentPolicyList.updatedOnColumnTitle",{defaultMessage:"Last updated on"}),render:e=>(0,R.jsx)(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})},{field:"agents",name:f.i18n.translate("xpack.fleet.agentPolicyList.agentsColumnTitle",{defaultMessage:"Unprivileged / Privileged"}),dataType:"number",render:(e,t)=>(0,R.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"xs",justifyContent:"flexEnd"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.unprivilegedAgentsTooltip",defaultMessage:"Unprivileged agents"})},(0,R.jsx)(C.Oy,{count:t.unprivileged_agents||0,agentPolicyId:t.id,showAgentText:!1,privilegeMode:"unprivileged"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},"/"),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.privilegedAgentsTooltip",defaultMessage:"Privileged agents"})},(0,R.jsx)(C.Oy,{count:e-(t.unprivileged_agents||0),agentPolicyId:t.id,showAgentText:!1,privilegeMode:"privileged"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("span",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltipWrapper",defaultMessage:"({message})",values:{message:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltip",defaultMessage:"Total agents"})},(0,R.jsx)(C.Oy,{count:e,agentPolicyId:t.id,showAgentText:!1}))}}))),(0,T.uo)(t.package_policies||[]).length>0&&(t.unprivileged_agents||0)>0&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",color:"warning",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.containsUnprivilegedAgentsWarning",defaultMessage:"This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."})})))},{field:"package_policies",name:f.i18n.translate("xpack.fleet.agentPolicyList.packagePoliciesCountColumnTitle",{defaultMessage:"Integrations"}),dataType:"number",render:e=>e?e.length:0},{field:"actions",name:f.i18n.translate("xpack.fleet.agentPolicyList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:e=>(0,R.jsx)(C.Nu,{agentPolicy:e,onCopySuccess:()=>_()})}]}];return r?e:e.filter((e=>!("field"in e)||"agents"!==e.field))}),[r,_]),D=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",isDisabled:!l,onClick:()=>I(!0),"data-test-subj":"createAgentPolicyButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"}))),[l,I]),B=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",isDisabled:!l,onClick:()=>I(!0),"data-test-subj":"emptyPromptCreateAgentPolicyButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"}))),[l,I]),z=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiEmptyPrompt,{title:(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.noAgentPoliciesPrompt",defaultMessage:"No agent policies"})),actions:B})),[B]);return(0,R.jsx)(n().Fragment,null,S?(0,R.jsx)(O,{onClose:()=>{I(!1),_()}}):null,(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},(0,R.jsx)(g.EuiFlexItem,{grow:4},(0,R.jsx)(F.IW,{value:x,indexPattern:M.yb,fieldPrefix:i,onChange:e=>{k({...E,currentPage:1}),h(e)},dataTestSubj:"agentPolicyList.queryInput"})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{color:"primary",iconType:"refresh",onClick:()=>_()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.reloadAgentPoliciesButtonText",defaultMessage:"Reload"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},D)),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiBasicTable,{loading:A,"data-test-subj":"agentPoliciesTable",noItemsMessage:A?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.loadingAgentPoliciesMessage",defaultMessage:"Loading agent policies…"}):x.trim()||0!==(null!==(t=null==P?void 0:P.total)&&void 0!==t?t:0)?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.noFilteredAgentPoliciesPrompt",defaultMessage:"No agent policies found. {clearFiltersLink}",values:{clearFiltersLink:(0,R.jsx)(g.EuiLink,{onClick:()=>h("")},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):z,items:P?P.items:[],itemId:"id",columns:L,pagination:{pageIndex:E.currentPage-1,pageSize:E.pageSize,totalItemCount:P?P.total:0,pageSizeOptions:y},sorting:{sort:v},onChange:e=>{const t={...E,currentPage:e.page.index+1,pageSize:e.page.size};k(t),j(e.sort)}}))};var z=a(53684),N=a(57421),U=a(86955),H=a(89423),W=a(61372);const G=({onClose:e,agentPolicy:t})=>{var a,l,i;const o=(0,g.useGeneratedHtmlId)(),[r,d]=n().useState(!1),{data:c}=(0,u.ZwD)();(0,s.useEffect)((()=>{const e=Boolean(null==c?void 0:c.item.prerelease_integrations_enabled);null!=c&&c.item&&d(e)}),[null==c?void 0:c.item]);const{filteredCards:p,isLoading:x}=(0,W.useAvailablePackages)({prereleaseIntegrationsEnabled:r}),h=(0,s.useMemo)((()=>p.filter((e=>{var t;return["integration","input"].includes(null!==(t=e.type)&&void 0!==t?t:"")})).map((e=>({label:e.title,value:e.name,integration:e.integration,prepend:(0,R.jsx)(w.qD,{packageName:e.name,version:e.version,integrationName:e.integration,size:"l",tryApi:!0})})))),[p]),[E,y]=(0,s.useState)([]),[k,v]=(0,s.useState)(!1),[j,b]=(0,s.useState)(!1),S=(0,s.useCallback)((e=>{b(e)}),[b]),F=(0,s.useCallback)((e=>{y(e)}),[]),M={title:f.i18n.translate("xpack.fleet.addIntegrationFlyout.selectIntegrationTitle",{defaultMessage:"Select integration"}),"data-test-subj":"selectIntegrationStep",children:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"m",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.selectIntegrationDescription",defaultMessage:"Search our integrations collection."}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiComboBox,{fullWidth:!0,"aria-label":"Select integration",placeholder:"Select integrations...",singleSelection:{asPlainText:!0},options:h,selectedOptions:E,onChange:F,isLoading:x})))),(0,R.jsx)(g.EuiSpacer,{size:"l"})),headingElement:"h2"},I=(0,s.useCallback)((()=>{v(!1),e()}),[e]);return(0,R.jsx)(s.Suspense,{fallback:(0,R.jsx)(U.Rh,null)},(0,R.jsx)(g.EuiErrorBoundary,null,(0,R.jsx)(g.EuiFlyout,{onClose:e,"data-test-subj":"addIntegrationFlyout","aria-labelledby":o},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{alignItems:"baseline",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiTitle,null,(0,R.jsx)("h2",{id:o},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.flyoutHeaderTitle",defaultMessage:"Add integration to policy"})))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiBadge,{color:"subdued"},t.name)))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"m",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.flyoutHeaderDescription",defaultMessage:"You are adding an integration to the selected policy."}))))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(n().Fragment,null,(0,R.jsx)(H.M,{from:"policy",queryParamsPolicyId:t.id,prerelease:r,pkgLabel:null===(a=E[0])||void 0===a?void 0:a.label,pkgName:null===(l=E[0])||void 0===l?void 0:l.value,integration:null===(i=E[0])||void 0===i?void 0:i.integration,addIntegrationFlyoutProps:{selectIntegrationStep:M,onSubmitCompleted:I,isSubmitted:k,agentPolicy:t,updateHasErrors:S}}),k&&(0,R.jsx)(g.EuiOverlayMask,{headerZindexLocation:"below"},(0,R.jsx)(U.Rh,null)))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:e,flush:"left","data-test-subj":"addIntegrationFlyout.cancelBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},j?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.errorOnSaveText",defaultMessage:"Your integration policy has errors."}):null),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,disabled:k||0===E.length||j,isLoading:k,onClick:()=>{v(!0)},"data-test-subj":"addIntegrationFlyout.submitBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegrationFlyout.submitButton",defaultMessage:"Add integration"}))))))))},K=(e,t)=>e.localeCompare(t),q=e=>({name:e,value:e}),V=({packagePolicies:e,agentPolicy:t,refreshAgentPolicy:a,...l})=>{var i,o;const r=(0,u.iO7)(),c=r.integrations.writeIntegrationPolicies,p=r.fleet.readAgentPolicies,x=r.integrations.readIntegrationPolicies,{isPackagePolicyUpgradable:h}=(0,u.hhZ)(),{getHref:E}=(0,u.iEg)(),{canUseMultipleAgentPolicies:y}=(0,u.phy)(),[k,v]=n().useState(!1),{enableOtelIntegrations:j}=z.ZX.get(),b=(0,u.B6B)(),S=!(null!==(i=b.data)&&void 0!==i&&i.success)&&"MISSING_SECURITY"===(null===(o=b.data)||void 0===o?void 0:o.error),[M,I]=(0,s.useMemo)((()=>{const t=new Set;return[e.map((e=>{var a,s,n,l,i,o;e.namespace&&t.add(e.namespace);const r=h(e);return{...e,packageName:null!==(a=null===(s=e.package)||void 0===s?void 0:s.name)&&void 0!==a?a:"",packageTitle:null!==(n=null===(l=e.package)||void 0===l?void 0:l.title)&&void 0!==n?n:"",packageVersion:null!==(i=null===(o=e.package)||void 0===o?void 0:o.version)&&void 0!==i?i:"",hasUpgrade:r}})),[...t].sort(K).map(q)]}),[e,h]),T=(0,s.useCallback)((e=>e.policy_ids.length||0),[]),{data:w,isLoading:C}=(0,u.Eiq)(),{output:A}=(0,u.OmG)(),P=(0,s.useMemo)((()=>{var e;return(null!==(e=null==w?void 0:w.items)&&void 0!==e?e:[]).reduce(((e,t)=>(e[t.id]=t.name,e)),{})}),[w]),_=(0,s.useMemo)((()=>[{field:"name",sortable:!0,truncateText:!0,name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.nameColumnTitle",{defaultMessage:"Integration policy"}),width:"35%",render:(e,a)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{"data-test-subj":"PackagePoliciesTableName",grow:!1},(0,R.jsx)(g.EuiLink,(0,d.default)({title:e},x?{href:E("edit_integration",{policyId:t.id,packagePolicyId:a.id})}:{disabled:!0}),(0,R.jsx)("span",{className:"eui-textTruncate"},e),a.description?(0,R.jsx)("span",null," ",(0,R.jsx)(g.EuiIconTip,{content:a.description,type:"question"})):null)),j&&(0,N.Wo)(null==a?void 0:a.inputs)&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",color:"warning",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.containsOtelPackages",defaultMessage:"The {integrationTitle} integration collects OpenTelemetry data adhering to semantic conventions and is available in technical preview. To collect OTel data, Elastic Agents must be on version {minVersion} or later.",values:{integrationTitle:a.packageTitle,minVersion:N.DP}})})),y&&p&&x&&T(a)>1&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.sharedTooltip",defaultMessage:"This integration is shared by {numberShared} agent policies",values:{numberShared:T(a)}})},(0,R.jsx)(g.EuiText,{"data-test-subj":"PackagePoliciesTableSharedLabel",color:"subdued",size:"xs",className:"eui-textNoWrap",tabIndex:0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.sharedText",defaultMessage:"Shared"})," ",(0,R.jsx)(g.EuiIcon,{type:"info"})))))},{field:"packageTitle",sortable:!0,name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.packageNameColumnTitle",{defaultMessage:"Integration"}),render:(e,a)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{"data-test-subj":"PackagePoliciesTableLink",grow:!1},(0,R.jsx)(g.EuiLink,{href:a.package&&E("integration_details_overview",{pkgkey:(0,z.Ku)(a.package)})},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},a.package&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(F.qD,{packageName:a.package.name,version:a.package.version,size:"m",tryApi:!0})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},e),a.package&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued",size:"xs",className:"eui-textNoWrap"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.packageVersion",defaultMessage:"v{version}",values:{version:a.package.version}})))))),a.hasUpgrade&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",color:"warning",content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.upgradeAvailable",{defaultMessage:"Upgrade Available"})})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{"data-test-subj":"PackagePoliciesTableUpgradeButton",size:"s",minWidth:"0",isDisabled:!c,href:`${E("upgrade_package_policy",{policyId:t.id,packagePolicyId:a.id})}?from=fleet-policy-list`},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.upgradeButton",defaultMessage:"Upgrade"})))))},{field:"namespace",name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:e=>e?(0,R.jsx)(g.EuiBadge,{color:"hollow"},e):(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiBadge,{color:"default"},t.namespace),(0,R.jsx)(g.EuiIconTip,{content:"Namespace defined in parent agent policy",position:"right",type:"info",color:"subdued"}))},{field:"output_id",name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputColumnTitle",{defaultMessage:"Output"}),render:e=>C?null:e?(0,R.jsx)(g.EuiBadge,{color:"hollow"},P[e]||e):t.data_output_id?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiBadge,{color:"default"},P[t.data_output_id]||t.data_output_id)," ",(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputFromParentPolicyText",{defaultMessage:"Output defined in parent agent policy"}),position:"right",type:"info",color:"subdued"})):A?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiBadge,{color:"default"},P[A.id]||A.id)," ",(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputFromFleetSettingsText",{defaultMessage:"Output defined in Fleet settings"}),position:"right",type:"info",color:"subdued"})):void 0},{name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.actionsColumnTitle",{defaultMessage:"Actions"}),width:"70px",actions:[{render:e=>c?(0,R.jsx)(F.Py,{agentPolicies:[t],from:"fleet-policy-list",packagePolicy:e,upgradePackagePolicyHref:`${E("upgrade_package_policy",{policyId:t.id,packagePolicyId:e.id})}?from=fleet-policy-list`}):(0,R.jsx)(n().Fragment,null)}]}]),[x,E,t,j,y,p,T,c,C,A,P]);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiInMemoryTable,(0,d.default)({itemId:"id",items:M,columns:_,sorting:{sort:{field:"name",direction:"asc"}}},l,{search:{toolsRight:t.is_managed||t.supports_agentless?[]:[(0,R.jsx)(F.rj,{key:"addPackagePolicyButton",fill:!0,isDisabled:!c,iconType:"plusInCircle",onClick:()=>{v(!0)},"data-test-subj":"addPackagePolicyButton",tooltip:c?void 0:{content:S?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.epm.addPackagePolicyButtonSecurityRequiredTooltip",defaultMessage:"To add Elastic Agent Integrations, you must have security enabled and have the All privilege for Fleet. Contact your administrator."}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.epm.addPackagePolicyButtonPrivilegesRequiredTooltip",defaultMessage:"Elastic Agent Integrations require the All privilege for Agent policies and All privilege for Integrations. Contact your administrator."})}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.addPackagePolicyButtonText",defaultMessage:"Add integration"}))],box:{incremental:!0,schema:!0},filters:[{type:"field_value_selection",field:"namespace",name:"Namespace",options:I,multiSelect:"or",operator:"exact"}]}})),k&&(0,R.jsx)(G,{onClose:()=>{v(!1),a()},agentPolicy:t}))},$=(0,s.memo)((({agentPolicy:e,refreshAgentPolicy:t})=>{const a=(0,u.iO7)(),s=a.integrations.writeIntegrationPolicies&&a.fleet.allAgentPolicies,[l,i]=n().useState(!1);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiEmptyPrompt,{iconType:"plusInCircle",title:(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstTitle",defaultMessage:"Add your first integration"})),body:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstMessage",defaultMessage:"This policy does not have any integrations yet."}),actions:(0,R.jsx)(g.EuiButton,{iconType:"plusInCircle",isDisabled:!s,fill:!0,onClick:()=>{i(!0)},"data-test-subj":"addPackagePolicyButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstButtonText",defaultMessage:"Add integration"}))}),l&&(0,R.jsx)(G,{onClose:()=>{i(!1),t()},agentPolicy:e}))})),Y=(0,s.memo)((({agentPolicy:e,refreshAgentPolicy:t})=>((0,u.ifo)("policy_details",{policyName:e.name}),e.package_policies&&0!==e.package_policies.length?(0,R.jsx)(V,{agentPolicy:e,packagePolicies:e.package_policies,refreshAgentPolicy:t}):(0,R.jsx)($,{agentPolicy:e,refreshAgentPolicy:t}))));var Q=a(4513),X=a.n(Q),J=a(30770),Z=a(21254),ee=a(82794),te=a(7049);const ae=e=>{var t;return{...(0,J.pick)(e,["name","description","namespace","monitoring_enabled","unenroll_timeout","inactivity_timeout","data_output_id","monitoring_output_id","download_source_id","fleet_server_host_id","agent_features","is_protected","advanced_settings","global_data_tags","monitoring_pprof_enabled","monitoring_http","monitoring_diagnostics"]),...!(null!==(t=e.space_ids)&&void 0!==t&&t.includes(te.eWz))&&{space_ids:e.space_ids}}},se=P().div.withConfig({displayName:"FormWrapper",componentId:"sc-1lbh22t-0"})(["max-width:1200px;margin-right:auto;margin-left:auto;"]),ne=(0,s.memo)((({agentPolicy:e})=>{(0,u.ifo)("policy_details",{policyName:e.name});const{notifications:t}=(0,u.WeA)(),{spaceId:a}=(0,u.YI3)(),{agents:{enabled:l}}=(0,u.UKg)(),{getPath:i}=(0,u.iEg)(),r=(0,u.iO7)().fleet.allAgentPolicies,d=(0,u.gCF)(),[c,p]=(0,s.useState)({...e}),x=(0,o.useHistory)(),h=(0,b.I)(),[E,y]=(0,s.useState)(!1),[k,v]=(0,s.useState)(!1),[j,S]=(0,s.useState)(0),[M,I]=(0,s.useState)(!0),T=(0,C.FS)(c,{allowedNamespacePrefixes:null==h?void 0:h.allowedNamespacePrefixes}),[w,A]=(0,s.useState)(!1),[P,L]=(0,s.useState)(!1),D=async()=>{y(!0);try{const l=ae(c);if(await(0,u.Tp2)(c.id,ae(c)),l.space_ids&&!X()(e.space_ids,l.space_ids)){var s,n;const a=(0,J.uniqBy)(null!==(s=null===(n=e.package_policies)||void 0===n?void 0:n.map((e=>e.package?{pkgName:e.package.name,pkgVersion:e.package.version}:void 0)).filter((e=>void 0!==e)))&&void 0!==s?s:[],"pkgName");for(const{pkgName:e,pkgVersion:s}of a)await(0,ee.i)({spaceIds:l.space_ids,pkgName:e,pkgVersion:s,toasts:t.toasts})}t.toasts.addSuccess(f.i18n.translate("xpack.fleet.editAgentPolicy.successNotificationTitle",{defaultMessage:"Successfully updated ''{name}'' settings",values:{name:c.name}})),c.space_ids&&!c.space_ids.includes(null!=a?a:Z.DEFAULT_SPACE_ID)?x.replace(i("policies_list")):(d(),v(!1))}catch(e){t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.editAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to update agent policy"})})}y(!1)},O=(0,s.useMemo)((()=>(0,_.Rq)(c.id,ae(c))),[c]);return n().createElement(se,null,j?n().createElement(C.oR,{agentCount:j,agentPolicies:[c],onConfirm:()=>{S(0),D()},onCancel:()=>{S(0),y(!1)}}):null,n().createElement(C.Kb,{agentPolicy:c,updateAgentPolicy:e=>{p({...c,...e}),v(!0)},withSysMonitoring:M,updateSysMonitoring:e=>I(e),validation:T,isEditing:!0,updateAdvancedSettingsHasErrors:A,setInvalidSpaceError:L}),k?n().createElement(n().Fragment,null,n().createElement(g.EuiSpacer,{size:"xl"}),n().createElement(g.EuiSpacer,{size:"xl"}),n().createElement(g.EuiBottomBar,null,n().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},n().createElement(g.EuiFlexItem,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.unsavedChangesText",defaultMessage:"You have unsaved changes"})),n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{color:"text",onClick:()=>{p({...e}),v(!1)}},n().createElement(m.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.cancelButtonText",defaultMessage:"Cancel"}))),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(F.T_,{isDisabled:E||Object.keys(T).length>0||w||P,btnProps:{color:"text"},description:f.i18n.translate("xpack.fleet.editAgentPolicy.devtoolsRequestDescription",{defaultMessage:"This Kibana request updates an agent policy."}),request:O})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButton,{onClick:async()=>{if(l){y(!0);const{data:e}=await(0,u.Wwg)({policyId:c.id});null!=e&&e.results.active?S(e.results.active):await D()}else await D()},isLoading:E,isDisabled:!r||E||Object.keys(T).length>0||w||P,"data-test-subj":"agentPolicyDetailsSaveButton",iconType:"save",color:"primary",fill:!0},E?n().createElement(m.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.savingButtonText",defaultMessage:"Saving…"}):n().createElement(m.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.saveButtonText",defaultMessage:"Save changes"})))))))):null)})),le=({isLoading:e,policyId:t,agentPolicy:a})=>{const{getHref:s}=(0,u.iEg)();return(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s",alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiButtonEmpty,{iconType:"arrowLeft",href:s("policies_list"),flush:"left",size:"xs"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.viewAgentListTitle",defaultMessage:"View all agent policies"}))),(0,R.jsx)(g.EuiFlexItem,null,e?(0,R.jsx)(F.Rh,null):(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",wrap:!0,responsive:!1,gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiTitle,null,(0,R.jsx)("h1",null,a&&a.name||(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.policyDetailsTitle",defaultMessage:"Policy ''{id}''",values:{id:t}})))),(null==a?void 0:a.is_managed)&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{title:"Hosted agent policy",content:f.i18n.translate("xpack.fleet.policyDetails.policyDetailsHostedPolicyTooltip",{defaultMessage:"This policy is managed outside of Fleet. Most actions related to this policy are unavailable."}),type:"lock",size:"l",color:"subdued"})))),a&&a.description?(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"s",className:"eui-textBreakWord"},a.description)):null)};var ie=a(95030),oe=a(87086),re=a(8627);const ue=({agentPolicy:e,isManageAutoUpgradeAgentsModalOpen:t,setIsManageAutoUpgradeAgentsModalOpen:a})=>{var n,l,i;const{data:o}=(0,u.t$K)(e.id),r=(null!==(n=e.required_versions)&&void 0!==n?n:[]).map((e=>e.version)),d=(0,s.useMemo)((()=>null==o?void 0:o.currentVersions.filter((e=>r.includes(e.version))).some((e=>e.failedUpgradeAgents>0))),[o,r]);return(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"xs",justifyContent:"flexEnd",alignItems:"center",id:"auto-upgrade-manage-button"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiLink,{onClick:()=>{a(!t)}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.autoUpgradeButton",defaultMessage:"Manage"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiNotificationBadge,{color:null!==(l=e.required_versions)&&void 0!==l&&l.length?"accent":"subdued"},(null===(i=e.required_versions)||void 0===i?void 0:i.length)||0)),d&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.manageAutoUpgradeAgents.failedUpgradeTooltip",defaultMessage:"Some agents failed to upgrade, click on Manage to see details."}),type:"warning",color:"danger"})))},de=P().div.withConfig({displayName:"Divider",componentId:"sc-zpeocb-0"})(["width:0;height:100%;border-left:",";"],(e=>e.theme.eui.euiBorderThin)),ce=({isLoading:e,agentPolicy:t,addAgent:a,onCancelEnrollment:l,isAddAgentHelpPopoverOpen:i,setIsAddAgentHelpPopoverOpen:r})=>{var d;const c=(0,u.iO7)(),{getPath:p}=(0,u.iEg)(),x=(0,o.useHistory)(),[h,E]=(0,s.useState)(!1),y=(0,u.gCF)(),k=(0,re.o)(),v=(0,s.useMemo)((()=>{var e;return null==t||null===(e=t.package_policies)||void 0===e?void 0:e.some((e=>{var t;return(null===(t=e.package)||void 0===t?void 0:t.name)===te.k7N}))}),[t]);if(!t)return null;const j=n().createElement(g.EuiLink,{onClick:a,"data-test-subj":"addAgentLink"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.addFleetServerButton",defaultMessage:"Add Fleet Server"})),b=n().createElement(g.EuiLink,{onClick:a,"data-test-subj":"addAgentLink"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.addAgentButton",defaultMessage:"Add agent"}));return n().createElement(n().Fragment,null,n().createElement(g.EuiFlexGroup,{justifyContent:"flexEnd",direction:"row"},e||!t?null:[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.revision",{defaultMessage:"Revision"}),content:null!==(d=t.revision)&&void 0!==d?d:0},{isDivider:!0},{label:f.i18n.translate("xpack.fleet.policyDetails.summary.integrations",{defaultMessage:"Integrations"}),content:n().createElement(g.EuiI18nNumber,{value:t.package_policies&&t.package_policies.length||0})},{isDivider:!0},...!c.fleet.readAgents||null!=t&&t.supports_agentless?[]:[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.usedBy",{defaultMessage:"Agents"}),content:!t.agents&&v&&c.fleet.addFleetServers?n().createElement(F.xt,{button:j,isOpen:i,offset:15,closePopover:()=>{r(!1)}}):t.agents||v||!c.fleet.addAgents?n().createElement(g.EuiFlexGroup,{direction:"row",gutterSize:"xs",alignItems:"center"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiToolTip,{content:n().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"xs"},n().createElement(g.EuiFlexItem,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.usedByUnprivilegedTooltip",defaultMessage:"{count, plural, one {# unprivileged agent} other {# unprivileged agents}}",values:{count:t.unprivileged_agents||0}})),n().createElement(g.EuiFlexItem,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.usedByPrivilegedTooltip",defaultMessage:"{count, plural, one {# privileged agent} other {# privileged agents}}",values:{count:(t.agents||0)-(t.unprivileged_agents||0)}})))},n().createElement(C.Oy,{count:t.agents||0,agentPolicyId:t.id,showAgentText:!0}))),(0,T.uo)(t.package_policies||[]).length>0&&(t.unprivileged_agents||0)>0&&n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiIconTip,{type:"warning",color:"warning",content:n().createElement(m.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.containsUnprivilegedAgentsWarning",defaultMessage:"This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."})}))):n().createElement(F.xt,{button:b,isOpen:i,offset:15,closePopover:()=>{r(!1)}})},{isDivider:!0}],{label:f.i18n.translate("xpack.fleet.policyDetails.summary.lastUpdated",{defaultMessage:"Last updated on"}),content:t&&n().createElement(m.FormattedDate,{value:null==t?void 0:t.updated_at,year:"numeric",month:"short",day:"2-digit"})||""},{isDivider:!0},...k&&c.fleet.allAgentPolicies&&c.fleet.allAgents&&!t.is_managed?[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.autoUpgrade",{defaultMessage:"Auto-upgrade agents"}),content:n().createElement(ue,{agentPolicy:t,isManageAutoUpgradeAgentsModalOpen:h,setIsManageAutoUpgradeAgentsModalOpen:E})},{isDivider:!0}]:[],{content:t&&n().createElement(C.Nu,{agentPolicy:t,fullButton:!0,onCopySuccess:e=>{x.push(p("policy_details",{policyId:e.id}))},onCancelEnrollment:l})}].map(((e,t)=>{var a;return n().createElement(g.EuiFlexItem,{grow:!1,key:t},null!==(a=e.isDivider)&&void 0!==a&&a?n().createElement(de,null):e.label?n().createElement(ge,{compressed:!0,textStyle:"reverse"},n().createElement(g.EuiDescriptionListTitle,{className:"eui-textNoWrap"},e.label),n().createElement(g.EuiDescriptionListDescription,{className:"eui-textNoWrap"},e.content)):e.content)}))),h&&n().createElement(g.EuiPortal,null,n().createElement(ie.i,{agentPolicy:t,agentCount:t.agents||0,onClose:e=>{E(!1),e&&y()}})),k?n().createElement(oe.i,{anchor:"#auto-upgrade-manage-button"}):null)};var ge=P()(g.EuiDescriptionList).withConfig({displayName:"_StyledEuiDescriptionList",componentId:"sc-zpeocb-1"})({textAlign:"right"});const pe=()=>{var e;const{params:{policyId:t,tabId:a=""}}=(0,o.useRouteMatch)(),{getHref:l}=(0,u.iEg)(),{urlParams:i}=(0,u.zmo)(),{showAgentless:r}=(0,u.jXQ)(),d=(0,u.ZJQ)(t),c=null===(e=d.data)||void 0===e||!e.item||d.data.item.supports_agentless&&!r?null:d.data.item,{isLoading:p,error:x,sendRequest:h}=d,E="true"===i.openEnrollmentFlyout,y="true"===i.showAddAgentHelp,[k]=(0,s.useState)(!1),[v,j]=(0,s.useState)(E),[b,S]=(0,s.useState)(y),{application:{navigateToApp:M}}=(0,u.WeA)(),T=(0,u.g7J)(),{isReady:w}=(0,u.YI3)(),C=(0,s.useMemo)((()=>{if(T&&T.onDoneNavigateTo&&w){const[e,t]=T.onDoneNavigateTo;return()=>M(e,t)}}),[w,M,T]),A=(0,s.useCallback)((()=>{S(!1),j(!0)}),[]),P=(0,s.useMemo)((()=>[{id:"integrations",name:f.i18n.translate("xpack.fleet.policyDetails.subTabs.packagePoliciesTabText",{defaultMessage:"Integrations"}),href:l("policy_details",{policyId:t,tabId:"integrations"}),isSelected:""===a||"integrations"===a},{id:"settings",name:f.i18n.translate("xpack.fleet.policyDetails.subTabs.settingsTabText",{defaultMessage:"Settings"}),"data-test-subj":"agentPolicySettingsTab",href:l("policy_details",{policyId:t,tabId:"settings"}),isSelected:"settings"===a}]),[l,t,a]),_=(0,s.useMemo)((()=>k?(0,R.jsx)(o.Redirect,{to:"/"}):p?(0,R.jsx)(F.Rh,null):x?(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:x}):c?(0,R.jsx)(n().Fragment,null,v&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.rt,{agentPolicy:c,onClose:C||(()=>j(!1))})),(0,R.jsx)(me,{agentPolicy:c,refreshAgentPolicy:h})):(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:f.i18n.translate("xpack.fleet.policyDetails.policyNotFoundErrorTitle",{defaultMessage:"Policy ''{id}'' not found",values:{id:t}})})),[k,p,x,c,v,C,t,h]),L=(0,R.jsx)(le,{agentPolicy:c,policyId:t,isLoading:p}),D=(0,R.jsx)(ce,{agentPolicy:c,onCancelEnrollment:C,isLoading:p,isAddAgentHelpPopoverOpen:b,setIsAddAgentHelpPopoverOpen:S,addAgent:A});return(0,R.jsx)(u.qfp.Provider,{value:{refresh:h}},(0,R.jsx)(I.QA,{leftColumn:L,rightColumn:D,tabs:P},_))},me=({agentPolicy:e,refreshAgentPolicy:t})=>((0,u.ifo)("policy_details",{policyName:e.name}),(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.policy_details_settings,render:()=>(0,R.jsx)(ne,{agentPolicy:e})}),(0,R.jsx)(r.Route,{path:M.X5.policy_details,render:()=>(0,R.jsx)(Y,{agentPolicy:e,refreshAgentPolicy:t})})));var fe=a(70940);const xe=(0,s.memo)((()=>{const{params:{packagePolicyId:e,policyId:t}}=(0,o.useRouteMatch)(),{search:a}=(0,o.useLocation)(),s=new URLSearchParams(a).get("from");let n;return s&&"fleet-policy-list"===s?n="upgrade-from-fleet-policy-list":s&&"integrations-policy-list"===s?n="upgrade-from-integrations-policy-list":s&&"installed-integrations"===s&&(n="installed-integrations"),(0,R.jsx)(fe.R,{packagePolicyId:e,policyId:t,from:n,forceUpgrade:!0})})),he=()=>((0,u.ifo)("policies"),(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.edit_integration},(0,R.jsx)(fe.k,null)),(0,R.jsx)(r.Route,{path:M.X5.upgrade_package_policy},(0,R.jsx)(xe,null)),(0,R.jsx)(r.Route,{path:M.X5.policy_details},(0,R.jsx)(pe,null)),(0,R.jsx)(r.Route,{path:M.X5.policies_list},(0,R.jsx)(I.iW,{section:"agent_policies"},(0,R.jsx)(B,null)))));var Ee=a(49358);const ye=(0,s.memo)((({datastream:e})=>{const{dashboards:t}=e,a=(0,u.e3j)(),s=(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.viewDashboardActionText",defaultMessage:"View dashboard"}),n=(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.viewDashboardsActionText",defaultMessage:"View dashboards"}),l=f.i18n.translate("xpack.fleet.dataStreamList.viewDashboardsPanelTitle",{defaultMessage:"View dashboards"}),i=f.i18n.translate("xpack.fleet.dataStreamList.viewInApmActionText",{defaultMessage:"View in APM"}),{isSuccessful:o,href:r}=(0,Ee.V)(e);if(o&&r){const e=[{id:0,items:[{icon:"apmApp",href:r,name:i}]}];return(0,R.jsx)(F.AK,{panels:e})}if(!t||0===t.length){const e=[{id:0,items:[{icon:"dashboardApp",disabled:!0,name:s}]}];return(0,R.jsx)(F.AK,{panels:e})}if(1===t.length){var d;const e=[{id:0,items:[{icon:"dashboardApp",href:null==a?void 0:a.getRedirectUrl({dashboardId:null===(d=t[0])||void 0===d?void 0:d.id}||""),name:s}]}];return(0,R.jsx)(F.AK,{panels:e})}const c=[{id:0,items:[{icon:"dashboardApp",panel:1,name:n}]},{id:1,title:l,items:t.map((e=>({icon:"dashboardApp",href:null==a?void 0:a.getRedirectUrl({dashboardId:null==e?void 0:e.id}||""),name:e.title})))}];return(0,R.jsx)(F.AK,{panels:c})})),ke=()=>{(0,u.ifo)("data_streams");const{pagination:e,pageSizeOptions:t}=(0,u.WQC)(),{isLoading:a,data:l,resendRequest:i}=(0,u.FM)(),o=(0,s.useMemo)((()=>[{field:"dataset",sortable:!0,width:"25%",name:f.i18n.translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"})},{field:"type",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"})},{field:"namespace",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:e=>e?(0,R.jsx)(g.EuiBadge,{color:"hollow"},e):""},{field:"package",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),render:(e,t)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},t.package_version&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(F.qD,{packageName:e,version:t.package_version,size:"m",tryApi:!0})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},e))},{field:"last_activity_ms",sortable:!0,width:"25%",dataType:"date",name:f.i18n.translate("xpack.fleet.dataStreamList.lastActivityColumnTitle",{defaultMessage:"Last activity"}),render:e=>(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"numeric"}),(0,R.jsx)(n().Fragment,null," @ "),(0,R.jsx)(m.FormattedTime,{value:e,hour:"numeric",minute:"numeric",second:"numeric"}))},{field:"size_in_bytes",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.sizeColumnTitle",{defaultMessage:"Size"}),render:(e,t)=>(0,R.jsx)(n().Fragment,null,t.size_in_bytes_formatted)},{name:f.i18n.translate("xpack.fleet.dataStreamList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:e=>(0,R.jsx)(ye,{datastream:e})}]}]),[]),r=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiEmptyPrompt,{title:(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.noDataStreamsPrompt",defaultMessage:"No data streams"}))})),[]),d={dataset:[],type:[],namespace:[],package:[]};if(l&&l.data_streams.length){const e={dataset:[],type:[],namespace:[],package:[]};l.data_streams.forEach((t=>{const{dataset:a,type:s,namespace:n,package:l}=t;e.dataset.includes(a)||e.dataset.push(a),e.type.includes(s)||e.type.push(s),e.namespace.includes(n)||e.namespace.push(n),e.package.includes(l)||e.package.push(l)}));for(const t in e)d[t]&&(d[t]=e[t].sort().map((e=>({value:e,name:e}))))}return(0,R.jsx)(g.EuiInMemoryTable,{loading:a,tableLayout:"auto",message:a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.loadingDataStreamsMessage",defaultMessage:"Loading data streams…"}):l&&!l.data_streams.length?r:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.noFilteredDataStreamsMessage",defaultMessage:"No matching data streams found"}),items:l?l.data_streams:[],itemId:"index",columns:o,pagination:{initialPageSize:e.pageSize,pageSizeOptions:t},sorting:!0,search:{toolsRight:[(0,R.jsx)(g.EuiButton,{key:"reloadButton",color:"primary",iconType:"refresh",onClick:()=>i()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.dataStreamList.reloadDataStreamsButtonText",defaultMessage:"Reload"}))],box:{placeholder:f.i18n.translate("xpack.fleet.dataStreamList.searchPlaceholderTitle",{defaultMessage:"Filter data streams"}),incremental:!0},filters:[{type:"field_value_selection",field:"dataset",name:f.i18n.translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"}),multiSelect:"or",operator:"exact",options:d.dataset},{type:"field_value_selection",field:"type",name:f.i18n.translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"}),multiSelect:"or",operator:"exact",options:d.type},{type:"field_value_selection",field:"namespace",name:f.i18n.translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),multiSelect:"or",operator:"exact",options:d.namespace},{type:"field_value_selection",field:"package",name:f.i18n.translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),multiSelect:"or",operator:"exact",options:d.package}]}})},ve=()=>(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.data_streams},(0,R.jsx)(I.iW,{section:"data_streams"},(0,R.jsx)(ke,null))));var je=a(30135),be=a(5850),Se=a(19573);const Fe=({onClose:e,agents:t,agentCount:a})=>{const n=(0,g.useGeneratedHtmlId)(),{notifications:l}=(0,u.WeA)(),[i,r]=(0,s.useState)(!1),d=Array.isArray(t)&&1===t.length,{getPath:c}=(0,u.iEg)(),p=(0,o.useHistory)(),[x,h]=(0,s.useState)(!1);return(0,R.jsx)(g.EuiConfirmModal,{"data-test-subj":"requestDiagnosticsModal","aria-labelledby":n,title:d?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.singleTitle",defaultMessage:"Request diagnostics"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.multipleTitle",defaultMessage:"Request diagnostics for {count} agents",values:{count:a}}),titleProps:{id:n},onCancel:e,onConfirm:async function(){try{r(!0);const a=x?[Se.m_.CPU]:[],{error:s}=d?await(0,u.o6X)(t[0].id,{additional_metrics:a}):await(0,u.aJz)({agents:"string"==typeof t?t:t.map((e=>e.id)),additional_metrics:a});if(s)throw s;r(!1);const n=f.i18n.translate("xpack.fleet.requestDiagnostics.successSingleNotificationTitle",{defaultMessage:"Request diagnostics submitted"});if(l.toasts.addSuccess(n),d){const e=c("agent_details_diagnostics",{agentId:t[0].id});p.push(e)}e()}catch(e){r(!1),l.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.requestDiagnostics.fatalErrorNotificationTitle",{defaultMessage:"Error requesting diagnostics {count, plural, one {agent} other {agents}}",values:{count:a}})})}},cancelButtonText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonDisabled:i,confirmButtonText:d?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.confirmSingleButtonLabel",defaultMessage:"Request diagnostics"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.confirmMultipleButtonLabel",defaultMessage:"Request diagnostics for {count} agents",values:{count:a}}),buttonColor:"primary"},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.description",defaultMessage:"Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy."})),(0,R.jsx)("p",null,(0,R.jsx)(g.EuiCheckbox,{id:"cpuMetricsCheckbox","data-test-subj":"cpuMetricsCheckbox",label:"Collect additional CPU metrics",checked:x,onChange:()=>h(!x)})))};function Me(e){return e.length>20?`${e.substring(0,20)}...`:e}function Ie(e){return e.replace(/[^a-zA-Z0-9 \-_]/g,"").slice(0,20)}const Te=P().div.withConfig({displayName:"Wrapped",componentId:"sc-rnfjm9-0"})(["display:flex;.wrappedText{white-space:pre-wrap;}"]),we=({tags:e,color:t,size:a})=>n().createElement(n().Fragment,null,n().createElement(Te,null,n().createElement(g.EuiToolTip,{anchorClassName:"wrappedText",content:n().createElement("span",{"data-test-subj":"agentTagsTooltip"},e.join(", "))},n().createElement(g.EuiText,{size:a,color:t,tabIndex:0},n().createElement("span",{"data-test-subj":"agentTags"},(0,J.take)(e,3).map(Me).join(", "),e.length>3?` + ${e.length-3} more`:"")))));function Ce(e,t){return void 0!==(null==e?void 0:e.cpu_avg)?(0,R.jsx)(g.EuiToolTip,{content:`${(100*e.cpu_avg).toFixed(4)} %`},(0,R.jsx)("span",{tabIndex:0},(100*e.cpu_avg).toFixed(2)," %")):(0,R.jsx)(U.DQ,{agentPolicy:t})}function Ae(e,t){return null!=e&&e.memory_size_byte_avg?function(e,t=0){if(0===e)return"0 Bytes";const a=t<0?0:t,s=Math.floor(Math.log(e)/Math.log(1024));return parseFloat((e/Math.pow(1024,s)).toFixed(a))+" "+["Bytes","KB","MB","GB","TB","PB","EB","ZB","YB"][s]}(e.memory_size_byte_avg):(0,R.jsx)(U.DQ,{agentPolicy:t})}var Pe=a(51783),_e=a.n(Pe);function Le(e){const t=Date.parse(e||"")-Date.now();return t<0?"":t<9e5?" The upgrade will start in less than 15 minutes.":t<18e5?" The upgrade will start in less than 30 minutes.":t<36e5?" The upgrade will start in less than 1 hour.":` The upgrade will start in less than ${Math.ceil(t/36e5)} hours.`}function De(e){if(!e||void 0===e.download_percent&&void 0===e.download_rate)return"";let t="";return void 0!==e.download_percent&&(t=`${e.download_percent}%`),void 0!==e.download_rate&&(t+=` at ${Oe(e.download_rate)}`),` (${t.trim()})`}const Oe=e=>{let t=0;const a=[" Bps"," kBps"," MBps"," GBps"];for(;t<a.length-1&&!(e<1024);t++)e/=1024;return e.toFixed(1)+a[t]},Re=e=>{if(!e)return"";const t=new Date(e).toISOString(),a=Date.parse(e)-Date.now(),s=_e().utc(_e().duration(a,"milliseconds").asMilliseconds()).format("HH:mm");return a>0?`Retrying until: ${t} (${s} remaining)`:""},Be=({isAgentUpgradable:e,agent:t,latestAgentVersion:a})=>{var n,l;const i=(0,s.useMemo)((()=>t.upgrade_started_at&&!t.upgraded_at),[t.upgrade_started_at,t.upgraded_at]),o=(0,s.useMemo)((()=>function(e){var t,a,s;switch(null==e?void 0:e.state){case"UPG_REQUESTED":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"calendar"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRequested",defaultMessage:"Upgrade requested"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRequested",defaultMessage:"The agent has requested an upgrade."})};case"UPG_SCHEDULED":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"clock"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeScheduled",defaultMessage:"Upgrade scheduled"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeScheduled",defaultMessage:"The agent has been instructed to upgrade.{upgradeStartDelay}",values:{upgradeStartDelay:Le(null===(t=e.metadata)||void 0===t?void 0:t.scheduled_at)}})};case"UPG_DOWNLOADING":var n,l;return null!=e&&null!==(a=e.metadata)&&void 0!==a&&a.retry_error_msg?{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"download"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeDownloading",defaultMessage:"Upgrade downloading"})),WarningTooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDownloadingFailed",defaultMessage:"Upgrade failing: {retryMsg}. {retryUntil}",values:{retryMsg:null==e||null===(n=e.metadata)||void 0===n?void 0:n.retry_error_msg,retryUntil:Re(null==e||null===(l=e.metadata)||void 0===l?void 0:l.retry_until)}})}:{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"download"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeDownloading",defaultMessage:"Upgrade downloading"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDownloading",defaultMessage:"Downloading the new agent artifact version{downloadEstimate}.",values:{downloadEstimate:De(null==e?void 0:e.metadata)}})};case"UPG_EXTRACTING":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"accent",iconType:"package"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeExtracting",defaultMessage:"Upgrade extracting"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeExtracting",defaultMessage:"The new agent artifact is extracting."})};case"UPG_REPLACING":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"warning",iconType:"copy"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeReplacing",defaultMessage:"Upgrade replacing"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeReplacing",defaultMessage:"Replacing the agent artifact version."})};case"UPG_RESTARTING":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"warning",iconType:"refresh"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRestarting",defaultMessage:"Upgrade restarting"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRestarting",defaultMessage:"The agent is restarting to apply the update."})};case"UPG_WATCHING":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"warning",iconType:"inspect"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeMonitoring",defaultMessage:"Upgrade monitoring"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeMonitoring",defaultMessage:"Monitoring the new agent version for errors."})};case"UPG_ROLLBACK":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"danger",iconType:"returnKey"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRolledBack",defaultMessage:"Upgrade rolled back"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRolledBack",defaultMessage:"Upgrade unsuccessful. Rolling back to previous version."})};case"UPG_FAILED":return{Badge:(0,R.jsx)(g.EuiBadge,{color:"danger",iconType:"error"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeFailed",defaultMessage:"Upgrade failed"})),TooltipText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeFailed",defaultMessage:"Upgrade failed: {errorMsg}.",values:{errorMsg:null==e||null===(s=e.metadata)||void 0===s?void 0:s.error_msg}})};default:return null}}(t.upgrade_details)),[t.upgrade_details]),r=(0,T.zm)(t,a),d=null!==(n=null===(l=(0,u.UKg)().autoUpgrades)||void 0===l?void 0:l.retryDelays)&&void 0!==n?n:te.Q2q;return t.upgrade_details&&o?(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},(0,R.jsx)(g.EuiFlexItem,{grow:!1},o.Badge),o.TooltipText&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"info",content:o.TooltipText,color:"subdued"})),o.WarningTooltipText&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",content:o.WarningTooltipText,color:"warning"}))):t.upgrade_attempts&&t.upgrade_attempts.length>1&&"updating"===t.status?(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{type:"warning",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.retryingUpgrade",defaultMessage:"Retrying Upgrade ({retryCount}/{maxRetries} attempts)",values:{retryCount:t.upgrade_attempts.length,maxRetries:d.length}}),color:"subdued"}))):e&&(0,T.vJ)(t,a)?(0,R.jsx)(g.EuiBadge,{color:"hollow",iconType:"sortUp"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeAvailable",defaultMessage:"Upgrade available"})):i?(0,R.jsx)(g.EuiIconTip,{type:"info",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDetailsNotAvailable",defaultMessage:"Detailed upgrade status is available for Elastic Agents on version {minVersion} and higher.",values:{minVersion:"8.12"}}),color:"subdued"}):!e&&r?(0,R.jsx)(g.EuiIconTip,{type:"info",content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.notUpgradeable",defaultMessage:"Agent not upgradeable: {reason}",values:{reason:r}}),color:"subdued"}):null},ze=({hasFleetAddAgentsPrivileges:e,setEnrollmentFlyoutState:t})=>(0,R.jsx)(g.EuiEmptyPrompt,{title:(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.noAgentsPrompt",defaultMessage:"No agents enrolled"})),actions:e?(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",onClick:()=>t({isOpen:!0})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})):null}),Ne="metrics";function Ue(e){return"string"!=typeof e?"-":e}const He=e=>{const{agents:t,isLoading:a,agentPoliciesIndexedById:n,renderActions:l,sortField:i,sortOrder:o,onTableChange:r,onSelectionChange:d,selected:c,totalAgents:p=0,showUpgradeable:x,pagination:h,pageSizeOptions:y,isUsingFilter:k,setEnrollmentFlyoutState:v,clearFilters:j,isCurrentRequestIncremented:b}=e,S=(0,u.iO7)(),{getHref:F}=(0,u.iEg)(),M=(0,u.JhS)(),I=(0,s.useCallback)((e=>{if(!e.active)return!1;if(!e.policy_id)return!0;const t=n[e.policy_id];return!(!0===(null==t?void 0:t.is_managed))}),[n]),T=(0,s.useMemo)((()=>p?x?t.filter((e=>I(e)&&(0,z._3)(e))):t:[]),[t,I,x,p]),C=a&&b?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.loadingAgentsMessage",defaultMessage:"Loading agents…"}):k?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.noFilteredAgentsPrompt",defaultMessage:"No agents found. {clearFiltersLink}",values:{clearFiltersLink:(0,R.jsx)(g.EuiLink,{onClick:()=>j()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):(0,R.jsx)(ze,{hasFleetAddAgentsPrivileges:S.fleet.addAgents,setEnrollmentFlyoutState:v}),A={sort:{field:i,direction:o}},P=[{field:"active",sortable:!1,width:"85px",name:f.i18n.translate("xpack.fleet.agentList.statusColumnTitle",{defaultMessage:"Status"}),render:(e,t)=>(0,R.jsx)(U.u0,{agent:t})},{field:"local_metadata.host.hostname",sortable:!0,name:f.i18n.translate("xpack.fleet.agentList.hostColumnTitle",{defaultMessage:"Host"}),width:"185px",render:(e,t)=>{var a;return(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"none",direction:"column"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiLink,{href:F("agent_details",{agentId:t.id})},Ue(e))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(we,{tags:null!==(a=t.tags)&&void 0!==a?a:[],color:"subdued",size:"xs"})))}},{field:"policy_id",sortable:!0,truncateText:!0,name:f.i18n.translate("xpack.fleet.agentList.policyColumnTitle",{defaultMessage:"Agent policy"}),width:"220px",render:(e,t)=>{const a=n[e];return a&&(0,R.jsx)(w.an,{direction:"column",policy:a,agent:t})}},{field:Ne,sortable:!1,name:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.cpuTooltip",defaultMessage:"Average CPU usage in the last 5 minutes. This includes usage from the Agent and the component it supervises. Possible value ranges from 0 to (number of available CPU cores * 100)"})},(0,R.jsx)("span",{tabIndex:0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.cpuTitle",defaultMessage:"CPU"})," ",(0,R.jsx)(g.EuiIcon,{type:"info"}))),width:"75px",render:(e,t)=>Ce(t.metrics,t.policy_id?n[t.policy_id]:void 0)},{field:Ne,sortable:!1,name:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.memoryTooltip",defaultMessage:"Average memory usage in the last 5 minutes"})},(0,R.jsx)("span",{tabIndex:0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.memoryTitle",defaultMessage:"Memory"})," ",(0,R.jsx)(g.EuiIcon,{type:"info"}))),width:"90px",render:(e,t)=>Ae(t.metrics,t.policy_id?n[t.policy_id]:void 0)},{field:"last_checkin",sortable:!0,name:f.i18n.translate("xpack.fleet.agentList.lastCheckinTitle",{defaultMessage:"Last activity"}),width:"100px",render:e=>e?(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.lastActivityTooltip",defaultMessage:"Last checked in at {lastCheckin}",values:{lastCheckin:(0,R.jsx)(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit",timeZoneName:"short",hour:"numeric",minute:"numeric"})}})},(0,R.jsx)("span",{tabIndex:0},(0,R.jsx)(m.FormattedRelative,{value:e}))):void 0},{field:"local_metadata.elastic.agent.version",sortable:!0,width:"220px",name:f.i18n.translate("xpack.fleet.agentList.versionTitle",{defaultMessage:"Version"}),render:(e,t)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"none",css:(0,E.css)({name:"ovk77c",styles:"min-width:0"}),direction:"column"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",wrap:!0},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{size:"s",className:"eui-textNoWrap"},Ue(e))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Be,{isAgentUpgradable:!(!I(t)||!(0,z._3)(t)),agent:t,latestAgentVersion:M})))))},{name:f.i18n.translate("xpack.fleet.agentList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:l}],width:"100px"}];return(0,R.jsx)(g.EuiBasicTable,{className:"fleet__agentList__table","data-test-subj":"fleetAgentListTable",loading:a,noItemsMessage:C,items:T,itemId:"id",columns:P,pagination:{pageIndex:h.currentPage-1,pageSize:h.pageSize,totalItemCount:p,pageSizeOptions:y},selection:{selected:c,onSelectionChange:d,selectable:I,selectableMessage:(e,t)=>e?"":t.active?t.policy_id&&n[t.policy_id].is_managed?"This action is not available for agents enrolled in an externally managed agent policy":"":"This agent is not active"},onChange:r,sorting:A})},We=()=>{var e,t;const a=(0,u.UKg)();return(0,R.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentSoftLimitCallout.calloutTitle",defaultMessage:"Max number of online agents reached"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentSoftLimitCallout.calloutDescription",defaultMessage:"Fleet supports a maximum of {nbAgents} active agents. You need to unenroll some agents to ensure that all active agents are able to connect and new agents can be enrolled.",values:{nbAgents:(0,R.jsx)(m.FormattedNumber,{value:null!==(e=null===(t=a.internal)||void 0===t?void 0:t.activeAgentsSoftLimit)&&void 0!==e?e:25e3})}}))},Ge=["healthy","unhealthy","orphaned","updating","offline","inactive","unenrolled","uninstalled"];function Ke(e,t){const a="EUI_THEME_AMSTERDAM"===t.themeName;switch(e){case"healthy":return a?t.colors.vis.euiColorVisBehindText0:t.colors.backgroundFilledSuccess;case"offline":case"uninstalled":return t.colors.lightShade;case"inactive":return t.colors.darkShade;case"unhealthy":case"orphaned":return a?t.colors.vis.euiColorVisBehindText5:t.colors.backgroundFilledWarning;case"updating":return a?t.colors.vis.euiColorVisBehindText1:t.colors.backgroundFilledPrimary;case"unenrolled":return t.colors.backgroundBaseDisabled;default:throw new Error(`Unsupported Agent status ${e}`)}}const qe=P()(g.EuiColorPaletteDisplay).withConfig({displayName:"StyledEuiColorPaletteDisplay",componentId:"sc-1wvk6tr-0"})(["&.ingest-agent-status-bar{border:none;border-radius:0;&:after{border:none;}}"]),Ve=({agentStatus:e})=>{const{euiTheme:t}=(0,g.useEuiTheme)(),a=(0,s.useMemo)((()=>Ge.reduce(((a,s)=>{const n=a.length>0?a[a.length-1].stop:0;return a.push({stop:n+(e[s]||0),color:Ke(s,t)}),a}),[])),[e,t]);return 0===a[a.length-1].stop?n().createElement(g.EuiSpacer,{size:"s"}):n().createElement(qe,{"data-test-subj":"agentStatusBar",className:"ingest-agent-status-bar",size:"s",palette:a})},$e=()=>{const{isOpen:e,dismiss:t}=(0,u.we$)("AGENT_EXPORT_CSV");return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTourStep,{content:(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentExportCSVTour.tourContent",defaultMessage:"Once you have selected the agents, click the action menu to download the CSV file."})),isStepOpen:e,onFinish:t,minWidth:360,maxWidth:360,step:1,stepsTotal:1,title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentExportCSVTour.tourTitle",defaultMessage:"Download CSV file"}),footerAction:(0,R.jsx)(g.EuiButtonEmpty,{onClick:t},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.genericTourPopover.dismissButton",defaultMessage:"Got it"})),anchorPosition:"upLeft",anchor:"#agentListSelectionText"}))},Ye=P().div.withConfig({displayName:"Divider",componentId:"sc-1e6bwq9-0"})(["width:0;height:",";border-left:",";"],(e=>e.theme.eui.euiSizeL),(e=>e.theme.eui.euiBorderThin)),Qe=P()(g.EuiFlexItem).withConfig({displayName:"FlexItem",componentId:"sc-1e6bwq9-1"})(["height:",";"],(e=>e.theme.eui.euiSizeL)),Xe=P()(g.EuiButtonEmpty).withConfig({displayName:"Button",componentId:"sc-1e6bwq9-2"})([".euiButtonEmpty__text{font-size:",";}"],(e=>e.theme.eui.euiFontSizeXS)),Je=({totalAgents:e,totalManagedAgents:t,selectableAgents:a,managedAgentsOnCurrentPage:s,selectionMode:l,setSelectionMode:i,selectedAgents:o,setSelectedAgents:r})=>{const u="manual"===l&&o.length>0||"query"===l&&e>0,d="manual"===l&&o.length===a&&a<e-s;return n().createElement(n().Fragment,null,n().createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiText,{size:"xs",color:"subdued",id:"agentListSelectionText"},e>M.W?n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.totalAgentsWithLimit",defaultMessage:"Showing {count} of {total} agents",values:{count:n().createElement(m.FormattedNumber,{value:M.W}),total:n().createElement(m.FormattedNumber,{value:e})}}):n().createElement(n().Fragment,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.totalAgents",defaultMessage:"Showing {count, plural, one {# agent} other {# agents}}",values:{count:e}})," ",n().createElement(g.EuiIconTip,{type:"info",content:n().createElement(m.FormattedMessage,{"data-test-subj":"selectedAgentCountTooltip",id:"xpack.fleet.agentBulkActions.agentsBreakDownTooltip",defaultMessage:" {totalAgents} total agents: {totalSelected} user-managed agents, {totalManagedAgents} on hosted policies",values:{totalAgents:e,totalManagedAgents:t,totalSelected:e-t}})}))),n().createElement($e,null)),u?n().createElement(n().Fragment,null,n().createElement(Qe,{grow:!1},n().createElement(Ye,null)),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiText,{size:"xs",color:"subdued","data-test-subj":"selectedAgentCountLabel"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.agentsSelected",defaultMessage:"{selectionMode, select, manual { {count, plural, one {# agent} other {# agents}} } other {All agents} } selected",values:{selectionMode:l,count:o.length}})," ","query"===l&&n().createElement(g.EuiIconTip,{type:"info",content:n().createElement(m.FormattedMessage,{"data-test-subj":"selectedAgentCountTooltip",id:"xpack.fleet.agentBulkActions.agentsSelectedTooltip",defaultMessage:"{totalSelected} user-managed agents selected: {totalAgents} total agents, {totalManagedAgents} on hosted policies. Most actions are only available to user-managed agents.",values:{totalAgents:e,totalManagedAgents:t,totalSelected:e-t}})}))),d?n().createElement(n().Fragment,null,n().createElement(Qe,{grow:!1},n().createElement(Ye,null)),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(Xe,{size:"xs",flush:"left","data-test-subj":"selectedEverythingOnAllPagesButton",onClick:()=>i("query")},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.selectAll",defaultMessage:"Select everything on all pages"})))):null,n().createElement(Qe,{grow:!1},n().createElement(Ye,null)),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(Xe,{size:"xs",flush:"left","data-test-subj":"clearAgentSelectionButton",onClick:()=>{i("manual"),r([])}},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.clearSelection",defaultMessage:"Clear selection"})))):n().createElement(Qe,{grow:!1})))},Ze=(0,s.memo)((({agentStatus:e})=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"m"},Ge.map((t=>(0,R.jsx)(g.EuiFlexItem,{key:t,grow:!1},(0,R.jsx)(et,{status:t,count:e[t]||0}))))))),et=(0,s.memo)((({status:e,count:t})=>{const{euiTheme:a}=(0,g.useEuiTheme)();return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiHealth,{color:Ke(e,a)},(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},function(e){switch(e){case"healthy":return f.i18n.translate("xpack.fleet.agentStatus.healthyLabel",{defaultMessage:"Healthy"});case"offline":return f.i18n.translate("xpack.fleet.agentStatus.offlineLabel",{defaultMessage:"Offline"});case"uninstalled":return f.i18n.translate("xpack.fleet.agentStatus.uninstalledLabel",{defaultMessage:"Uninstalled"});case"inactive":return f.i18n.translate("xpack.fleet.agentStatus.inactiveLabel",{defaultMessage:"Inactive"});case"unenrolled":return f.i18n.translate("xpack.fleet.agentStatus.unenrolledLabel",{defaultMessage:"Unenrolled"});case"unhealthy":return f.i18n.translate("xpack.fleet.agentStatus.unhealthyLabel",{defaultMessage:"Unhealthy"});case"orphaned":return f.i18n.translate("xpack.fleet.agentStatus.orphanedLabel",{defaultMessage:"Orphaned"});case"updating":return f.i18n.translate("xpack.fleet.agentStatus.updatingLabel",{defaultMessage:"Updating"});default:throw new Error(`Unsupported Agent status ${e}`)}}(e)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiNotificationBadge,{size:"s",color:"subdued"},t)))))})),tt=({agentStatus:e,totalAgents:t,totalManagedAgents:a,selectableAgents:s,managedAgentsOnCurrentPage:l,selectionMode:i,setSelectionMode:o,selectedAgents:r,setSelectedAgents:u,clearFilters:d,isUsingFilter:c})=>(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Je,{totalAgents:t,totalManagedAgents:a,selectableAgents:s,managedAgentsOnCurrentPage:l,selectionMode:i,setSelectionMode:o,selectedAgents:r,setSelectedAgents:u})),c?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiLink,{onClick:()=>d()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.header.clearFiltersLinkText",defaultMessage:"Clear filters"}))):null),(0,R.jsx)(g.EuiFlexItem,{grow:!1},e&&(0,R.jsx)(Ze,{agentStatus:e}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),e&&(0,R.jsx)(Ve,{agentStatus:e}));var at=a(27548),st=a(55964),nt=a(7195),lt=a(34127),it=a(45804),ot=a(89019);const rt=f.i18n.translate("xpack.fleet.noTagsValue",{defaultMessage:"No Tags"}),ut=({search:e,selectedAgentPolicies:t,selectedTags:a,selectedStatus:s,selectedAgentIds:n})=>{let l="";if(e&&(l=e.trim()),null!=t&&t.length&&(l&&(l=`(${l}) and`),l=`${l} ${M.Ah}.policy_id : (${t.map((e=>`"${e}"`)).join(" or ")})`),null!=a&&a.length)if(l&&(l=`(${l}) and`),a.includes(rt)){const e=a.filter((e=>e!==rt));l=`${l} ((NOT ${M.Ah}.tags : (*))${e.length>0?` or ${M.Ah}.tags : (${e.map((e=>`"${e}"`)).join(" or ")}))`:")"}`}else l=`${l} ${M.Ah}.tags : (${a.map((e=>`"${e}"`)).join(" or ")})`;if(null!=n&&n.length&&(l&&(l=`(${l}) and`),l=`${l} ${M.Ah}.agent.id : (${n.map((e=>`"${e}"`)).join(" or ")})`),null!=s&&s.length){const e=s.map((e=>{switch(e){case"healthy":return z.ir.buildKueryForOnlineAgents();case"unhealthy":return z.ir.buildKueryForErrorAgents();case"offline":return z.ir.buildKueryForOfflineAgents();case"updating":return z.ir.buildKueryForUpdatingAgents();case"inactive":return z.ir.buildKueryForInactiveAgents();case"unenrolled":return z.ir.buildKueryForUnenrolledAgents();case"orphaned":return z.ir.buildKueryForOrphanedAgents();case"uninstalled":return z.ir.buildKueryForUninstalledAgents()}})).filter((e=>void 0!==e)).join(" or ");l=l?`(${l}) and (${e})`:e}return l.trim()},dt="local_metadata.elastic.agent.version",ct="local_metadata.host.hostname",gt=e=>[dt,ct].includes(e)?`${e}.keyword`:e;const pt=[{field:"agent.id",description:f.i18n.translate("xpack.fleet.exportCSV.agentIdField",{defaultMessage:"Agent ID"})},{field:"status",description:f.i18n.translate("xpack.fleet.exportCSV.statusField",{defaultMessage:"Status"})},{field:"local_metadata.host.hostname",description:f.i18n.translate("xpack.fleet.exportCSV.hostnameField",{defaultMessage:"Host Name"})},{field:"policy_id",description:f.i18n.translate("xpack.fleet.exportCSV.policyIdField",{defaultMessage:"Policy ID"})},{field:"last_checkin",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinField",{defaultMessage:"Last Checkin Time"})},{field:"local_metadata.elastic.agent.version",description:f.i18n.translate("xpack.fleet.exportCSV.agentVersionField",{defaultMessage:"Agent Version"})}],mt=[{field:"active",description:f.i18n.translate("xpack.fleet.exportCSV.activeField",{defaultMessage:"Active"})},{field:"audit_unenrolled_reason",description:f.i18n.translate("xpack.fleet.exportCSV.auditUnenrolledReasonField",{defaultMessage:"Audit Unenrolled Reason"})},{field:"audit_unenrolled_time",description:f.i18n.translate("xpack.fleet.exportCSV.auditUnenrolledTimeField",{defaultMessage:"Audit Unenrolled Time"})},{field:"enrolled_at",description:f.i18n.translate("xpack.fleet.exportCSV.enrolledAtField",{defaultMessage:"Enrolled At"})},{field:"last_checkin_message",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinMessageField",{defaultMessage:"Last Checkin Message"})},{field:"last_checkin_status",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinStatusField",{defaultMessage:"Last Checkin Status"})},{field:"last_updated",description:f.i18n.translate("xpack.fleet.exportCSV.lastUpdatedField",{defaultMessage:"Last Updated Time"})},{field:"local_metadata.elastic.agent.build.original",description:f.i18n.translate("xpack.fleet.exportCSV.agentBuildOriginalField",{defaultMessage:"Agent Build Original"})},{field:"local_metadata.elastic.agent.log_level",description:f.i18n.translate("xpack.fleet.exportCSV.logLevelField",{defaultMessage:"Agent Log Level"})},{field:"local_metadata.elastic.agent.snapshot",description:f.i18n.translate("xpack.fleet.exportCSV.agentSnapshotField",{defaultMessage:"Agent Snapshot"})},{field:"local_metadata.elastic.agent.unprivileged",description:f.i18n.translate("xpack.fleet.exportCSV.agentUnprivilegedField",{defaultMessage:"Agent Unprivileged"})},{field:"local_metadata.elastic.agent.upgradeable",description:f.i18n.translate("xpack.fleet.exportCSV.agentUpgradeableField",{defaultMessage:"Agent Upgradeable"})},{field:"local_metadata.host.architecture",description:f.i18n.translate("xpack.fleet.exportCSV.hostArchitectureField",{defaultMessage:"Host Architecture"})},{field:"local_metadata.host.id",description:f.i18n.translate("xpack.fleet.exportCSV.hostIdField",{defaultMessage:"Host ID"})},{field:"local_metadata.host.ip",description:f.i18n.translate("xpack.fleet.exportCSV.hostIpField",{defaultMessage:"Host IP"})},{field:"local_metadata.host.mac",description:f.i18n.translate("xpack.fleet.exportCSV.hostMacField",{defaultMessage:"Host Mac"})},{field:"local_metadata.host.name",description:f.i18n.translate("xpack.fleet.exportCSV.hostNameField",{defaultMessage:"Host Name"})},{field:"local_metadata.os.family",description:f.i18n.translate("xpack.fleet.exportCSV.osFamilyField",{defaultMessage:"OS Family"})},{field:"local_metadata.os.full",description:f.i18n.translate("xpack.fleet.exportCSV.osFullField",{defaultMessage:"OS Full"})},{field:"local_metadata.os.kernel",description:f.i18n.translate("xpack.fleet.exportCSV.osKernelField",{defaultMessage:"OS Kernel"})},{field:"local_metadata.os.name",description:f.i18n.translate("xpack.fleet.exportCSV.osNameField",{defaultMessage:"OS Name"})},{field:"local_metadata.os.platform",description:f.i18n.translate("xpack.fleet.exportCSV.osPlatformField",{defaultMessage:"OS Platform"})},{field:"local_metadata.os.version",description:f.i18n.translate("xpack.fleet.exportCSV.osVersionField",{defaultMessage:"OS Version"})},{field:"tags",description:f.i18n.translate("xpack.fleet.exportCSV.tagsField",{defaultMessage:"Tags"})},{field:"unenrolled_at",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledAtField",{defaultMessage:"Unenrolled At"})},{field:"unenrolled_reason",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledReasonField",{defaultMessage:"Unenrolled Reason"})},{field:"unenrollment_started_at",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledStartedAtField",{defaultMessage:"Unenrolled Started At"})},{field:"unhealthy_reason",description:f.i18n.translate("xpack.fleet.exportCSV.unhealthyReasonField",{defaultMessage:"Unhealthy Reason"})},{field:"updated_at",description:f.i18n.translate("xpack.fleet.exportCSV.updatedAtField",{defaultMessage:"Updated At"})},{field:"upgrade_started_at",description:f.i18n.translate("xpack.fleet.exportCSV.upgradeStartedAtField",{defaultMessage:"Upgrade Started At"})},{field:"upgrade_status",description:f.i18n.translate("xpack.fleet.exportCSV.upgradeStatusField",{defaultMessage:"Upgrade Status"})},{field:"upgraded_at",description:f.i18n.translate("xpack.fleet.exportCSV.upgradedAtField",{defaultMessage:"Upgraded At"})},{field:"user_provided_metadata",description:f.i18n.translate("xpack.fleet.exportCSV.userProvidedMetadataField",{defaultMessage:"User Provided Metadata"})}],ft=({onClose:e,onSubmit:t,agentCount:a})=>{const[n,l]=(0,s.useState)(pt),i=(0,g.useGeneratedHtmlId)(),o=(0,J.uniqBy)([...pt,...mt],"field"),r={selectable:()=>!0,onSelectionChange:e=>{l(e)},initialSelected:pt};return(0,R.jsx)(g.EuiConfirmModal,{"data-test-subj":"agentExportCSVModal",confirmButtonDisabled:0===n.length,title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.modalTitle",defaultMessage:"Download table results as a CSV file"}),"aria-labelledby":i,titleProps:{id:i},onCancel:e,onConfirm:()=>t(n.map((e=>({field:e.field})))),cancelButtonText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.confirmButtonLabel",defaultMessage:"Download CSV"})},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.agentsCountText",defaultMessage:"Agents"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiNotificationBadge,{color:"subdued",size:"m"},a)))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSpacer,{size:"s"})),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.exportCSV.modalTableDescription",defaultMessage:"Select the table columns to display in the CSV file"}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiInMemoryTable,{tableCaption:"Column",items:o,itemId:"field",columns:[{field:"field",name:"Field",truncateText:!0},{field:"description",name:"Description",truncateText:!0}],selection:r}))))},xt=()=>{const{notifications:e}=(0,u.WeA)(),t=(0,s.useCallback)((async(t,a,s,n)=>{try{const n=await t();if(n.error)throw n.error;const l=!n.data.actionId,i=null!=s?s:f.i18n.translate("xpack.fleet.updateAgentTags.successNotificationTitle",{defaultMessage:"Tag(s) updated"});e.toasts.addSuccess(i),a(l)}catch(t){const a=null!=n?n:f.i18n.translate("xpack.fleet.updateAgentTags.errorNotificationTitle",{defaultMessage:"Tag(s) update failed"});e.toasts.addError(t,{title:a})}}),[e.toasts]);return{updateTags:(0,s.useCallback)((async(e,a,s,n,l)=>{await t((async()=>await(0,u.FA$)(e,{tags:a})),s,n,l)}),[t]),bulkUpdateTags:(0,s.useCallback)((async(e,a,s,n,l,i)=>{await t((async()=>await(0,u.yX1)({agents:e,tagsToAdd:a,tagsToRemove:s,includeInactive:!0})),n,l,i)}),[t])}},ht="fleet.lastSeenInactiveAgentsCount";async function Et(){var e,t;const a=await(0,u.voy)({kuery:"status:online",perPage:0,showInactive:!1});if(a.error)throw new Error(a.error.message);return null!==(e=null===(t=a.data)||void 0===t?void 0:t.total)&&void 0!==e?e:0}const yt="fleet.missingEncryptionKeyCalloutHasBeenDismissed",kt=({tagName:e,isTagHovered:t,onTagsUpdated:a})=>{const[l,i]=(0,s.useState)(!1),[o,r]=(0,s.useState)(),[u,d]=(0,s.useState)(t),[c,p]=(0,s.useState)(e);(0,s.useEffect)((()=>{d(t||l)}),[t,l]),(0,s.useEffect)((()=>{p(e)}),[e]);const x=(e=!1)=>{i(!1),e?v():k(c)},h=xt(),E=h.bulkUpdateTags,y='tags:"{name}"',k=t=>{if(t===e||!t)return;const s=y.replace("{name}",e);E(s,[t],[e],(s=>a([t],[e],s)),f.i18n.translate("xpack.fleet.renameAgentTags.successNotificationTitle",{defaultMessage:"Tag renamed"}),f.i18n.translate("xpack.fleet.renameAgentTags.errorNotificationTitle",{defaultMessage:"Tag rename failed"}))},v=()=>{const t=y.replace("{name}",e);h.bulkUpdateTags(t,[],[e],(t=>a([],[e],t)),f.i18n.translate("xpack.fleet.deleteAgentTags.successNotificationTitle",{defaultMessage:"Tag deleted"}),f.i18n.translate("xpack.fleet.deleteAgentTags.errorNotificationTitle",{defaultMessage:"Tag delete failed"}))};return(0,R.jsx)(n().Fragment,null,u&&(0,R.jsx)(g.EuiButtonIcon,{iconType:"boxesHorizontal","aria-label":f.i18n.translate("xpack.fleet.tagOptions.tagOptionsToggleButtonLabel",{defaultMessage:"Tag Options"}),color:"text",onClick:e=>{r(e.currentTarget),i(!l)}}),l&&(0,R.jsx)(g.EuiWrappingPopover,{isOpen:!0,button:o,closePopover:x,anchorPosition:"downCenter"},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",alignItems:"flexStart",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldText,{placeholder:f.i18n.translate("xpack.fleet.tagOptions.nameTextFieldPlaceholder",{defaultMessage:"Enter new name for tag"}),value:c,required:!0,onKeyDown:e=>{"Enter"===e.key&&x()},onChange:e=>{const t=e.currentTarget.value;p(Ie(t))}})),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiButtonEmpty,{size:"s",color:"danger",onClick:()=>{x(!0)}},(0,R.jsx)(g.EuiIcon,{type:"trash"})," ",(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.tagOptions.deleteText",defaultMessage:"Delete tag"}))))))},vt=P()(g.EuiHighlight).withConfig({displayName:"TruncatedEuiHighlight",componentId:"sc-492jbf-0"})(["width:120px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;"]),jt=({agentId:e,agents:t,allTags:a,selectedTags:l,button:i,onTagsUpdated:o,onClosePopover:r})=>{const u=(0,s.useCallback)(((e,t)=>e.map((e=>({label:e,checked:t.includes(e)?"on":void 0,onFocusBadge:!1})))),[]),[d,c]=(0,s.useState)(u(a,l)),[p,x]=(0,s.useState)(void 0),[h,E]=(0,s.useState)(!0),[y,k]=(0,s.useState)({}),v=xt();(0,s.useEffect)((()=>{c(u(a,l))}),[a,u,l]);const j=(0,s.useMemo)((()=>d.some((e=>e.label===p))),[d,p]),b=(e,t,s=!0,n=!1)=>{if(s)return o(e);const l=d.filter((e=>"on"===e.checked)).map((e=>e.label)),i=(0,J.difference)(l,t).concat(e),r=(0,J.uniq)(a.concat(i)),g=n?(0,J.difference)(r,t):r;c(u(g,i))},S=async(a,s,n,i)=>{if(e){const t=(0,J.difference)(l,s).concat(a);v.updateTags(e,t,(()=>o(a)),n,i)}else v.bulkUpdateTags(t,a,s,(e=>b(a,s,e)),n,i)},F=n().createElement(g.EuiButtonEmpty,{color:"text","data-test-subj":"createTagBtn",onClick:()=>{p&&S([p],[],f.i18n.translate("xpack.fleet.createAgentTags.successNotificationTitle",{defaultMessage:"Tag created"}),f.i18n.translate("xpack.fleet.createAgentTags.errorNotificationTitle",{defaultMessage:"Tag creation failed"}))}},n().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiIcon,{type:"plus"})),n().createElement(g.EuiFlexItem,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.tagsAddRemove.createText",defaultMessage:'Create a new tag "{name}"',values:{name:p}}))));return n().createElement(n().Fragment,null,n().createElement(g.EuiWrappingPopover,{isOpen:h,button:i,closePopover:()=>{E(!1),r()},anchorPosition:"leftUp"},n().createElement(g.EuiSelectable,{onFocus:()=>{},"aria-label":f.i18n.translate("xpack.fleet.tagsAddRemove.selectableTagsLabel",{defaultMessage:"Add / remove tags"}),searchable:!0,searchProps:{"data-test-subj":"addRemoveTags",placeholder:f.i18n.translate("xpack.fleet.tagsAddRemove.findOrCreatePlaceholder",{defaultMessage:"Find or create tag..."}),onChange:e=>{x(Ie(e))},value:null!=p?p:""},options:d,renderOption:(e,t)=>n().createElement(g.EuiFlexGroup,{gutterSize:"s",onMouseEnter:()=>k({...y,[e.label]:!0}),onMouseLeave:()=>k({...y,[e.label]:!1})},n().createElement(g.EuiFlexItem,null,n().createElement(vt,{search:t,onClick:()=>{const t="on"===e.checked?[]:[e.label],a="on"===e.checked?[e.label]:[];S(t,a)}},e.label)),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(kt,{tagName:e.label,isTagHovered:y[e.label],onTagsUpdated:(e,t,a)=>b(e,t,a,!0)})))},((e,t)=>n().createElement(s.Fragment,null,t,e))),j&&0!==d.length||""===p?null:F))},bt=({headers:e,onUpdate:t})=>{const a=(0,s.useCallback)(((a,s,n)=>{const l=Object.entries(e);if("key"===n){const e=l.map(((e,t)=>t===a?[s,e[1]]:e));t(Object.fromEntries(e))}else{const e=l.map(((e,t)=>t===a?[e[0],s]:e));t(Object.fromEntries(e))}}),[e,t]);return(0,R.jsx)(n().Fragment,null,e&&Object.entries(e).map((([s,l],i)=>(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,{grow:5},(0,R.jsx)(g.EuiFieldText,{placeholder:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.headersKeyPlaceholder",{defaultMessage:"Key"}),onChange:e=>{a(i,e.target.value,"key")},value:s,fullWidth:!0})),(0,R.jsx)(g.EuiFlexItem,{grow:5},(0,R.jsx)(g.EuiFieldText,{value:l,placeholder:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.headersValuePlaceholder",{defaultMessage:"Value"}),onChange:e=>{a(i,e.target.value,"value")},fullWidth:!0})),(0,R.jsx)(g.EuiFlexItem,{grow:0},(0,R.jsx)(g.EuiButtonEmpty,{iconType:"cross",onClick:()=>{const a=Object.entries(e).filter(((e,t)=>t!==i));t(Object.fromEntries(a))}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"})))),(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",onClick:()=>{t({...e,"":""})}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.addHeaderLabel",defaultMessage:"Add Row"}))))},St=({agents:e,agentCount:t,onClose:a,onSave:l,unsupportedMigrateAgents:i})=>{var o,r,d,c,p,x;const{notifications:h}=(0,u.WeA)(),E=u.L5X,y=u.Ch0,[k,v]=n().useState(!1),[j,b]=n().useState(!1),[S,F]=n().useState({id:"",agents:[],uri:"",enrollment_token:"",settings:{}}),M=(0,g.useGeneratedHtmlId)(),I=(0,s.useMemo)((()=>Array.isArray(e)?e.filter((e=>!i.some((t=>t.id===e.id)))):e),[e,i]),T=(0,s.useMemo)((()=>Array.isArray(I)?I.length:t),[t,I]);return(0,s.useEffect)((()=>{(()=>{if(S.uri)try{new URL(S.uri),b(!0)}catch(e){b(!1)}else b(!1)})(),(()=>{const e=!Array.isArray(I)||I.length>0;S.uri&&S.enrollment_token&&j&&e?v(!0):v(!1)})()}),[S,j,I]),(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlyout,{"data-test-subj":"migrateAgentFlyout",onClose:a,"aria-labelledby":M},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"l"},(0,R.jsx)("h1",{id:M},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.title",defaultMessage:"Migrate {agentCount, plural, one {agent} other {agents}}",values:{agentCount:T}}))),(0,R.jsx)(g.EuiSpacer,null),(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.title",defaultMessage:"Move {agentCount, plural, one {this agent} other {these agents}} to a different Fleet Server by specifying a new cluster URL and enrollment token.",values:{agentCount:T}})),Array.isArray(e)&&i.length>0&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,null),(0,R.jsx)(g.EuiPanel,{color:"warning","data-test-subj":"migrateAgentFlyoutAlertPanel"},(0,R.jsx)(g.EuiText,{color:"warning",className:"eui-alignMiddle"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.warning",defaultMessage:"{icon} {x} of {y} selected agents cannot be migrated as they are either tamper-protected agents, Fleet Server agents, containerized agents, or agents on an unsupported version.",values:{icon:(0,R.jsx)(g.EuiIcon,{type:"warning"}),x:i.length,y:t}})),(0,R.jsx)(g.EuiAccordion,{id:"migrateAgentFlyoutWarningAccordion",buttonContent:(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>{}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.warningAccordion",defaultMessage:"View Hosts"})),initialIsOpen:!1},(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiText,null,(0,R.jsx)("ul",null,i.map((e=>{var t,a;return(0,R.jsx)("li",{key:e.id},null===(t=e.local_metadata)||void 0===t||null===(a=t.host)||void 0===a?void 0:a.hostname)})))))))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(g.EuiForm,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.clusterUrlLabel",defaultMessage:"Remote Cluster URL"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.clusterUrlHelpText",defaultMessage:"Enter the URL of the Fleet server in the target cluster you want the agent to migrate to"}),isInvalid:!j&&""!==S.uri,error:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.clusterUrlError",defaultMessage:"Invalid cluster URL"})},(0,R.jsx)(g.EuiFieldText,{isInvalid:!j&&""!==S.uri,placeholder:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.clusterUrlPlaceholder",{defaultMessage:"Enter a valid cluster URL"}),fullWidth:!0,onChange:e=>F({...S,uri:e.target.value}),"data-test-subj":"migrateAgentFlyoutClusterUrlInput"})),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenLabel",defaultMessage:"Enrollment Token"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenHelpText",defaultMessage:"Enter a valid enrollment token generated in the target cluster"})},(0,R.jsx)(g.EuiFieldPassword,{"data-test-subj":"migrateAgentFlyoutEnrollmentTokenInput",onChange:e=>F({...S,enrollment_token:e.target.value}),placeholder:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenPlaceholder",{defaultMessage:"Enter a valid enrollment token"}),fullWidth:!0})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiAccordion,{arrowDisplay:"left",id:"migrateAgentFlyoutAdditionalOptions",initialIsOpen:!1,buttonContent:(0,R.jsx)(g.EuiButtonEmpty,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.additionalOptionsLabel",defaultMessage:"Advanced options"}))},(0,R.jsx)(g.EuiPanel,{color:"subdued",hasBorder:!0},(0,R.jsx)(g.EuiAccordion,{id:"tlsCertsSection",initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTextColor,{color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.tlsCertsLabel",defaultMessage:"TLS & Certs"}))},(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.tlsCertsDescriptionLabel",defaultMessage:"Provide optional TLS settings if your target Fleet server uses custom certificates."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{label:"ca_sha256",fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,onChange:e=>F({...S,settings:{...S.settings,ca_sha256:e.target.value}})})),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.certAuthLabel",defaultMessage:"Certificate Authorities"}),fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,onChange:e=>F({...S,settings:{...S.settings,certificate_authorities:e.target.value}})})),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.elasticAgentCertLabel",defaultMessage:"Elastic Agent Certificate"}),fullWidth:!0},(0,R.jsx)(g.EuiTextArea,{onChange:e=>F({...S,settings:{...S.settings,elastic_agent_cert:e.target.value}}),fullWidth:!0})),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.elasticAgentCertKeyLabel",defaultMessage:"Elastic Agent Certificate Key"}),fullWidth:!0},(0,R.jsx)(g.EuiTextArea,{onChange:e=>F({...S,settings:{...S.settings,elastic_agent_cert_key:e.target.value}}),fullWidth:!0}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiAccordion,{id:"headersSection",initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTextColor,{color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.headersMainLabel",defaultMessage:"Headers"}))},(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.headersDescriptionLabel",defaultMessage:"Custom HTTP headers sent during agent enrollment."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.headersLabel",defaultMessage:"Headers"}),fullWidth:!0},(0,R.jsx)(bt,{headers:(null===(o=S.settings)||void 0===o?void 0:o.headers)||{},onUpdate:e=>F({...S,settings:{...S.settings,headers:e}})})),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.proxyHeadersLabel",defaultMessage:"Proxy Headers"}),fullWidth:!0},(0,R.jsx)(bt,{headers:(null===(r=S.settings)||void 0===r?void 0:r.proxy_headers)||{},onUpdate:e=>F({...S,settings:{...S.settings,proxy_headers:e}})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiAccordion,{id:"networkingSection",initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTextColor,{color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.networkingLabel",defaultMessage:"Networking"}))},(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.networkingDescriptionLabel",defaultMessage:"Configure proxy settings if your network requires routing traffic through a proxy server."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.proxyUrlLabel",defaultMessage:"Proxy URL"}),fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,onChange:e=>F({...S,settings:{...S.settings,proxy_url:e.target.value}})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiAccordion,{id:"headersSection",initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTextColor,{color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.agentOptionsLabel",defaultMessage:"Agent Options"}))},(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.agentOptionsDescriptionLabel",defaultMessage:"Customize behavior during migration. Control connection handling, staging environments, and token replacement logic."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),1===e.length&&(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.replaceTokenLabel",defaultMessage:"Replace token"}),fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,"data-test-subj":"migrateAgentFlyoutReplaceTokenInput",onChange:e=>{"id"in S&&F({...S,settings:{...S.settings,replace_token:e.target.value}})}})),1===e.length&&(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.stagingLabel",defaultMessage:"Staging"}),fullWidth:!0},(0,R.jsx)(g.EuiFieldText,{fullWidth:!0,onChange:e=>F({...S,settings:{...S.settings,staging:e.target.value}})})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.insecurelabel",defaultMessage:"Insecure"}),checked:null!==(d=null===(c=S.settings)||void 0===c?void 0:c.insecure)&&void 0!==d&&d,onChange:e=>F({...S,settings:{...S.settings,insecure:e.target.checked}})})))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.proxyLabel",defaultMessage:"Proxy Disabled"}),checked:null!==(p=null===(x=S.settings)||void 0===x?void 0:x.proxy_disabled)&&void 0!==p&&p,onChange:e=>F({...S,settings:{...S.settings,proxy_disabled:e.target.checked}})})))))))))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiButtonEmpty,{onClick:a,"data-test-subj":"migrateAgentFlyoutCancelButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.cancelButtonLabel",defaultMessage:"Cancel"})),(0,R.jsx)(g.EuiButton,{disabled:!k,onClick:async()=>{try{Array.isArray(I)?1===I.length?await E({...S,id:I[0].id}):await y({...S,agents:I.map((e=>e.id))}):await y({...S,agents:I}),h.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.successNotificationTitle",{defaultMessage:"Agent migration initiated"}),text:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.successNotificationDescription",{defaultMessage:"The agent migration process has been successfully initiated."})}),l()}catch(e){h.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.errorNotificationTitle",{defaultMessage:"Failed to migrate {agentCount, plural, one {agent} other {agents}}",values:{agentCount:T}}),toastMessage:f.i18n.translate("xpack.fleet.agentList.migrateAgentFlyout.errorNotificationDescription",{defaultMessage:"The agent migration process has failed."})})}},fill:!0,"data-test-subj":"migrateAgentFlyoutSubmitButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentFlyout.submitButtonLabel",defaultMessage:"Migrate {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:T}}))))))},Ft=({nAgentsInTable:e,totalManagedAgentIds:t,selectionMode:a,currentQuery:l,selectedAgents:i,agentsOnCurrentPage:o,refreshAgents:r,allTags:d,agentPolicies:c,sortField:p,sortOrder:x,unsupportedMigrateAgents:h})=>{const E=(0,u.RR_)(),y=(0,u.iO7)(),k=E.hasAtLeast(te.l7o),v=E.hasAtLeast(te.NY3),[j,b]=(0,s.useState)(!1),S=()=>b(!1),[F,M]=(0,s.useState)(!1),[I,T]=(0,s.useState)(!1),[w,C]=(0,s.useState)({isOpen:!1,isScheduled:!1,isUpdating:!1}),[A,P]=(0,s.useState)(!1),[_,L]=(0,s.useState)(!1),[D,O]=(0,s.useState)(!1),[B,z]=(0,s.useState)(!1),N=(0,s.useMemo)((()=>{if(t.length){const e=`${te.AhM}.agent.id : (${t.map((e=>`"${e}"`)).join(" or ")})`;return`(${l}) AND NOT (${e})`}return l}),[l,t]),H="manual"===a?i:N,W="manual"===a?i.length:e-(null==t?void 0:t.length),[G,K]=(0,s.useState)(),{generateReportingJobCSV:q}=function(){const e=(0,ot.WeA)(),{notifications:t,http:a,uiSettings:s}=e,n=(0,ot.Q14)(),{data:l}=(0,ot.VmO)({enabled:!0}),i=l||'emit("")',o=new lt.ReportingAPIClient(a,s,n);return{generateReportingJobCSV:(a,s,n)=>{const l=o.getDecoratedJobParams(((e,t,a)=>{var s,n;const l=new nt.DataView({spec:{title:".fleet-agents",allowHidden:!0,runtimeFieldMap:{status:{type:"keyword",script:{source:i}}}},fieldFormats:{}});let o;o=Array.isArray(e)?`agent.id:(${e.map((e=>e.id)).join(" OR ")})`:e;const r=gt(null!==(s=null==a?void 0:a.field)&&void 0!==s?s:"enrolled_at"),u=null!==(n=null==a?void 0:a.direction)&&void 0!==n?n:nt.SortDirection.desc,d=(0,be.getSortConfig)(r,u),c={query:{query:"",language:"kuery"},filter:{meta:{index:"fleet-agents",params:{}},query:(0,st.toElasticsearchQuery)((0,st.fromKueryExpression)((0,be.removeSOAttributes)(o)))},fields:t,index:l,sort:d};return{title:"Agent List",objectType:"search",columns:t.map((e=>e.field)),searchSource:c}})(a,s,n));return o.createReportingShareJob("csv_searchsource",l).then((()=>{t.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.modalContent.successfullyQueuedReportNotificationTitle",{defaultMessage:"Queued report for CSV"}),text:(0,it.toMountPoint)((0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.modalContent.successfullyQueuedReportNotificationDescription",defaultMessage:"Track its progress in {path}.",values:{path:(0,R.jsx)("a",{href:o.getManagementLink()},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.publicNotifier.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}}),e),"data-test-subj":"queueReportSuccess"})})).catch((e=>{var a;t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.modalContent.notification.reportingErrorTitle",{defaultMessage:"Unable to create report"}),toastMessage:(0,R.jsx)("span",{dangerouslySetInnerHTML:{__html:null===(a=e.body)||void 0===a?void 0:a.message}})})}))}}}(),V=[{id:0,items:[{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.addRemoveTags","data-test-subj":"agentBulkActionsAddRemoveTags",defaultMessage:"Add / remove tags"}),icon:(0,R.jsx)(g.EuiIcon,{type:"tag",size:"m"}),disabled:!y.fleet.allAgents,onClick:e=>{K(e.target.closest("button")),P(!A)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.bulkMigrateAgents","data-test-subj":"agentBulkActionsBulkMigrate",defaultMessage:"Migrate {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:W}}),icon:(0,R.jsx)(g.EuiIcon,{type:"cluster",size:"m"}),disabled:!y.fleet.allAgents||!v,onClick:e=>{S(),z(!0)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.reassignPolicy","data-test-subj":"agentBulkActionsReassign",defaultMessage:"Assign to new policy"}),icon:(0,R.jsx)(g.EuiIcon,{type:"pencil",size:"m"}),disabled:!y.fleet.allAgents,onClick:()=>{S(),M(!0)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.upgradeAgents","data-test-subj":"agentBulkActionsUpgrade",defaultMessage:"Upgrade {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:W}}),icon:(0,R.jsx)(g.EuiIcon,{type:"refresh",size:"m"}),disabled:!y.fleet.allAgents,onClick:()=>{S(),C({isOpen:!0,isScheduled:!1,isUpdating:!1})}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.scheduleUpgradeAgents","data-test-subj":"agentBulkActionsScheduleUpgrade",defaultMessage:"Schedule upgrade for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:W}}),icon:(0,R.jsx)(g.EuiIcon,{type:"timeRefresh",size:"m"}),disabled:!y.fleet.allAgents||!k,onClick:()=>{S(),C({isOpen:!0,isScheduled:!0,isUpdating:!1})}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.restartUpgradeAgents","data-test-subj":"agentBulkActionsRestartUpgrade",defaultMessage:"Restart upgrade {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:W}}),icon:(0,R.jsx)(g.EuiIcon,{type:"refresh",size:"m"}),disabled:!y.fleet.allAgents,onClick:()=>{S(),C({isOpen:!0,isScheduled:!1,isUpdating:!0})}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.requestDiagnostics","data-test-subj":"agentBulkActionsRequestDiagnostics",defaultMessage:"Request diagnostics for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:W}}),disabled:!y.fleet.readAgents,icon:(0,R.jsx)(g.EuiIcon,{type:"download",size:"m"}),onClick:()=>{S(),L(!0)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.unenrollAgents","data-test-subj":"agentBulkActionsUnenroll",defaultMessage:"Unenroll {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:W}}),disabled:!y.fleet.allAgents,icon:(0,R.jsx)(g.EuiIcon,{type:"trash",size:"m"}),onClick:()=>{S(),T(!0)}},{name:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.exportAgents","data-test-subj":"bulkAgentExportBtn",defaultMessage:"Export {agentCount, plural, one {# agent} other {# agents}} as CSV",values:{agentCount:W}}),disabled:!y.fleet.readAgents,icon:(0,R.jsx)(g.EuiIcon,{type:"exportAction",size:"m"}),onClick:()=>{S(),O(!0)}}]}],$=(0,s.useMemo)((()=>((e,t,a)=>{const s=e=>e.reduce(((e,t)=>{var s,n;return(e=>{const t=a.find((t=>t.id===e.policy_id));return!!t&&t.is_managed})(t)?e:e.length<1?null!==(n=t.tags)&&void 0!==n?n:[]:(0,J.intersection)(null!==(s=t.tags)&&void 0!==s?s:[],e)}),[]);return Array.isArray(e)?s(t.length>0?t.filter((t=>e.find((e=>e.id===t.id)))):e):s(t)})(H,null!=o?o:[],c)),[H,o,c]);return(0,R.jsx)(n().Fragment,null,F&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.eN,{agents:H,onClose:()=>{M(!1),r()}})),I&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.VH,{agents:H,agentCount:W,onClose:()=>{T(!1),r({refreshTags:!0})}})),D&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(ft,{onSubmit:e=>{q(H,e,{field:p,direction:x}),O(!1)},onClose:()=>{O(!1)},agentCount:W})),w.isOpen&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.YF,{agents:H,agentCount:W,isScheduled:w.isScheduled,isUpdating:w.isUpdating,onClose:()=>{C({isOpen:!1,isScheduled:!1,isUpdating:!1}),r()}})),A&&(0,R.jsx)(jt,{agents:Array.isArray(H)?H.map((e=>e.id)):H,allTags:null!=d?d:[],selectedTags:$,button:G,onTagsUpdated:()=>{r({refreshTags:!0})},onClosePopover:()=>{P(!1),S()}}),_&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fe,{agents:H,agentCount:W,onClose:()=>{L(!1)}})),B&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(St,{agents:H,agentCount:W,unsupportedMigrateAgents:h,onClose:()=>{z(!1)},onSave:()=>{z(!1),r()}})),(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiPopover,{id:"agentBulkActionsMenu",button:(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"arrowDown",iconSide:"right",onClick:()=>b(!j),"data-test-subj":"agentBulkActionsButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentBulkActions.actions",defaultMessage:"Actions"})),isOpen:j,closePopover:S,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,R.jsx)(g.EuiContextMenu,{initialPanelId:0,panels:V})))))},Mt=({onClickAgentActivity:e,shouldShowTour:t=!1})=>{const{isOpen:a,dismiss:s}=(0,u.we$)("AGENT_ACTIVITY",t);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTourStep,{content:(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityButton.tourContent",defaultMessage:"Review in progress, completed, and scheduled agent action activity history here anytime."})),isStepOpen:a,onFinish:s,minWidth:360,maxWidth:360,step:1,stepsTotal:1,title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityButton.tourTitle",defaultMessage:"Agent activity history"}),anchorPosition:"upCenter",footerAction:(0,R.jsx)(g.EuiButtonEmpty,{onClick:s},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.genericTourPopover.dismissButton",defaultMessage:"Got it"})),anchor:"#agentActivityButton"}),(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>{e()},"data-test-subj":"agentActivityButton",iconType:"clock",id:"agentActivityButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityButton",defaultMessage:"Agent activity"})))};var It=a(97050);const Tt=[{status:"healthy",label:f.i18n.translate("xpack.fleet.agentList.statusHealthyFilterText",{defaultMessage:"Healthy"})},{status:"unhealthy",label:f.i18n.translate("xpack.fleet.agentList.statusUnhealthyFilterText",{defaultMessage:"Unhealthy"})},{status:"orphaned",label:f.i18n.translate("xpack.fleet.agentList.statusOrphanedFilterText",{defaultMessage:"Orphaned"})},{status:"updating",label:f.i18n.translate("xpack.fleet.agentList.statusUpdatingFilterText",{defaultMessage:"Updating"})},{status:"offline",label:f.i18n.translate("xpack.fleet.agentList.statusOfflineFilterText",{defaultMessage:"Offline"})},{status:"inactive",label:f.i18n.translate("xpack.fleet.agentList.statusInactiveFilterText",{defaultMessage:"Inactive"})},{status:"unenrolled",label:f.i18n.translate("xpack.fleet.agentList.statusUnenrolledFilterText",{defaultMessage:"Unenrolled"})},{status:"uninstalled",label:f.i18n.translate("xpack.fleet.agentList.statusUninstalledFilterText",{defaultMessage:"Uninstalled"})}],wt=P()(g.EuiNotificationBadge).withConfig({displayName:"LeftpaddedNotificationBadge",componentId:"sc-94zpuo-0"})(["margin-left:10px;"]),Ct=({children:e,isOpen:t,onDismiss:a})=>n().createElement(g.EuiTourStep,{content:n().createElement(g.EuiText,{size:"s"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.inactiveAgentsTourStepContent",defaultMessage:"Some agents have become inactive and have been hidden. Use status filters to show inactive or unenrolled agents."})),isStepOpen:t,minWidth:300,step:1,stepsTotal:0,title:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.inactiveAgentsTourStepTitle",defaultMessage:"Inactive agents"}),onFinish:a,anchorPosition:"upCenter",maxWidth:280,footerAction:n().createElement(g.EuiButtonEmpty,{onClick:a},n().createElement(m.FormattedMessage,{id:"xpack.fleet.genericTourPopover.dismissButton",defaultMessage:"Got it"}))},e),At=e=>{const{euiTheme:t}=(0,g.useEuiTheme)(),{selectedStatus:a,onSelectedStatusChange:l,disabled:i,totalInactiveAgents:o,isOpenByDefault:r=!1}=e,[u,d]=(()=>{const{storage:e}=(0,ot.WeA)(),[t,a]=(0,s.useState)(0);return(0,s.useEffect)((()=>{const t=e.get(ht);t&&a(parseInt(t,10))}),[e]),[t,t=>{e.set(ht,t.toString()),a(t)}]})(),{isHidden:c,isOpen:p,dismiss:f}=(0,It.w)("INACTIVE_AGENTS"),x=(0,s.useMemo)((()=>{const e=o-u;return e<0?0:e}),[u,o]);(0,s.useMemo)((()=>{a.length&&a.includes("inactive")&&x&&d(o)}),[a,x,d,o]),(0,s.useMemo)((()=>{o>0&&u>o&&d(o)}),[u,o,d]);const[h,E]=(0,s.useState)(r),y=e=>{e&&x>0&&!c&&f(),E(e)},k=(0,s.useCallback)((()=>Tt.map((({label:e,status:t})=>({label:e,checked:a.includes(t)?"on":void 0,key:t,append:"inactive"===t&&x>0?n().createElement(wt,null,x):void 0})))),[a,x]),[v,j]=(0,s.useState)(k());(0,s.useEffect)((()=>{j(k())}),[k]);const b=(0,s.useCallback)((e=>{j(e),e.forEach(((e,t)=>{if(e.checked===v[t].checked);else{const t=e.key;"on"!==e.checked?l([...a.filter((e=>e!==t))]):l([...a,t])}}))}),[l,v,a]);return n().createElement(Ct,{isOpen:x>0&&p,onDismiss:f},n().createElement(g.EuiPopover,{ownFocus:!0,zIndex:Number(t.levels.header)-1,button:n().createElement(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>y(!h),isSelected:h,hasActiveFilters:a.length>0,numActiveFilters:a.length,numFilters:Tt.length,disabled:i,"data-test-subj":"agentList.statusFilter"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.statusFilterText",defaultMessage:"Status"})),isOpen:h,closePopover:()=>y(!1),panelPaddingSize:"none"},n().createElement(g.EuiSelectable,{options:v,onChange:b,"data-test-subj":"agentList.agentStatusFilterOptions",listProps:{paddingSize:"s",style:{minWidth:140}}},(e=>e))))};function Pt(e=Z.DEFAULT_SPACE_ID,t,a){var s,n,l,i,o;if("installed"!==(null==t||null===(s=t.item)||void 0===s?void 0:s.status))return a;const r=t.item.installationInfo;return r&&(null==r?void 0:r.installed_kibana_space_id)!==e&&null!==(n=null===(l=r.additional_spaces_installed_kibana)||void 0===l||null===(i=l[e])||void 0===i||null===(o=i.find((({originId:e})=>e===a)))||void 0===o?void 0:o.id)&&void 0!==n?n:a}const _t=()=>{const{data:e}=(0,u.E1o)(te.cOw),{spaceId:t}=(0,u.YI3)(),a=(0,u.e3j)(),s=e=>(null==a?void 0:a.getRedirectUrl({dashboardId:e}))||"",l=Pt(t,e,te.K$s.ELASTIC_AGENT_OVERVIEW),i=Pt(t,e,te.K$s.ELASTIC_AGENT_AGENT_INFO),{dashboardExists:o,loading:r}=(e=>{const{dashboard:t}=(0,u.WeA)(),{data:a,isLoading:s}=(0,x.useQuery)({queryKey:["dashboard_exists",e],queryFn:async()=>{try{const a=await t.findDashboardsService(),[s]=await a.findByIds([e]);return"success"===(null==s?void 0:s.status)}catch(e){return!1}}});return{dashboardExists:null!=a&&a,loading:s}})(l);return r||!o?null:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{iconType:"dashboardApp",href:s(l),"data-test-subj":"ingestOverviewLinkButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.ingestOverviewlinkButton",defaultMessage:"Ingest Overview Metrics"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{iconType:"dashboardApp",href:s(i),"data-test-subj":"agentInfoLinkButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.agentInfoLinkButton",defaultMessage:"Agent Info Metrics"})))))},Lt=({selectedAgentPolicies:e,onSelectedAgentPoliciesChange:t,agentPolicies:a})=>{const{euiTheme:n}=(0,g.useEuiTheme)(),[l,i]=(0,s.useState)(!1),o=(0,s.useCallback)((()=>a.map((t=>({label:t.name,checked:e.includes(t.id)?"on":void 0,key:t.id,"data-test-subj":"agentList.agentPolicyFilterOption"})))),[a,e]),[r,u]=(0,s.useState)(o());return(0,s.useEffect)((()=>{u(o())}),[o]),(0,R.jsx)(g.EuiPopover,{ownFocus:!0,zIndex:Number(n.levels.header)-1,button:(0,R.jsx)(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>i(!l),isSelected:l,hasActiveFilters:e.length>0,numActiveFilters:e.length,numFilters:a.length,disabled:0===a.length,"data-test-subj":"agentList.policyFilter"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.policyFilterText",defaultMessage:"Agent policy"})),isOpen:l,closePopover:()=>i(!1),panelPaddingSize:"none"},(0,R.jsx)(g.EuiSelectable,{options:r,onChange:a=>{u(a),a.forEach(((a,s)=>{if(a.checked===r[s].checked)var n;else{const s=a.key;"on"!==a.checked?(n=s,t(e.filter((e=>e!==n)))):(a=>{t([...e,a])})(s)}}))},"data-test-subj":"agentList.agentPolicyFilterOptions",listProps:{paddingSize:"s",style:{minWidth:200}}},(e=>e)))},Dt=({tags:e,selectedTags:t,onSelectedTagsChange:a})=>{const{euiTheme:l}=(0,g.useEuiTheme)(),[i,o]=(0,s.useState)(!1),r=(0,s.useCallback)((()=>e.map((e=>({label:e,checked:t.includes(e)?"on":void 0,key:e,"data-test-subj":"agentList.tagFilterOption"})))),[e,t]),[u,d]=(0,s.useState)(r());return(0,s.useEffect)((()=>{d(r())}),[r]),(0,R.jsx)(g.EuiPopover,{ownFocus:!0,zIndex:Number(l.levels.header)-1,button:(0,R.jsx)(g.EuiFilterButton,{iconType:"arrowDown",onClick:()=>o(!i),isSelected:i,hasActiveFilters:t.length>0,numActiveFilters:t.length,numFilters:e.length,disabled:0===e.length,"data-test-subj":"agentList.tagsFilter"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.tagsFilterText",defaultMessage:"Tags"})),isOpen:i,closePopover:()=>o(!1),panelPaddingSize:"none"},(0,R.jsx)(g.EuiSelectable,{options:u,searchable:!0,onChange:e=>{e.forEach(((e,s)=>{if(e.checked!==u[s].checked){const s=e.key;return"on"!==e.checked?void(e=>{a(t.filter((t=>t!==e)))})(s):void(e=>{a([...t,e])})(s)}})),d(e)},"data-test-subj":"agentList.agentPolicyFilterOptions",listProps:{paddingSize:"s",style:{minWidth:140}}},((e,t)=>(0,R.jsx)(n().Fragment,null,t,e))),(0,R.jsx)(g.EuiHorizontalRule,{margin:"none"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"center",gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{iconType:"error",color:"danger","data-test-subj":"agentList.tagFilterClearAllBtn",onClick:()=>{a([])}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.tagsFilterClearAllBtnText",defaultMessage:"Clear all"})))))},Ot=({recentErrors:e,onClick:t})=>0===e?null:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityBadge.tooltip",defaultMessage:"{recentErrors, plural, one {There is # new agent activity error} other {There are # new agent activity errors}}. Click to view.",values:{recentErrors:e}})},(0,R.jsx)(g.EuiBadge,{color:"warning",onClick:t,onClickAriaLabel:"Open the Agent activity flyout",iconType:"warning",iconOnClick:t,iconOnClickAriaLabel:"Open the Agent activity flyout","data-test-subj":"agentActivityBadge"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityBadge.label",defaultMessage:"Review errors"}))),Rt=({agentPolicies:e,draftKuery:t,onDraftKueryChange:a,onSubmitSearch:s,selectedAgentPolicies:l,onSelectedAgentPoliciesChange:i,selectedStatus:o,onSelectedStatusChange:r,showUpgradeable:d,onShowUpgradeableChange:c,tags:p,selectedTags:x,onSelectedTagsChange:h,nAgentsInTable:E,totalInactiveAgents:y,totalManagedAgentIds:k,selectionMode:v,currentQuery:j,selectedAgents:b,refreshAgents:S,onClickAddAgent:I,onClickAddFleetServer:T,agentsOnCurrentPage:w,onClickAgentActivity:C,shouldShowAgentActivityTour:A,latestAgentActionErrors:P,sortField:_,sortOrder:L,unsupportedMigrateAgents:D})=>{const O=(0,u.iO7)(),{isFirstTimeAgentUser:B,isLoading:z}=(0,at.X)(),{cloud:N}=(0,u.WeA)(),U=f.i18n.translate("xpack.fleet.agentList.noTagsValue",{defaultMessage:"No Tags"}),H=[...p,U];return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"column"},(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,null,!z&&!B&&(0,R.jsx)(_t,null)),(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",justifyContent:"flexEnd"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Ot,{recentErrors:P,onClick:C})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Mt,{onClickAgentActivity:C,shouldShowTour:A})),!O.fleet.addFleetServers||null!=N&&N.isServerlessEnabled?null:(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addFleetServerButton.tooltip",defaultMessage:"Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents"})},(0,R.jsx)(g.EuiButton,{onClick:T,"data-test-subj":"addFleetServerButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addFleetServerButton",defaultMessage:"Add Fleet Server"})))),O.fleet.addAgents?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addAgentButton.tooltip",defaultMessage:"Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack"})},(0,R.jsx)(g.EuiButton,{fill:!0,onClick:I,"data-test-subj":"addAgentButton"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})))):null)),(0,R.jsx)(g.EuiFlexItem,{grow:4},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:6},(0,R.jsx)(F.IW,{value:t,fieldPrefix:M.Ah,indexPattern:M.QF,onChange:(e,t)=>{a(e),t&&s(e)},dataTestSubj:"agentList.queryInput"})),(0,R.jsx)(g.EuiFlexItem,{grow:2},(0,R.jsx)(g.EuiFilterGroup,null,(0,R.jsx)(At,{selectedStatus:o,onSelectedStatusChange:r,totalInactiveAgents:y,disabled:0===e.length}),(0,R.jsx)(Dt,{tags:H,selectedTags:x,onSelectedTagsChange:h}),(0,R.jsx)(Lt,{selectedAgentPolicies:l,onSelectedAgentPoliciesChange:i,agentPolicies:e}),(0,R.jsx)(g.EuiFilterButton,{hasActiveFilters:d,onClick:()=>{c(!d)},"data-test-subj":"agentList.showUpgradeable"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.showUpgradeableFilterLabel",defaultMessage:"Upgrade available"})))),"manual"===v&&b.length||"query"===v&&E>0?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Ft,{nAgentsInTable:E,totalManagedAgentIds:k,selectionMode:v,currentQuery:j,selectedAgents:b,agentsOnCurrentPage:w,refreshAgents:S,allTags:p,agentPolicies:e,sortField:_,sortOrder:L,unsupportedMigrateAgents:D})):null))))};var Bt=a(7817);const zt=({agent:e,agentPolicy:t,onReassignClick:a,onUnenrollClick:n,onGetUninstallCommandClick:l,onUpgradeClick:i,onAddRemoveTagsClick:o,onRequestDiagnosticsClick:r,onMigrateAgentClick:d})=>{var c,p;const{getHref:f}=(0,u.iEg)(),x=(0,Bt.i)(),h=(0,u.RR_)(),E=null!==(c=null==t||null===(p=t.package_policies)||void 0===p?void 0:p.some((e=>{var t;return(null===(t=e.package)||void 0===t?void 0:t.name)===be.FLEET_SERVER_PACKAGE})))&&void 0!==c&&c,y="unenrolling"===e.status,k=h.hasAtLeast(te.NY3),[v,j]=(0,s.useState)(!1),b=[(0,R.jsx)(g.EuiContextMenuItem,{icon:"inspect",href:f("agent_details",{agentId:e.id}),key:"viewAgent"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.viewActionText",defaultMessage:"View agent"}))];return!x.fleet.allAgents||null!=t&&t.is_protected||E||!(0,T.gL)(e)||b.push((0,R.jsx)(g.EuiContextMenuItem,{icon:"cluster",onClick:e=>{d(),j(!1)},disabled:!e.active||!k,key:"migrateAgent","data-test-subj":"migrateAgentMenuItem"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.migrateAgentActionText",defaultMessage:"Migrate agent"}))),x.fleet.allAgents&&!1===(null==t?void 0:t.is_managed)&&(b.push((0,R.jsx)(g.EuiContextMenuItem,{icon:"tag",onClick:e=>{o(e.target.closest("button"))},disabled:!e.active,key:"addRemoveTags"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addRemoveTagsActionText",defaultMessage:"Add / remove tags"})),(0,R.jsx)(g.EuiContextMenuItem,{icon:"pencil",onClick:()=>{a()},disabled:!e.active||!0===(null==t?void 0:t.supports_agentless),key:"reassignPolicy"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),(0,R.jsx)(g.EuiContextMenuItem,{key:"agentUnenrollBtn",disabled:!e.active||!0===(null==t?void 0:t.supports_agentless),icon:"trash",onClick:()=>{n()}},y?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"})),(0,R.jsx)(g.EuiContextMenuItem,{key:"agentUpgradeBtn",icon:"refresh",disabled:!(0,z._3)(e)||!0===(null==t?void 0:t.supports_agentless),onClick:()=>{i()},"data-test-subj":"upgradeBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))),x.fleet.allAgents&&(0,je.isStuckInUpdating)(e)&&b.push((0,R.jsx)(g.EuiContextMenuItem,{key:"agentRestartUpgradeBtn",icon:"refresh",onClick:()=>{i()},"data-test-subj":"restartUpgradeBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.restartUpgradeOneButton",defaultMessage:"Restart upgrade"}))),!x.fleet.allAgents||!e.policy_id||null!=t&&t.supports_agentless||b.push((0,R.jsx)(g.EuiContextMenuItem,{icon:"minusInCircle",onClick:()=>{l(),j(!1)},disabled:!e.active,key:"getUninstallCommand","data-test-subj":"uninstallAgentMenuItem"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.getUninstallCommand",defaultMessage:"Uninstall agent"})))),x.fleet.readAgents&&b.push((0,R.jsx)(g.EuiContextMenuItem,{key:"requestAgentDiagnosticsBtn",icon:"download","data-test-subj":"requestAgentDiagnosticsBtn",disabled:!(0,T.fx)(e),onClick:()=>{r()}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}))),(0,R.jsx)(F.AK,{isOpen:v,onChange:e=>j(e),items:b})};var Nt=a(61971);const Ut={POLICY_REASSIGN:{inProgressText:"Reassigning",completedText:"assigned to a new policy",cancelledText:"assignment"},UPGRADE:{inProgressText:"Upgrading",completedText:"upgraded",cancelledText:"upgrade"},UNENROLL:{inProgressText:"Unenrolling",completedText:"unenrolled",cancelledText:"unenrollment"},FORCE_UNENROLL:{inProgressText:"Force unenrolling",completedText:"force unenrolled",cancelledText:"force unenrollment"},AUTOMATIC_FORCE_UNENROLL:{inProgressText:"Automatic unenrolling",completedText:"automatically unenrolled",cancelledText:"automatic unenrollment"},UPDATE_TAGS:{inProgressText:"Updating tags of",completedText:"updated tags",cancelledText:"update tags"},CANCEL:{inProgressText:"Cancelling",completedText:"cancelled",cancelledText:""},REQUEST_DIAGNOSTICS:{inProgressText:"Requesting diagnostics for",completedText:"requested diagnostics",cancelledText:"request diagnostics"},SETTINGS:{inProgressText:"Updating settings of",completedText:"updated settings",cancelledText:"update settings"},POLICY_CHANGE:{inProgressText:"Applying policy change on",completedText:"applied policy change",cancelledText:"policy change"},INPUT_ACTION:{inProgressText:"Input action in progress of",completedText:"input action completed",cancelledText:"input action"},MIGRATE:{inProgressText:"Migrating",completedText:"migrated",cancelledText:"migration"},PRIVILEGE_LEVEL_CHANGE:{inProgressText:"Changing privilege level of",completedText:"changed privilege level",cancelledText:"change privilege level"},ACTION:{inProgressText:"Actioning",completedText:"actioned",cancelledText:"action"}},Ht=(e,t)=>{var a;return null!=t&&t.includes("UnenrollInactiveAgentsTask-")?Ut.AUTOMATIC_FORCE_UNENROLL:null!==(a=Ut[null!=e?e:"ACTION"])&&void 0!==a?a:Ut.ACTION},Wt=(e,t)=>(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivity.inProgressTitle",defaultMessage:"{inProgressText} {nbAgents} {agents}{reassignText}{upgradeText}{failuresText}{automaticIcon}",values:{nbAgents:e.nbAgentsAck>=e.nbAgentsActioned?e.nbAgentsAck:0===e.nbAgentsAck?e.nbAgentsActioned:e.nbAgentsActioned-e.nbAgentsAck+" of "+e.nbAgentsActioned,agents:1===e.nbAgentsActioned?"agent":"agents",inProgressText:Ht(e.type,e.actionId).inProgressText,reassignText:"POLICY_REASSIGN"===e.type&&e.newPolicyId?` to ${e.newPolicyId}`:"",upgradeText:"UPGRADE"===e.type?` to version ${e.version}`:"",failuresText:e.nbAgentsFailed>0?`, has ${e.nbAgentsFailed} failure(s)`:"",automaticIcon:t?(0,R.jsx)(g.EuiIconTip,{anchorProps:{style:{display:"flex",alignItems:"center"}},type:"timeRefresh",content:"Triggered by an automatic upgrade"}):null}})),Gt=e=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.startedDescription",defaultMessage:"Started on {date}.",values:{date:Kt(e)}}),Kt=e=>e?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})," ",(0,R.jsx)(m.FormattedTime,{value:e})):null,qt=({action:e,onClickViewAgents:t})=>{const a=(0,s.useMemo)((()=>e.nbAgentsActionCreated>1e3),[e]);if("UPDATE_TAGS"===e.type)return null;const n=(0,R.jsx)(g.EuiButtonEmpty,{size:"m",onClick:()=>t(e),"data-test-subj":"agentActivityFlyout.viewAgentsButton",disabled:a},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButton",defaultMessage:"View Agents"}));return a?(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButtonDisabledMaxTooltip",defaultMessage:"The view agents feature is only available for action impacting less than {agentCount} agents",values:{agentCount:1e3}})},n):"POLICY_CHANGE"===e.type?(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButtonPolicyChangeTooltip",defaultMessage:"View agents currently assigned to this policy"})},n):n},Vt=(0,Nt.A)("div",{target:"egpilro0"})("width:0;height:50%;border-left:",(e=>e.theme.euiTheme.border.thin),";position:relative;top:50%;transform:translateY(-50%);"),$t=({action:e,abortUpgrade:t,onClickViewAgents:a,onClickManageAutoUpgradeAgents:l})=>{const{docLinks:i}=(0,u.WeA)(),o=(0,g.useEuiTheme)(),r=e.is_automatic,[d,c]=(0,s.useState)(!1),p=(0,s.useCallback)((async()=>{try{c(!0),await t(e)}finally{c(!1)}}),[e,t]),f=(0,s.useMemo)((()=>{if(!e.startTime)return!1;const t=Date.now();return new Date(e.startTime).getTime()>t}),[e]),x=(0,s.useMemo)((()=>f||e.hasRolloutPeriod),[e,f]);return(0,R.jsx)(g.EuiPanel,{hasBorder:!0,borderRadius:"none"},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{color:"subdued","data-test-subj":"upgradeInProgressDescription"},(0,R.jsx)("p",null,f&&e.startTime?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.scheduledDescription",defaultMessage:"Scheduled for "}),(0,R.jsx)("strong",null,Kt(e.startTime)),". "):(0,R.jsx)(n().Fragment,null,Gt(e.creationTime)," ")))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},f?(0,R.jsx)(g.EuiIcon,{type:"clock"}):(0,R.jsx)(g.EuiLoadingSpinner,{size:"m"})),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{color:o.euiTheme.colors.textPrimary,"data-test-subj":"upgradeInProgressTitle"},f&&e.startTime?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.scheduleTitle",defaultMessage:"{nbAgents} agents scheduled to upgrade to version {version}",values:{nbAgents:e.nbAgentsActioned-e.nbAgentsAck,version:e.version}}):Wt(e,r))))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"column",alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(qt,{action:e,onClickViewAgents:a})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Vt,null)),r&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{"data-test-subj":"manageAutoUpgradesButton",onClick:()=>l(e),size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.manageAutoUpgradeAgents",defaultMessage:"Manage auto-upgrade agents"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Vt,null))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,null,(0,R.jsx)(g.EuiLink,{href:i.links.fleet.upgradeElasticAgent,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.guideLink",defaultMessage:"Learn more"}))))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},x?(0,R.jsx)(g.EuiButton,{size:"s",onClick:p,isLoading:d,"data-test-subj":"abortBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.abortUpgradeButtom",defaultMessage:"Cancel"})):null)))))};var Yt=a(57016);const Qt=({agentId:e,datasets:t,logLevels:a,userQuery:s})=>{const n=`${Yt.JQ.name}:${e}`,l=t.length?t.map((e=>`${Yt.Ep.name}:${e}`)).join(" or "):`${Yt.Ep.name}:${Yt.tO} or ${Yt.Ep.name}:${Yt.sn}`,i=a.map((e=>`${Yt.Jt.name}:${e}`)).join(" or "),o=`${n} and (${l})`,r=i?`${o} and (${i})`:o;return s?`(${r}) and (${s})`:r};var Xt=a(66764);const Jt=e=>new Date(e).getTime(),Zt=({logStreamQuery:e,startTime:t,endTime:a})=>{const{share:n}=(0,u.WeA)(),l=(0,Xt.getLogsLocatorFromUrlService)(n.url),i=(0,u.iO7)(),o=(0,s.useMemo)((()=>{const s=_e()().toISOString(),n=_e()().subtract(1,"day").toISOString(),i=Jt(n),o=Jt(s);return null==l?void 0:l.getRedirectUrl({time:a||o,timeRange:{from:(0,Xt.getTimeRangeStartFromTime)(t||i),to:(0,Xt.getTimeRangeEndFromTime)(a||o)},query:{language:"kuery",query:e}})}),[a,e,l,t]);return i.fleet.readAgents&&o?(0,R.jsx)(g.EuiButton,{href:o,iconType:"discoverApp","data-test-subj":"viewInLogsBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.openInDiscoverUiLinkText",defaultMessage:"Open in Discover"})):null},ea=P()(g.EuiText).withConfig({displayName:"TruncatedEuiText",componentId:"sc-1ioa7tn-0"})(["overflow:hidden;max-height:3rem;text-overflow:ellipsis;"]),ta=({action:e})=>{var t;const a=(0,u.WeA)(),s=(0,g.useEuiTheme)(),l=[{field:"hostname",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.hostnameColumnTitle",{defaultMessage:"Host Name"}),render:e=>n().createElement(g.EuiText,{size:"s","data-test-subj":"hostText"},e)},{field:"error",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.errorColumnTitle",{defaultMessage:"Error Message"}),render:e=>n().createElement(g.EuiToolTip,{content:e},n().createElement(ea,{size:"s",color:s.euiTheme.colors.textDanger,"data-test-subj":"errorText"},e))},{field:"agentId",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.actionColumnTitle",{defaultMessage:"Action"}),render:t=>{var s;const l=(null!==(s=e.latestErrors)&&void 0!==s?s:[]).find((e=>e.agentId===t));return n().createElement(k.V,{coreStart:a},((e,t)=>{const a=_e()(t).subtract(5,"m").toISOString(),s=_e()(t).add(5,"m").toISOString(),l=Jt(a),i=Jt(s),o=Qt({agentId:e,datasets:["elastic_agent"],logLevels:["error"],userQuery:""});return n().createElement(Zt,{logStreamQuery:o,startTime:l,endTime:i})})(t,l.timestamp))}}];return n().createElement(n().Fragment,null,n().createElement(g.EuiAccordion,{id:e.actionId+"_errors",buttonContent:"Show errors"},n().createElement(g.EuiBasicTable,{items:null!==(t=e.latestErrors)&&void 0!==t?t:[],columns:l,tableLayout:"auto"})))},aa=(0,Nt.A)("div",{target:"eqazjax0"})("width:0;height:50%;border-left:",(e=>e.theme.euiTheme.border.thin),";position:relative;top:50%;transform:translateY(-50%);"),sa=({action:e,onClickViewAgents:t,onClickManageAutoUpgradeAgents:a})=>{const s=(0,g.useEuiTheme)(),l=e.is_automatic,i="POLICY_CHANGE"===e.type&&0===e.nbAgentsActioned?(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivity.policyChangeCompletedTitle",defaultMessage:"Policy changed"})):(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivity.completedTitle",defaultMessage:"{nbAgents} {agents} {completedText}{versionText}{offlineText}{automaticIcon}",values:{nbAgents:e.nbAgentsAck===e.nbAgentsActioned?e.nbAgentsAck:e.nbAgentsAck+" of "+e.nbAgentsActioned,agents:1===e.nbAgentsActioned?"agent":"agents",completedText:Ht(e.type,e.actionId).completedText,offlineText:"ROLLOUT_PASSED"===e.status&&e.nbAgentsActioned-e.nbAgentsAck>0?`, ${e.nbAgentsActioned-e.nbAgentsAck} agent(s) offline during the rollout period`:"",versionText:e.version?` to version ${e.version}`:"",automaticIcon:e.is_automatic?(0,R.jsx)(g.EuiIconTip,{anchorProps:{style:{display:"flex",alignItems:"center"}},type:"timeRefresh",content:"Triggered by an automatic upgrade"}):null}}))))),o=(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.completedDescription",defaultMessage:"Completed {date}",values:{date:"0001-01-01T00:00:00.000Z"===e.completionTime?null:Kt(e.completionTime)}}),r=(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.failureDescription",defaultMessage:"A problem occurred during this operation."})," ",Gt(e.creationTime))),u={IN_PROGRESS:{icon:(0,R.jsx)(g.EuiLoadingSpinner,{size:"m"}),title:(0,R.jsx)(g.EuiText,null,Wt(e,e.is_automatic)),titleColor:s.euiTheme.colors.textPrimary,description:(0,R.jsx)(g.EuiText,{color:"subdued"},Gt(e.creationTime))},ROLLOUT_PASSED:{icon:e.nbAgentsFailed>0?(0,R.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"danger"}):(0,R.jsx)(g.EuiIcon,{size:"m",type:"checkInCircleFilled",color:"success"}),title:i,titleColor:e.nbAgentsFailed>0?s.euiTheme.colors.textDanger:s.euiTheme.colors.textSuccess,description:e.nbAgentsFailed>0?r:(0,R.jsx)(g.EuiText,{color:"subdued"},o)},COMPLETE:{icon:(0,R.jsx)(g.EuiIcon,{size:"m",type:"checkInCircleFilled",color:"success"}),title:i,titleColor:s.euiTheme.colors.textSuccess,description:"POLICY_REASSIGN"===e.type&&e.newPolicyId?(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.reassignCompletedDescription",defaultMessage:"Assigned to {policy}.",values:{policy:e.newPolicyId}})," ",o)):"POLICY_CHANGE"===e.type?(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)("p",null,(0,R.jsx)("b",null,e.policyId)," ",(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.policyChangedDescription",defaultMessage:"changed to revision {rev} at {date}.",values:{rev:e.revision,date:Kt(e.creationTime)}}))):(0,R.jsx)(g.EuiText,{color:"subdued"},o)},FAILED:{icon:(0,R.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"danger"}),title:i,titleColor:s.euiTheme.colors.textDanger,description:r},CANCELLED:{icon:(0,R.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"subdued"}),titleColor:s.euiTheme.colors.textSubdued,title:(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.cancelledTitle",defaultMessage:"Agent {cancelledText} cancelled",values:{cancelledText:Ht(e.type,e.actionId).cancelledText}})),description:(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.cancelledDescription",defaultMessage:"Cancelled on {date}",values:{date:Kt(e.cancellationTime)}}))},EXPIRED:{icon:(0,R.jsx)(g.EuiIcon,{size:"m",type:"warning",color:"subdued"}),titleColor:s.euiTheme.colors.textSubdued,title:(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.expiredTitle",defaultMessage:"Agent {expiredText} expired",values:{expiredText:Ht(e.type,e.actionId).cancelledText}})),description:(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.expiredDescription",defaultMessage:"Expired on {date}",values:{date:Kt(e.expiration)}}))}};return(0,R.jsx)(g.EuiPanel,{hasBorder:!0,borderRadius:"none"},(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},u[e.status].icon),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{color:u[e.status].titleColor,"data-test-subj":"statusTitle"},u[e.status].title)))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{color:"subdued","data-test-subj":"statusDescription"},u[e.status].description)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},"FAILED"===e.status&&e.latestErrors&&e.latestErrors.length>0?(0,R.jsx)(ta,{action:e}):null)),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(qt,{action:e,onClickViewAgents:t})),l&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(aa,null)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{"data-test-subj":"manageAutoUpgradesButton",onClick:()=>a(e),size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.manageAutoUpgradeAgents",defaultMessage:"Manage auto-upgrade agents"}))))))},na=({title:e,actions:t,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:l})=>(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiPanel,{color:"subdued",hasBorder:!0,borderRadius:"none"},(0,R.jsx)(g.EuiText,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"xs",alignItems:"center"},t.some((e=>"IN_PROGRESS"===e.status))&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiHealth,{color:"success"})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("b",null,e))))),t.map((e=>"UPGRADE"===e.type&&"IN_PROGRESS"===e.status?(0,R.jsx)($t,{action:e,abortUpgrade:a,key:e.actionId,onClickViewAgents:s,onClickManageAutoUpgradeAgents:l}):(0,R.jsx)(sa,{action:e,key:e.actionId,onClickViewAgents:s,onClickManageAutoUpgradeAgents:l})))),la=e=>(0,R.jsx)(g.EuiDatePicker,{"data-test-subj":"agentActivityFlyout.goToDateButton",selected:e.selectedDate,onChange:e.onChangeSelectedDate,maxDate:_e()(),customInput:e.filledStyle?(0,R.jsx)(ia,e):(0,R.jsx)(oa,e)}),ia=(0,s.forwardRef)((({onClick:e,value:t},a)=>(0,R.jsx)(g.EuiButton,{fill:!0,onClick:e},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.emptyState.goToDateButton",defaultMessage:"Go to date"})))),oa=(0,s.forwardRef)((({onClick:e,value:t},a)=>(0,R.jsx)(g.EuiButtonEmpty,{size:"m",flush:"left",onClick:e},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.goToDateButton",defaultMessage:"Go to date"})))),ra=()=>(new Date).toISOString().substring(0,10),ua=P()(g.EuiFlyoutBody).withConfig({displayName:"FullHeightFlyoutBody",componentId:"sc-1p58nye-0"})([".euiFlyoutBody__overflowContent{height:100%;}"]),da=P()(g.EuiFlexGroup).withConfig({displayName:"ButtonsFlexGroup",componentId:"sc-1p58nye-1"})(["padding-left:24px;"]),ca=P().div.withConfig({displayName:"ScrollAnchor",componentId:"sc-1p58nye-2"})(["height:0;margin:0;padding:0;"]),ga=({isFirstLoading:e,currentActions:t,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:l,areActionsFullyLoaded:i,onClickShowMore:o,dateFilter:r,onChangeDateFilter:u})=>{const d=n().useRef(null);if(n().useEffect((()=>{var e;null!==(e=d.current)&&void 0!==e&&e.scrollIntoView&&d.current.scrollIntoView()}),[r]),e)return n().createElement(ua,null,n().createElement(g.EuiFlexGroup,{direction:"row",justifyContent:"center",alignItems:"center",className:"eui-fullHeight"},n().createElement(g.EuiFlexItem,null,n().createElement(U.Rh,null))));if(0===t.length)return n().createElement(ua,null,n().createElement(ca,{ref:d}),n().createElement(g.EuiFlexGroup,{direction:"column",justifyContent:"center",alignItems:"center",className:"eui-fullHeight"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiEmptyPrompt,{iconType:"clock",iconColor:"default",title:n().createElement("h2",null," ",n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.noActivityText",defaultMessage:"No activity to display"})),titleSize:"m",body:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.noActivityDescription",defaultMessage:"Activity feed will appear here as agents are reassigned, upgraded, or unenrolled."})})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(la,{selectedDate:r,onChangeSelectedDate:u,filledStyle:!0})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{onClick:()=>u(null)},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.emptyState.showMoreButton",defaultMessage:"Clear selected date"})))));const c=t.filter((e=>"IN_PROGRESS"===e.status)),p=t.filter((e=>"IN_PROGRESS"!==e.status)),f=p.filter((e=>e.creationTime.startsWith(ra()))),x=function(e){const t={};return e.filter((e=>!e.creationTime.startsWith(ra()))).forEach((e=>{const a=e.creationTime.substring(0,10);t[a]||(t[a]=[]),t[a].push(e)})),t}(p);return n().createElement(ua,null,n().createElement(ca,{ref:d}),n().createElement(g.EuiFlexGroup,{direction:"column"},n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiFlexGroup,{direction:"column"},c.length>0?n().createElement(na,{title:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.inProgressTitle",defaultMessage:"In progress"}),actions:c,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:l}):null,f.length>0?n().createElement(na,{title:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.todayTitle",defaultMessage:"Today"}),actions:f,abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:l}):null,Object.keys(x).map((e=>n().createElement(na,{key:e,title:n().createElement(m.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"}),actions:x[e],abortUpgrade:a,onClickViewAgents:s,onClickManageAutoUpgradeAgents:l}))))),n().createElement(g.EuiFlexItem,null,n().createElement(da,{direction:"row",gutterSize:"s",alignItems:"center"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{size:"m",onClick:o,disabled:i,flush:"left","data-test-subj":"agentActivityFlyout.showMoreButton"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.showMoreButton",defaultMessage:"Show more"}))),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(la,{selectedDate:r,onChangeSelectedDate:u,filledStyle:!1})),r&&n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{size:"m",onClick:()=>u(null),flush:"left","data-test-subj":"agentActivityFlyout.clearSelectedDateButton"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.clearSelectedDateutton",defaultMessage:"Clear selected date"})))))))},pa=P()(g.EuiFlyoutFooter).withConfig({displayName:"FlyoutFooterWPadding",componentId:"sc-7yfogs-0"})(["padding:16px 24px !important;"]),ma=({onClose:e,onAbortSuccess:t,refreshAgentActivity:a,setSearch:l,setSelectedStatus:i,openManageAutoUpgradeModal:o})=>{const{notifications:r}=(0,u.WeA)(),{data:d}=(0,u.$sk)({perPage:M.W}),[c,p]=(0,s.useState)(20),[x,h]=(0,s.useState)(null),{currentActions:E,abortUpgrade:y,isFirstLoading:k,areActionsFullyLoaded:v}=function(e,t,a,n){const[l,i]=(0,s.useState)(!0),[o,r]=(0,s.useState)([]),[d,c]=(0,s.useState)(0),[g,p]=(0,s.useState)(!1),{notifications:m,overlays:x}=(0,u.WeA)(),h=(0,s.useCallback)((async()=>{try{const e=await(0,u.RYf)({perPage:a,date:null==n?void 0:n.format()});if(i(!1),e.error)throw e.error;if(!e.data)throw new Error("No data");p(d<a),c(e.data.items.length),r(e.data.items)}catch(e){m.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.actionStatus.fetchRequestError",{defaultMessage:"An error happened while fetching action status"})})}}),[a,n,d,m.toasts]);return l&&h(),(0,s.useEffect)((()=>{t&&h()}),[h,t]),(0,s.useEffect)((()=>{h()}),[h,a]),{currentActions:o,abortUpgrade:(0,s.useCallback)((async t=>{try{if(!await x.openConfirm(f.i18n.translate("xpack.fleet.currentUpgrade.confirmDescription",{defaultMessage:"This action will cancel upgrade of {nbAgents, plural, one {# agent} other {# agents}}",values:{nbAgents:t.nbAgentsActioned-t.nbAgentsAck}}),{title:f.i18n.translate("xpack.fleet.currentUpgrade.confirmTitle",{defaultMessage:"Cancel upgrade?"})}))return;await(0,u.DRU)(t.actionId),await Promise.all([h(),e()])}catch(e){m.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.currentUpgrade.abortRequestError",{defaultMessage:"An error happened while cancelling upgrade"})})}}),[h,m.toasts,x,e]),isFirstLoading:l,areActionsFullyLoaded:g}}(t,a,c,x),j=(0,s.useCallback)((e=>{var t;const a=null==d?void 0:d.items.find((t=>t.id===e));return null!==(t=null==a?void 0:a.name)&&void 0!==t?t:e}),[d]),b=(0,s.useMemo)((()=>E.map((e=>{var t,a;return{...e,newPolicyId:j(null!==(t=e.newPolicyId)&&void 0!==t?t:""),policyId:e.policyId?e.policyId:j(null!==(a=e.newPolicyId)&&void 0!==a?a:"")}}))),[E,j]);return n().createElement(n().Fragment,null,n().createElement(g.EuiFlyout,{"data-test-subj":"agentActivityFlyout",onClose:()=>{a=!1,e()},paddingSize:"none",maxWidth:M.MW},n().createElement(g.EuiFlyoutHeader,{"aria-labelledby":"FleetAgentActivityFlyoutTitle"},n().createElement(g.EuiPanel,{borderRadius:"none",hasShadow:!1,hasBorder:!0},n().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiTitle,{size:"l"},n().createElement("h1",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.title",defaultMessage:"Agent activity"})))),n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiText,{color:"subdued"},n().createElement("p",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.activityLogText",defaultMessage:"Activity log of Elastic Agent operations will appear here."}))))))),n().createElement(ga,{isFirstLoading:k,currentActions:b,abortUpgrade:y,onClickViewAgents:async t=>{try{var a;const{data:s}=await(0,u.DTC)({actionIds:[t.actionId]});if(null!=s&&null!==(a=s.items)&&void 0!==a&&a.length){const e=ut({selectedAgentIds:s.items});l(e)}i(Ge),e()}catch(e){r.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentActivityFlyout.error",{defaultMessage:"Error viewing selected agents"})})}},onClickManageAutoUpgradeAgents:async t=>{e(),o(t.policyId)},areActionsFullyLoaded:v,onClickShowMore:()=>{p(c+10)},dateFilter:x,onChangeDateFilter:e=>{var t;h(null!==(t=null==e?void 0:e.startOf("day"))&&void 0!==t?t:null),p(20)}}),n().createElement(pa,null,n().createElement(g.EuiFlexGroup,{justifyContent:"flexStart"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{onClick:e},n().createElement(g.EuiText,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.closeBtn",defaultMessage:"Close"}))))))))},fa=()=>{var e;const{cloud:t}=(0,u.WeA)();(0,u.ifo)("agent_list");const[a,l]=(0,s.useState)([]),[i,r]=(0,s.useState)("manual"),[d,c]=(0,s.useState)({isOpen:!1}),[p,m]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(),v=(0,u.Wdf)(),[j,b]=(0,s.useState)(void 0),[S,I]=(0,s.useState)(void 0),[w,C]=(0,s.useState)(void 0),[A,P]=(0,s.useState)(void 0),[_,L]=(0,s.useState)(void 0),[D,O]=(0,s.useState)(),[B,N]=(0,s.useState)(!1),[H,W]=(0,s.useState)(void 0),[G,K]=(0,s.useState)(!1),[q,V]=(0,s.useState)(void 0),{allTags:$,agentsOnCurrentPage:Y,agentsStatus:Q,isLoading:X,nAgentsInTable:Z,totalInactiveAgents:ee,totalManagedAgentIds:te,managedAgentsOnCurrentPage:ae,showUpgradeable:se,setShowUpgradeable:ne,search:le,setSearch:oe,selectedAgentPolicies:re,setSelectedAgentPolicies:ue,sortField:de,setSortField:ce,sortOrder:ge,setSortOrder:pe,selectedStatus:me,setSelectedStatus:fe,selectedTags:xe,setSelectedTags:he,allAgentPolicies:Ee,agentPoliciesRequest:ye,agentPoliciesIndexedById:ke,pagination:ve,pageSizeOptions:Se,setPagination:Me,kuery:Ie,draftKuery:Te,setDraftKuery:we,fetchData:Ce,currentRequestRef:Ae,latestAgentActionErrors:Pe,setLatestAgentActionErrors:_e}=function(){const e=function(){const e=(0,u.iO7)(),t=(0,s.useRef)({}),a=(0,s.useCallback)((async a=>{const s=a.reduce(((e,a)=>(t.current[a]||e.push(a),e)),[]);if(s.length){const a=await(0,u.IDi)(s,{full:e.fleet.readAgentPolicies,ignoreMissing:!0});if(a.error)throw a.error;if(!a.data)throw new Error("Invalid bulk GET agent policies response");a.data.items.forEach((e=>{t.current[e.id]=e}))}return a.reduce(((e,a)=>(t.current[a]&&e.push(t.current[a]),e)),[])}),[e.fleet.readAgentPolicies]);return(0,s.useMemo)((()=>({fetchPolicies:a})),[a])}(),{notifications:t}=(0,u.WeA)(),a=(0,o.useHistory)(),{urlParams:n,toUrlParams:l}=(0,u.zmo)(),{showAgentless:i}=(0,u.jXQ)(),r=n.kuery||"",d="true"===n.showInactive,[c,g]=(0,s.useState)(!1),[p,m]=(0,s.useState)(r),[x,h]=(0,s.useState)(r),{pagination:E,pageSizeOptions:y,setPagination:k}=(0,u.WQC)(),[v,j]=(0,s.useState)("enrolled_at"),[b,S]=(0,s.useState)("desc"),[F,I]=(0,s.useState)([]),[w,C]=(0,s.useState)(["healthy","unhealthy","orphaned","updating","offline",...d?["inactive"]:[]]),[A,P]=(0,s.useState)([]),_=(0,s.useMemo)((()=>w.some((e=>"inactive"===e))||0===w.length),[w]),L=(0,s.useMemo)((()=>w.some((e=>"unenrolled"===e))||0===w.length),[w]),D=(0,s.useCallback)((e=>{h(e),(""!==e.trim()||n.kuery)&&n.kuery!==e&&a.replace({search:l({...n,kuery:""===e?void 0:e})})}),[n,a,l]);let O=(0,s.useMemo)((()=>ut({search:x,selectedAgentPolicies:F,selectedTags:A,selectedStatus:w})),[x,F,w,A]);O=L&&O?`status:* AND (${O})`:L?"status:*":O;const[R,B]=(0,s.useState)([]),[N,U]=(0,s.useState)(),[H,W]=(0,s.useState)(),[G,K]=(0,s.useState)(!1),[q,V]=(0,s.useState)(0),[$,Y]=(0,s.useState)(0),[Q,X]=(0,s.useState)([]),[Z,ee]=(0,s.useState)(0),[te,ae]=(0,s.useState)({}),[se,ne]=(0,s.useState)([]),le=(0,s.useRef)(!1),ie=(0,s.useRef)(0),oe=(0,s.useCallback)((({refreshTags:a=!1}={})=>{!async function(){if(le.current)return;ie.current++;const s=ie.current;le.current=!0;try{var n,l,o;K(!0);const[t,g,p,m,f]=await Promise.all([(0,u.voy)({page:E.currentPage,perPage:E.pageSize,kuery:O&&""!==O?O:void 0,sortField:gt(v),sortOrder:b,showAgentless:i,showInactive:_,showUpgradeable:c,getStatusSummary:!0,withMetrics:!0}),(0,u.Wwg)({kuery:z.ir.buildKueryForInactiveAgents()}),(0,u.cnO)({kuery:`${M.mm}.is_managed:true`,perPage:M.W,full:!1}),(0,u.n_W)({showInactive:_}),(0,u.RYf)({latest:35e3,perPage:100})]);if(ie.current!==s)return;if(t.error)throw t.error;if(!t.data)throw new Error("Invalid GET /agents response");if(!g.data)throw new Error("Invalid GET /agents_status response");if(p.error)throw new Error(p.error.message);if(m.error)throw m.error;if(!m.data)throw new Error("Invalid GET /agent/tags response");if(f.error)throw new Error("Invalid GET /agents/action_status response");const h=t.data.statusSummary;if(!h)throw new Error("Invalid GET /agents response - no status summary");const y=t.data.items.map((e=>e.policy_id)),k=await e.fetchPolicies(y);if(le.current=!1,ie.current!==s)return;ae(k.reduce(((e,t)=>(e[t.id]=t,e)),{})),U((0,T.db)(h));const j=[...m.data.items];H&&!a&&(0,J.isEqual)(j,H)||W(j),B(t.data.items),V(t.data.total),Y(g.data.results.inactive||0);const S=null!==(n=null===(l=p.data)||void 0===l?void 0:l.items)&&void 0!==n?n:[];if(0===S.length)X([]),ee(0);else{var r,d;const e=ut({search:x,selectedAgentPolicies:S.map((e=>e.id)),selectedTags:A,selectedStatus:w}),a=await(0,u.voy)({kuery:`${e}`,perPage:M.W,showInactive:_});if(a.error)throw new Error(a.error.message);const s=null!==(r=null===(d=a.data)||void 0===d?void 0:d.items)&&void 0!==r?r:[],n=null==s?void 0:s.map((e=>e.id));X(n),ee(t.data.items.map((e=>e.id)).filter((e=>n.includes(e))).length)}const F=(null===(o=f.data)||void 0===o?void 0:o.items.filter((e=>{var t,a;return null!==(t=null===(a=e.latestErrors)||void 0===a?void 0:a.length)&&void 0!==t&&t})).map((e=>e.actionId)))||[],I=[...new Set([...se,...F])];(0,J.isEqual)(se,I)||ne(I)}catch(e){le.current=!1,t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentList.errorFetchingDataTitle",{defaultMessage:"Error fetching agents"})})}K(!1)}()}),[E.currentPage,E.pageSize,O,v,b,i,_,c,e,H,se,x,A,w,t.toasts]);(0,s.useEffect)((()=>{oe();const e=setInterval((()=>{oe()}),3e4);return()=>clearInterval(e)}),[oe]);const re=(0,u.$sk)({page:1,perPage:M.W}),ue=(0,s.useMemo)((()=>{var e;return(null===(e=re.data)||void 0===e?void 0:e.items)||[]}),[re.data]);return{allTags:H,setAllTags:W,agentsOnCurrentPage:R,agentsStatus:N,isLoading:G,nAgentsInTable:q,totalInactiveAgents:$,totalManagedAgentIds:Q,managedAgentsOnCurrentPage:Z,showUpgradeable:c,setShowUpgradeable:g,search:x,setSearch:D,selectedAgentPolicies:F,setSelectedAgentPolicies:I,sortField:v,setSortField:j,sortOrder:b,setSortOrder:S,selectedStatus:w,setSelectedStatus:C,selectedTags:A,setSelectedTags:P,allAgentPolicies:ue,agentPoliciesRequest:re,agentPoliciesIndexedById:te,pagination:E,pageSizeOptions:y,setPagination:k,kuery:O,draftKuery:p,setDraftKuery:m,fetchData:oe,currentRequestRef:ie,latestAgentActionErrors:se,setLatestAgentActionErrors:ne}}(),Le=(0,s.useCallback)((e=>{oe(e),Me({...ve,currentPage:1})}),[oe,ve,Me]),De=!!(le.trim()||re.length||me.length||xe.length||se),Oe=(0,s.useCallback)((()=>{we(""),oe(""),ue([]),fe([]),he([]),ne(!1)}),[we,oe,ue,fe,he,ne]),Re=(0,s.useMemo)((()=>[...Array.isArray(a)?a.filter((e=>{var t;return null===(t=ke[e.policy_id])||void 0===t?void 0:t.is_protected})):[],...Array.isArray(a)?a.filter((e=>{var t,a;return null===(t=ke[e.policy_id])||void 0===t||null===(a=t.package_policies)||void 0===a?void 0:a.some((e=>{var t;return(null===(t=e.package)||void 0===t?void 0:t.name)===be.FLEET_SERVER_PACKAGE}))})):[],...Array.isArray(a)?a.filter((e=>!(0,T.gL)(e))):[]]),[a,ke]),Be=(0,s.useCallback)((e=>{if(!e.active)return!1;if(!e.policy_id)return!0;const t=ke[e.policy_id];return!(!0===(null==t?void 0:t.is_managed))}),[ke]),ze=(0,s.useMemo)((()=>{if(!S||!S.policy_id)return!1;const e=ke[S.policy_id];return!!e&&(0,z.ob)(e)}),[S,ke]),[Ne,Ue]=(()=>{const{missingOptionalFeatures:e}=(0,u.YI3)(),{storage:t}=(0,u.WeA)(),[a,n]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{const e=t.get(yt);e&&n(Boolean(e))}),[t]),[(0,s.useMemo)((()=>!(a||!e)&&e.includes("encrypted_saved_object_encryption_key_required")),[e,a]),(0,s.useCallback)((()=>{t.set(yt,"true"),n(!0)}),[t])]})(),{isUnhealthy:Ge}=function(){const e=(0,u.iO7)(),{notifications:t}=(0,u.WeA)(),[a,n]=(0,s.useState)(!0),[l,i]=(0,s.useState)(!1),o=(0,s.useCallback)((async()=>{try{var e;const t=await(0,u.eK3)();if(t.error)throw t.error;null!==(e=t.data)&&void 0!==e&&e.fleet_server.has_active||i(!0),n(!1)}catch(e){t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.fleetServerUnhealthy.requestError",{defaultMessage:"An error happened while fetching fleet server status"})}),n(!1)}}),[t.toasts]);return(0,s.useEffect)((()=>{e.fleet.addAgents||e.fleet.addFleetServers?o():n(!1)}),[o,e.fleet.addAgents,e.fleet.addFleetServers]),{isLoading:a,isUnhealthy:l}}(),{isFleetServerStandalone:Ke}=(0,u.GER)(),qe=Ge&&!Ke,{shouldDisplayAgentSoftLimit:Ve}=function(){var e;const t=null===(e=(0,u.UKg)().internal)||void 0===e?void 0:e.activeAgentsSoftLimit,{data:a}=(0,x.useQuery)(["fetch-total-online-agents"],Et,{enabled:void 0!==t});return{shouldDisplayAgentSoftLimit:!(!t||!a)&&a>t}}(),$e=(0,s.useCallback)((()=>{v.openFleetServerFlyout()}),[v]),Ye=(0,s.useCallback)((()=>{m(!0),_e([])}),[m,_e]),Qe=({refreshTags:e=!1}={})=>{Ce({refreshTags:e}),K(!0)},Xe=1===(null==Ae?void 0:Ae.current);return(0,R.jsx)(n().Fragment,null,p?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(ma,{onAbortSuccess:Ce,onClose:()=>m(!1),openManageAutoUpgradeModal:e=>{k(e),E(!0)},refreshAgentActivity:X,setSearch:oe,setSelectedStatus:fe})):null,h?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(ie.i,{key:y,onClose:()=>E(!1),agentPolicy:Ee.find((e=>e.id===y))})):null,d.isOpen?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.rt,{agentPolicy:Ee.find((e=>e.id===d.selectedPolicyId)),onClose:()=>{c({isOpen:!1}),Ce(),ye.resendRequest()}})):null,j&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.eN,{agents:[j],onClose:()=>{b(void 0),Qe()}})),S&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.VH,{agents:[S],agentCount:1,onClose:()=>{I(void 0),Qe({refreshTags:!0})},useForceUnenroll:"unenrolling"===S.status,hasFleetServer:ze})),(null==w?void 0:w.policy_id)&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.pc,{target:"agent",policyId:w.policy_id,onClose:()=>{C(void 0),Qe({refreshTags:!0})}})),A&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.YF,{agents:[A],agentCount:1,onClose:()=>{P(void 0),Qe()},isUpdating:(0,je.isStuckInUpdating)(A)})),H&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fe,{agents:[H],agentCount:1,onClose:()=>{W(void 0)}})),B&&(0,R.jsx)(jt,{agentId:null==_?void 0:_.id,allTags:null!=$?$:[],selectedTags:null!==(e=null==_?void 0:_.tags)&&void 0!==e?e:[],button:D,onTagsUpdated:e=>{Qe({refreshTags:!0}),e.length>0&&("No Tags"===xe[0]||Ie.includes("not tags:*"))&&N(!1)},onClosePopover:()=>{N(!1)}}),q&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(St,{agents:[q],agentCount:1,unsupportedMigrateAgents:null!=Re?Re:[],onClose:()=>{V(void 0)},onSave:()=>{V(void 0),Qe()}})),qe&&(0,R.jsx)(n().Fragment,null,null!=t&&t.deploymentUrl?(0,R.jsx)(U.XL,{deploymentUrl:t.deploymentUrl}):(0,R.jsx)(U.T5,{onClickAddFleetServer:$e}),(0,R.jsx)(g.EuiSpacer,{size:"l"})),Ne&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(U.a4,{onClickHandler:Ue}),(0,R.jsx)(g.EuiSpacer,{size:"l"})),Ve&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(We,null),(0,R.jsx)(g.EuiSpacer,{size:"l"})),(0,R.jsx)(Rt,{agentPolicies:Ee,draftKuery:Te,onDraftKueryChange:we,onSubmitSearch:Le,selectedAgentPolicies:re,onSelectedAgentPoliciesChange:e=>{"query"===i&&r("manual"),ue(e)},selectedStatus:me,onSelectedStatusChange:e=>{"query"===i&&r("manual"),fe(e)},showUpgradeable:se,onShowUpgradeableChange:ne,tags:null!=$?$:[],selectedTags:xe,onSelectedTagsChange:he,nAgentsInTable:Z,totalInactiveAgents:ee,totalManagedAgentIds:te,selectionMode:i,currentQuery:Ie,selectedAgents:a,refreshAgents:Qe,onClickAddAgent:()=>c({isOpen:!0}),onClickAddFleetServer:$e,agentsOnCurrentPage:Y,onClickAgentActivity:Ye,shouldShowAgentActivityTour:G,latestAgentActionErrors:Pe.length,sortField:de,sortOrder:ge,unsupportedMigrateAgents:Re}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(tt,{totalAgents:Z,totalManagedAgents:te.length||0,agentStatus:Q,selectableAgents:(null==Y?void 0:Y.filter(Be).length)||0,managedAgentsOnCurrentPage:ae,selectionMode:i,setSelectionMode:r,selectedAgents:a,setSelectedAgents:e=>{l(e),r("manual")},clearFilters:Oe,isUsingFilter:De}),(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(He,{agents:Y,sortField:de,pageSizeOptions:Se,sortOrder:ge,isLoading:X,agentPoliciesIndexedById:ke,renderActions:e=>{const t="string"==typeof e.policy_id?ke[e.policy_id]:void 0;return(null==_?void 0:_.id)!==e.id||(0,J.isEqual)(e.tags,_.tags)||L(e),(0,R.jsx)(zt,{agent:e,agentPolicy:t,onReassignClick:()=>b(e),onUnenrollClick:()=>I(e),onUpgradeClick:()=>P(e),onAddRemoveTagsClick:t=>{O(t),L(e),N(!B)},onGetUninstallCommandClick:()=>C(e),onRequestDiagnosticsClick:()=>W(e),onMigrateAgentClick:()=>V(e)})},onSelectionChange:e=>{if("query"===i&&e.length<a.length){if(!(a.length>0&&0===(0,J.differenceBy)(a,Y,"id").length))return l(Y.filter((e=>Be(e))));r("manual")}l(e)},selected:a,showUpgradeable:se,onTableChange:({page:e,sort:t})=>{const a={...ve,currentPage:e.index+1,pageSize:e.size};Me(a),ce(t.field),pe(t.direction)},pagination:ve,totalAgents:Math.min(Z,M.W),isUsingFilter:De,setEnrollmentFlyoutState:c,clearFilters:Oe,isCurrentRequestIncremented:Xe}))};var xa=a(43609),ha=a(94655),Ea=a(61215),ya=a(23833),ka=a.n(ya),va=a(60362),ja=a.n(va);const ba=function(e,t={}){const a=n().lazy(e);return n().forwardRef(((e,l)=>{var i;return(0,R.jsx)(s.Suspense,{fallback:null!==(i=t.fallback)&&void 0!==i?i:null},n().createElement(a,{...e,ref:l}))}))}((()=>a.e(741).then(a.bind(a,12741)).then((e=>({default:e.SavedSearchComponent})))));var Sa=a(16524),Fa=a.n(Sa);const Ma=(0,s.memo)((({selectedDatasets:e,onToggleDataset:t})=>{const{unifiedSearch:a,data:n}=(0,u.WeA)(),[l,i]=(0,s.useState)(!1),[o,r]=(0,s.useState)(!1),[d,c]=(0,s.useState)([Yt.tO]),p=(0,s.useCallback)((()=>i((e=>!e))),[i]),m=(0,s.useCallback)((()=>i(!1)),[i]),x=(0,s.useCallback)((t=>t.map((t=>({label:t,checked:e.includes(t)?"on":void 0,key:t})))),[e]),[h,E]=(0,s.useState)(x(d));return(0,s.useEffect)((()=>{(async()=>{r(!0);try{const e=(await n.dataViews.getFieldsForWildcard({pattern:Yt.Lr})).reduce(((e,t)=>(e[t.name]=t,e)),{}),t=await n.dataViews.create({title:Yt.Lr,fields:e}),s=await a.autocomplete.getValueSuggestions({indexPattern:t,field:Yt.Ep,query:""});s.length>0&&(c(s.sort()),E(x(s.sort())))}catch(e){c([Yt.tO]),E(x([Yt.tO]))}r(!1)})()}),[n.dataViews,a.autocomplete,x]),(0,R.jsx)(g.EuiPopover,{button:(0,R.jsx)(g.EuiFilterButton,{"data-test-subj":"agentList.datasetFilterBtn",iconType:"arrowDown",onClick:p,isSelected:l,isLoading:o,numFilters:d.length,hasActiveFilters:e.length>0,numActiveFilters:e.length},f.i18n.translate("xpack.fleet.agentLogs.datasetSelectText",{defaultMessage:"Dataset"})),isOpen:l,closePopover:m,panelPaddingSize:"none"},(0,R.jsx)(g.EuiSelectable,{options:h,onChange:e=>{E(e),e.forEach(((e,a)=>{e.checked===h[a].checked||t(e.label)}))},"data-test-subj":"agentList.datasetFilterOptions",isLoading:o,listProps:{paddingSize:"s",style:{minWidth:220}}},(e=>e)))})),Ia=(0,s.memo)((({selectedLevels:e,onToggleLevel:t})=>{const[a,n]=(0,s.useState)(!1),l=(0,s.useCallback)((()=>n((e=>!e))),[]),i=(0,s.useCallback)((()=>n(!1)),[]),[o,r]=(0,s.useState)(te.F$W.map((t=>({label:t,checked:e.includes(t)?"on":void 0,key:t}))));return(0,R.jsx)(g.EuiPopover,{button:(0,R.jsx)(g.EuiFilterButton,{"data-test-subj":"agentList.logLevelFilterBtn",iconType:"arrowDown",onClick:l,isSelected:a,numFilters:o.length,hasActiveFilters:e.length>0,numActiveFilters:e.length},f.i18n.translate("xpack.fleet.agentLogs.logLevelSelectText",{defaultMessage:"Log level"})),isOpen:a,closePopover:i,panelPaddingSize:"none"},(0,R.jsx)(g.EuiSelectable,{options:o,onChange:e=>{r(e),e.forEach(((e,a)=>{e.checked===o[a].checked||t(e.label)}))},"data-test-subj":"agentList.logLevelFilterOptions",listProps:{paddingSize:"s"}},(e=>e)))})),Ta=[Yt.JQ.name,Yt.Ep.name,Yt.Jt.name],wa=(0,s.memo)((({query:e,isQueryValid:t,onUpdateQuery:a})=>{const{data:n,unifiedSearch:{ui:{QueryStringInput:l}}}=(0,u.WeA)(),[i,o]=(0,s.useState)();return(0,s.useEffect)((()=>{(async()=>{try{const e=(await n.dataViews.getFieldsForWildcard({pattern:Yt.Lr})||[]).filter((e=>!Ta.includes(e.name)));o(e)}catch(e){o(void 0)}})()}),[n.dataViews]),(0,R.jsx)(l,{iconType:"search",autoSubmit:!0,disableLanguageSwitcher:!0,indexPatterns:i?[{title:Yt.Lr,fields:i}]:[],query:{query:e,language:"kuery"},isInvalid:!t,disableAutoFocus:!0,placeholder:f.i18n.translate("xpack.fleet.agentLogs.searchPlaceholderText",{defaultMessage:"Search logs…"}),onChange:e=>{a(e.query)},onSubmit:e=>{a(e.query,!0)},appName:f.i18n.translate("xpack.fleet.appTitle",{defaultMessage:"Fleet"})})})),Ca=P()(g.EuiFlexGroup).withConfig({displayName:"WrapperFlexGroup",componentId:"sc-fcgfrk-0"})(["height:100%;"]),Aa=P()(g.EuiFlexItem).withConfig({displayName:"DatePickerFlexItem",componentId:"sc-fcgfrk-1"})(["max-width:312px;"]),Pa=(0,Ea.createStateContainerReactHelpers)(),_a=({agentPolicy:e})=>{const{getHref:t}=(0,u.iEg)();return n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiCallOut,{size:"m",color:"primary",iconType:"info",title:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.logDisabledCallOutTitle",defaultMessage:"Log collection is disabled"})},e.is_managed?null:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.logDisabledCallOutDescription",defaultMessage:"Update the agent's policy {settingsLink} to enable logs collection.",values:{settingsLink:n().createElement(g.EuiLink,{href:t("policy_details",{policyId:e.id,tabId:"settings"})},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.settingsLink",defaultMessage:"settings"}))}})))},La=(0,s.memo)((({agent:e,agentPolicy:t,state:a})=>{var l,i,o,r;const{application:d,logsDataAccess:{services:{logSourcesService:c}},embeddable:p,data:{search:{searchSource:f},query:{timefilter:{timefilter:x}},dataViews:h}}=(0,u.WeA)(),E=Fa()(c.getFlattenedLogSources),{update:y}=Pa.useTransitions(),v=(0,s.useCallback)((e=>{const{min:t,max:a}=x.calculateBounds(e);return t&&a?{start:t.valueOf(),end:a.valueOf()}:void 0}),[x]),j=(0,s.useCallback)((e=>{v(e)&&y({start:e.from,end:e.to})}),[v,y]),b=(0,s.useCallback)((e=>{try{return(0,st.fromKueryExpression)(e),!0}catch(e){return!1}}),[]),[S,F]=(0,s.useState)(a.query),[M,I]=(0,s.useState)(b(a.query)),T=(0,s.useCallback)(((e,t)=>{F(e),b(e)?(I(!0),t&&y({query:e})):I(!1)}),[b,y]),w=(0,s.useMemo)((()=>({language:"kuery",query:Qt({agentId:e.id,datasets:a.datasets,logLevels:a.logLevels,userQuery:a.query})})),[e.id,a.datasets,a.logLevels,a.query]),C=null===(l=e.local_metadata)||void 0===l||null===(i=l.elastic)||void 0===i||null===(o=i.agent)||void 0===o?void 0:o.version;return(0,s.useMemo)((()=>{var e;if(!C)return!1;const t=null===(e=ja()(C))||void 0===e?void 0:e.version;return!!t&&ka()(t,"7.11.0")}),[C])?n().createElement(Ca,{direction:"column",gutterSize:"m"},t&&!(null!==(r=t.monitoring_enabled)&&void 0!==r&&r.includes("logs"))&&n().createElement(_a,{agentPolicy:t}),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiFlexGroup,{gutterSize:"m"},n().createElement(g.EuiFlexItem,null,n().createElement(wa,{query:S,onUpdateQuery:T,isQueryValid:M})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiFilterGroup,null,n().createElement(Ma,{selectedDatasets:a.datasets,onToggleDataset:e=>{const t=[...a.datasets],s=t.indexOf(e);s>=0?(t.splice(s,1),y({datasets:t})):y({datasets:[...a.datasets,e]})}}),n().createElement(Ia,{selectedLevels:a.logLevels,onToggleLevel:e=>{const t=[...a.logLevels],s=t.indexOf(e);s>=0?(t.splice(s,1),y({logLevels:t})):y({logLevels:[...a.logLevels,e]})}}))),n().createElement(Aa,{grow:!1},n().createElement(g.EuiSuperDatePicker,{showUpdateButton:!1,start:a.start,end:a.end,onTimeChange:({start:e,end:t})=>{j({from:e,to:t})}})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(k.V,{coreStart:{application:d}},n().createElement(Zt,{logStreamQuery:w.query,startTime:Jt(a.start),endTime:Jt(a.end)}))))),n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiPanel,{paddingSize:"none",grow:!1},E.value?n().createElement(ba,{dependencies:{embeddable:p,searchSource:f,dataViews:h},index:E.value,timeRange:{from:a.start,to:a.end},query:w,height:"60vh",displayOptions:{enableDocumentViewer:!0,enableFilters:!1},columns:["@timestamp","event.dataset","component.id","message","error.message"]}):null))):n().createElement(g.EuiCallOut,{size:"m",color:"warning",title:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.oldAgentWarningTitle",defaultMessage:"The Logs view requires Elastic Agent 7.11 or higher. To upgrade an agent, go to the Actions menu, or {downloadLink} a newer version.",values:{downloadLink:n().createElement(g.EuiLink,{href:"https://ela.st/download-elastic-agent",external:!0,target:"_blank"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentLogs.downloadLink",defaultMessage:"download"}))}})})})),Da=(0,s.memo)((({agent:e,agentPolicy:t})=>{const a=(0,s.useMemo)((()=>(0,Ea.createStateContainer)({...Yt.ky,...(0,Ea.getStateFromKbnUrl)(Yt.CK,window.location.href,{getFromHashQuery:!1})},{update:e=>t=>({...e,...t})})),[]),n=(0,s.useMemo)((()=>Pa.connect((e=>({state:e||Yt.ky})))(La)),[]),[l,i]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{const e=(0,Ea.createKbnUrlStateStorage)({useHashQuery:!1,useHash:!1}),{start:t,stop:s}=(0,Ea.syncState)({storageKey:Yt.CK,stateContainer:a,stateStorage:e});return t(),i(!0),()=>{s(),a.set(Yt.ky)}}),[a]),(0,R.jsx)(Pa.Provider,{value:a},l?(0,R.jsx)(n,{agent:e,agentPolicy:t}):null)})),Oa=(0,s.memo)((({agent:e,onClose:t})=>{var a,s;const n=JSON.stringify(e,null,2),l="string"==typeof(null===(a=e.local_metadata)||void 0===a||null===(s=a.host)||void 0===s?void 0:s.hostname)?e.local_metadata.host.hostname:e.id,{docLinks:i}=(0,u.WeA)(),o=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:t,maxWidth:M.MW,"aria-labelledby":o},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:o},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutTitle",defaultMessage:"''{name}'' agent details",values:{name:l}})))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(g.EuiText,null,(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutDescription",defaultMessage:"The JSON below is the raw agent data tracked by Fleet. This data can be useful for debugging or troubleshooting Elastic Agent. For more information, see the {doc}.",values:{doc:(0,R.jsx)(g.EuiLink,{href:i.links.fleet.troubleshooting},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutDocLink",defaultMessage:"troubleshooting documentation"}))}}))),(0,R.jsx)(g.EuiSpacer,null),(0,R.jsx)(g.EuiCodeBlock,{language:"json",isCopyable:!0},n)),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:t,flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsJsonFlyoutCloseButtonLabel",defaultMessage:"Close"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{iconType:"download",onClick:()=>{const e=document.createElement("a");e.href=`data:text/json;charset=utf-8,${encodeURIComponent(n)}`,e.download=`${l}-agent-details.json`,e.click()}},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsJsonDownloadButtonLabel",defaultMessage:"Download JSON"}))))))})),Ra=(0,s.memo)((({agent:e,assignFlyoutOpenByDefault:t=!1,onCancelReassign:a,agentPolicy:l,onAddRemoveTagsClick:i})=>{const o=(0,u.iO7)(),r=o.fleet.allAgents,d=(0,ha.a)(),[c,p]=(0,s.useState)(t),[f,x]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(!1),[v,j]=(0,s.useState)(!1),b="unenrolling"===e.status,S=(0,je.isStuckInUpdating)(e),[M,I]=(0,s.useState)(!1),w=(0,s.useCallback)((e=>{I(e)}),[I]),C=l&&(0,z.ob)(l),A=(0,s.useMemo)((()=>a||(()=>p(!1))),[a,p]),P=[...!r||null!=l&&l.is_managed?[]:[(0,R.jsx)(g.EuiContextMenuItem,{icon:"tag",onClick:e=>{i(e.target.closest("button"))},disabled:!e.active,key:"addRemoveTags"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.addRemoveTagsActionText",defaultMessage:"Add / remove tags"})),(0,R.jsx)(g.EuiContextMenuItem,{icon:"pencil",onClick:()=>{p(!0)},disabled:!e.active&&!l||!0===(null==l?void 0:l.supports_agentless),key:"reassignPolicy"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),(0,R.jsx)(g.EuiContextMenuItem,{icon:"refresh",disabled:!(0,z._3)(e)||!0===(null==l?void 0:l.supports_agentless),onClick:()=>{E(!0)},key:"upgradeAgent","data-test-subj":"upgradeBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))],...r&&S?[(0,R.jsx)(g.EuiContextMenuItem,{icon:"refresh",onClick:()=>{E(!0)},key:"restartUpgradeAgent","data-test-subj":"restartUpgradeBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.restartUpgradeOneButton",defaultMessage:"Restart upgrade"}))]:[],(0,R.jsx)(g.EuiContextMenuItem,{icon:"inspect",onClick:()=>{I(!1),j(!v)},key:"agentDetailsJson","data-test-subj":"viewAgentDetailsJsonBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.viewAgentDetailsJsonText",defaultMessage:"View agent JSON"})),...o.fleet.readAgents?[(0,R.jsx)(g.EuiContextMenuItem,{icon:"download",disabled:!(0,T.fx)(e),onClick:()=>{k(!0)},"data-test-subj":"requestAgentDiagnosticsBtn",key:"requestDiagnostics"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}))]:[],...!r||null!=l&&l.is_managed?[]:[(0,R.jsx)(g.EuiContextMenuItem,{icon:"trash",disabled:!r||!e.active||!0===(null==l?void 0:l.supports_agentless),onClick:()=>{x(!0)},key:"unenrollAgent"},b?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"}))]];return(0,R.jsx)(n().Fragment,null,c&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.eN,{agents:[e],onClose:A})),f&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.VH,{agents:[e],agentCount:1,onClose:()=>{x(!1),d()},useForceUnenroll:b,hasFleetServer:C})),h&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(U.YF,{agents:[e],agentCount:1,onClose:()=>{E(!1),d()},isUpdating:S})),y&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fe,{agents:[e],agentCount:1,onClose:()=>{k(!1)}})),v&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Oa,{agent:e,onClose:()=>j(!1)})),(0,R.jsx)(F.AK,{isOpen:M,onChange:w,button:{props:{iconType:"arrowDown",iconSide:"right",color:"primary"},children:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.actionsButton",defaultMessage:"Actions"})},items:P}))})),Ba=P()(g.EuiButton).withConfig({displayName:"EuiButtonCompressed",componentId:"sc-1y6vsns-0"})(["height:32px;"]),za=({agent:e,agentPolicy:t})=>{var a,s;const{isInstalled:l,link:i,isLoading:o}=function(e){const{isLoading:t,data:a}=(0,u.E1o)(te.cOw),{spaceId:s}=(0,u.YI3)(),n=function(e,t){var a,s;if("installed"!==(null==t||null===(a=t.item)||void 0===a?void 0:a.status))return!1;const n=t.item.installationInfo;return!(!n||"installed"!==n.install_status)&&(n.installed_kibana_space_id===e||e&&(null===(s=n.additional_spaces_installed_kibana)||void 0===s?void 0:s[e]))}(s,a),l=(0,u.e3j)();return{isLoading:t,isInstalled:n,link:null==l?void 0:l.getRedirectUrl({dashboardId:Pt(s,a,te.K$s.ELASTIC_AGENT_AGENT_METRICS),query:{language:"kuery",query:`elastic_agent.id:${e.id}`}})}}(e),{getHref:r}=(0,u.iEg)(),c=null!==(a=null==t||null===(s=t.monitoring_enabled)||void 0===s?void 0:s.length)&&void 0!==a&&a,p=l&&!o&&c?{href:i}:{disabled:!0},f=n().createElement(Ba,(0,d.default)({},p,{isLoading:o,color:"primary",iconType:"dashboardApp"}),n().createElement(m.FormattedMessage,{"data-test-subj":"agentDetails.viewMoreMetricsButton",id:"xpack.fleet.agentDetails.viewDashboardButtonLabel",defaultMessage:"View more agent metrics"}));return o||c||!t?l?f:n().createElement(g.EuiToolTip,{content:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.viewDashboardButton.disabledNoIntegrationTooltip",defaultMessage:"Agent dashboard not found, you need to install the elastic_agent integration."})},f):n().createElement(g.EuiToolTip,{content:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.viewDashboardButton.disabledNoLogsAndMetricsTooltip",defaultMessage:"Logs and metrics for agent are not enabled in the agent policy."})},n().createElement(Ba,{"data-test-subj":"agentDetails.enableLogsAndMetricsButton",isLoading:o,color:"primary",href:r("policy_details",{policyId:t.id,tabId:"settings"}),disabled:null==t?void 0:t.is_managed},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.enableLogsAndMetricsLabel",defaultMessage:"Enable logs and metrics"})))},Na=P()(g.EuiLink).withConfig({displayName:"TruncatedEuiLink",componentId:"sc-7tcs8-0"})(["overflow:hidden;text-overflow:ellipsis;white-space:nowrap;width:120px;"]),Ua=({outputs:e,isMonitoring:t})=>{var a,l,i,o;const{getHref:r}=(0,u.iEg)(),[d,c]=(0,s.useState)(!1),p=null==e?void 0:e.monitoring,m=null==e?void 0:e.data,x=(0,s.useMemo)((()=>null!=m&&m.integrations?((null==m?void 0:m.integrations)||[]).map(((e,t)=>{var a;return{"data-test-subj":`output-integration-${t}`,label:`${e.integrationPolicyName}: ${e.name}`,href:r("settings_edit_outputs",{outputId:null!==(a=null==e?void 0:e.id)&&void 0!==a?a:""}),iconType:"dot"}})):[]),[r,null==m?void 0:m.integrations]);return n().createElement(g.EuiFlexGroup,{gutterSize:"s",alignItems:"baseline",responsive:!1,justifyContent:"flexStart"},t?n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(Na,{href:r("settings_edit_outputs",{outputId:null!==(a=null==p||null===(l=p.output)||void 0===l?void 0:l.id)&&void 0!==a?a:""}),title:null==p?void 0:p.output.name,"data-test-subj":"outputNameLink"},null==p?void 0:p.output.name)):n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(Na,{href:r("settings_edit_outputs",{outputId:null!==(i=null==m||null===(o=m.output)||void 0===o?void 0:o.id)&&void 0!==i?i:""}),title:null==m?void 0:m.output.name,"data-test-subj":"outputNameLink"},null==m?void 0:m.output.name)),(null==m?void 0:m.integrations)&&(null==m?void 0:m.integrations.length)>=1&&!t&&n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiBadge,{color:"hollow","data-test-subj":"outputsIntegrationsNumberBadge",onClick:()=>c(!d),onClickAriaLabel:"Open output integrations popover"},"+",null==m?void 0:m.integrations.length),n().createElement(g.EuiPopover,{"data-test-subj":"outputPopover",isOpen:d,closePopover:()=>c(!1),anchorPosition:"downCenter"},n().createElement(g.EuiPopoverTitle,null,f.i18n.translate("xpack.fleet.AgentPolicyOutputsSummary.popover.title",{defaultMessage:"Output for integrations"})),n().createElement("div",{style:{width:"280px"}},n().createElement(g.EuiListGroup,{listItems:x,color:"primary",size:"s",gutterSize:"none"})))))},Ha=P()(g.EuiFlexItem).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1y4d0ny-0"})(["min-width:0px;"]),Wa=(0,s.memo)((({agent:e,agentPolicy:t})=>{var a,s,l,i,o,r,d,c,p,x,h,E,y,k,v,j,b,S,M,I;const T=(0,u.JhS)(),w=(0,u.zQn)(null==t?void 0:t.id),C=null==w||null===(a=w.data)||void 0===a?void 0:a.item;return n().createElement(g.EuiPanel,null,n().createElement(g.EuiDescriptionList,{compressed:!0},n().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m","data-test-subj":"agentDetailsOverviewSection"},n().createElement(g.EuiFlexGroup,null,n().createElement(Ha,{grow:5},n().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},[{title:n().createElement(g.EuiToolTip,{content:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.cpuTooltip",defaultMessage:"Average CPU usage in the last 5 minutes"})},n().createElement("span",{tabIndex:0},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.cpuTitle",defaultMessage:"CPU"})," ",n().createElement(g.EuiIcon,{type:"info"}))),description:Ce(e.metrics,t)},{title:n().createElement(g.EuiToolTip,{content:n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.memoryTooltip",defaultMessage:"Average memory usage in the last 5 minutes"})},n().createElement("span",{tabIndex:0},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.memoryTitle",defaultMessage:"Memory"})," ",n().createElement(g.EuiIcon,{type:"info"}))),description:Ae(e.metrics,t)}].map((({title:e,description:t})=>{const a="string"==typeof t&&t.length>20?t:"";return n().createElement(g.EuiFlexGroup,null,n().createElement(Ha,{grow:8},n().createElement(g.EuiDescriptionListTitle,null,e)),n().createElement(Ha,{grow:4},n().createElement(g.EuiToolTip,{position:"top",content:a},n().createElement(g.EuiDescriptionListDescription,{className:"eui-textTruncate"},t))))})))),n().createElement(Ha,{grow:5},n().createElement(g.EuiFlexGroup,{justifyContent:"flexEnd"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(za,{agent:e,agentPolicy:t}))))),[{title:f.i18n.translate("xpack.fleet.agentDetails.statusLabel",{defaultMessage:"Status"}),description:n().createElement(U.u0,{agent:e,fromDetails:!0})},{title:f.i18n.translate("xpack.fleet.agentDetails.lastActivityLabel",{defaultMessage:"Last activity"}),description:e.last_checkin?Kt(e.last_checkin):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.lastCheckinMessageLabel",{defaultMessage:"Last checkin message"}),description:e.last_checkin_message?e.last_checkin_message:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.agentIdLabel",{defaultMessage:"Agent ID"}),description:e.id},{title:f.i18n.translate("xpack.fleet.agentDetails.agentPolicyLabel",{defaultMessage:"Agent policy"}),description:t?n().createElement(F.an,{policy:t,agent:e}):n().createElement(g.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.versionLabel",{defaultMessage:"Agent version"}),description:"string"==typeof(null===(s=e.local_metadata)||void 0===s||null===(l=s.elastic)||void 0===l||null===(i=l.agent)||void 0===i?void 0:i.version)?n().createElement(Ga,{gutterSize:"s",alignItems:"center"},n().createElement(g.EuiFlexItem,{grow:!1,className:"eui-textNoWrap"},e.local_metadata.elastic.agent.version),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(Be,{isAgentUpgradable:!(!0===(null==t?void 0:t.is_managed)||!(0,z._3)(e)),agent:e,latestAgentVersion:T}))):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.hostNameLabel",{defaultMessage:"Host name"}),description:"string"==typeof(null===(o=e.local_metadata)||void 0===o||null===(r=o.host)||void 0===r?void 0:r.hostname)?e.local_metadata.host.hostname:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.hostIdLabel",{defaultMessage:"Host ID"}),description:"string"==typeof(null===(d=e.local_metadata)||void 0===d||null===(c=d.host)||void 0===c?void 0:c.id)?e.local_metadata.host.id:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.outputForMonitoringLabel",{defaultMessage:"Output for integrations"}),description:C?n().createElement(Ua,{outputs:C}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.outputForMonitoringLabel",{defaultMessage:"Output for monitoring"}),description:C?n().createElement(Ua,{outputs:C,isMonitoring:!0}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.logLevel",{defaultMessage:"Logging level"}),description:"string"==typeof(null===(p=e.local_metadata)||void 0===p||null===(x=p.elastic)||void 0===x||null===(h=x.agent)||void 0===h?void 0:h.log_level)?e.local_metadata.elastic.agent.log_level:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.privilegeModeLabel",{defaultMessage:"Privilege mode"}),description:!0===e.local_metadata.elastic.agent.unprivileged?n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModeUnprivilegedText",defaultMessage:"Running as non-root"}):n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModePrivilegedText",defaultMessage:"Running as root"})},{title:f.i18n.translate("xpack.fleet.agentDetails.releaseLabel",{defaultMessage:"Agent release"}),description:"boolean"==typeof(null===(E=e.local_metadata)||void 0===E||null===(y=E.elastic)||void 0===y||null===(k=y.agent)||void 0===k?void 0:k.snapshot)?!0===e.local_metadata.elastic.agent.snapshot?"snapshot":"stable":"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.platformLabel",{defaultMessage:"Platform"}),description:"string"==typeof(null===(v=e.local_metadata)||void 0===v||null===(j=v.os)||void 0===j?void 0:j.platform)?e.local_metadata.os.platform:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.monitorLogsLabel",{defaultMessage:"Monitor logs"}),description:Array.isArray(null==t?void 0:t.monitoring_enabled)?null!=t&&null!==(b=t.monitoring_enabled)&&void 0!==b&&b.includes("logs")?n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.monitorLogsEnabledText",defaultMessage:"Enabled"}):n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.monitorLogsDisabledText",defaultMessage:"Disabled"}):n().createElement(g.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.monitorMetricsLabel",{defaultMessage:"Monitor metrics"}),description:Array.isArray(null==t?void 0:t.monitoring_enabled)?null!=t&&null!==(S=t.monitoring_enabled)&&void 0!==S&&S.includes("metrics")?n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.monitorMetricsEnabledText",defaultMessage:"Enabled"}):n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentList.monitorMetricsDisabledText",defaultMessage:"Disabled"}):n().createElement(g.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.tagsLabel",{defaultMessage:"Tags"}),description:(null!==(M=e.tags)&&void 0!==M?M:[]).length>0?n().createElement(we,{tags:null!==(I=e.tags)&&void 0!==I?I:[]}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.platformLabel",{defaultMessage:"FIPS mode"}),description:!0===e.local_metadata.elastic.agent.fips?n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.fipsModeCompliantText",defaultMessage:"Enabled"}):n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModePrivilegedText",defaultMessage:"Not enabled"})}].map((({title:e,description:t})=>{const a="string"==typeof t&&t.length>20?t:"";return n().createElement(g.EuiFlexGroup,null,n().createElement(Ha,{grow:3},n().createElement(g.EuiDescriptionListTitle,null,e)),n().createElement(Ha,{grow:7},n().createElement(g.EuiToolTip,{position:"top",content:a},n().createElement(g.EuiDescriptionListDescription,{className:"eui-textTruncate"},t))))})))))}));var Ga=P()(g.EuiFlexGroup).withConfig({displayName:"_StyledEuiFlexGroup",componentId:"sc-1y4d0ny-1"})(["min-width:0;"]),Ka=a(91785);const qa=P()(g.EuiFlexItem).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1n7kbng-0"})(["min-width:0px;"]),Va=(0,s.memo)((({agent:e,agentPolicy:t})=>n().createElement(n().Fragment,null,n().createElement(g.EuiFlexGroup,{alignItems:"flexStart"},n().createElement(qa,null,n().createElement(g.EuiTitle,{size:"s"},n().createElement("h3",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.overviewSectionTitle",defaultMessage:"Overview"}))),n().createElement(g.EuiSpacer,{size:"s"}),n().createElement(Wa,{agent:e,agentPolicy:t})),n().createElement(qa,null,n().createElement(g.EuiTitle,{size:"s"},n().createElement("h3",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentDetails.integrationsSectionTitle",defaultMessage:"Integrations"}))),n().createElement(g.EuiSpacer,{size:"s"}),n().createElement(Ka.P,{agent:e,agentPolicy:t})))))),$a=({agent:e})=>{const t=(0,u.iO7)(),{notifications:a}=(0,u.WeA)(),{getAbsolutePath:l}=(0,u.iEg)(),[i,o]=(0,s.useState)(!0),[r,d]=(0,s.useState)(!1),[c,p]=(0,s.useState)([]),[x,h]=(0,s.useState)([]),[E,y]=(0,s.useState)([]),[k,v]=(0,s.useState)(1e4),[j,b]=(0,s.useState)(!1),S=(0,s.useCallback)((async()=>{try{const t=await(0,u.uWX)(e.id),a=t.error;if(a)throw a;if(!t.data)throw new Error("No data");const s=t.data.items;h(s),o(!1),s.some((e=>"IN_PROGRESS"===e.status||"AWAITING_UPLOAD"===e.status))?v(3e3):v(1e4)}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.requestDiagnostics.errorLoadingUploadsNotificationTitle",{defaultMessage:"Error loading diagnostics uploads"})})}}),[e.id,a.toasts,v]);(0,s.useEffect)((()=>{S();const e=setInterval((async()=>{S()}),k);return()=>{e&&clearInterval(e)}}),[S,k]),(0,s.useEffect)((()=>{y(x),E.length>0&&x.filter((e=>{const t=E.find((t=>t.id===e.id));return"READY"===e.status&&(!t||"READY"!==(null==t?void 0:t.status))})).forEach((e=>{a.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.requestDiagnostics.readyNotificationTitle",{defaultMessage:"Agent diagnostics {name} ready",values:{name:e.name}})},{toastLifeTimeMs:5e3})}))}),[E,x,a.toasts]),(0,s.useEffect)((()=>{p(r?x:x.filter((e=>"EXPIRED"!==e.status)))}),[x,r]);const F=[{field:"id",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.fileLabelText",{defaultMessage:"File"}),render:e=>{const t=x.find((t=>t.id===e));return"READY"===(null==t?void 0:t.status)?(0,R.jsx)(g.EuiLink,{href:l(null==t?void 0:t.filePath),download:!0,target:"_blank"},(0,R.jsx)(g.EuiIcon,{type:"download"}),"   ",null==t?void 0:t.name):"IN_PROGRESS"===(null==t?void 0:t.status)||"AWAITING_UPLOAD"===(null==t?void 0:t.status)?(0,R.jsx)(g.EuiLink,{color:"subdued",disabled:!0},(0,R.jsx)(g.EuiLoadingSpinner,null),"  ",(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.generatingText",defaultMessage:"Generating diagnostics file..."})):(0,R.jsx)(g.EuiLink,{color:"subdued",disabled:!0},(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",direction:"row",alignItems:"center"},null!=t&&t.error?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.errorGeneratingFileMessage",defaultMessage:"Error generating file: {reason}",values:{reason:t.error}}),type:"warning",color:"danger"})):null!=t&&t.status?(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:t.status,type:"warning",color:"danger"})):null,(0,R.jsx)(g.EuiFlexItem,null,null==t?void 0:t.name)))}},{field:"id",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.dateLabelText",{defaultMessage:"Date"}),dataType:"date",render:e=>{const t=x.find((t=>t.id===e));return(0,R.jsx)(g.EuiText,{size:"s",color:"READY"===(null==t?void 0:t.status)?"default":"subdued"},(0,g.formatDate)(null==t?void 0:t.createTime,"lll"))}},...t.fleet.allAgents?[{name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.actionsLabelText",{defaultMessage:"Actions"}),width:"70px",actions:[{type:"icon",icon:"trash",color:"danger",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.deleteButtonText",{defaultMessage:"Delete"}),available:e=>"READY"===e.status,description:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.deleteButtonDesc",{defaultMessage:"Delete diagnostics file"}),onClick:e=>{var t;t=e.id,(0,u.A$L)(t).then((({data:e,error:t})=>{t||!1===(null==e?void 0:e.deleted)?a.toasts.addError(t||new Error("Request returned `deleted: false`"),{title:f.i18n.translate("xpack.fleet.requestDiagnostics.errorDeletingUploadNotificationTitle",{defaultMessage:"Error deleting diagnostics file"})}):a.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.requestDiagnostics.successDeletingUploadNotificationTitle",{defaultMessage:"Diagnostics file deleted"})}),S()}))}}]}]:[]],M=(0,R.jsx)(g.EuiButton,{fill:!0,size:"s",onClick:()=>{b(!0)},disabled:!(0,T.fx)(e)||!t.fleet.readAgents},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}));return(0,R.jsx)(n().Fragment,null,j&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Fe,{agents:[e],agentCount:1,onClose:()=>{b(!1),S()}})),(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.calloutText",defaultMessage:"Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy."}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center",justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,T.fx)(e)?M:(0,R.jsx)(g.EuiToolTip,{content:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.notSupportedTooltip",defaultMessage:"Requesting agent diagnostics is not supported for agents before version {version}.",values:{version:T.dS}})},M)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.showExpiredFilesLabel",defaultMessage:"Show expired file requests"}),checked:r,onChange:e=>d(e.target.checked)}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),i?(0,R.jsx)(g.EuiSkeletonText,{lines:3}):(0,R.jsx)(g.EuiBasicTable,{items:c,columns:F}))},Ya=(0,s.memo)((({agent:e,agentPolicyLogLevel:t=te.OHG})=>{var a,l,i,o,r,d,c;const p=(0,u.iO7)(),{notifications:x,docLinks:h}=(0,u.WeA)(),[E,y]=(0,s.useState)(!1),[k,v]=(0,s.useState)(!1),j=ka()(null===(a=e.local_metadata)||void 0===a||null===(l=a.elastic)||void 0===l||null===(i=l.agent)||void 0===i?void 0:i.version,"8.15.0",!0),[b,S]=(0,s.useState)(null!==(o=null===(r=e.local_metadata)||void 0===r||null===(d=r.elastic)||void 0===d||null===(c=d.agent)||void 0===c?void 0:c.log_level)&&void 0!==o?o:te.OHG),[F,M]=(0,s.useState)(b),I=(0,s.useCallback)((()=>{v(!0),async function(){try{const a=await(0,u.wtt)(e.id,{action:{type:"SETTINGS",data:{log_level:null}}});if(a.error)throw a.error;S(t),M(t),x.toasts.addSuccess(f.i18n.translate("xpack.fleet.agentLogs.resetLogLevel.successText",{defaultMessage:"Reset agent logging level to policy"}))}catch(e){x.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentLogs.resetLogLevel.errorTitleText",{defaultMessage:"Error resetting agent logging level"})})}v(!1)}()}),[e.id,t,x]),T=(0,s.useCallback)((()=>{y(!0),async function(){try{const t=await(0,u.wtt)(e.id,{action:{type:"SETTINGS",data:{log_level:F}}});if(t.error)throw t.error;S(F),x.toasts.addSuccess(f.i18n.translate("xpack.fleet.agentLogs.selectLogLevel.successText",{defaultMessage:"Changed agent logging level to ''{logLevel}''",values:{logLevel:F}}))}catch(e){x.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentLogs.selectLogLevel.errorTitleText",{defaultMessage:"Error updating agent logging level"})})}y(!1)}()}),[x,F,e.id]);return(0,s.useEffect)((()=>{F!==b&&T()}),[F,b,T]),(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.selectLogLevelLabelText",defaultMessage:"Agent logging level"}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.selectLogLevelLabelText",defaultMessage:"Sets the log level for the agent. The default log level is {infoText}. {guideLink}",values:{infoText:(0,R.jsx)(g.EuiCode,null,"info"),guideLink:(0,R.jsx)(g.EuiLink,{target:"_blank",external:!0,href:h.links.fleet.agentLevelLogging},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.levelGuideLinkText",defaultMessage:"Learn More"}))}}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiSelect,{disabled:E||!p.fleet.allAgents,compressed:!0,fullWidth:!0,id:"selectAgentLogLevel","data-test-subj":"selectAgentLogLevel",value:F,onChange:e=>{M(e.target.value)},options:te.F$W.map((e=>({value:e,text:e})))})),j&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{flush:"both",size:"xs",disabled:!p.fleet.allAgents,isLoading:E||k,iconType:"cross",onClick:I,"data-test-subj":"resetLogLevelBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentLogs.resetLogLevelLabelText",defaultMessage:"Reset to policy"})))))})),Qa=({agent:e,agentPolicy:t})=>{var a;return(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(Ya,{agent:e,agentPolicyLogLevel:null==t||null===(a=t.advanced_settings)||void 0===a?void 0:a.agent_logging_level})))},Xa=()=>{var e,t,a;const{params:{agentId:l,tabId:i=""}}=(0,o.useRouteMatch)(),{getHref:r}=(0,u.iEg)(),{showAgentless:d}=(0,u.jXQ)(),{isLoading:c,isInitialRequest:p,error:x,data:h,resendRequest:E}=(0,u.rXq)(l,{pollIntervalMs:5e3,query:{withMetrics:!0}}),{isLoading:y,data:k,sendRequest:v}=(0,u.ZJQ)(null==h||null===(e=h.item)||void 0===e?void 0:e.policy_id),{application:{navigateToApp:j},notifications:b}=(0,u.WeA)(),S=(0,u.g7J)(),M="true"===new URLSearchParams((0,o.useLocation)().search).get("openReassignFlyout"),T=(0,s.useCallback)((()=>{S&&S.onDoneNavigateTo&&j(S.onDoneNavigateTo[0],S.onDoneNavigateTo[1])}),[S,j]),w=null==k?void 0:k.item.supports_agentless,C=null==h||!h.item||w&&!d?null:h.item,A=C&&(null===(t=C.local_metadata)||void 0===t?void 0:t.host),P=(0,s.useMemo)((()=>(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"s",alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiButtonEmpty,{iconType:"arrowLeft",href:r("agent_list"),flush:"left",size:"xs"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.viewAgentListTitle",defaultMessage:"View all agents"}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{className:"eui-textBreakWord"},(0,R.jsx)("h1",null,c&&p?(0,R.jsx)(F.Rh,null):"object"==typeof A&&"string"==typeof(null==A?void 0:A.hostname)?A.hostname:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsTitle",defaultMessage:"Agent ''{id}''",values:{id:l}})))))),[A,l,r,p,c]),[_,L]=(0,s.useState)(),[D,O]=(0,s.useState)(!1),[B,z]=(0,s.useState)();(0,s.useEffect)((()=>{null!=C&&C.active&&(async()=>{try{var e,t;const a=await(0,u.n_W)({showInactive:"inactive"===(null==C?void 0:C.status)});if(a.error)throw a.error;const s=null!==(e=null==a||null===(t=a.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[];z(s)}catch(e){b.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentList.errorFetchingTagsTitle",{defaultMessage:"Error fetching tags"})})}})()}),[z,b,C]);const N=(0,s.useMemo)((()=>C?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"flexEnd",alignItems:"center",gutterSize:"s",direction:"row"},!y&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(Ra,{agent:C,agentPolicy:null==k?void 0:k.item,assignFlyoutOpenByDefault:M,onCancelReassign:S&&S.onDoneNavigateTo?T:void 0,onAddRemoveTagsClick:e=>{L(e),O(!D)}})))):void 0),[k,h,r,y]),U=(0,s.useMemo)((()=>[{id:"details",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.detailsTab",{defaultMessage:"Agent details"}),href:r("agent_details",{agentId:l,tabId:"details"}),isSelected:!i||"details"===i},{id:"logs",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.logsTab",{defaultMessage:"Logs"}),href:r("agent_details_logs",{agentId:l,tabId:"logs"}),isSelected:"logs"===i},{id:"diagnostics",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.diagnosticsTab",{defaultMessage:"Diagnostics"}),href:r("agent_details_diagnostics",{agentId:l,tabId:"diagnostics"}),isSelected:"diagnostics"===i},{id:"settings",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.settingsTab",{defaultMessage:"Settings"}),href:r("agent_details_settings",{agentId:l,tabId:"settings"}),isSelected:"settings"===i}]),[r,l,i]);return(0,R.jsx)(ha.U.Provider,{value:{refresh:()=>{E(),v()}}},(0,R.jsx)(I.QA,{leftColumn:P,rightColumn:N,tabs:U},c&&p?(0,R.jsx)(F.Rh,null):x?(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.unexceptedErrorTitle",defaultMessage:"Error loading agent"}),error:x}):C?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(Ja,{agent:C,agentPolicy:null==k?void 0:k.item}),D&&(0,R.jsx)(jt,{agentId:null==C?void 0:C.id,allTags:null!=B?B:[],selectedTags:null!==(a=null==C?void 0:C.tags)&&void 0!==a?a:[],button:_,onTagsUpdated:e=>{E(),e.length>0&&z([...new Set([...null!=B?B:[],...e])].sort())},onClosePopover:()=>{O(!1)}})):(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentDetails.agentNotFoundErrorTitle",defaultMessage:"Agent not found"}),error:f.i18n.translate("xpack.fleet.agentDetails.agentNotFoundErrorDescription",{defaultMessage:"Cannot find agent ID {agentId}",values:{agentId:l}})})))},Ja=({agent:e,agentPolicy:t})=>((0,u.ifo)("agent_details",{agentHost:"object"==typeof e.local_metadata.host&&"string"==typeof e.local_metadata.host.hostname?e.local_metadata.host.hostname:"-"}),(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.agent_details_logs,render:()=>(0,R.jsx)(Da,{agent:e,agentPolicy:t})}),(0,R.jsx)(r.Route,{path:M.X5.agent_details_diagnostics,render:()=>(0,R.jsx)($a,{agent:e})}),(0,R.jsx)(r.Route,{path:M.X5.agent_details_settings,render:()=>(0,R.jsx)(Qa,{agent:e,agentPolicy:t})}),(0,R.jsx)(r.Route,{path:M.X5.agent_details,render:()=>(0,R.jsx)(Va,{agent:e,agentPolicy:t})}))),Za=(0,o.withRouter)((({actionSection:e,title:t,children:a})=>(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceAround"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiPageSection,{color:"transparent"},(0,R.jsx)(g.EuiEmptyPrompt,{color:"plain",iconType:"logoBeats",title:(0,R.jsx)("h2",null,t),body:a,actions:e})))))),es=(0,m.injectI18n)((({intl:e})=>(0,R.jsx)(Za,{title:e.formatMessage({id:"xpack.fleet.noAccess.accessDeniedTitle",defaultMessage:"Access denied"}),actionSection:[]},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.noAccess.accessDeniedDescription",defaultMessage:"You are not authorized to access Elastic Fleet. To use Elastic Fleet, you need a user role that contains All permissions for this application."}))))),ts=()=>{var e;(0,u.ifo)("agent_list");const{agents:t}=(0,u.UKg)(),a=(0,u.iO7)(),s=(0,u.YI3)(),l=(0,u.Wdf)();if(!t.enabled)return null;if(!s.missingRequirements&&s.isLoading)return(0,R.jsx)(F.Rh,null);if(s.error)return(0,R.jsx)(I.gv,null,(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.agentsInitializationErrorMessageTitle",defaultMessage:"Unable to initialize central management for Elastic Agents"}),error:s.error}));const i=1===(null==s||null===(e=s.missingRequirements)||void 0===e?void 0:e.length)&&"fleet_server"===s.missingRequirements[0],o=a.fleet.allAgents&&(s.forceDisplayInstructions||i);if(!i&&s.missingRequirements&&s.missingRequirements.length>0)return(0,R.jsx)(xa.O,{missingRequirements:s.missingRequirements});if(!a.fleet.readAgents)return(0,R.jsx)(es,null);const d=o?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"flexEnd"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,iconType:"plusInCircle",onClick:()=>l.openEnrollmentFlyout(),"data-test-subj":"addAgentBtnTop"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addAgentButton",defaultMessage:"Add Agent"}))))):void 0;return(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.agent_details},(0,R.jsx)(Xa,null)),(0,R.jsx)(r.Route,{path:M.X5.agents},(0,R.jsx)(I.iW,{section:"agents",rightColumn:d},o?(0,R.jsx)(xa.Q,{showEnrollmentRecommendation:!1}):(0,R.jsx)(fa,null))))};var as=a(46048);const ss=e=>{const{discover:t}=(0,ot.WeA)(),[a,n]=(0,s.useState)(null);return(0,s.useEffect)((()=>{(async()=>{if(t&&t.locator){const a=await t.locator.getUrl({indexPatternId:"logs-*",timeRange:{from:"now-1h",to:"now",mode:"relative"},filters:[{meta:{alias:"Recently enrolled agents",index:"logs-*"},query:{terms:{"agent.id":e}}}]});n(a)}})()}),[t,e]),a};var ns=a(89700);const ls=P()("h1").withConfig({displayName:"CentralTitle",componentId:"sc-ve6hfp-0"})(["text-align:center;"]),is=({children:e})=>n().createElement(n().Fragment,null,n().createElement(g.EuiSpacer,{size:"s"}),n().createElement(g.EuiTitle,{size:"l"},n().createElement(ls,null,e)),n().createElement(g.EuiSpacer,{size:"xl"})),os=P()(g.EuiText).withConfig({displayName:"SubtitleText",componentId:"sc-ve6hfp-1"})(["max-width:250px;margin:0 auto;text-align:center;"]),rs=P()(g.EuiStepNumber).withConfig({displayName:"CenteredEuiStepNumber",componentId:"sc-ve6hfp-2"})(["margin:0 auto;"]),us=e=>n().createElement(fs,null,n().createElement(g.EuiImage,(0,d.default)({role:"presentation"},e))),ds=({children:e})=>{const t=(0,g.useIsWithinMaxBreakpoint)("s");return n().createElement(g.EuiFlexGroup,{direction:"column",gutterSize:t?"xs":"l",alignItems:"center",justifyContent:"center",wrap:!0},e)},cs=()=>{const{http:e}=(0,u.WeA)(),t=e.basePath.prepend("/plugins/fleet/assets/");return n().createElement(g.EuiFlexGroup,{alignItems:"center",justifyContent:"spaceEvenly",gutterSize:"none"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(ds,null,n().createElement(g.EuiFlexItem,null,n().createElement(rs,{status:"incomplete",number:1})),n().createElement(g.EuiFlexItem,null,n().createElement(xs,null,n().createElement(us,{alt:"",src:t+"1_install_agent.svg"}))),n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiText,{textAlign:"center",size:"xs"},n().createElement("h2",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentStepTitle",defaultMessage:"Install Elastic Agent"}))),n().createElement(os,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentStep",defaultMessage:"Install agents on the hosts that you want to connect to Elastic."}))))),n().createElement(g.EuiShowFor,{sizes:["s","xs"]},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiSpacer,{size:"xl"}))),n().createElement(g.EuiHideFor,{sizes:["s","xs"]},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(us,{alt:"",src:t+"arrow_right_curve_over.svg"}))),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(ds,null,n().createElement(g.EuiFlexItem,null,n().createElement(rs,{status:"incomplete",number:2})),n().createElement(g.EuiFlexItem,null,n().createElement(us,{alt:"",src:t+"2_add_integration.svg"})),n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiText,{textAlign:"center",size:"xs"},n().createElement("h2",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationStepTitle",defaultMessage:"Add the integration"}))),n().createElement(os,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationStep",defaultMessage:"Make a few selections to finalize how Elastic receives your data."}))))),n().createElement(g.EuiShowFor,{sizes:["s","xs"]},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiSpacer,{size:"xl"}))),n().createElement(g.EuiHideFor,{sizes:["s","xs"]},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(us,{alt:"",src:t+"arrow_right_curve_under.svg"}))),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(ds,null,n().createElement(g.EuiFlexItem,null,n().createElement(rs,{status:"incomplete",number:3})),n().createElement(g.EuiFlexItem,null,n().createElement(us,{alt:"",src:t+"3_confirm_data.svg"})),n().createElement(g.EuiFlexItem,null,n().createElement(g.EuiText,{textAlign:"center",size:"xs"},n().createElement("h2",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.confirmDataStepTitle",defaultMessage:"Confirm incoming data"}))),n().createElement(os,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.confirmDataStep",defaultMessage:"Explore and analyze the incoming data."}))))))},gs=P()("div").withConfig({displayName:"NotObscuredByBottomBar",componentId:"sc-ve6hfp-3"})(["padding-bottom:100px;"]),ps=()=>{const{docLinks:e}=(0,u.WeA)();return n().createElement(g.EuiFlexGroup,{justifyContent:"spaceAround"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiLink,{href:e.links.fleet.elasticAgent,target:"_blank"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.learnMoreLink",defaultMessage:"Learn more about installing Elastic Agent"}))))},ms=({integrationInfo:e,packageInfo:t,isLoading:a,error:s,cancelUrl:l,cancelClickHandler:i,onNext:o})=>{if(s)return n().createElement(F.$D,{title:n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:s});const r=n().createElement(is,null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.pageTitle",defaultMessage:"Ready to add your first integration?"}));return n().createElement(I.QA,{topContent:r},n().createElement(n().Fragment,null,n().createElement(g.EuiSpacer,{size:"xxl"}),n().createElement(g.EuiSpacer,{size:"xxl"}),n().createElement(cs,null),n().createElement(g.EuiSpacer,{size:"xxl"}),n().createElement(g.EuiSpacer,{size:"xxl"}),n().createElement(gs,null,n().createElement(ps,null)),n().createElement(ys,{cancelUrl:l,cancelMessage:n().createElement("span",{"data-test-subj":"skipAgentInstallation"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.skipAddAgentButton",defaultMessage:"Add integration only (skip agent installation)"})),cancelClickHandler:i,isLoading:a,onNext:o,noAnimation:!0,actionMessage:n().createElement(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentButton",defaultMessage:"Install Elastic Agent"})}),t&&n().createElement(ns.I3,{pkgTitle:(null==e?void 0:e.title)||t.title,pkgkey:(0,z.Ku)(t),integration:null==e?void 0:e.name})))};var fs=P()("div").withConfig({displayName:"_StyledDiv",componentId:"sc-ve6hfp-4"})({margin:"0 auto"}),xs=P()("div").withConfig({displayName:"_StyledDiv2",componentId:"sc-ve6hfp-5"})({margin:"0 auto"});const hs=P()(g.EuiBottomBar).withConfig({displayName:"NoAnimationBottomBar",componentId:"sc-113t0u1-0"})(["animation-delay:-99s;#stop bottom bar flying in on step change"]),Es=P()("div").withConfig({displayName:"NotObscuredByBottomBar",componentId:"sc-113t0u1-1"})(["padding-bottom:100px;"]),ys=({isLoading:e,loadingMessage:t,onNext:a,cancelClickHandler:s,cancelUrl:l,actionMessage:i,cancelMessage:o,isDisabled:r=!1,noAnimation:u=!1})=>{const d=u?hs:g.EuiBottomBar;return n().createElement(d,null,n().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:l,onClick:s},o||n().createElement(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.backButton",defaultMessage:"Go back"})))),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButton,{color:"primary",fill:!0,size:"m",isDisabled:r,isLoading:!r&&e,onClick:a},e?t||n().createElement(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.loading",defaultMessage:"Loading..."}):i))))},ks=({onNext:e,cancelClickHandler:t,cancelUrl:a,noAnimation:s=!1})=>{const l=s?hs:g.EuiBottomBar;return n().createElement(l,null,n().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:a,onClick:t},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentStandaloneBottomBar.backButton",defaultMessage:"Go back"})))),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButton,{color:"primary",fill:!0,size:"m",onClick:e},n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentStandaloneBottomBar.viewIncomingDataBtn",defaultMessage:"View incoming data"})))))},vs=({pkgkey:e})=>{const t=e.includes(be.FLEET_KUBERNETES_PACKAGE),{getHref:a}=(0,ot.iEg)(),{getAbsolutePath:s}=(0,ot.iEg)();return n().createElement(g.EuiBottomBar,null,n().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:a("integrations_all")},n().createElement(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.addAnotherIntegration",defaultMessage:"Add another integration"})))),!t&&n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButton,{color:"success",fill:!0,size:"m",href:a("integration_details_assets",{pkgkey:e})},n().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.viewDataAssetsButtonText'",defaultMessage:"View assets"}))),t&&n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButton,{color:"success",fill:!0,size:"m",href:s("/app/dashboards#/view/kubernetes-f4dc26db-1b53-4ea2-a78b-1bfab8ea267c")},n().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData. '",defaultMessage:"View Kubernetes metrics dashboards"})))))},js=({troubleshootLink:e,agentIds:t,integration:a})=>{const s=ss(t);return n().createElement(g.EuiBottomBar,null,n().createElement(g.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonEmpty,{color:"text",size:"s",href:e,iconType:"popout",target:"_blank"},n().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.troubleshootLinkBottomBar",defaultMessage:"Troubleshooting guide"}))),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButton,{color:"success",fill:!0,href:null!=s?s:""},n().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.discoverLogsLink",defaultMessage:"View incoming {integration} logs",values:{integration:null!=a?a:""}})))))},bs=e=>{const{packageInfo:t,integrationInfo:a,steps:s,currentStep:l,error:i}=e;if(i)return(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:i});const o=s[l].component,r=(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"l",className:"eui-textCenter"},(0,R.jsx)("h1",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.multiPageTitle",defaultMessage:"Set up {title} integration",values:{title:t.title}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Fs,{currentStep:l,steps:s.map((e=>e.title))}),(0,R.jsx)(g.EuiSpacer,{size:"xl"}));return(0,R.jsx)(I.QA,{topContent:r,restrictHeaderWidth:866,restrictWidth:866},(0,R.jsx)(o,e),t&&(0,R.jsx)(ns.I3,{pkgTitle:(null==a?void 0:a.title)||t.title,pkgkey:(0,z.Ku)(t),integration:null==a?void 0:a.name}))},Ss=(e,t,a)=>e===t?a?"complete":"current":e>t?"complete":"incomplete",Fs=({steps:e,currentStep:t=0,currentStepComplete:a=!1})=>{const s=e.map(((e,s)=>({title:e,status:Ss(t,s,a),onClick:()=>{}})));return(0,R.jsx)(g.EuiStepsHorizontal,{size:"xs",steps:s})};var Ms=a(8683),Is=a(29466),Ts=a(4888);var ws=P()(g.EuiCodeBlock).withConfig({displayName:"_StyledEuiCodeBlock",componentId:"sc-oz6m9j-1"})(["max-width:1100px;"]),Cs=a(62652);const As=e=>{var t,a;const{cancelUrl:l,onNext:i,cancelClickHandler:o,setIsManaged:r,agentPolicy:u,enrollmentAPIKey:d,fleetServerHost:c,fleetProxy:p,enrolledAgentIds:x}=e,h=(0,ot.WeA)(),{docLinks:E}=h,y=E.links.fleet.troubleshooting,k=(0,ot.JhS)(),[v,j]=(0,s.useState)(!1),[b,S]=(0,s.useState)(!1);if(!d)return(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:"Enrollment API key not found"});const M="kubernetes"===e.packageInfo.name?"IS_KUBERNETES_MULTIPAGE":"IS_NOT_KUBERNETES",I=(0,T.dF)(null!==(t=null==u?void 0:u.package_policies)&&void 0!==t?t:[]),w=(0,Ts.w)({apiKey:d.api_key,fleetProxy:p,fleetServerHost:c,agentVersion:k||"",showInstallServers:I}),C=[(0,Is.YD)({installCommand:w,apiKeyData:{item:d},enrollToken:d.api_key,isK8s:M,selectedApiKeyId:d.id,isComplete:v||!!x.length,fullCopyButton:!0,fleetServerHost:c,onCopy:()=>j(!0),rootIntegrations:(0,T.uo)(null!==(a=null==u?void 0:u.package_policies)&&void 0!==a?a:[]),nonFipsIntegrations:(0,Cs.I)(u)})];return"IS_KUBERNETES_MULTIPAGE"===M&&C.push((({isComplete:e,fullCopyButton:t,onCopy:a})=>{const[l,i]=(0,s.useState)(!1),o=P().pre.withConfig({displayName:"CommandCode",componentId:"sc-oz6m9j-0"})({overflow:"auto"});return{status:e?"complete":void 0,title:f.i18n.translate("xpack.fleet.agentEnrollment.stepKubernetesApplyManifest",{defaultMessage:"Run the apply command"}),children:n().createElement(n().Fragment,null,n().createElement(g.EuiText,null,n().createElement(g.EuiSpacer,{size:"s"}),n().createElement(m.FormattedMessage,{id:"xpack.fleet.agentEnrollment.kubernetesCommandInstructions",defaultMessage:"From the directory where the manifest is downloaded, run the apply command."}),n().createElement(g.EuiSpacer,{size:"m"})),n().createElement(ws,{onClick:()=>{a&&a()},fontSize:"m",isCopyable:!t,paddingSize:"m"},n().createElement(o,null,"kubectl apply -f elastic-agent-managed-kubernetes.yml")),n().createElement(g.EuiSpacer,{size:"s"}),t&&n().createElement(g.EuiCopy,{textToCopy:"kubectl apply -f elastic-agent-managed-kubernetes.yml"},(e=>n().createElement(g.EuiButton,{color:"primary",iconType:"copyClipboard",size:"m",onClick:()=>(e=>{e(),i(!0),a&&a()})(e)},l?n().createElement(m.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.copyButtonClicked",defaultMessage:"Copied"}):n().createElement(m.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.copyButton",defaultMessage:"Copy to clipboard"})))))}})({isComplete:b||!!x.length,fullCopyButton:!0,onCopy:()=>S(!0)})),C.push((0,Is.nV)({selectedPolicyId:null==u?void 0:u.id,troubleshootLink:y,agentCount:x.length,showLoading:!0,poll:v})),k?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegration.installAgentStepTitle",defaultMessage:"These steps configure and enroll the Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent. As an alternative to Fleet, advanced users can run agents in {standaloneLink}.",values:{standaloneLink:(0,R.jsx)(g.EuiLink,{onClick:()=>r(!1)},"standalone mode")}})),(0,R.jsx)(g.EuiSpacer,{size:"xl"}),(0,R.jsx)(g.EuiSteps,{steps:C}),!!x.length&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(Es,null),(0,R.jsx)(ys,{cancelUrl:l,cancelClickHandler:o,onNext:i,actionMessage:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationButton",defaultMessage:"Add the integration"})}))):(0,R.jsx)(g.EuiLoadingSpinner,null)};var Ps=a(96104);const _s=e=>{var t;const{setIsManaged:a,agentPolicy:l,cancelUrl:i,onNext:o,cancelClickHandler:r}=e,u=(0,ot.Q14)(),[d,c]=(0,s.useState)(!1),[p,f]=(0,s.useState)(!1),{yaml:x,onCreateApiKey:h,isCreatingApiKey:E,apiKey:y,downloadYaml:k}=(0,Ps.Pe)(l);if(!l)return(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:"Agent policy not provided"});const v=(0,Ts.p)({agentVersion:u}),j=[(0,Is.N9)({selectedPolicyId:null==l?void 0:l.id,yaml:x,downloadYaml:k,apiKey:y,onCreateApiKey:h,isCreatingApiKey:E,isComplete:p,onCopy:()=>f(!0)}),(0,Is.iR)({installCommand:v,isComplete:x&&d,fullCopyButton:!0,onCopy:()=>c(!0),rootIntegrations:(0,T.uo)(null!==(t=null==l?void 0:l.package_policies)&&void 0!==t?t:[]),nonFipsIntegrations:(0,Cs.I)(l)})];return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(Us,{setIsManaged:a}),(0,R.jsx)(g.EuiSpacer,{size:"xl"}),(0,R.jsx)(g.EuiSteps,{steps:j}),d&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(Es,null),(0,R.jsx)(ks,{cancelUrl:i,onNext:o,cancelClickHandler:r})))};var Ls=a(92604),Ds=a(74892),Os=a(33342),Rs=a(49688),Bs=a(43721);const zs=({children:e})=>{const[t,a]=(0,s.useState)(!1);return(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween",direction:"column"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween",direction:"row"},(0,R.jsx)(g.EuiFlexItem,null),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{size:"s",iconType:t?"arrowUp":"arrowDown",iconSide:"right",onClick:()=>a(!t),flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.stepConfigure.advancedOptionsToggleLinkText",defaultMessage:"Advanced options"}))))),t&&(0,R.jsx)(g.EuiFlexItem,null,e)))},Ns=({error:e,title:t})=>(0,R.jsx)(F.$D,{title:t||(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegration.errorTitle",defaultMessage:"Error adding integration"}),error:e}),Us=({setIsManaged:e})=>(0,R.jsx)(g.EuiCallOut,{title:"Setting up to run Elastic Agent in standalone mode",color:"primary",iconType:"info"},(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegration.standaloneWarning",defaultMessage:"Setting up integrations by running Elastic Agent in standalone mode is advanced. When possible, we recommend using {link} instead. ",values:{link:(0,R.jsx)(g.EuiLink,{href:"#"},"Fleet-managed agents")}})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiButton,{onClick:()=>e(!0),color:"primary"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.addIntegration.switchToManagedButton",defaultMessage:"Enroll in Fleet instead (recommended)"})));var Hs=a(69433),Ws=a(30276);const Gs=({agentIds:e,troubleshootLink:t,packageInfo:a})=>{var s;const l=ss(e);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTitle,null,(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.title",defaultMessage:"Confirming data is taking longer than expected"}))),(0,R.jsx)(g.EuiText,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.body",defaultMessage:"If the system is not generating data, it may help to generate some to ensure data is being collected correctly. If you're having trouble, see our {troubleshootLink}, or you may check later by viewing {discoverLink}.",values:{troubleshootLink:(0,R.jsx)(g.EuiLink,{external:!0,href:t,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.troubleshootLink",defaultMessage:"troubleshooting guide"})),discoverLink:(0,R.jsx)(g.EuiLink,{external:!0,href:null!=l?l:"",target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.discoverLink",defaultMessage:"{integration} logs in Discover",values:{integration:null!==(s=null==a?void 0:a.title)&&void 0!==s?s:""}}))}})),(0,R.jsx)(Es,null),(0,R.jsx)(js,{agentIds:e,troubleshootLink:t,integration:null==a?void 0:a.title}))},Ks=["agent.ephemeral_id","agent.id","elastic_agent.id","data_stream.namespace","@timestamp"],qs=P()(g.EuiDescriptionList).withConfig({displayName:"CleanOverflowDescriptionList",componentId:"sc-6co0kl-0"})(["overflow:hidden;max-height:125px;word-break:break-all;white-space:pre-wrap;"]),Vs=P()("pre").withConfig({displayName:"CompressedPre",componentId:"sc-6co0kl-1"})(["&&&{background:none;padding:0 0;}"]),$s=({hit:e})=>{const t=(0,J.omit)((0,Hs.getFlattenedObject)(e._source),Ks),a=Object.entries(t).map((([e,t])=>({title:`${e}:`,description:JSON.stringify(t)})));return n().createElement("pre",null,n().createElement("code",null,n().createElement(qs,{listItems:a,type:"inline",align:"left",compressed:!0})))},Ys=({hit:e})=>{const t=(null==e?void 0:e._source)||{},a=(null==t?void 0:t["@timestamp"])||"-";return n().createElement(g.EuiText,{size:"xs"},n().createElement(Vs,null,a?(0,g.formatDate)(a,"MMM D, YYYY @ HH:mm:ss.SSS"):"-"))},Qs=({dataPreview:e})=>{const t=e.slice(0,5);return n().createElement(n().Fragment,null,t.map((e=>n().createElement("div",{id:e._id},n().createElement(g.EuiFlexGroup,{gutterSize:"xs"},n().createElement(Js,null,n().createElement(Ys,{hit:e})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement($s,{hit:e}))),n().createElement(g.EuiHorizontalRule,{margin:"s"})))))},Xs=({agentIds:e,packageInfo:t,agentDataConfirmed:a,setAgentDataConfirmed:s,troubleshootLink:l})=>{const{incomingData:i,dataPreview:o,hasReachedTimeout:r}=(0,Ws.Tm)({agentIds:e,previewData:!0,stopPollingAfterPreviewLength:5}),{numAgentsWithData:u}=(0,Ws.VK)(i,t);return a?n().createElement(n().Fragment,null,n().createElement(g.EuiCallOut,{"data-test-subj":"IncomingDataConfirmedCallOut",title:f.i18n.translate("xpack.fleet.confirmIncomingDataWithPreview.title",{defaultMessage:"Incoming data received from {numAgentsWithData} enrolled { numAgentsWithData, plural, one {agent} other {agents}}.",values:{numAgentsWithData:u}}),color:"success",iconType:"check"}),n().createElement(g.EuiSpacer,{size:"m"}),n().createElement(g.EuiText,null,n().createElement("h3",null,n().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.previewTitle",defaultMessage:"Preview of incoming data:"}))),n().createElement(g.EuiSpacer,{size:"m"}),n().createElement(Qs,{dataPreview:o})):n().createElement(n().Fragment,null,n().createElement(g.EuiText,null,n().createElement(g.EuiCallOut,{size:"m",color:"primary",iconType:g.EuiLoadingSpinner,title:n().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.listening",defaultMessage:"Listening for incoming data from enrolled agents..."})}),n().createElement(g.EuiSpacer,{size:"m"}),r?n().createElement(Gs,{agentIds:e,troubleshootLink:l,packageInfo:t}):n().createElement(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.loading",defaultMessage:"It might take a few minutes for the data to get to Elasticsearch. If you're not seeing any, try generating some to verify. If you're having trouble connecting, check out the {link}.",values:{link:n().createElement(g.EuiLink,{target:"_blank",external:!0,href:l},n().createElement(m.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.troubleshootingLink",defaultMessage:"troubleshooting guide"}))}})),n().createElement(g.EuiSpacer,{size:"m"}),n().createElement(g.EuiSkeletonText,{lines:10}))};var Js=P()(g.EuiFlexItem).withConfig({displayName:"_StyledEuiFlexItem",componentId:"sc-6co0kl-2"})({minWidth:"220px"});const Zs=({troubleshootLink:e})=>(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,null,(0,R.jsx)(g.EuiCallOut,{size:"m",color:"primary",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.title",defaultMessage:"Data preview is not available for standalone agents. "})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.description",defaultMessage:"You can check for agent data in the integration asset tab. If you're having trouble seeing data, check out the {link}.",values:{link:(0,R.jsx)(g.EuiLink,{target:"_blank",external:!0,href:e},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.troubleshootingLink",defaultMessage:"troubleshooting guide"}))}})))),en={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.installAgentStepTitle",{defaultMessage:"Install Elastic Agent"}),component:e=>{var t;const[a,n]=(0,s.useState)(e.isManaged),[l,i]=(0,s.useState)(!1),{enrolledAgentIds:o}=(0,Ms.X)((null===(t=e.agentPolicy)||void 0===t?void 0:t.id)||"",{noLowerTimeLimit:!0,pollImmediately:!0}),r=()=>{e.setEnrolledAgentIds(o),e.onNext()},u={...e,onNext:r,enrolledAgentIds:o,setIsManaged:l?n:e.setIsManaged};if(a)return(0,R.jsx)(As,u);const d={...e,onNext:r,enrolledAgentIds:o,setIsManaged:e=>{e&&i(!0),n(e)}};return(0,R.jsx)(_s,d)}},tn={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.addIntegrationStepTitle",{defaultMessage:"Add the integration"}),component:e=>{var t;const{onNext:a,onBack:l,isManaged:i,setIsManaged:o,packageInfo:r,integrationInfo:d,agentPolicy:c}=e,{spaceId:p}=(0,u.YI3)(),[x,h]=(0,s.useState)(),{notifications:E}=(0,u.WeA)(),[y,k]=(0,s.useState)("VALID"),[v,b]=(0,s.useState)(),S=(0,j.wsd)(),[M,I]=(0,s.useState)({name:"",description:"",namespace:"",policy_id:"",policy_ids:[""],enabled:!0,inputs:[]}),w=(0,s.useCallback)((e=>{const t=(0,Os.bS)({...M,...e},r,Ls.Hh);return b(t),Bs.debug("Package policy validation results",t),t}),[r,M]),C=(0,s.useCallback)((e=>{const t={...M,...e};I(t),Bs.debug("Package policy updated",t);const a=w(t),s=t.package,n=!!a&&(0,Os.nt)(a);k(s&&!n?"VALID":"INVALID")}),[M,w]),A=(0,s.useCallback)((async({newPackagePolicy:e,force:t})=>{var a;k("LOADING");const{policy:s,forceCreateNeeded:n}=await(0,Rs.E)(e),l=await(0,u.H_o)({...s,force:n||t});return k("SUBMITTED"),!l.error&&null!==(a=l.data)&&void 0!==a&&a.item.package&&await(0,ee.i)({currentSpaceId:null!=p?p:Z.DEFAULT_SPACE_ID,pkgName:l.data.item.package.name,pkgVersion:l.data.item.package.version,toasts:E.toasts}),l}),[E.toasts,p]),P=(0,s.useCallback)((async({force:e=!1}={})=>{const t=!!v&&(0,Os.nt)(v);if("VALID"===y&&t)return void k("INVALID");k("LOADING");const{error:s}=await A({newPackagePolicy:M,force:e});if(s){if((0,Ds.G0)(s))return void(await S(r)?P({force:!0}):k("VALID"));E.toasts.addError(s,{title:"Error"}),k("VALID")}else a()}),[v,A,y,M,E.toasts,S,r,a]);(0,s.useEffect)((()=>{(async()=>{if(!c)return;const{packagePolicy:e,error:t}=await(async(e,t,a)=>{const{data:s,error:n}=await(0,u.TR6)({perPage:te.WaW,page:1,kuery:`${as.f$}.package.name:${t.name}`}),l={name:(0,T.sW)(t.name,null==s?void 0:s.items),description:"",namespace:"",policy_id:e,policy_ids:[e],enabled:!0,inputs:[]};return{packagePolicy:(0,z.eE)(t,e,l.namespace,l.name,l.description,a),error:n}})(c.id,r,null==d?void 0:d.name);t&&h(t),C(e)})()}),[]);const _=(0,u.fWy)(null!==(t=r.name)&&void 0!==t?t:"","package-policy-create-multi-step"),L=(0,s.useMemo)((()=>_&&(0,R.jsx)(F.BA,null,(0,R.jsx)(_.Component,null))),[_]),D=(0,s.useMemo)((()=>{if("endpoint"!==r.name)return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"l"}),(0,R.jsx)(ns.lS,{packageInfo:r,showOnlyIntegration:null==d?void 0:d.name,packagePolicy:M,updatePackagePolicy:C,validationResults:v,submitAttempted:"INVALID"===y,noTopRule:!0}),v&&(0,R.jsx)(zs,null,(0,R.jsx)(ns.os,{packageInfo:r,packagePolicy:M,updatePackagePolicy:C,validationResults:v,submitAttempted:"INVALID"===y,noAdvancedToggle:!0})))}),[y,null==d?void 0:d.name,r,M,C,v]);return c?x?(0,R.jsx)(Ns,{error:x}):(0,R.jsx)(n().Fragment,null,i?null:(0,R.jsx)(Us,{setIsManaged:o}),D,L,(0,R.jsx)(Es,null),(0,R.jsx)(ys,{cancelClickHandler:i?l:()=>o(!0),onNext:P,isLoading:"LOADING"===y,isDisabled:"INVALID"===y,loadingMessage:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.savingPackagePolicy",defaultMessage:"Saving policy..."}),actionMessage:i?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.confirmIncomingDataButton",defaultMessage:"Confirm incoming data"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.installAgentButton",defaultMessage:"Save and continue"})})):(0,R.jsx)(Ns,{error:f.i18n.translate("xpack.fleet.addIntegration.noAgentPolicy",{defaultMessage:"Error creating agent policy."})})}},an={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.confirmDataStepTitle",{defaultMessage:"Confirm incoming data"}),component:e=>{const{enrolledAgentIds:t,packageInfo:a,isManaged:l}=e,i=(0,u.WeA)(),[o,r]=(0,s.useState)(!1),{docLinks:d}=i,c=d.links.fleet.troubleshooting,g=(0,R.jsx)(n().Fragment,null,(0,R.jsx)(Es,null),(0,R.jsx)(vs,{pkgkey:`${a.name}-${a.version}`}));return l?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(Xs,{agentIds:t,packageInfo:a,agentDataConfirmed:o,setAgentDataConfirmed:r,troubleshootLink:c}),!!o&&g):(0,R.jsx)(n().Fragment,null,(0,R.jsx)(Zs,{troubleshootLink:c}),g)}},sn=[en,tn,an],nn=[tn,en,an],ln=({queryParamsPolicyId:e,prerelease:t})=>{const{params:a}=(0,o.useRouteMatch)(),{pkgkey:n,policyId:l,integration:i}=a,{pkgName:r,pkgVersion:d}=(0,T.CB)(n),[c,g]=(0,s.useState)(!0),[p,m]=(0,s.useState)(0),[x,h]=(0,s.useState)(!0),{getHref:E}=(0,u.iEg)(),[y,k]=(0,s.useState)([]),v=l||e,{data:j,error:b,isLoading:S}=(0,u.E1o)(r,d,{prerelease:t,full:!0}),{agentPolicy:F,enrollmentAPIKey:M,error:I,isLoading:w}=function(e){const{spaceId:t,isSpaceAwarenessEnabled:a}=(0,ot.YI3)(),[n,l]=(0,s.useState)(!0),[i,o]=(0,s.useState)(),[r,u]=(0,s.useState)(),[d,c]=(0,s.useState)(),[g,p]=(0,s.useState)(),m="fleet-first-agent-policy",x=(0,s.useMemo)((()=>a&&"default"!==t?`${t}:${m}`:m),[a,t]),h=(0,s.useMemo)((()=>Object.freeze((0,L.b)({id:x,name:f.i18n.translate("xpack.fleet.createPackagePolicy.firstAgentPolicyNameText",{defaultMessage:"My first agent policy"})}))),[x]);return(0,s.useEffect)((()=>{(async()=>{var t;l(!0);const a=e||x,{data:s,error:n}=await(async e=>{var t;let a,s;try{a=await(0,ot.Ag1)(e),a.error&&(s=a.error)}catch(e){s=e}return s&&404!==s.statusCode?{error:s}:{data:null===(t=a)||void 0===t?void 0:t.data}})(a),i=null==s?void 0:s.item;if(e&&!i)return l(!1),void o(new Error(`Agent policy ${a} not found`));let r;if(n)return l(!1),void o(n);if(!i){const{data:e,error:t}=await ot.iF6.bind(null,h)();if(t)return l(!1),void o(t);r=e.item,p(!0)}u(i||r);const{data:d,error:g}=await(0,ot.d1z)({page:1,perPage:1,kuery:`policy_id:"${a}"`});g?(l(!1),o(g)):d&&null!==(t=d.items)&&void 0!==t&&t.length?(l(!1),c(d.items[0])):(l(!1),o(new Error(`No enrollment API key found for policy ${a}`)))})()}),[e,h,x]),{isLoading:n,error:i,agentPolicy:r,enrollmentAPIKey:d,created:g}}(v),C=(0,s.useMemo)((()=>null==j?void 0:j.item),[j]),A=(0,s.useMemo)((()=>{var e;if(i)return null==C||null===(e=C.policy_templates)||void 0===e?void 0:e.find((e=>e.name===i))}),[null==C?void 0:C.policy_templates,i]),{fleetServerHost:P,fleetProxy:_,downloadSource:D,isLoadingInitialRequest:O}=(0,u.Dc7)(F),B=E("add_integration_to_policy",{pkgkey:n,useMultiPageLayout:!1,...i?{integration:i}:{},...v?{agentPolicyId:v}:{},...t?{prerelease:"true"}:{}});if(c||!C)return(0,R.jsx)(ms,{isLoading:S||O||w,error:b||I,integrationInfo:A,packageInfo:C,cancelUrl:B,onNext:()=>{g(!1)}});const z=x?sn:nn;return(0,R.jsx)(bs,{fleetServerHost:P,fleetProxy:_,downloadSource:D,agentPolicy:F,enrollmentAPIKey:M,currentStep:p,steps:z,packageInfo:C,integrationInfo:A,cancelUrl:B,onNext:()=>{p!==z.length-1&&m(p+1)},onBack:()=>{0!==p&&m(p-1)},isManaged:x,setIsManaged:e=>{h(e),m(0)},setEnrolledAgentIds:k,enrolledAgentIds:y})},on=()=>{const{search:e}=(0,o.useLocation)(),{params:t}=(0,o.useRouteMatch)(),a=(0,s.useMemo)((()=>new URLSearchParams(e)),[e]),l=(0,s.useMemo)((()=>a.has("useMultiPageLayout")),[a]),i=(0,s.useMemo)((()=>{var e;return null!==(e=a.get("policyId"))&&void 0!==e?e:void 0}),[a]),[r,d]=n().useState(!1),{pkgName:c,pkgVersion:g}=(0,T.CB)(t.pkgkey),{data:p}=(0,u.ZwD)(),m=(0,s.useMemo)((()=>Boolean(a.get("prerelease"))),[a]);(0,s.useEffect)((()=>{const e=Boolean(null==p?void 0:p.item.prerelease_integrations_enabled)||m;null!=p&&p.item&&d(e)}),[m,null==p?void 0:p.item]);const f={from:"policyId"in t||i?"policy":"package",queryParamsPolicyId:i,prerelease:r,pkgName:c,pkgVersion:g,integration:t.integration};return l?(0,R.jsx)(ln,f):(0,R.jsx)(H.M,f)},rn=({apiKeyId:e,length:t,sendGetAPIKey:a,tokenGetter:n})=>{const{euiTheme:l}=(0,g.useEuiTheme)(),{notifications:i}=(0,ot.WeA)(),[o,r]=(0,s.useState)("HIDDEN"),[u,d]=(0,s.useState)(),c=(0,s.useMemo)((()=>"•".repeat(t)),[t]);return(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued",size:"xs",css:(0,R.css)("font-family:",l.font.familyCode,";",""),"data-test-subj":"apiKeyField"},"VISIBLE"===o?u:c)),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiToolTip,{content:"VISIBLE"===o?f.i18n.translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):f.i18n.translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"}),disableScreenReaderOutput:!0},(0,R.jsx)(g.EuiButtonIcon,{"aria-label":"VISIBLE"===o?f.i18n.translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):f.i18n.translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"}),color:"text",onClick:async()=>{if("VISIBLE"===o)r("HIDDEN");else if("HIDDEN"===o)try{r("LOADING");const t=await a(e);if(t.error)throw t.error;d(n(t)),r("VISIBLE")}catch(e){i.toasts.addError(e,{title:"Error"}),r("HIDDEN")}},iconType:"VISIBLE"===o?"eyeClosed":"eye","data-test-subj":"showHideTokenButton"}))))};var un=a(13788);const dn=e=>{const{onCancel:t,onConfirm:a,enrollmentKey:s}=e,n=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":n,title:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.title",{defaultMessage:"Revoke enrollment token"}),titleProps:{id:n},onCancel:t,onConfirm:a,cancelButtonText:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.cancelButton",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.deleteButton",{defaultMessage:"Revoke enrollment token"}),defaultFocusedButton:"confirm",buttonColor:"danger"},(0,R.jsx)(g.EuiCallOut,{title:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.description",{defaultMessage:"Are you sure you want to revoke {keyName}? New agents will no longer be able to be enrolled using this token.",values:{keyName:s.name}}),color:"danger"}))},cn=({apiKey:e,refresh:t})=>{const{notifications:a}=(0,u.WeA)(),[l,i]=(0,s.useState)("CONFIRM_HIDDEN");return(0,R.jsx)(n().Fragment,null,"CONFIRM_VISIBLE"===l&&(0,R.jsx)(dn,{enrollmentKey:e,onCancel:()=>i("CONFIRM_HIDDEN"),onConfirm:async()=>{try{const t=await(0,u.TOj)(e.id);if(t.error)throw t.error}catch(e){a.toasts.addError(e,{title:"Error"})}i("CONFIRM_HIDDEN"),t()}}),(0,R.jsx)(g.EuiToolTip,{content:f.i18n.translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"}),disableScreenReaderOutput:!0},(0,R.jsx)(g.EuiButtonIcon,{"data-test-subj":"enrollmentTokenTable.revokeBtn","aria-label":f.i18n.translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"}),onClick:()=>i("CONFIRM_VISIBLE"),iconType:"trash",color:"danger"})))},gn="not hidden:true",pn=()=>{var e,t,a;(0,u.ifo)("enrollment_tokens");const[n,l]=(0,s.useState)(!1),[i,o]=(0,s.useState)(""),{pagination:r,setPagination:d,pageSizeOptions:c}=(0,u.WQC)(),p=(0,u.CUP)({page:r.currentPage,perPage:r.pageSize,kuery:""!==i.trim()?`(${i}) and (${gn})`:gn}),x=(0,u.$sk)({page:1,perPage:M.W}),h=x.data?x.data.items:[],E=h.reduce(((e,t)=>(e[t.id]=t,e)),{}),y=null!==(e=null==p||null===(t=p.data)||void 0===t?void 0:t.total)&&void 0!==e?e:0,k=(null==p||null===(a=p.data)||void 0===a?void 0:a.items.filter((e=>{if(!h.length||!e.policy_id)return!1;const t=E[e.policy_id];return!(null!=t&&t.is_managed||null!=t&&t.supports_agentless)})))||[],v=[{field:"name",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.nameTitle",{defaultMessage:"Name"}),render:e=>(0,R.jsx)("span",{className:"eui-textTruncate",title:e},e)},{field:"id",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.secretTitle",{defaultMessage:"Secret"}),width:"215px",render:e=>(0,R.jsx)(rn,{apiKeyId:e,sendGetAPIKey:u.aGY,tokenGetter:e=>{var t;return null===(t=e.data)||void 0===t?void 0:t.item.api_key},length:60})},{field:"policy_id",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.policyTitle",{defaultMessage:"Agent policy"}),render:e=>{const t=E[e],a=t?t.name:e;return(0,R.jsx)("span",{className:"eui-textTruncate",title:a},a)}},{field:"created_at",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.createdAtTitle",{defaultMessage:"Created on"}),width:"150px",render:e=>e?(0,R.jsx)(m.FormattedDate,{year:"numeric",month:"short",day:"2-digit",value:e}):null},{field:"active",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.activeTitle",{defaultMessage:"Active"}),width:"70px",align:"center",render:e=>(0,R.jsx)(g.EuiIcon,{size:"m",color:e?"success":"danger",type:"dot"})},{field:"actions",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.actionsTitle",{defaultMessage:"Actions"}),width:"70px",render:(e,t)=>{const a=h.find((e=>e.id===t.policy_id));return t.active&&!(null!=a&&a.is_managed)&&(0,R.jsx)(cn,{apiKey:t,refresh:()=>p.refetch()})}}],j=p.isInitialLoading||x.isLoading&&x.isInitialRequest;return(0,R.jsx)(I.iW,{section:"enrollment_tokens"},n&&(0,R.jsx)(F.jY,{agentPolicies:h,onClose:e=>{l(!1),p.refetch()}}),(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.enrollmentTokensList.pageDescription",defaultMessage:"Create and revoke enrollment tokens. An enrollment token enables one or more agents to enroll in Fleet and send data."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(un.I,{value:i,indexPattern:M.Al,fieldPrefix:M.w1,onChange:e=>{d({...r,currentPage:1}),o(e)},dataTestSubj:"enrollmentKeysList.queryInput"})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{"data-test-subj":"createEnrollmentTokenButton",fill:!0,iconType:"plusInCircle",onClick:()=>l(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.enrollmentTokensList.newKeyButton",defaultMessage:"Create enrollment token"})))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiBasicTable,{"data-test-subj":"enrollmentTokenListTable",loading:j,noItemsMessage:j?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.enrollemntAPIKeyList.loadingTokensMessage",defaultMessage:"Loading enrollment tokens..."}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.enrollemntAPIKeyList.emptyMessage",defaultMessage:"No enrollment tokens found."}),items:y?k:[],itemId:"id",columns:v,pagination:{pageIndex:r.currentPage-1,pageSize:r.pageSize,totalItemCount:y,pageSizeOptions:c},onChange:({page:e})=>{const t={...r,currentPage:e.index+1,pageSize:e.size};d(t)}}))};var mn=a(50998),fn=a(1442);const xn=f.i18n.translate("xpack.fleet.uninstallTokenList.policyIdTitle",{defaultMessage:"Policy ID"}),hn=f.i18n.translate("xpack.fleet.uninstallTokenList.policyNameTitle",{defaultMessage:"Policy name"}),En=f.i18n.translate("xpack.fleet.uninstallTokenList.createdAtTitle",{defaultMessage:"Created at"}),yn=f.i18n.translate("xpack.fleet.uninstallTokenList.tokenTitle",{defaultMessage:"Token"}),kn=f.i18n.translate("xpack.fleet.uninstallTokenList.actionsTitle",{defaultMessage:"Actions"}),vn=f.i18n.translate("xpack.fleet.uninstallTokenList.viewUninstallCommandLabel",{defaultMessage:"View uninstall command"}),jn=f.i18n.translate("xpack.fleet.uninstallTokenList.searchByPolicyIdOrNamePlaceholder",{defaultMessage:"Search by policy ID or policy name"}),bn=f.i18n.translate("xpack.fleet.uninstallTokenList.searchByPolicyIdOrNameHint",{defaultMessage:"If an Agent policy is deleted, its policy name is also deleted. Use the policy ID to search for uninstall tokens related to deleted Agent policies."}),Sn=({text:e,dataTestSubj:t})=>(0,R.jsx)(g.EuiText,{size:"s",className:"eui-textTruncate",title:e,"data-test-subj":t},e),Fn=({onClick:e})=>(0,R.jsx)(g.EuiToolTip,{content:vn,disableScreenReaderOutput:!0},(0,R.jsx)(g.EuiButtonIcon,{"data-test-subj":"uninstallTokensViewCommandButton","aria-label":vn,onClick:e,iconType:"inspect",color:"text"})),Mn=({isLoading:e})=>e?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.loadingTokensMessage",defaultMessage:"Loading uninstall tokens..."}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.emptyMessage",defaultMessage:"No uninstall tokens found."}),In=()=>{var e,t;(0,u.ifo)("uninstall_tokens");const[a,n]=(0,s.useState)(""),[l,i]=(0,s.useState)(null),{pagination:o,setPagination:r,pageSizeOptions:d}=(0,u.WQC)(),{isLoading:c,data:p}=(0,fn.oH)({perPage:o.pageSize,page:o.currentPage,search:a}),f=null!==(e=null==p?void 0:p.items)&&void 0!==e?e:[],x=null!==(t=null==p?void 0:p.total)&&void 0!==t?t:0,h=(0,s.useMemo)((()=>[{field:"policy_name",name:hn,render:e=>null===e?(0,R.jsx)(mn.C,null):(0,R.jsx)(Sn,{text:e})},{field:"policy_id",name:xn,render:e=>(0,R.jsx)(Sn,{text:e,dataTestSubj:"uninstallTokensPolicyIdField"})},{field:"created_at",name:En,width:"130px",render:e=>e?(0,R.jsx)(m.FormattedDate,{year:"numeric",month:"short",day:"2-digit",value:e}):null},{field:"id",name:yn,width:"300px",render:e=>(0,R.jsx)(rn,{apiKeyId:e,sendGetAPIKey:fn.Wz,tokenGetter:e=>{var t;return null===(t=e.data)||void 0===t?void 0:t.item.token},length:32})},{field:"actions",name:kn,align:"center",width:"70px",render:(e,{id:t})=>(0,R.jsx)(Fn,{onClick:()=>i(t)})}]),[]),E=(0,s.useCallback)((({page:e})=>{r((t=>({...t,currentPage:e.index+1,pageSize:e.size})))}),[r]),y=(0,s.useCallback)((e=>{n(e),r((e=>({...e,currentPage:1})))}),[r]);return(0,R.jsx)(I.iW,{section:"uninstall_tokens"},l&&(0,R.jsx)(F.pc,{onClose:()=>i(null),target:"agent",uninstallTokenId:l}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.pageDescription",defaultMessage:"An uninstall token allows you to use the uninstall command to remove Elastic Agent from a host."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{direction:"row",alignItems:"center"},(0,R.jsx)(g.EuiFieldSearch,{onSearch:y,incremental:!0,fullWidth:!0,maxLength:50,placeholder:jn,"data-test-subj":"uninstallTokensPolicyIdSearchInput"}),(0,R.jsx)(g.EuiIconTip,{content:bn,type:"info"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiBasicTable,{"data-test-subj":"uninstallTokenListTable",items:f,columns:h,itemId:"id",loading:c,pagination:{pageIndex:o.currentPage-1,pageSize:o.pageSize,totalItemCount:x,pageSizeOptions:d},onChange:E,noItemsMessage:(0,R.jsx)(Mn,{isLoading:c})}),(0,R.jsx)(g.EuiSpacer,{size:"xl"}))},Tn=P()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-1t6qzy1-0"})(["max-width:250px;"]),wn=P()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-1t6qzy1-1"})(["min-width:0px;"]),Cn=({fleetServerHosts:e,deleteFleetServerHost:t})=>{const a=(0,u.iO7)(),{getHref:l}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>n().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},n().createElement(Tn,{grow:!1},n().createElement("p",{title:e.name,className:"eui-textTruncate"},e.name)),e.is_preconfigured&&n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.managedTooltip",{defaultMessage:"This Fleet server host is managed outside of Fleet. Please refer to your kibana config file for more info."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,field:"host_urls",render:e=>n().createElement(wn,{direction:"column",gutterSize:"xs"},e.map((e=>n().createElement(g.EuiFlexItem,{key:e},n().createElement("p",{title:e,className:"eui-textTruncate"},e))))),name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.hostUrlsColumnTitle",{defaultMessage:"Host URLs"})},{render:e=>e.is_default?n().createElement(g.EuiIcon,{type:"check","data-test-subj":"fleetServerHostTable.defaultIcon"}):null,width:"200px",name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&!e.is_preconfigured&&a.fleet.allSettings;return n().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},n().createElement(g.EuiFlexItem,{grow:!1},s&&n().createElement(g.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.deleteButtonTitle",{defaultMessage:"Delete"}),"aria-label":f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.deleteButtonAriaLabel",{defaultMessage:"Delete host"}),"data-test-subj":"fleetServerHostsTable.delete.btn"})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonIcon,{color:"text",iconType:"pencil",href:l("settings_edit_fleet_server_hosts",{itemId:e.id}),title:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.editButtonTitle",{defaultMessage:"Edit"}),"aria-label":f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.editButtonAriaLabel",{defaultMessage:"Edit host"}),"data-test-subj":"fleetServerHostsTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.actionsColumnTitle",{defaultMessage:"Actions"})}]),[l,t,a.fleet.allSettings]);return n().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"settingsFleetServerHostsTable"})},An=({fleetServerHosts:e,deleteFleetServerHost:t})=>{const a=(0,u.iO7)(),{docLinks:s}=(0,u.WeA)(),{getHref:l}=(0,u.iEg)();return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",{"data-test-subj":"fleetServerHostHeader"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostSectionTitle",defaultMessage:"Fleet server hosts"}))),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostSectionSubtitle",defaultMessage:"Specify the URLs that your agents will use to connect to a Fleet Server. If multiple URLs exist, Fleet will show the first provided URL for enrollment purposes. For more information, see the {guideLink} .",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:s.links.fleet.guide,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetUserGuideLink",defaultMessage:"Fleet and Elastic Agent Guide"}))}})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Cn,{fleetServerHosts:e,deleteFleetServerHost:t}),a.fleet.addFleetServers?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:l("settings_create_fleet_server_hosts"),"data-test-subj":"settings.fleetServerHosts.addFleetServerHostBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostCreateButtonLabel",defaultMessage:"Add Fleet Server"}))):null,(0,R.jsx)(g.EuiSpacer,{size:"m"}))},Pn=({output:e,showBadge:t})=>{var a,l;const{notifications:i}=(0,u.WeA)(),[o,r]=(0,s.useState)(),{data:d}=(0,x.useQuery)(["outputHealth",e.id],(()=>(0,u.IaD)(e.id)),{refetchInterval:1e4});(0,s.useEffect)((()=>{null!=d&&d.error&&i.toasts.addError(null==d?void 0:d.error,{title:f.i18n.translate("xpack.fleet.output.errorFetchingOutputHealth",{defaultMessage:"Error fetching output state"})}),r(null==d?void 0:d.data)}),[d,i.toasts]);const c={DEGRADED:(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger",iconType:"error","data-test-subj":"outputHealthDegradedCallout"},(0,R.jsx)("p",{className:"eui-textBreakWord"},f.i18n.translate("xpack.fleet.output.calloutText",{defaultMessage:'Unable to connect to "{name}" at {host}.',values:{name:e.name,host:null!==(a=null===(l=e.hosts)||void 0===l?void 0:l.join(","))&&void 0!==a?a:""}})),(0,R.jsx)("p",null,f.i18n.translate("xpack.fleet.output.calloutPromptText",{defaultMessage:"Please check the details are correct."}))),HEALTHY:(0,R.jsx)(g.EuiCallOut,{title:"Healthy",color:"success",iconType:"check","data-test-subj":"outputHealthHealthyCallout"},(0,R.jsx)("p",null,f.i18n.translate("xpack.fleet.output.successCalloutText",{defaultMessage:"Connection with remote output established."})))},p={DEGRADED:(0,R.jsx)(g.EuiBadge,{color:"danger","data-test-subj":"outputHealthDegradedBadge"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.outputHealth.degradedStatusText",defaultMessage:"Unhealthy"})),HEALTHY:(0,R.jsx)(g.EuiBadge,{color:"success","data-test-subj":"outputHealthHealthyBadge"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.outputHealth.healthyStatusText",defaultMessage:"Healthy"}))},h=new Date((null==o?void 0:o.timestamp)||0).getTime(),E=h?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.outputHealth.timestampTooltipText",defaultMessage:"Last reported {timestamp}",values:{timestamp:(0,R.jsx)(m.FormattedRelative,{value:h})}})):null,y=(null==o?void 0:o.state)&&p[null==o?void 0:o.state]||null;return t?E&&null!=o&&o.state?(0,R.jsx)(g.EuiToolTip,{position:"top",content:E,"data-test-subj":"outputHealthBadgeTooltip"},(0,R.jsx)(n().Fragment,null,y," ")):y:(null==o?void 0:o.state)&&c[o.state]||null},_n=n().memo((({output:e})=>{const t=(0,s.useMemo)((()=>{const t=[];return e.is_default&&t.push((0,R.jsx)(Ln,{key:"default-output"})),e.is_default_monitoring&&t.push((0,R.jsx)(Dn,{key:"default-monitoring-output"})),t}),[e]);return(0,R.jsx)(g.EuiBadgeGroup,{gutterSize:"xs"},t.map(((e,t)=>e)))})),Ln=()=>(0,R.jsx)(g.EuiBadge,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputs.defaultOutputBadgeTitle",defaultMessage:"Agent integrations"})),Dn=()=>(0,R.jsx)(g.EuiBadge,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputs.defaultMonitoringOutputBadgeTitle",defaultMessage:"Agent monitoring"})),On=({status:e,onClick:t,onClickAriaLabel:a})=>{const s=t&&a?{onClick:t,onClickAriaLabel:a}:{};return{FAILED:(0,R.jsx)(g.EuiBadge,(0,d.default)({color:"danger","data-test-subj":"integrationSyncFailedBadge",iconType:"errorFilled"},s),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.failedText",defaultMessage:"Failed"})),WARNING:(0,R.jsx)(g.EuiBadge,(0,d.default)({color:"warning","data-test-subj":"integrationSyncWarningBadge",iconType:"warning"},s),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.warningText",defaultMessage:"Warning"})),COMPLETED:(0,R.jsx)(g.EuiBadge,(0,d.default)({color:"success","data-test-subj":"integrationSyncCompletedBadge",iconType:"check"},s),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.completedText",defaultMessage:"Completed"})),SYNCHRONIZING:(0,R.jsx)(g.EuiBadge,(0,d.default)({color:"hollow","data-test-subj":"integrationSyncSyncingBadge"},s),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiLoadingSpinner,{size:"s"})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.syncingText",defaultMessage:"Syncing..."})))),NA:(0,R.jsx)(g.EuiFlexGroup,{alignItems:"baseline",justifyContent:"flexStart",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued",size:"xs"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.naText",defaultMessage:"N/A"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.integrationSyncStatus.naTooltip",{defaultMessage:"Integration syncing only applies to remote outputs."}),type:"info",color:"subdued"}))),DISABLED:(0,R.jsx)(g.EuiFlexGroup,{alignItems:"baseline",justifyContent:"flexStart",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{color:"subdued",size:"xs"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.disabledText",defaultMessage:"Sync disabled"})," ")),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.integrationSyncStatus.disabledTooltip",{defaultMessage:"Integration syncing is disabled for this remote output. Enable it by clicking the edit icon and updating the output settings."}),type:"info",color:"subdued"})))}[e]},Rn=({id:e,title:t,children:a,isDisabled:n,"data-test-subj":l})=>{const i=(0,s.useMemo)((()=>{if(l)return{"data-test-subj":`${l}-openCloseToggle`}}),[l]),{euiTheme:o}=(0,g.useEuiTheme)();return(0,R.jsx)(g.EuiPanel,{paddingSize:"none",css:(0,R.css)("border:solid 1px ",o.colors.borderBasePlain,";box-shadow:none;border-radius:6px;","")},(0,R.jsx)(g.EuiAccordion,{css:(0,R.css)(".euiAccordion__button{width:90%;}.euiAccordion__triggerWrapper{padding-left:",o.size.m,";}&.euiAccordion-isOpen{.euiAccordion__childWrapper{padding:",o.size.m,";padding-top:0px;}}.ingest-integration-title-button{padding:",o.size.s,";}.euiTableRow:last-child .euiTableRowCell{border-bottom:none;}.euiIEFlexWrapFix{min-width:0;}.euiAccordion__buttonContent{width:100%;}",""),id:e,arrowDisplay:n?"none":"left",buttonClassName:"ingest-integration-title-button",buttonContent:t,arrowProps:i,"data-test-subj":l,isDisabled:n},a))},Bn=(0,s.memo)((({integration:e,customAssets:t,syncUninstalledIntegrations:a,"data-test-subj":l})=>{var i,o,r;const[d,c]=(0,s.useState)(void 0);(0,s.useEffect)((()=>{(0,u.rfo)(e.package_name,e.package_version,{prerelease:!0}).then((e=>{c(e.item)}))}),[e.package_name,e.package_version]);const p=Nn([e.sync_status,...t.map((e=>e.sync_status))]).toUpperCase(),{euiTheme:f}=(0,g.useEuiTheme)(),{docLinks:x}=(0,u.WeA)(),h="installed"!==e.install_status.main?f.colors.textDisabled:f.colors.textParagraph;return(0,R.jsx)(Rn,{id:e.package_name,"data-test-subj":l,isDisabled:!(e.error||null!=e&&e.warning||t.length),title:(0,R.jsx)(g.EuiTitle,{size:"xs"},(0,R.jsx)("h3",null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center",justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(w.qD,{packageName:e.package_name,version:e.package_version,size:"l",tryApi:!0})),(0,R.jsx)(g.EuiFlexItem,{className:"eui-textTruncate"},d?(0,R.jsx)(g.EuiTitle,{size:"xs",css:(0,R.css)("color:",h,";","")},(0,R.jsx)("p",null,null!==(i=null==d?void 0:d.title)&&void 0!==i?i:"")):(0,R.jsx)(U.Rh,null)))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(On,{status:p})))))},(0,R.jsx)(n().Fragment,null,(null==e?void 0:e.error)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.integrationErrorTitle",defaultMessage:"Error"}),color:"danger",iconType:"error",size:"s","data-test-subj":"integrationSyncIntegrationErrorCallout"},(0,R.jsx)(g.EuiText,{size:"s"},e.error)),(0,R.jsx)(g.EuiSpacer,{size:"s"})),"warning"===e.sync_status&&(null==e?void 0:e.warning)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.integrationWarningTitle",defaultMessage:"{Warning}",values:{Warning:null===(o=e.warning)||void 0===o?void 0:o.title}}),color:"warning",iconType:"warning",size:"s","data-test-subj":"integrationSyncIntegrationWarningCallout"},(null==e||null===(r=e.warning)||void 0===r?void 0:r.message)&&(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.integrationWarningContent",defaultMessage:"{uninstallWarning}",values:{uninstallWarning:e.warning.message}})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiButton,{color:"warning",href:x.links.fleet.remoteESOoutputTroubleshooting,iconType:"popout",target:"blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.integrationWarningButton",defaultMessage:"View troubleshooting guide"})))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),t.map((e=>(0,R.jsx)(g.EuiAccordion,{id:`${e.type}:${e.name}`,key:`${e.type}:${e.name}`,arrowDisplay:e.error?"left":"none",isDisabled:!e.error&&!e.warning,buttonContent:(0,R.jsx)(g.EuiFlexGroup,{alignItems:"baseline",gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiText,{size:"s"},e.name)),e.is_deleted&&(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiBadge,{color:"hollow"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.deletedText",defaultMessage:"Deleted"})))),"data-test-subj":`${e.type}:${e.name}-accordion`,extraAction:e.sync_status===Se.um.SYNCHRONIZING?(0,R.jsx)(g.EuiLoadingSpinner,{size:"m"}):(0,R.jsx)(g.EuiIcon,{size:"m",color:e.sync_status===Se.um.FAILED?"danger":e.sync_status===Se.um.WARNING?"warning":"success",type:e.sync_status===Se.um.FAILED?"errorFilled":e.sync_status===Se.um.WARNING?"warning":"checkInCircleFilled"}),paddingSize:"none"},(0,R.jsx)(n().Fragment,null,e.error&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{announceOnMount:!1,title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.errorTitle",defaultMessage:"Error"}),color:"danger",iconType:"error",size:"s","data-test-subj":"integrationSyncAssetErrorCallout"},(0,R.jsx)(g.EuiText,{size:"s"},e.error)),(0,R.jsx)(g.EuiSpacer,{size:"s"})),e.sync_status===Se.um.WARNING&&e.warning&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{announceOnMount:!0,title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.customAssetWarningTitle",defaultMessage:"{Warning}",values:{Warning:e.warning.title}}),color:"warning",iconType:"warning",size:"s","data-test-subj":"customAssetWarningCallout"},e.warning.message&&(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncStatus.customAssetWarningContent",defaultMessage:"{customAssetWarning}",values:{customAssetWarning:e.warning.message}}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}))))))))})),zn=(0,s.memo)((({onClose:e,syncedIntegrationsStatus:t,outputName:a,syncUninstalledIntegrations:s})=>{var n;const{docLinks:l}=(0,u.WeA)(),i=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:e,"aria-labelledby":i},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,null,(0,R.jsx)("h2",{id:i},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.titleText",defaultMessage:"Integration syncing status"}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"s","data-test-subj":"integrationSyncFlyoutHeaderText"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.headerText",defaultMessage:"You're viewing sync activity for {outputName}. Check overall progress and view individual sync statuses from custom assets. {documentationLink}.",values:{outputName:a,documentationLink:(0,R.jsx)(g.EuiLink,{href:`${l.links.fleet.remoteESOoutput}#automatic-integrations-synchronization`,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.documentationLink",defaultMessage:"Learn more"}))}}))),(0,R.jsx)(g.EuiFlyoutBody,null,(null==t?void 0:t.error)&&(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.errorTitle",defaultMessage:"Error"}),color:"danger",iconType:"error",size:"s","data-test-subj":"integrationSyncFlyoutTopErrorCallout"},(0,R.jsx)(g.EuiText,{size:"s"},null==t?void 0:t.error)),(0,R.jsx)(g.EuiFlexGroup,{direction:"column",gutterSize:"m"},(null!==(n=null==t?void 0:t.integrations)&&void 0!==n?n:[]).filter((e=>{var t,a;return!("not_installed"===(null===(t=e.install_status)||void 0===t?void 0:t.main)&&"not_installed"===(null===(a=e.install_status)||void 0===a?void 0:a.remote))})).map((e=>{var a;const n=Object.values(null!==(a=null==t?void 0:t.custom_assets)&&void 0!==a?a:{}).filter((t=>t.package_name===e.package_name));return(0,R.jsx)(g.EuiFlexItem,{grow:!1,key:e.package_name},(0,R.jsx)(Bn,{"data-test-subj":`${e.package_name}-accordion`,integration:e,customAssets:n,syncUninstalledIntegrations:s}))})))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:e},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.integrationSyncFlyout.closeFlyoutButtonLabel",defaultMessage:"Close"}))))))}));function Nn(e){return e.some((e=>e===Se.um.FAILED))?Se.um.FAILED:e.some((e=>e===Se.um.WARNING))?Se.um.WARNING:e.some((e=>e===Se.um.SYNCHRONIZING))?Se.um.SYNCHRONIZING:Se.um.COMPLETED}const Un=(0,s.memo)((({output:e})=>{const{data:t,error:a}=(0,u.XMG)(e.id,{enabled:"remote_elasticsearch"===e.type&&e.sync_integrations}),[l,i]=(0,s.useState)(!1),o=(0,s.useMemo)((()=>{var s,n;if("remote_elasticsearch"!==e.type)return"NA";if(!e.sync_integrations)return"DISABLED";if(!a&&!t)return"SYNCHRONIZING";const l=Nn([...(null!==(s=null==t?void 0:t.integrations)&&void 0!==s?s:[]).filter((e=>{var t,a;return!("not_installed"===(null===(t=e.install_status)||void 0===t?void 0:t.main)&&"not_installed"===(null===(a=e.install_status)||void 0===a?void 0:a.remote))})).map((e=>e.sync_status))||[],...Object.values(null!==(n=null==t?void 0:t.custom_assets)&&void 0!==n?n:{}).map((e=>e.sync_status))]).toUpperCase();return null!=a&&a.message||null!=t&&t.error?"FAILED":l}),[e,t,a]);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(On,{status:o,onClick:()=>{i(!0)},onClickAriaLabel:"Show details"}),l&&(0,R.jsx)(zn,{onClose:()=>i(!1),syncedIntegrationsStatus:a?{integrations:[],error:a.message}:t,outputName:e.name,syncUninstalledIntegrations:"remote_elasticsearch"===e.type&&(null==e?void 0:e.sync_uninstalled_integrations)}))})),Hn=P()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-uvxtm0-0"})(["max-width:250px;"]),Wn=P()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-uvxtm0-1"})(["min-width:0px;"]),Gn=({outputs:e,deleteOutput:t})=>{const a=(0,u.iO7)(),{getHref:l}=(0,u.iEg)(),{enableSyncIntegrationsOnRemote:i}=z.ZX.get(),{cloud:o}=(0,u.WeA)(),r=i&&u.Fjq.isEnterprise()&&!(null!=o&&o.isServerlessEnabled),d=(0,s.useMemo)((()=>[{render:e=>n().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},n().createElement(Hn,{grow:!1},n().createElement("p",{title:e.name,className:"eui-textTruncate"},e.name)),e.is_preconfigured&&n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.outputsTable.managedTooltip",{defaultMessage:"This output is managed outside of Fleet."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.outputsTable.nameColumnTitle",{defaultMessage:"Name"})},{width:"172px",render:e=>function(e){switch(e){case"elasticsearch":return f.i18n.translate("xpack.fleet.settings.outputsTable.elasticsearchTypeLabel",{defaultMessage:"Elasticsearch"});case"remote_elasticsearch":return f.i18n.translate("xpack.fleet.settings.outputsTable.remoteElasticsearchTypeLabel",{defaultMessage:"Remote Elasticsearch"});default:return e}}(e.type),name:f.i18n.translate("xpack.fleet.settings.outputsTable.typeColumnTitle",{defaultMessage:"Type"})},{truncateText:!0,render:e=>n().createElement(Wn,{direction:"column",gutterSize:"xs"},(e.hosts||[]).map((e=>n().createElement(g.EuiFlexItem,{key:e},n().createElement("p",{title:e,className:"eui-textTruncate"},e))))),name:f.i18n.translate("xpack.fleet.settings.outputsTable.hostColumnTitle",{defaultMessage:"Hosts"})},{render:e=>null!=e&&e.id&&"remote_elasticsearch"===e.type?n().createElement(Pn,{output:e,showBadge:!0}):null,name:f.i18n.translate("xpack.fleet.settings.outputsTable.statusColumnTitle",{defaultMessage:"Status"})},...r?[{render:e=>n().createElement(Un,{output:e}),name:f.i18n.translate("xpack.fleet.settings.outputsTable.integrationSyncColumnTitle",{defaultMessage:"Integration syncing"})}]:[],{render:e=>n().createElement(_n,{output:e}),width:"200px",name:f.i18n.translate("xpack.fleet.settings.outputSection.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&!e.is_default_monitoring&&!e.is_preconfigured&&a.fleet.allSettings;return n().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},n().createElement(g.EuiFlexItem,{grow:!1},s&&n().createElement(g.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:f.i18n.translate("xpack.fleet.settings.outputSection.deleteButtonTitle",{defaultMessage:"Delete"}),"aria-label":f.i18n.translate("xpack.fleet.settings.outputSection.deleteButtonTitle",{defaultMessage:"Delete"})})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonIcon,{color:"text",iconType:"pencil",href:l("settings_edit_outputs",{outputId:e.id}),title:f.i18n.translate("xpack.fleet.settings.outputSection.editButtonTitle",{defaultMessage:"Edit"}),"aria-label":f.i18n.translate("xpack.fleet.settings.outputSection.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"editOutputBtn"})))},name:f.i18n.translate("xpack.fleet.settings.outputSection.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,l,a.fleet.allSettings,r]);return n().createElement(g.EuiBasicTable,{columns:d,items:e,"data-test-subj":"settingsOutputsTable"})},Kn=({outputs:e,deleteOutput:t})=>{const a=(0,u.iO7)(),{getHref:s}=(0,u.iEg)(),{docLinks:l}=(0,u.WeA)();return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputSectionTitle",defaultMessage:"Outputs"}))),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,R.jsx)(g.EuiLink,{href:l.links.fleet.settings,external:!0,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputSectionSubtitle",defaultMessage:"Specify where agents will send data."}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Gn,{outputs:e,deleteOutput:t}),a.fleet.allSettings&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:s("settings_create_outputs"),"data-test-subj":"addOutputBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.outputCreateButtonLabel",defaultMessage:"Add output"}))))},qn=P()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-xsf6c1-0"})(["max-width:250px;"]),Vn=P()(g.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-xsf6c1-1"})(["min-width:0px;"]),$n=({downloadSources:e,deleteDownloadSource:t,hasAllSettingsPrivileges:a})=>{const{getHref:l}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>n().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},n().createElement(qn,{grow:!1},n().createElement("p",{title:e.name,className:"eui-textTruncate","data-test-subj":"editDownloadSourceTable.name"},e.name))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,render:e=>n().createElement(Vn,{direction:"column",gutterSize:"xs"},n().createElement(g.EuiFlexItem,{key:e.host},n().createElement("p",{title:e.host,className:"eui-textTruncate","data-test-subj":"editDownloadSourceTable.host"},e.host))),name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.hostColumnTitle",{defaultMessage:"Host"})},{render:e=>e.is_default?n().createElement(g.EuiIcon,{type:"check","data-test-subj":"editDownloadSourceTable.defaultIcon"}):null,width:"200px",name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&a,i=f.i18n.translate("xpack.fleet.settings.downloadSourceSection.deleteButtonTitle",{defaultMessage:"Delete"}),o=f.i18n.translate("xpack.fleet.settings.downloadSourceSection.editButtonTitle",{defaultMessage:"Edit"});return n().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},n().createElement(g.EuiFlexItem,{grow:!1},s&&n().createElement(g.EuiButtonIcon,{"aria-label":i,color:"text",iconType:"trash",onClick:()=>t(e),title:i,"data-test-subj":"editDownloadSourceTable.delete.btn"})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonIcon,{"aria-label":o,color:"text",iconType:"pencil",href:l("settings_edit_download_sources",{downloadSourceId:e.id}),title:o,"data-test-subj":"editDownloadSourceTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.downloadSourceSection.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,l,a]);return n().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"AgentDownloadSourcesTable"})},Yn=({downloadSources:e,deleteDownloadSource:t})=>{const{getHref:a}=(0,u.iEg)(),s=(0,u.iO7)().fleet.allSettings;return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.Title",defaultMessage:"Agent Binary Download"}))),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.Subtitle",defaultMessage:"List of sources used by Elastic agents to download their binaries. The default source applies to all agent policies that don't have a specific binary source specified."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)($n,{downloadSources:e,deleteDownloadSource:t,hasAllSettingsPrivileges:s}),s&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:a("settings_create_download_sources"),"data-test-subj":"addDownloadSourcesBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.CreateButtonLabel",defaultMessage:"Add agent binary source"}))))},Qn=P()(g.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-czjc9c-0"})(["max-width:250px;"]),Xn=({proxies:e,deleteFleetProxy:t})=>{const a=(0,u.iO7)(),{getHref:l}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>n().createElement(g.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},n().createElement(Qn,{grow:!1},n().createElement("p",{title:e.name,className:"eui-textTruncate","data-test-subj":"fleetProxiesTable.name"},e.name)),e.is_preconfigured&&n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.managedTooltip",{defaultMessage:"This proxy is managed outside of Fleet. Please refer to your kibana config file for more info."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,field:"url",name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.urlColumnTitle",{defaultMessage:"Url"})},{width:"68px",render:e=>{const s=a.fleet.allSettings&&!e.is_preconfigured,i=f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.deleteButtonTitle",{defaultMessage:"Delete"}),o=f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.editButtonTitle",{defaultMessage:"Edit"});return n().createElement(g.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},n().createElement(g.EuiFlexItem,{grow:!1},s&&n().createElement(g.EuiButtonIcon,{"aria-label":i,color:"text",iconType:"trash",onClick:()=>t(e),title:i,"data-test-subj":"fleetProxiesTable.delete.btn"})),n().createElement(g.EuiFlexItem,{grow:!1},n().createElement(g.EuiButtonIcon,{"aria-label":o,color:"text",iconType:"pencil",href:l("settings_edit_fleet_proxy",{itemId:e.id}),title:o,"data-test-subj":"fleetProxiesTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,l,a.fleet.allSettings]);return n().createElement(g.EuiBasicTable,{columns:i,items:e,"data-test-subj":"fleetProxiesTable"})},Jn=({proxies:e,deleteFleetProxy:t})=>{const a=(0,u.iO7)(),{getHref:s}=(0,u.iEg)(),{docLinks:l}=(0,u.WeA)();return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFlexGroup,{gutterSize:"xs"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.title",defaultMessage:"Proxies"}))))),(0,R.jsx)(g.EuiText,{color:"subdued",size:"m"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.subtitle",defaultMessage:"Specify any proxy URLs to be used in Fleet servers, Outputs or Agent binary download sources. For more information see our {docLink}.",values:{docLink:(0,R.jsx)(g.EuiLink,{target:"_blank",external:!0,href:l.links.fleet.proxiesSettings},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.link",defaultMessage:"docs"}))}})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Xn,{proxies:e,deleteFleetProxy:t}),a.fleet.allSettings&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiButtonEmpty,{iconType:"plusInCircle",href:s("settings_create_fleet_proxy"),"data-test-subj":"addProxyBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.CreateButtonLabel",defaultMessage:"Add proxy"}))))},Zn=({})=>{var e,t,a,l,i,o,r,d;const c=(0,u.iO7)(),p=(0,u.YI3)(),{docLinks:x,notifications:h,overlays:E}=(0,u.WeA)(),y=null!==(e=null===(t=(0,u.ZwD)().data)||void 0===t||null===(a=t.item)||void 0===a||null===(l=a.delete_unenrolled_agents)||void 0===l?void 0:l.enabled)&&void 0!==e&&e,k=null!==(i=null===(o=(0,u.ZwD)().data)||void 0===o||null===(r=o.item)||void 0===r||null===(d=r.delete_unenrolled_agents)||void 0===d?void 0:d.is_preconfigured)&&void 0!==i&&i,[v,j]=n().useState(y),{mutateAsync:b}=(0,u.Zd9)(),{showAgentless:S,setShowAgentless:F}=(0,u.jXQ)(),{mutateAsync:M,isLoading:I}=(0,u.X37)();(0,s.useEffect)((()=>{y&&j(y)}),[y]);const T=(0,s.useCallback)((async e=>{try{j(e);const t=await b({delete_unenrolled_agents:{enabled:e,is_preconfigured:!1}});if(t.error)throw t.error}catch(t){j(!e),h.toasts.addError(t,{title:f.i18n.translate("xpack.fleet.errorUpdatingSettings",{defaultMessage:"Error updating settings"})})}}),[b,h.toasts]),w=(0,s.useCallback)((async()=>{if(await E.openConfirm(f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigrationMessage",{defaultMessage:"This migration will enable each space to have its own agent policy and agents. This is a one-way migration and can’t be reversed."}),{title:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigrationTitle",{defaultMessage:"Migrate to Space-Aware Agent Policies?"}),buttonColor:"warning",confirmButtonText:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigration.confirmButtonText",{defaultMessage:"Confirm and migrate"})}))try{await M(),h.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigration.successToastTitle",{defaultMessage:"Migration complete"}),text:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigration.successToastContent",{defaultMessage:"Your cluster now uses space-aware agent policies."})})}catch(e){h.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.confirmSpaceAwarenessMigration.errorToastTitle",{defaultMessage:"Migration failed"})})}}),[M,h.toasts,E]);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h4",{"data-test-subj":"advancedHeader"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.advancedSectionTitle",defaultMessage:"Advanced Settings"}))),p.isSpaceAwarenessEnabled?null:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiDescribedFormGroup,{title:(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.migrateSpaceAwarenessLabel",defaultMessage:"Migrate to space-aware agent policies"})),description:(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.switchLabel",defaultMessage:"Take advantage of improved isolation and management by enabling space-specific agent policies."}))},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiButton,{onClick:w,isLoading:I},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Start migration"}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiDescribedFormGroup,{title:(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Delete unenrolled agents"})),description:(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.switchLabel",defaultMessage:"Switching on this setting will enable auto-deletion of unenrolled agents. For more information, refer to the {docLink}.",values:{docLink:(0,R.jsx)(g.EuiLink,{target:"_blank",external:!0,href:x.links.fleet.settings},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.link",defaultMessage:"docs"}))}}))},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiToolTip,{content:k?f.i18n.translate("xpack.fleet.settings.advancedSection.preconfiguredTitle",{defaultMessage:"This setting is preconfigured and cannot be updated."}):void 0},(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Delete unenrolled agents"}),checked:v,onChange:e=>T(e.target.checked),disabled:!c.fleet.allSettings||k})))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiDescribedFormGroup,{title:(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.showAgentlessResourcesLabel",defaultMessage:"Show agentless resources"})),description:(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.showAgentlessResourcesDescription",defaultMessage:"Enable this toggle to display agentless agents and policies in Fleet for debugging and diagnostics purposes. This setting is stored locally and is only visible to you."}))},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.showAgentlessResourcesLabel",defaultMessage:"Show agentless resources"}),checked:S,onChange:e=>{F(e.target.checked),F(e.target.checked)},"data-test-subj":"showAgentlessResourcesSwitch"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}))},el=({outputs:e,proxies:t,fleetServerHosts:a,deleteOutput:s,deleteFleetServerHost:l,downloadSources:i,deleteDownloadSource:o,deleteFleetProxy:r})=>(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(An,{fleetServerHosts:a,deleteFleetServerHost:l}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Kn,{outputs:e,deleteOutput:s}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Yn,{downloadSources:i,deleteDownloadSource:o}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Jn,{proxies:t,deleteFleetProxy:r}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Zn,null));var tl=a(47907),al=a(54761);const sl=({label:e,inputProps:t,placeholder:a,dataTestSubj:s})=>(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:e},t.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":s,fullWidth:!0},t.props,{placeholder:a}))),nl=({label:e,inputProps:t,placeholder:a,dataTestSubj:s})=>(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:e},t.formRowProps),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5,"data-test-subj":s},t.props,{placeholder:a}))),ll=()=>(0,R.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",size:"s",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.proxyWarning.warningTitle",defaultMessage:"Be aware that changing the proxy settings may cause Elastic Agents to lose connectivity. Please ensure that agents have reachability to the proxy in the context that it is being used for."})});var il=a(79519),ol=a(38684);const rl=({onClose:e,fleetServerHost:t,defaultFleetServerHost:a,proxies:l})=>{var i,o,r;const c=(0,g.useGeneratedHtmlId)(),{docLinks:p,cloud:x}=(0,u.WeA)(),h=(0,ol.ao)(t,e,a),{inputs:E}=h,y=(0,s.useMemo)((()=>l.map((e=>({value:e.id,label:e.name})))),[l]),{enableSSLSecrets:k}=z.ZX.get(),[v,j]=n().useState(!0),[b,S]=n().useState({sslKey:!1,sslESKey:!1}),[F,I]=(0,s.useState)(!0),T=!0===F,w=(0,u.YI3)();return void 0!==w.isSecretsStorageEnabled&&"disabled"===F&&I(w.isSecretsStorageEnabled),(0,s.useEffect)((()=>{v&&(j(!1),T&&k&&(E.sslKeyInput.value&&!E.sslKeySecretInput.value&&(E.sslKeySecretInput.setValue(E.sslKeyInput.value),E.sslKeyInput.clear(),S({...b,sslKey:!0})),E.sslESKeyInput.value&&!E.sslESKeySecretInput.value&&(E.sslESKeySecretInput.setValue(E.sslESKeyInput.value),E.sslESKeyInput.clear(),S({...b,sslESKey:!0}))))}),[E.sslKeyInput,E.sslKeySecretInput,v,j,b,E.sslESKeyInput,E.sslESKeySecretInput,F,T,k]),(0,R.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW,"aria-labelledby":c},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:c},t?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.editTitle",defaultMessage:"Edit Fleet Server"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.addTitle",defaultMessage:"Add Fleet Server"}))),!t&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiText,{color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.serverlessInfoText",defaultMessage:"You may create another Fleet Server definition reachable via a proxy. In context of the serverless project, Fleet Service is managed by Elastic. Creation of a new one is therefore not permitted."}))))),(0,R.jsx)(g.EuiFlyoutBody,null,t&&(0,R.jsx)(g.EuiCallOut,{size:"m",color:"warning",iconType:"warning",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutTitle",defaultMessage:"Changing these settings can break your agent connections"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutDescription",defaultMessage:"Invalid settings can break the connection between Elastic Agent and Fleet Server. If this happens, you will need to re-enroll your agents."})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiForm,{onSubmit:h.submit},(0,R.jsx)(sl,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.nameInputLabel",defaultMessage:"Name"}),inputProps:E.nameInput,dataTestSubj:"fleetServerHostsFlyout.nameInput",placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.hostUrlLabel",defaultMessage:"URL"})},(0,R.jsx)(n().Fragment,null,!(null!=x&&x.isServerlessEnabled)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,{color:"subdued",size:"relative"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.description",defaultMessage:"Specify multiple URLs to scale out your deployment and provide automatic failover. If multiple URLs exist, Fleet shows the first provided URL for enrollment purposes. Enrolled Elastic Agents will connect to the URLs in round robin order until they connect successfully. For more information, see the {link} .",values:{link:(0,R.jsx)(g.EuiLink,{href:p.links.fleet.settingsFleetServerHostSettings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.userGuideLink",defaultMessage:"Fleet and Elastic Agent Guide"}))}})),(0,R.jsx)(g.EuiSpacer,{size:"m"})),(0,R.jsx)(al.G,(0,d.default)({},E.hostUrlsInput.props,{id:"fleet-server-inputs",placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.fleetServerHostsInputPlaceholder",{defaultMessage:"Specify host URL"}),isUrl:!0,helpText:(null==x?void 0:x.isServerlessEnabled)&&(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.serverlessHostUrlsHelpText",defaultMessage:"Custom host URLs are not allowed in serverless."})})))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.proxyIdLabel",defaultMessage:"Proxy"})},(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"fleetServerHostsFlyout.proxyIdInput"},null===(i=E.proxyIdInput)||void 0===i?void 0:i.props,{onChange:e=>{var t,a,s;return null==E||null===(t=E.proxyIdInput)||void 0===t?void 0:t.setValue(null!==(a=null==e||null===(s=e[0])||void 0===s?void 0:s.value)&&void 0!==a?a:"")},selectedOptions:""!==(null==E||null===(o=E.proxyIdInput)||void 0===o?void 0:o.value)?y.filter((e=>{var t;return e.value===(null===(t=E.proxyIdInput)||void 0===t?void 0:t.value)})):[],options:y,singleSelection:{asPlainText:!0},isDisabled:null===(r=E.proxyIdInput)||void 0===r?void 0:r.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})})),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(ll,null))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},E.isDefaultInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"fleetServerHostsFlyout.isDefaultSwitch"},E.isDefaultInput.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",defaultMessage:"Make this Fleet server the default one."})}))),(0,R.jsx)(g.EuiSpacer,{size:"l"}),(0,R.jsx)(il.k,{inputs:E,useSecretsStorage:k&&T,onToggleSecretAndClearValue:e=>{e?(E.sslKeyInput.clear(),E.sslESKeyInput.clear()):(E.sslKeySecretInput.setValue(""),E.sslESKeySecretInput.setValue("")),S({...b,sslKey:!1,sslESKey:!1}),(e=>{"disabled"!==F&&I(e)})(e)},isConvertedToSecret:b}))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,isLoading:h.isLoading,isDisabled:h.isDisabled,onClick:h.submit,"data-test-subj":"saveApplySettingsBtn","aria-label":"Save and apply settings"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},ul=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetProxy.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),dl=({})=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetProxy.confirmModalText",defaultMessage:"This action will change agent policies currently using that proxy. Are you sure you wish to continue?"});async function cl(e){var t,a;let s=`${M.mm}.data_output_id:"${e.id}" or ${M.mm}.monitoring_output_id:"${e.id}"`;const n=`${M.f$}.output_id:"${e.id}"`;e.is_default&&(s+=` or (not ${M.mm}.data_output_id:*)`);const l=await(0,u.cnO)({kuery:s,page:1,perPage:M.W,noAgentCount:!0});if(l.error)throw l.error;const i=await(0,u.TR6)({kuery:n,page:1,perPage:M.W});if(i.error)throw l.error;const o=((null===(t=l.data)||void 0===t?void 0:t.items)||[]).map((e=>e.id)),r=((null===(a=i.data)||void 0===a?void 0:a.items)||[]).reduce(((e,t)=>[...e,...t.policy_ids||[]]),[]),d=new Set([...o,...r]),c=d.size;let g=0;if(c>0){var p,m;const e=await(0,u.voy)({page:1,perPage:0,showInactive:!1,kuery:[...d].map((e=>`policy_id:"${e}"`)).join(" or ")});if(e.error)throw e.error;g=null!==(p=null===(m=e.data)||void 0===m?void 0:m.total)&&void 0!==p?p:0}return{agentPolicyCount:c,agentCount:g}}const gl=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),pl=({output:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalText",defaultMessage:"This action will delete {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,R.jsx)("strong",null,e.name),agents:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalTextWithCount",defaultMessage:"This action will delete {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,R.jsx)("strong",null,e.name)}}),ml=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetServerHosts.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),fl=({})=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetServerHosts.confirmModalText",defaultMessage:"This action will change agent policies currently enrolled in this Fleet Server, to instead enroll in your default Fleet server. Are you sure you wish to continue?"});var xl=a(23921);const hl=e=>{var t;const{type:a,inputs:s,useSecretsStorage:l,isConvertedToSecret:i,onToggleSecretAndClearValue:o}=e,r=a===te.gf.Elasticsearch||a===te.gf.RemoteElasticsearch,u=!!s.sslKeySecretInput.value||(null===(t=s.sslCertificateAuthoritiesInput.value)||void 0===t?void 0:t.length)>0||!!s.sslCertificateInput.value||!!s.sslKeySecretInput.value;return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiAccordion,{initialIsOpen:u,id:"advancedSSLOptions","data-test-subj":"advancedSSLOptionsButton",buttonClassName:"ingest-active-button",buttonContent:(0,R.jsx)("div",null,(0,R.jsx)(g.EuiTitle,{size:"xs"},(0,R.jsx)("h3",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.editOutputFlyout.SSLOptionsToggleLabel",defaultMessage:"Authentication"}))),(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)("p",null,(0,R.jsx)(g.EuiTextColor,{color:"subdued"},r?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.SSLOptionsDescription",defaultMessage:"Add these settings only when setting up an mTLS connection"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.editOutputFlyout.SSLOptionsToggleLabel",defaultMessage:"Set up a TLS secure connection"})))))},(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiPanel,{color:"subdued",borderRadius:"none",hasShadow:!1},"download_source"===a?(0,R.jsx)(g.EuiCallOut,{title:f.i18n.translate("xpack.fleet.editOutputFlyout.downloadSource.sslWarningCallout",{defaultMessage:"Invalid settings can prevent Elastic Agent from being able to upgrade. If this happens, you will need to provide valid credentials."}),color:"warning",iconType:"warning"}):(0,R.jsx)(g.EuiCallOut,{title:f.i18n.translate("xpack.fleet.editOutputFlyout.sslWarningCallout",{defaultMessage:"Invalid settings can break the connection between Elastic Agent and the configured output. If this happens, you will need to provide valid credentials."}),color:"warning",iconType:"warning"}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(al.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder",{defaultMessage:"Specify certificate authority"}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel",{defaultMessage:"Server SSL certificate authorities"}),multiline:!0,sortable:!1},s.sslCertificateAuthoritiesInput.props)),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",defaultMessage:"Client SSL certificate"})},s.sslCertificateInput.formRowProps),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},s.sslCertificateInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder",{defaultMessage:"Specify SSL certificate"})}))),l?(0,R.jsx)(xl.h,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTitle",{defaultMessage:"Client SSL certificate key"})},s.sslKeySecretInput.formRowProps,{useSecretsStorage:l,isConvertedToSecret:i,onToggleSecretStorage:o,cancelEdit:s.sslKeySecretInput.cancelEdit}),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},s.sslKeySecretInput.props,{"data-test-subj":"sslKeySecretInput",placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputPlaceholder",{defaultMessage:"Specify certificate key"})}))):(0,R.jsx)(xl.h,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",defaultMessage:"Client SSL certificate key"})},s.sslKeyInput.formRowProps,{useSecretsStorage:l,onToggleSecretStorage:o,disabled:!l}),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},s.sslKeyInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}))};async function El(e){var t,a,s;let n=`${M.mm}.download_source_id:"${e.id}"`;e.is_default&&(n+=` or (not ${M.mm}.download_source_id:*)`);const l=await(0,u.cnO)({kuery:n,page:1,perPage:M.W});if(l.error)throw l.error;const i=null!==(t=null===(a=l.data)||void 0===a||null===(s=a.items)||void 0===s?void 0:s.length)&&void 0!==t?t:0;let o=0;if(i>0){var r,d,c;const e=await(0,u.voy)({page:1,perPage:0,showInactive:!1,kuery:null===(r=l.data)||void 0===r?void 0:r.items.map((e=>`policy_id:"${e.id}"`)).join(" or ")});if(e.error)throw e.error;o=null!==(d=null===(c=e.data)||void 0===c?void 0:c.total)&&void 0!==d?d:0}return{agentPolicyCount:i,agentCount:o}}const yl=({downloadSource:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalText","data-test-subj":"editDownloadSourcesConfirmModal.confirmModalText",defaultMessage:"This action will update {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,R.jsx)("strong",null,e.name),agents:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalTextWithoutCount","data-test-subj":"editDownloadSourcesConfirmModal.confirmModalText",defaultMessage:"This action will update {downloadSourceName} agent binary source. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,R.jsx)("strong",null,e.name)}});function kl(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}function vl(e){try{if(!e)return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.HostIsRequiredErrorMessage",{defaultMessage:"Host is required"})];const t=new URL(e);if(!["http:","https:"].includes(t.protocol))throw new Error("Invalid protocol")}catch(e){return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.hostError",{defaultMessage:"Invalid URL"})]}}const jl=({onClose:e,downloadSource:t,proxies:a})=>{(0,u.ifo)("settings");const l=function(e,t){var a,n,l,i,o,r,d,c,g,p,x,h;const E=(0,u.iO7)(),[y,k]=(0,s.useState)(!1),{notifications:v}=(0,u.WeA)(),{confirm:j}=(0,tl.fl)(),b=!E.fleet.allSettings,S=(0,u.Gez)(null!==(a=null==t?void 0:t.name)&&void 0!==a?a:"",kl,b),F=(0,u.MbH)(null!==(n=null==t?void 0:t.is_default)&&void 0!==n&&n,(null==t?void 0:t.is_default)||b),M=(0,u.Gez)(null!==(l=null==t?void 0:t.host)&&void 0!==l?l:"",vl,b),I=(0,u.Gez)(null!==(i=null==t?void 0:t.proxy_id)&&void 0!==i?i:"",(()=>{}),b),T=(0,u.U6y)("sslCertificateAuthoritiesComboxBox",null!==(o=null==t||null===(r=t.ssl)||void 0===r?void 0:r.certificate_authorities)&&void 0!==o?o:[],void 0,void 0),w=(0,u.Gez)(null!==(d=null==t||null===(c=t.ssl)||void 0===c?void 0:c.certificate)&&void 0!==d?d:"",void 0,void 0),C=(0,u.Gez)(null!==(g=null==t||null===(p=t.ssl)||void 0===p?void 0:p.key)&&void 0!==g?g:"",void 0,void 0),A=(0,u.YZM)(null==t||null===(x=t.secrets)||void 0===x||null===(h=x.ssl)||void 0===h?void 0:h.key,void 0,void 0),P={nameInput:S,hostInput:M,defaultDownloadSourceInput:F,proxyIdInput:I,sslCertificateInput:w,sslKeyInput:C,sslCertificateAuthoritiesInput:T,sslKeySecretInput:A},_=Object.values(P).some((e=>e.hasChanged)),L=(0,s.useCallback)((()=>{const e=S.validate(),t=M.validate(),a=w.validate(),s=C.validate(),n=A.validate();return e&&t&&a&&s&&n}),[S,M,w,C,A]),D=(0,s.useCallback)((async()=>{try{if(!L())return;k(!0);const a={name:S.value.trim(),host:M.value.trim(),is_default:F.value,proxy_id:I.value||null,ssl:{certificate:w.value,key:C.value||void 0,certificate_authorities:T.value.filter((e=>""!==e))},...!C.value&&A.value&&{secrets:{ssl:{key:A.value||void 0}}}};if(t){if(!await async function(e,t){const{agentCount:a,agentPolicyCount:s}=await El(e).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));return t((0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),(0,R.jsx)(yl,{agentCount:a,agentPolicyCount:s,downloadSource:e}))}(t,j))return void k(!1);const e=await(0,u.liT)(t.id,a);if(e.error)throw e.error}else{const e=await(0,u.YLO)(a);if(e.error)throw e.error}e(),k(!1)}catch(e){k(!1),v.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.errorToastTitle",{defaultMessage:"Error while saving binary source"})})}}),[j,F.value,t,M.value,S.value,v.toasts,e,I.value,T.value,w.value,C.value,A.value,L]);return{inputs:P,submit:D,isLoading:y,isDisabled:y||t&&!_||b}}(e,t),i=l.inputs,{docLinks:o}=(0,u.WeA)(),r=(0,s.useMemo)((()=>a.map((e=>({value:e.id,label:e.name})))),[a]),[c,p]=n().useState(!0),[x,h]=(0,s.useState)(!0),E=!0===x,[y,k]=n().useState({sslKey:!1}),{enableSSLSecrets:v}=z.ZX.get(),j=(0,u.YI3)();void 0!==j.isSecretsStorageEnabled&&"disabled"===x&&h(j.isSecretsStorageEnabled),(0,s.useEffect)((()=>{c&&(p(!1),E&&v&&i.sslKeyInput.value&&!i.sslKeySecretInput.value&&(i.sslKeySecretInput.setValue(i.sslKeyInput.value),i.sslKeyInput.clear(),k({...y,sslKey:!0})))}),[E,i.sslKeyInput,i.sslKeySecretInput,c,p,y,v]);const b=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW,"aria-labelledby":b},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:b},t?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.editTitle",defaultMessage:"Edit agent binary source","data-test-subj":"editDownloadSourcesFlyout.edit.title"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.createTitle",defaultMessage:"Add new agent binary source","data-test-subj":"editDownloadSourcesFlyout.add.title"})))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(g.EuiForm,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.nameInputLabel",defaultMessage:"Name"})},i.nameInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.nameInput",fullWidth:!0},i.nameInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editDownloadSourcesFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:(0,R.jsx)(m.FormattedMessage,{"data-test-subj":"editDownloadSourcesFlyout.hostHelpText",id:"xpack.fleet.settings.editDownloadSourcesFlyout.hostsInputDescription",defaultMessage:"Enter the address of the directory containing the binaries to download. {guideLink}",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:o.links.fleet.settings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetSettingsLink",defaultMessage:"Learn more"}))}}),label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.hostInputLabel",defaultMessage:"Host"})},i.hostInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.hostInput",fullWidth:!0},i.hostInput.props,{placeholder:"https://artifacts.elastic.co/downloads"}))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdLabel",defaultMessage:"Proxy"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.proxyInputDescription",defaultMessage:"Proxy used for accessing the download source. When selected, the SSL settings and headers from the proxy will be used."})},(0,R.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.proxyIdInput"},i.proxyIdInput.props,{onChange:e=>{var t,a;return i.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==i.proxyIdInput.value?r.filter((e=>e.value===i.proxyIdInput.value)):[],options:r,singleSelection:{asPlainText:!0},isDisabled:i.proxyIdInput.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})}))),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(ll,null),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},i.defaultDownloadSourceInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.isDefaultSwitch"},i.defaultDownloadSourceInput.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.defaultSwitchLabel",defaultMessage:"Make this host the default for all agent policies."})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(hl,{inputs:i,useSecretsStorage:v&&E,isConvertedToSecret:y.sslKey,onToggleSecretAndClearValue:e=>{e?i.sslKeyInput.clear():i.sslKeySecretInput.setValue(""),k({sslKey:!1}),(e=>{"disabled"!==x&&h(e)})(e)},type:"download_source"}))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:e,flush:"left","data-test-subj":"editDownloadSourcesFlyout.cancelBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,isLoading:l.isLoading,isDisabled:l.isDisabled,onClick:l.submit,"data-test-subj":"editDownloadSourcesFlyout.submitBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},bl=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),Sl=({downloadSource:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalText",defaultMessage:"This action will delete {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,R.jsx)("strong",null,e.name),agents:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalTextWithoutCount",defaultMessage:"This action will delete {downloadSourceName} agent binary source and it will update its related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,R.jsx)("strong",null,e.name)}}),Fl=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),Ml=({})=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.confirmModalText",defaultMessage:"This action will update agent policies using this proxy. This action can not be undone. Are you sure you wish to continue?"});function Il(e){return e&&""!==e?e.match(te.lyu)?void 0:[f.i18n.translate("xpack.fleet.settings.fleetProxyFlyoutUrlError",{defaultMessage:"Invalid URL"})]:[f.i18n.translate("xpack.fleet.settings.fleetProxyFlyoutUrlRequired",{defaultMessage:"URL is required"})]}function Tl(e){if(e&&""!==e){const t=(0,Ls.Hh)(e);if("object"!=typeof t||Object.values(t).some((e=>{const t=typeof e;return"string"!==t&&"number"!==t&&"boolean"!==t})))return[f.i18n.translate("xpack.fleet.settings.fleetProxy.proxyHeadersErrorMessage",{defaultMessage:"Proxy headers is not a valid key: value object."})]}}function wl(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.fleetProxy.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}const Cl=({onClose:e,fleetProxy:t})=>{const a=function(e,t){var a,n,l,i,o,r;const[d,c]=(0,s.useState)(!1),g=(0,u.iO7)(),{notifications:p}=(0,u.WeA)(),{confirm:m}=(0,tl.fl)(),x=null!==(a=!g.fleet.allSettings||(null==e?void 0:e.is_preconfigured))&&void 0!==a&&a,h=(0,u.Gez)(null!==(n=null==e?void 0:e.name)&&void 0!==n?n:"",wl,x),E=(0,u.Gez)(null!==(l=null==e?void 0:e.url)&&void 0!==l?l:"",Il,x),y=(0,u.Gez)(null!=e&&e.proxy_headers?(0,Ls.Bh)(e.proxy_headers):"",Tl,x),k=(0,u.Gez)(null!==(i=null==e?void 0:e.certificate_authorities)&&void 0!==i?i:"",(()=>{}),x),v=(0,u.Gez)(null!==(o=null==e?void 0:e.certificate)&&void 0!==o?o:"",(()=>{}),x),j=(0,u.Gez)(null!==(r=null==e?void 0:e.certificate_key)&&void 0!==r?r:"",(()=>{}),x),b=(0,s.useMemo)((()=>({nameInput:h,urlInput:E,proxyHeadersInput:y,certificateAuthoritiesInput:k,certificateInput:v,certificateKeyInput:j})),[h,E,y,k,v,j]),S=(0,s.useCallback)((()=>(0,u.C11)(b)),[b]),F=(0,s.useCallback)((async()=>{try{if(!S())return;if(e&&!await m((0,R.jsx)(Fl,null),(0,R.jsx)(Ml,null)))return;c(!0);const a={name:h.value,url:E.value,proxy_headers:""===y.value?void 0:(0,Ls.Hh)(y.value),certificate_authorities:k.value,certificate:v.value,certificate_key:j.value};if(e){const t=await(0,u.aCR)(e.id,a);if(t.error)throw t.error}else{const e=await(0,u.nJY)(a);if(e.error)throw e.error}p.toasts.addSuccess(f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.successToastTitle",{defaultMessage:"Fleet proxy saved"})),c(!1),await t()}catch(e){c(!1),p.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.errorToastTitle",{defaultMessage:"An error happened while saving Fleet Server host"})})}}),[e,h.value,E.value,y.value,k.value,v.value,j.value,S,p,m,t]),M=Object.values(b).some((e=>e.hasChanged));return{isLoading:d,isDisabled:d||!M||h.props.isInvalid||E.props.isInvalid,submit:F,inputs:b}}(t,e),{inputs:n}=a,l=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:e,maxWidth:M.MW,"aria-labelledby":l},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:l},t?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.editTitle",defaultMessage:"Edit Proxy"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.addTitle",defaultMessage:"Add Proxy"})))),(0,R.jsx)(g.EuiFlyoutBody,null,(0,R.jsx)(ll,null),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiForm,{onSubmit:a.submit},(0,R.jsx)(sl,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.nameInputLabel",defaultMessage:"Name"}),inputProps:n.nameInput,"data-test-subj":"fleetProxyFlyout.nameInput",placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}),(0,R.jsx)(sl,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.urlInputLabel",defaultMessage:"Proxy Url"}),dataTestSubj:"fleetProxyFlyout.urlInput",inputProps:n.urlInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.urlInputPlaceholder",{defaultMessage:"Specify proxy url"})}),(0,R.jsx)(nl,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.proxyHeadersLabel",defaultMessage:"Proxy headers"}),dataTestSubj:"fleetProxyFlyout.proxyHeadersInput",inputProps:n.proxyHeadersInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.proxyHeadersPlaceholder",{defaultMessage:"Specify proxy headers"})}),(0,R.jsx)(sl,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesLabel",defaultMessage:"Certificate authorities"}),dataTestSubj:"fleetProxyFlyout.certificateAuthoritiesInput",inputProps:n.certificateAuthoritiesInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesPlaceholder",{defaultMessage:"Specify certificate authorities"})}),(0,R.jsx)(sl,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateLabel",defaultMessage:"Certificate"}),dataTestSubj:"fleetProxyFlyout.certificateInput",inputProps:n.certificateInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificatePlaceholder",{defaultMessage:"Specify certificate"})}),(0,R.jsx)(sl,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateKeyLabel",defaultMessage:"Certificate key"}),dataTestSubj:"fleetProxyFlyout.certificateKeyInput",inputProps:n.certificateKeyInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificateKeyPlaceholder",{defaultMessage:"Specify certificate key"})}))),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,isLoading:a.isLoading,isDisabled:a.isDisabled,onClick:a.submit,"data-test-subj":"saveApplySettingsBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))};var Al=a(2912);const Pl=({inputs:e})=>{const{docLinks:t}=(0,u.WeA)(),a=(0,s.useMemo)((()=>te.HDJ.map((e=>({label:e,value:e})))),[]);return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaTopicsPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaHeaders"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopcisTitle",defaultMessage:"Topics"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",defaultMessage:"Default topic"})},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({style:{flexDirection:"row",flexWrap:"wrap",columnGap:30},"data-test-subj":"editOutputFlyout.kafkaTopicsRadioInput",options:te.HV8,compressed:!0,name:"kafkaTopics"},e.kafkaTopicsInput.props))),(()=>{switch(e.kafkaTopicsInput.value){case te.LXo.Static:return(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",defaultMessage:"Default topic"})},e.kafkaStaticTopicInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaStaticTopicInput",fullWidth:!0},e.kafkaStaticTopicInput.props)));case te.LXo.Dynamic:return(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicHelptext",{defaultMessage:"Select a topic from the list. If a topic is not available, create a custom one."}),label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicLabel",defaultMessage:"Topic from field(s). For more info, see our {guideLink}.",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:t.links.fleet.kafkaOutputTopicsSettings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.kafkaGuideLink",defaultMessage:"docs"}))}})},e.kafkaDynamicTopicInput.formRowProps),(0,R.jsx)(g.EuiComboBox,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaDynamicTopicInput",fullWidth:!0,isClearable:!0,options:a,customOptionText:"Use custom field",singleSelection:{asPlainText:!0}},e.kafkaDynamicTopicInput.props)))}})(),(0,R.jsx)(g.EuiSpacer,{size:"m"}))},_l=e=>{const{inputs:t}=e,{props:{onChange:a},value:n,formRowProps:{error:l}}=t.kafkaHeadersInput,[i,o]=(0,s.useState)(!1),r=(0,s.useCallback)(((e,t,s)=>{const l=n.map(((a,n)=>n===e?{...a,[t]:s}:a));a(l)}),[n,a]),u=(0,s.useCallback)((()=>{o(!0);const e=[...n,{key:"",value:""}];a(e)}),[n,a]),c=(0,s.useCallback)((e=>{const t=n.filter(((t,a)=>a!==e));a(t)}),[n,a]),p=1===n.length,x=1===n.length&&(""===n[0].key||""===n[0].value),h=e=>null!=e&&e.length?e.map(((e,t)=>(0,R.jsx)(g.EuiFormErrorText,{key:t},e))):null,E=(0,s.useMemo)((()=>(e,t)=>null==l?void 0:l.filter((a=>a.index===e&&("key"===t?a.hasKeyError:a.hasValueError))).map((e=>e.message))),[l]),y=(0,s.useMemo)((()=>l&&l.filter((e=>void 0===e.index)).map((({message:e})=>e))),[l]);return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaHeadersPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaHeaders"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeadersTitle",defaultMessage:"Headers"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),n.map(((e,t)=>{var a,s,n,l;const o=E(t,"key"),u=E(t,"value");return(0,R.jsx)("div",{key:t},t>0&&(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart",gutterSize:"none",style:{gap:30}},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeaderKeyInputLabel",defaultMessage:"Key"}),error:h(o),isInvalid:(null!==(a=null==o?void 0:o.length)&&void 0!==a?a:0)>0},(0,R.jsx)(g.EuiFieldText,{isInvalid:(null!==(s=null==o?void 0:o.length)&&void 0!==s?s:0)>0,"data-test-subj":`settingsOutputsFlyout.kafkaHeadersKeyInput${t}`,fullWidth:!0,value:e.key,onChange:e=>r(t,"key",e.target.value),autoFocus:i}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeaderValueInputLabel",defaultMessage:"Value"}),error:h(u),isInvalid:(null!==(n=null==u?void 0:u.length)&&void 0!==n?n:0)>0},(0,R.jsx)(g.EuiFieldText,{isInvalid:(null!==(l=null==u?void 0:u.length)&&void 0!==l?l:0)>0,"data-test-subj":`settingsOutputsFlyout.kafkaHeadersValueInput${t}`,fullWidth:!0,value:e.value,onChange:e=>r(t,"value",e.target.value)}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1,style:{marginTop:28}},(0,R.jsx)(g.EuiButtonIcon,{"data-test-subj":`settingsOutputsFlyout.kafkaHeadersDeleteButton${t}`,color:"text",onClick:()=>c(t),iconType:"cross",disabled:p,"aria-label":f.i18n.translate("xpack.fleet.kafkaHeadersInput.deleteButton",{defaultMessage:"Delete row"})}))))})),h(y),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiButtonEmpty,{"data-test-subj":"kafkaHeaders.multiRowInput.addRowButton",disabled:x,size:"xs",flush:"left",iconType:"plusInCircle",onClick:u},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.kafkaHeadersInput.addRow",defaultMessage:"Add header"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaClientIdLabel",defaultMessage:"Client ID"})},t.kafkaClientIdInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaClientIdInput",fullWidth:!0},t.kafkaClientIdInput.props))))},Ll=e=>{const{inputs:t}=e,a=(0,s.useMemo)((()=>Array.from({length:6},((e,t)=>10*(t+1))).map((e=>({text:e,label:`${e} seconds`})))),[]),n=e=>{switch(e){case te.NAW.DoNotWait:return"No response";case te.NAW.Replica:return"Wait for all replicas to commit";default:case te.NAW.Commit:return"Wait for local commit"}},l=(0,s.useMemo)((()=>Object.keys(te.NAW).map((e=>({text:te.NAW[e],label:n(te.NAW[e])})))),[]);return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaBrokerSettingsPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaBrokerSettings"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerSettingsTitle",defaultMessage:"Broker settings"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputLabel",defaultMessage:"Broker timeout"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputHelpText",defaultMessage:"Define how long a Kafka server waits for data in the same cluster."})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerTimeoutInput"},t.kafkaBrokerTimeoutInput.props,{options:a}))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputLabel",defaultMessage:"Broker reachability timeout"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputHelpText",defaultMessage:"Define how long an Agent would wait for a response from Kafka broker."})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerReachabilityTimeoutInput"},t.kafkaBrokerReachabilityTimeoutInput.props,{options:a}))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputLabel",defaultMessage:"ACK Reliability"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputHelpText",defaultMessage:"Reliability level required from the broker."})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerAckReliabilityInputLabel"},t.kafkaBrokerAckReliabilityInput.props,{options:l}))))},Dl=e=>{const{inputs:t}=e,a=(0,s.useMemo)((()=>Object.keys(te.jZS).filter((e=>"None"!==e)).map((e=>({text:te.jZS[e],label:te.jZS[e]})))),[]),l=(0,s.useMemo)((()=>Array.from({length:9},((e,t)=>t+1)).map((e=>({text:e,label:e.toString()})))),[]);return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaCompressionPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaCompression"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionTitle",defaultMessage:"Compression"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaCompressionSwitch"},t.kafkaCompressionInput.props,{onChange:e=>{e.target.checked||t.kafkaCompressionCodecInput.setValue(te.jZS.None),t.kafkaCompressionInput.setValue(e.target.checked)},label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionSwitchLabel",defaultMessage:"Enable compression"})})),t.kafkaCompressionInput.value?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionCodecInputLabel",defaultMessage:"Codec"})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaCompressionCodecInput"},t.kafkaCompressionCodecInput.props,{options:a}))),t.kafkaCompressionCodecInput.value===te.jZS.Gzip&&(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionLevelInputLabel",defaultMessage:"Level"})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0},t.kafkaCompressionLevelInput.props,{"data-test-subj":"settingsOutputsFlyout.kafkaCompressionLevelInput",options:l})))):null)},Ol=[{id:te.BwZ.Random,label:"Random","data-test-subj":"kafkaPartitionRandomRadioButton"},{id:te.BwZ.RoundRobin,label:"Round robin","data-test-subj":"kafkaPartitionRoundRobinRadioButton"},{id:te.BwZ.Hash,label:"Hash","data-test-subj":"kafkaPartitionHashRadioButton"}],Rl=e=>{const{inputs:t}=e;return(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaPartitionPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaPartitionTitle"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTitle",defaultMessage:"Partitioning"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitioningInputLabel",defaultMessage:"Partitioning strategy"})},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({style:{flexDirection:"row",flexWrap:"wrap",columnGap:30},"data-test-subj":"settingsOutputsFlyout.kafkaPartitioningRadioInput",options:Ol,compressed:!0,name:"kafkaPartitioningStrategy"},t.kafkaPartitionTypeInput.props))),(()=>{switch(t.kafkaPartitionTypeInput.value){case te.BwZ.Random:return(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRandomInputLabel",defaultMessage:"Number of events"})},t.kafkaPartitionTypeRandomInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeRandomInput",fullWidth:!0},t.kafkaPartitionTypeRandomInput.props)));case te.BwZ.RoundRobin:return(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRoundRobinInputLabel",defaultMessage:"Number of events"})},t.kafkaPartitionTypeRoundRobinInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeRoundRobinInput",fullWidth:!0},t.kafkaPartitionTypeRoundRobinInput.props)));case te.BwZ.Hash:default:return(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashInputLabel",defaultMessage:"List of fields"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashHelpTextLabel",defaultMessage:"Comma separated."})},(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeHashInput",fullWidth:!0},t.kafkaPartitionTypeHashInput.props))))}})())},Bl=[{id:te.N9h.Plain,label:"Plain","data-test-subj":"kafkaSaslPlainRadioButton"},{id:te.N9h.ScramSha256,label:"SCRAM-SHA-256","data-test-subj":"kafkaSaslScramSha256RadioButton"},{id:te.N9h.ScramSha512,label:"SCRAM-SHA-512","data-test-subj":"kafkaSaslScramSha512RadioButton"}],zl=[{id:te.NB8.None,label:"None","data-test-subj":"kafkaAuthenticationNoneRadioButton"},{id:te.NB8.Userpass,label:"Username / Password","data-test-subj":"kafkaAuthenticationUsernamePasswordRadioButton"},{id:te.NB8.Ssl,label:"SSL","data-test-subj":"kafkaAuthenticationSSLRadioButton"}],Nl=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:l}=e,[i,o]=n().useState({kafkaAuthPassword:!1,kafkaSslKey:!1}),[r,u]=n().useState(!0);(0,s.useEffect)((()=>{r&&(u(!1),a&&(t.kafkaAuthPasswordInput.value&&!t.kafkaAuthPasswordSecretInput.value&&(t.kafkaAuthPasswordSecretInput.setValue(t.kafkaAuthPasswordInput.value),t.kafkaAuthPasswordInput.clear(),o({...i,kafkaAuthPassword:!0})),t.kafkaSslKeyInput.value&&!t.kafkaSslKeySecretInput.value&&(t.kafkaSslKeySecretInput.setValue(t.kafkaSslKeyInput.value),t.kafkaSslKeyInput.clear(),o({...i,kafkaSslKey:!0}))))}),[a,t.kafkaAuthPasswordInput,t.kafkaAuthPasswordSecretInput,t.kafkaSslKeyInput,t.kafkaSslKeySecretInput,r,u,i]);const c=e=>{e?(t.kafkaAuthPasswordInput.clear(),t.kafkaSslKeyInput.clear()):(t.kafkaAuthPasswordSecretInput.setValue(""),t.kafkaSslKeySecretInput.setValue("")),o({kafkaAuthPassword:!1,kafkaSslKey:!1}),l(e)},p=(0,s.useMemo)((()=>Object.keys(te.i36).map((e=>({text:te.i36[e],label:e})))),[]),x=(0,s.useMemo)((()=>Object.keys(te.zPI).map((e=>({id:te.zPI[e],label:e,"data-test-subj":`kafkaConnectionType${e}RadioButton`})))),[]);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaAuthenticationPanel"},(0,R.jsx)(g.EuiTitle,{size:"s"},(0,R.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaAuthenticationTitle"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaAuthenticationTitle",defaultMessage:"Authentication"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({name:"kafkaAuthMethod",style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaAuthenticationRadioInput",options:zl,compressed:!0},t.kafkaAuthMethodInput.props))),(()=>{switch(t.kafkaAuthMethodInput.value){case te.NB8.None:return(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaConnectionTypeLabel",defaultMessage:"Connection"})},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({name:"kafkaConnectionType",style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaConnectionTypeRadioInput",options:x,compressed:!0},t.kafkaConnectionTypeInput.props)));case te.NB8.Ssl:return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",defaultMessage:"Client SSL certificate"})},t.kafkaSslCertificateInput.formRowProps),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.kafkaSslCertificateInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaSslCertificateInputPlaceholder",{defaultMessage:"Specify ssl certificate"})}))),a?(0,R.jsx)(xl.h,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaPasswordSecretInputTitle",{defaultMessage:"Client SSL certificate key"})},t.kafkaSslKeySecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:i.kafkaSslKey,onToggleSecretStorage:c,cancelEdit:t.kafkaSslKeySecretInput.cancelEdit}),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5,"data-test-subj":"kafkaSslKeySecretInput"},t.kafkaSslKeySecretInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))):(0,R.jsx)(xl.h,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",defaultMessage:"Client SSL certificate key"})},t.kafkaSslKeyInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:c}),(0,R.jsx)(g.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.kafkaSslKeyInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))));default:case te.NB8.Userpass:return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaUsernameInputLabel",defaultMessage:"Username"})},t.kafkaAuthUsernameInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaUsernameInput",fullWidth:!0},t.kafkaAuthUsernameInput.props))),a?(0,R.jsx)(xl.h,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputtitle",{defaultMessage:"Password"})},t.kafkaAuthPasswordSecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:i.kafkaAuthPassword,onToggleSecretStorage:c,cancelEdit:t.kafkaAuthPasswordSecretInput.cancelEdit}),(0,R.jsx)(g.EuiFieldPassword,(0,d.default)({type:"dual","data-test-subj":"settingsOutputsFlyout.kafkaPasswordSecretInput",fullWidth:!0},t.kafkaAuthPasswordSecretInput.props))):(0,R.jsx)(xl.h,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputLabel",defaultMessage:"Password"})},t.kafkaAuthPasswordInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:c}),(0,R.jsx)(g.EuiFieldPassword,(0,d.default)({type:"dual","data-test-subj":"settingsOutputsFlyout.kafkaPasswordInput",fullWidth:!0},t.kafkaAuthPasswordInput.props))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaSaslInputLabel",defaultMessage:"SASL Mechanism"})},(0,R.jsx)(g.EuiRadioGroup,(0,d.default)({name:"kafkaSaslMechanism",style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaSaslInput",options:Bl,compressed:!0},t.kafkaSaslMechanismInput.props))))}})()),t.kafkaConnectionTypeInput.value!==te.zPI.Plaintext||t.kafkaAuthMethodInput.value!==te.NB8.None?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(al.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder",{defaultMessage:"Specify certificate authority"}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaSslCertificateAuthoritiesInputLabel",{defaultMessage:"Server SSL certificate authorities (optional)"}),multiline:!0,sortable:!1},t.kafkaSslCertificateAuthoritiesInput.props)),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaVerificationModeInputLabel",defaultMessage:"Verification mode"})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaVerificationModeInput"},t.kafkaVerificationModeInput.props,{options:p})))):null)},Ul=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:l}=e,{docLinks:i}=(0,ot.WeA)(),o=(0,s.useMemo)((()=>te.y6d.map((e=>({text:e,label:e})))),[]);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaVersionInputLabel",defaultMessage:"Kafka version"})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaVersionInput"},t.kafkaVersionInput.props,{options:o}))),(0,R.jsx)(al.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaHostsInputPlaceholder",{defaultMessage:"Specify host"}),sortable:!0,helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHostsInputDescription",defaultMessage:"Specify the URLs that your agents will use to connect to Kafka. {guideLink}.",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:i.links.fleet.kafkaSettings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.kafkaUserGuideLink",defaultMessage:"Learn more"}))}}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaHostsInputLabel",{defaultMessage:"Hosts"})},t.kafkaHostsInput.props)),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Nl,{inputs:t,useSecretsStorage:a,onToggleSecretStorage:l}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Rl,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Pl,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(_l,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Dl,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ll,{inputs:t}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaKeyInputLabel",defaultMessage:"Key (optional)"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaKeyInputHelpText",defaultMessage:"If configured, the event key can be extracted from the event using a format string."})},(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaKeyInput",fullWidth:!0},t.kafkaKeyInput.props))))};var Hl=a(9424);const Wl=P().div.withConfig({displayName:"CodeEditorContainer",componentId:"sc-1u19e39-0"})(["min-height:0;position:relative;height:116px;"]),Gl=P()(g.EuiTextColor).attrs((e=>({color:"subdued",size:"xs"}))).withConfig({displayName:"CodeEditorPlaceholder",componentId:"sc-1u19e39-1"})(["position:absolute;top:0;left:0;font-family:Menlo,Monaco,'Courier New',monospace;font-size:12px;line-height:21px;pointer-events:none;"]),Kl={minimap:{enabled:!1},ariaLabel:f.i18n.translate("xpack.fleet.settings.yamlCodeEditor",{defaultMessage:"YAML Code Editor"}),scrollBeyondLastLine:!1,wordWrap:"on",wrappingIndent:"indent",automaticLayout:!0,tabSize:2,lineNumbers:"off",lineNumbersMinChars:0,glyphMargin:!1,folding:!1,lineDecorationsWidth:0},ql=e=>{const{placeholder:t,disabled:a,...s}=e;return a?n().createElement(g.EuiCodeBlock,{style:{height:"116px"},language:"yaml",isCopyable:!1,paddingSize:"s"},n().createElement("pre",null,s.value)):n().createElement(Wl,null,n().createElement(Hl.CodeEditor,(0,d.default)({languageId:"yaml",width:"100%",height:"116px",options:Kl},s)),(!s.value||""===s.value)&&n().createElement(Gl,null,t))},Vl=e=>t=>{if("object"!=typeof t)return e(null!=t?t:"")};function $l(e){const t=[],a={};if(e.forEach(((e,s)=>{if(!e)return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostFieldRequiredError",{defaultMessage:"Host is required"})});const n=e.split(":");if(2!==n.length||!n[0]||!n[1])return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostPortError",{defaultMessage:'Invalid format. Expected "host:port" without protocol.'}),index:s});const l=parseInt(n[1],10);(isNaN(l)||l<1||l>65535)&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPortError",{defaultMessage:"Invalid port number. Expected a number between 1 and 65535"}),index:s});const i=a[e]||[];a[e]=[...i,s]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostDuplicateError",{defaultMessage:"Duplicate URL"}),index:e})))})),0===e.length&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostRequiredError",{defaultMessage:"Host is required"})}),t.length)return t}function Yl(e){const t=[],a={},s=f.i18n.translate("xpack.fleet.settings.outputForm.elasticUrlRequiredError",{defaultMessage:"URL is required"});if(e.forEach(((e,n)=>{try{if(e){const a=new URL(e);["http:","https:"].includes(a.protocol)||t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.invalidProtocolError",{defaultMessage:"Invalid protocol"}),index:n})}else t.push({message:s,index:n})}catch(e){t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.elasticHostError",{defaultMessage:"Invalid URL"}),index:n})}const l=a[e]||[];a[e]=[...l,n]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.elasticHostDuplicateError",{defaultMessage:"Duplicate URL"}),index:e})))})),0===e.length&&t.push({message:s}),t.length)return t}function Ql(e){const t=[],a={};if(e.forEach(((e,s)=>{try{if(e.match(/^http([s]){0,1}:\/\//))return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostProtocolError",{defaultMessage:"Host address must begin with a domain name or IP address"}),index:s});if(new URL(`http://${e}`).host!==e.toLowerCase())throw new Error("Invalid host")}catch(a){0===e.length?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostRequiredError",{defaultMessage:"Host is required"}),index:s}):t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostError",{defaultMessage:"Invalid Host"}),index:s})}const n=a[e]||[];a[e]=[...n,s]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostDuplicateError",{defaultMessage:"Duplicate Host"}),index:e})))})),0===e.length&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostRequiredError",{defaultMessage:"Host is required"})}),t.length)return t}function Xl(e){try{return void(0,Ls.Hh)(e)}catch(e){return[f.i18n.translate("xpack.fleet.settings.outputForm.invalidYamlFormatErrorMessage",{defaultMessage:"Invalid YAML: {reason}",values:{reason:e.message}})]}}function Jl(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}function Zl(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaUsernameIsRequired",{defaultMessage:"Username is required"})]}function ei(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPasswordIsRequired",{defaultMessage:"Password is required"})]}const ti=Vl(ei);function ai(e){if(""!==e&&!e.match(/^[a-zA-Z0-9]+$/))return[f.i18n.translate("xpack.fleet.settings.outputForm.caTrusterdFingerprintInvalidErrorMessage",{defaultMessage:"CA trusted fingerprint should be valid HEX encoded SHA-256 of a CA certificate"})]}function si(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.serviceTokenRequiredErrorMessage",{defaultMessage:"Service token is required"})]}const ni=Vl(si);function li(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kibanaAPIKeyRequiredErrorMessage",{defaultMessage:"Kibana API Key is required"})]}function ii(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.sslCertificateRequiredErrorMessage",{defaultMessage:"SSL certificate is required"})]}function oi(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.sslKeyRequiredErrorMessage",{defaultMessage:"SSL key is required"})]}Vl(li);const ri=Vl(oi);function ui(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaDefaultTopicRequiredMessage",{defaultMessage:"Default topic is required"})]}function di(e){const t=[];if(e.forEach(((e,a)=>{e||t.push(f.i18n.translate("xpack.fleet.settings.outputForm.kafkaTopicFieldRequiredMessage",{defaultMessage:"Topic is required"}))})),0===e.length&&t.push(f.i18n.translate("xpack.fleet.settings.outputForm.kafkaTopicRequiredMessage",{defaultMessage:"Topic is required"})),t.length)return t}function ci(e){return/^[A-Za-z0-9._-]+$/.test(e)?void 0:[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaClientIdFormattingMessage",{defaultMessage:"Client ID is invalid. Only letters, numbers, dots, underscores, and dashes are allowed."})]}function gi(e){return/^[0-9]+$/.test(e)?void 0:[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPartitioningGroupEventsFormattingMessage",{defaultMessage:"Number of events must be a number"})]}function pi(e){const t=[],a=new Set;if(e.forEach(((e,s)=>{const{key:n,value:l}=e,i=!!n,o=!!l;i&&!o?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersMissingKeyError",{defaultMessage:'Missing value for key "{key}"',values:{key:n}}),index:s,hasKeyError:!1,hasValueError:!0}):!i&&o?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersMissingValueError",{defaultMessage:'Missing key for value "{value}"',values:{value:l}}),index:s,hasKeyError:!0,hasValueError:!1}):i&&o&&(a.has(n)?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersDuplicateKeyError",{defaultMessage:'Duplicate key "{key}"',values:{key:n}}),index:s,hasKeyError:!0,hasValueError:!1}):a.add(n))})),t.length)return t}const mi=()=>(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),fi=({output:e,agentCount:t,agentPolicyCount:a})=>(0,R.jsx)(n().Fragment,null,void 0!==t&&void 0!==a?(0,R.jsx)(m.FormattedMessage,{"data-test-subj":"settings.outputModal",id:"xpack.fleet.settings.updateOutput.confirmModalText",defaultMessage:"This action will update {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,R.jsx)("strong",null,e.name),agents:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,R.jsx)(m.FormattedMessage,{"data-test-subj":"settings.outputModal",id:"xpack.fleet.settings.updateOutput.confirmModalTextWithoutCount",defaultMessage:"This action will update {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,R.jsx)("strong",null,e.name)}}),"logstash"===e.type?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",size:"m",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.warningTitle",defaultMessage:"Logstash output for agent integration is not supported for fleet server and synthetics."})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.warningMessage",defaultMessage:"Fleet server and synthetics policies will keep using the existing ES output."}))," "):null);const xi=({enabled:e,inputs:t})=>{const{diskQueueEnabledInput:a,diskQueuePathInput:s,diskQueueMaxSizeInput:l,loadBalanceEnabledInput:i,diskQueueEncryptionEnabled:o,diskQueueCompressionEnabled:r,compressionLevelInput:u,memQueueEvents:c,queueFlushTimeout:p,maxBatchBytes:x}=t,{showExperimentalShipperOptions:h}=z.ZX.get();return e?(0,R.jsx)(g.EuiAccordion,{id:"advancedOutputOptions",arrowDisplay:"left",buttonContent:(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.advancedOptionsToggleLabel",defaultMessage:"Advanced options"})),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiBetaBadge,{label:"Experimental",color:"subdued"})))},(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},x.formRowProps,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescriptionLabel",defaultMessage:"Maximum Batch Size"})}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldNumber,(0,d.default)({},x.props,{placeholder:"Batching Bytes",min:0}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescription",defaultMessage:"Data will be sent to the output when the agent has more events in the queue than this number."}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},p.formRowProps,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutLabel",defaultMessage:"Flush Timeout"})}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldNumber,(0,d.default)({},p.props,{placeholder:"Seconds",min:0}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutDescription",defaultMessage:"Upon expiry the output queue is flushed and data is written to the output."}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},c.formRowProps,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.memQueueEventsLabel",defaultMessage:"Memory Queue Size"})}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldNumber,(0,d.default)({},c.props,{placeholder:"Events",min:0}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.memQueueEventsSizeDescription",defaultMessage:"Maximum number of events that can be stored in the queue. Default is set to 4096. When this queue is full, new events are dropped."}))))),h&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiHorizontalRule,null),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},a.formRowProps),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.diskQueueSwitch"},a.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueSwitchLabel",defaultMessage:"Disk Queue"})}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueSwitchDescription",defaultMessage:"Once enabled, events will be queued on disk if, for some reason, agent is not able to send them."}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.formRowProps),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.diskQueueEncryption"},o.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionLabel",defaultMessage:"Disk Queue Encryption"})}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionDescription",defaultMessage:"Enable encryption of data written to the disk queue."}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueuePathLabel",defaultMessage:"Disk Queue Path"})},s.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.diskQueuePath"},s.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.diskQueuePathPlaceholder",{defaultMessage:"path_data/diskqueue"})}))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},l.formRowProps,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueMaxSize",defaultMessage:"Maximum Disk Queue Size"})}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFieldNumber,(0,d.default)({},l.props,{placeholder:"Bytes",min:0}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueMaxSizeDescription",defaultMessage:"Limits the disk queue size for spooling of data. When data in the queue exceeds this limit, new events will be dropped."}))))),(0,R.jsx)(g.EuiHorizontalRule,null),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},i.formRowProps),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.loadBalancingSwitch"},i.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.loadBalancingSwitchLabel",defaultMessage:"Load Balancing"})}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.loadBalancingDescription",defaultMessage:"Once enabled, the agents will balance the load across all the hosts defined for this output. This will increase the number of connections opened by the agent."}))))),(0,R.jsx)(g.EuiHorizontalRule,null),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0},(0,R.jsx)(g.EuiFlexGroup,{alignItems:"flexStart"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.compressionSwitch"},r.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.compressionSwitchLabel",defaultMessage:"Compression"})}))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiSelect,(0,d.default)({"data-test-subj":"editOutputFlyout.compressionLevelSelect",id:"selectCompressionLevel","aria-label":"Use aria labels when no actual label is in use"},u.props))),(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiText,{size:"s",color:"subdued"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.compressionSwitchDescription",defaultMessage:"Level 1 compression is the fastest, Level 9 however would provide the most compression."})))))))):null},hi=e=>{const{docLinks:t,cloud:a}=(0,u.WeA)(),{inputs:l,useSecretsStorage:i,onToggleSecretStorage:o}=e,[r,c]=n().useState({serviceToken:!1,kibanaAPIKey:!1,sslKey:!1}),{enableSyncIntegrationsOnRemote:p,enableSSLSecrets:x}=z.ZX.get(),h=p&&u.Fjq.isEnterprise()&&!(null!=a&&a.isServerlessEnabled),[E,y]=n().useState(!1),[k,v]=n().useState(!0);(0,s.useEffect)((()=>{if(k&&(v(!1),i)){let e=!1;l.serviceTokenInput.value&&!l.serviceTokenSecretInput.value&&(l.serviceTokenSecretInput.setValue(l.serviceTokenInput.value),l.serviceTokenInput.clear(),e=!0);let t=!1;x&&l.sslKeyInput.value&&!l.sslKeySecretInput.value&&(l.sslKeySecretInput.setValue(l.sslKeyInput.value),l.sslKeyInput.clear(),t=!0),c({...r,serviceToken:e,sslKey:t})}}),[i,l.serviceTokenInput,l.serviceTokenSecretInput,l.kibanaAPIKeyInput,k,v,r,l.sslKeyInput,l.sslKeySecretInput,x]);const j=e=>{e?(l.serviceTokenInput.clear(),l.kibanaAPIKeyInput.clear(),x&&l.sslKeyInput.clear()):(l.serviceTokenSecretInput.setValue(""),x&&l.sslKeyInput.setValue("")),c({...r,serviceToken:!1,kibanaAPIKey:!1,sslKey:!1}),o(e)};return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(al.G,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.hostUrlInput",label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputLabel",{defaultMessage:"Hosts"}),placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputPlaceholder",{defaultMessage:"Specify host URL"})},l.elasticsearchUrlInput.props,{isUrl:!0})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),i?(0,R.jsx)(xl.h,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",{defaultMessage:"Service token"})},l.serviceTokenSecretInput.formRowProps,{cancelEdit:l.serviceTokenSecretInput.cancelEdit,useSecretsStorage:i,isConvertedToSecret:r.serviceToken,onToggleSecretStorage:j}),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"serviceTokenSecretInput",fullWidth:!0},l.serviceTokenSecretInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder",{defaultMessage:"Specify service token"})}))):(0,R.jsx)(xl.h,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",defaultMessage:"Service token"})},l.serviceTokenInput.formRowProps,{useSecretsStorage:i,onToggleSecretStorage:j}),(0,R.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0,"data-test-subj":"serviceTokenSecretInput"},l.serviceTokenInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder",{defaultMessage:"Specify service token"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serviceTokenCalloutText",defaultMessage:"Generate a service token by running this API request in the remote Kibana Console and copy the response value"}),"data-test-subj":"serviceTokenCallout"},(0,R.jsx)(g.EuiCodeBlock,{isCopyable:!0},'POST kbn:/api/fleet/service_tokens\n{\n  "remote": true\n}')),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(hl,{type:l.typeInput.value,inputs:l,useSecretsStorage:x&&i,isConvertedToSecret:r.sslKey,onToggleSecretAndClearValue:j}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),h?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.syncIntegrationsFormRowLabel",defaultMessage:"If enabled, integration assets will be installed on the remote Elasticsearch cluster"})},l.syncIntegrationsInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({},l.syncIntegrationsInput.props,{"data-test-subj":"syncIntegrationsSwitch",label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.syncIntegrationsSwitchLabel",defaultMessage:"Synchronize integrations"})}))),!0===l.syncIntegrationsInput.value&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.syncUninstalledIntegrationsFormRowLabel",defaultMessage:"If enabled, uninstalled integrations will also be uninstalled on the remote Elasticsearch cluster"})},l.syncUninstalledIntegrationsInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({},l.syncUninstalledIntegrationsInput.props,{"data-test-subj":"syncUninstalledIntegrationsSwitch",label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.syncUninstalledIntegrationsSwitchLabel",defaultMessage:"Uninstall integrations on remote"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{iconType:"info",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.remoteClusterConfigurationCalloutTitle",defaultMessage:"Additional remote cluster configuration required"}),"data-test-subj":"remoteClusterConfigurationCallout"},E?(0,R.jsx)(g.EuiButton,{onClick:()=>y(!1)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.collapseInstructionsButtonLabel",defaultMessage:"Collapse steps"})):(0,R.jsx)(g.EuiButton,{onClick:()=>y(!0),fill:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.viewInstructionButtonLabel",defaultMessage:"View steps"})),E&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.description",defaultMessage:"To sync integrations from this cluster, the remote Elasticsearch output needs additional configuration. {documentationLink}.",values:{documentationLink:(0,R.jsx)(g.EuiLink,{external:!0,href:t.links.fleet.remoteESOoutput},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.documentationLink",defaultMessage:"Learn more"}))}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)("ol",null,(0,R.jsx)("li",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.addRemoteClusterStep",defaultMessage:"In the remote cluster, open Kibana and go to {appPath}, and follow the steps to add this cluster.",values:{appPath:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.addRemoteClusterKibanaPath",defaultMessage:"Stack Management > Remote Clusters"}))}}),(0,R.jsx)(g.EuiSpacer,{size:"s"})),(0,R.jsx)("li",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.replicationStep",defaultMessage:"Go to {appPath} and create a follower index using the cluster from Step 1. The leader index is {leaderIndex} from this cluster and should be replicated to the follower index {followerIndex} on the remote cluster.",values:{appPath:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.replicationKibanaPath",defaultMessage:"Stack Management > Cross-Cluster Replication"})),leaderIndex:(0,R.jsx)(g.EuiCode,null,"fleet-synced-integrations"),followerIndex:(0,R.jsx)(g.EuiCode,null,"fleet-synced-integrations-ccr-",(0,J.snakeCase)(l.nameInput.props.value)||"<output name>")}}),(0,R.jsx)(g.EuiSpacer,{size:"s"})),(0,R.jsx)("li",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.configureKibanaStep",defaultMessage:"Below, provide the access details for the remote cluster's Kibana instance."}))),(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.ccsDescription",defaultMessage:"To search accross remote clusters from this cluster, see the {prerequisites}. Once the remote cluster is added, CCS Data Views will be created automatically.",values:{prerequisites:(0,R.jsx)(g.EuiLink,{target:"_blank",href:`${t.links.ccs.guide}#_prerequisites`},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.remoteClusterConfiguration.ccsDocumentationLink",defaultMessage:"CCS prerequisites"}))}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kibanaURLInputLabel",defaultMessage:"Remote Kibana URL"})},l.kibanaURLInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kibanaURLInput",fullWidth:!0},l.kibanaURLInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kibanaURLInputPlaceholder",{defaultMessage:"Specify Kibana URL"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyLabel",defaultMessage:"Remote Kibana API Key"})},l.kibanaAPIKeyInput.formRowProps),(0,R.jsx)(g.EuiFieldPassword,(0,d.default)({fullWidth:!0,type:"dual","data-test-subj":"kibanaAPIKeySecretInput"},l.kibanaAPIKeyInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyPlaceholder",{defaultMessage:"Specify encoded Kibana API Key"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kibanaAPIKeyCalloutText",defaultMessage:"Create an API Key by running this API request in the remote Kibana Console and copy the encoded value"}),"data-test-subj":"kibanaAPIKeyCallout"},(0,R.jsx)(g.EuiCodeBlock,{isCopyable:!0},' POST /_security/api_key\n   {\n     "name": "integration_sync_api_key",\n     "role_descriptors": {\n       "integration_writer": {\n         "cluster": [],\n        "indices":[],\n        "applications": [{\n           "application": "kibana-.kibana",\n             "privileges": ["feature_fleet.read", "feature_fleetv2.read"],\n             "resources": ["*"]\n         }]\n        }\n     }\n   }')),(0,R.jsx)(g.EuiSpacer,{size:"m"}))):null)};var Ei=a(40622);function yi(e,t){return`input {\n  elastic_agent {\n    port => 5044 ${e?'\n    ssl_enabled => true\n    ssl_certificate_authorities => ["<ca_path>"]\n    ssl_certificate => "<server_cert_path>"\n    ssl_key => "<server_cert_key_in_pkcs8>"\n    ssl_client_authentication => "required"':""}\n  }\n}\n\noutput {\n  elasticsearch {\n    hosts => "<es_host>"\n    api_key => "<api_key>"\n    data_stream => true\n    ssl_enabled => true\n    # ssl_certificate_authorities => "<elasticsearch_ca_path>"\n  }\n}`.replace("<api_key>",t||"<api_key>")}const ki=({isSSLEnabled:e})=>{const{docLinks:t}=(0,u.WeA)();return(0,R.jsx)(vi,{iconType:"info",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.calloutTitle",defaultMessage:"Additional Logstash configuration required"})},(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.description",defaultMessage:"Add an Elastic Agent pipeline configuration to Logstash to receive events from the Elastic Agent framework. {documentationLink}.",values:{documentationLink:(0,R.jsx)(g.EuiLink,{external:!0,href:t.links.logstash.inputElasticAgent},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.documentationLink",defaultMessage:"Learn more"}))}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(ji,{isSSLEnabled:e})))},vi=({children:e,...t})=>{const[a,l]=(0,s.useState)(!1),i=(0,u.iO7)().fleet.allSettings;return(0,R.jsx)(g.EuiCallOut,t,(0,R.jsx)(g.EuiSpacer,{size:"s"}),a?(0,R.jsx)(g.EuiButton,{onClick:()=>l(!1)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.collapseInstructionsButtonLabel",defaultMessage:"Collapse steps"})):(0,R.jsx)(Ei.m,{missingPrivilege:i?void 0:"Settings All",position:"left"},(0,R.jsx)(g.EuiButton,{onClick:()=>l(!0),fill:!0,disabled:!i},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.viewInstructionButtonLabel",defaultMessage:"View steps"}))),a&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),e))},ji=({isSSLEnabled:e})=>{const{docLinks:t}=(0,u.WeA)(),a=function(){const[e,t]=(0,s.useState)(!1),[a,l]=(0,s.useState)(),i=(0,u.WeA)(),{notifications:o}=i,r=(0,s.useCallback)((async()=>{try{var e;t(!0);const a=await(0,u.waY)();if(a.error)throw a.error;l(null===(e=a.data)||void 0===e?void 0:e.api_key)}catch(e){403===e.statusCode?o.toasts.addDanger({title:f.i18n.translate("xpack.fleet.settings.logstashInstructions.generateApiKeyError",{defaultMessage:"Cannot generate an API key"}),text:(0,it.toMountPoint)((0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.generateApiKeyPermissions",defaultMessage:"You need the cluster permissions: {clusterPermissions}{br} and the index permissions: {indexPermissions}{br}for indexes: {br}{indexes}",values:{clusterPermissions:(0,R.jsx)(g.EuiCode,null,te.pfJ.join(", ")),indexPermissions:(0,R.jsx)(g.EuiCode,null,te.MVu.join(", ")),indexes:te.xPW.map((e=>(0,R.jsx)(n().Fragment,{key:e},(0,R.jsx)(g.EuiCode,null,e),(0,R.jsx)("br",null)))),br:(0,R.jsx)("br",null)}}),i)},{}):o.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.logstashInstructions.generateApiKeyError",{defaultMessage:"Cannot generate an API key"})})}finally{t(!1)}}),[o.toasts,i]);return(0,s.useMemo)((()=>({isLoading:e,generateApiKey:r,apiKey:a})),[e,r,a])}(),l=(0,u.iO7)().fleet.allSettings,i=(0,s.useMemo)((()=>[{children:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.apiKeyStepDescription",defaultMessage:"We recommend authorizing Logstash to output to Elasticsearch with minimal privileges for Elastic Agent."}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),a.apiKey?(0,R.jsx)(g.EuiCodeBlock,{paddingSize:"m"},(0,R.jsx)("h5",null,"API Key"),a.apiKey,(0,R.jsx)("div",{className:"euiCodeBlock__controls"},(0,R.jsx)("div",{className:"euiCodeBlock__copyButton"},(0,R.jsx)(g.EuiCopy,{textToCopy:a.apiKey},(e=>(0,R.jsx)(g.EuiButtonIcon,{onClick:e,iconType:"copyClipboard",color:"text",disabled:!l,"aria-label":f.i18n.translate("xpack.fleet.settings.logstashInstructions.copyApiKeyButtonLabel",{defaultMessage:"Copy message"})})))))):(0,R.jsx)(g.EuiButton,{isLoading:a.isLoading,onClick:a.generateApiKey,disabled:!l},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.generateApiKeyButtonLabel",defaultMessage:"Generate API key"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}))},{children:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.editPipelineStepDescription",defaultMessage:"Next, open the {pipelineConfFile} file and insert the following content:",values:{pipelineConfFile:(0,R.jsx)(g.EuiCode,null,"elastic-agent-pipeline.conf")}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCodeBlock,{paddingSize:"m",language:"yaml",isCopyable:!0},yi(e,a.apiKey)))},{children:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.addPipelineStepDescription",defaultMessage:"In your Logstash configuration directory, open the {pipelineFile} file and add the following configuration. Replace the path to your file.",values:{pipelineFile:(0,R.jsx)(g.EuiCode,null,"pipelines.yml")}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCodeBlock,{paddingSize:"m",language:"yaml",isCopyable:!0},'- pipeline.id: elastic-agent-pipeline\n  path.config: "/etc/path/to/elastic-agent-pipeline.conf"\n'))},{children:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.replaceStepDescription",defaultMessage:"Replace the parts between the brackets with your generated SSL certificate file paths. View {documentationLink} to generate the certificates.",values:{documentationLink:(0,R.jsx)(g.EuiLink,{external:!0,href:t.links.fleet.secureLogstash},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.ourDocumentationLink",defaultMessage:"our documentation"}))}}),(0,R.jsx)(g.EuiSpacer,{size:"m"}))},{children:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.saveAndRestartStepDescription",defaultMessage:"Save the pipeline and restart Logstash so the changes take effect."}),(0,R.jsx)(g.EuiSpacer,{size:"m"}))}]),[a,t,l,e]);return(0,R.jsx)("ol",null,i.map(((e,t)=>(0,R.jsx)("li",{key:t},e.children))))},bi=()=>{const{docLinks:e}=(0,u.WeA)();return(0,R.jsx)(g.EuiCallOut,{iconType:"warning",color:"warning",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.calloutTitle",defaultMessage:"Additional setup required"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.calloutDescription",defaultMessage:"You must configure an encryption key before configuring this output. {link}",values:{link:(0,R.jsx)(g.EuiLink,{href:e.links.kibana.secureSavedObject,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.link",defaultMessage:"Learn more"}))}}))},Si=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:l,hasEncryptedSavedObjectConfigured:i}=e,{docLinks:o}=(0,u.WeA)(),[r,c]=n().useState(!0),[p,x]=n().useState({sslKey:!1});return(0,s.useEffect)((()=>{r&&(c(!1),a&&t.sslKeyInput.value&&!t.sslKeySecretInput.value&&(t.sslKeySecretInput.setValue(t.sslKeyInput.value),t.sslKeyInput.clear(),x({...p,sslKey:!0})))}),[a,t.sslKeyInput,t.sslKeySecretInput,r,c,p]),(0,R.jsx)(n().Fragment,null,!i&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(bi,null)),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiSwitch,(0,d.default)({label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashSSLSwitchLabel",{defaultMessage:"Enable SSL"})},t.logstashEnableSSLInput.props)),!t.logstashEnableSSLInput.value&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashSSLSwitchCalloutTitle",{defaultMessage:"Proceed with caution!"}),color:"warning",iconType:"warning"},(0,R.jsx)("p",null,f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashSSLSwitchCalloutMessage",{defaultMessage:"Using SSL/TLS ensures that your Elastic Agents send encrypted data to trusted Logstash servers, and that your Logstash servers receive data from trusted Elastic Agent clients."})))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(ki,{isSSLEnabled:t.logstashEnableSSLInput.value}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(al.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashHostsInputPlaceholder",{defaultMessage:"Specify host"}),sortable:!1,helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.logstashHostsInputDescription",defaultMessage:"Specify the addresses that your agents will use to connect to Logstash. {guideLink}.",values:{guideLink:(0,R.jsx)(g.EuiLink,{href:o.links.fleet.logstashSettings,target:"_blank",external:!0},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetSettingsLink",defaultMessage:"Learn more"}))}}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashHostsInputLabel",{defaultMessage:"Logstash hosts"})},t.logstashHostsInput.props)),(0,R.jsx)(g.EuiSpacer,{size:"m"}),t.logstashEnableSSLInput.value&&(0,R.jsx)(hl,{inputs:t,useSecretsStorage:a,isConvertedToSecret:p.sslKey,onToggleSecretAndClearValue:e=>{e?t.sslKeyInput.clear():t.sslKeySecretInput.setValue(""),x({sslKey:!1}),l(e)},type:t.typeInput.value}))},Fi=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:l}=e,{cloud:i}=(0,u.WeA)(),[o,r]=n().useState(!0),[c,p]=n().useState({sslKey:!1}),{enableSSLSecrets:x}=z.ZX.get();return(0,s.useEffect)((()=>{o&&(r(!1),a&&x&&t.sslKeyInput.value&&!t.sslKeySecretInput.value&&(t.sslKeySecretInput.setValue(t.sslKeyInput.value),t.sslKeyInput.clear(),p({...c,sslKey:!0})))}),[a,t.sslKeyInput,t.sslKeySecretInput,o,r,c,x]),(0,R.jsx)(n().Fragment,null,(0,R.jsx)(al.G,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.hostUrlInput",label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esHostsInputLabel",{defaultMessage:"Hosts"}),placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esHostsInputPlaceholder",{defaultMessage:"Specify host URL"})},t.elasticsearchUrlInput.props,{isUrl:!0,helpText:(null==i?void 0:i.isServerlessEnabled)&&(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serverlessHostUrlsHelpText",defaultMessage:"Custom host URLs are not allowed in serverless."})})),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputLabel",defaultMessage:"Elasticsearch CA trusted fingerprint (optional)"})},t.caTrustedFingerprintInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({fullWidth:!0},t.caTrustedFingerprintInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputPlaceholder",{defaultMessage:"Specify Elasticsearch CA trusted fingerprint"})}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(hl,{type:t.typeInput.value,inputs:t,useSecretsStorage:x&&a,isConvertedToSecret:c.sslKey,onToggleSecretAndClearValue:e=>{e?t.sslKeyInput.clear():t.sslKeySecretInput.setValue(""),p({sslKey:!1}),l(e)}}))},Mi=({defaultOutput:e,onClose:t,output:a,proxies:l})=>{(0,u.ifo)("settings");const i=function(e,t,a){var n,l,i,o,r,d,c,g,p,m,x,h,E,y,k,v,j,b,S,F,M,I,T,w,C,A,P,_,L,D,O,B,N,U,H,W,G,K,q,V,$,Y,Q,X,J,Z,ee,ae,se,ne,le,ie,oe,re,ue,de,ce,ge,pe,me,fe,xe,he,Ee,ye,ke,ve,je,be,Se,Fe,Me,Ie,Te,we,Ce,Ae,Pe,_e;const Le=(0,u.YI3)(),De=(0,u.iO7)(),{showExperimentalShipperOptions:Oe}=z.ZX.get(),Re=!(null!==(n=Le.missingOptionalFeatures)&&void 0!==n&&n.includes("encrypted_saved_object_encryption_key_required")),[Be,ze]=(0,s.useState)(!1),{notifications:Ne,cloud:Ue}=(0,u.WeA)(),{confirm:He}=(0,tl.fl)(),We=null!==(l=null==t?void 0:t.is_preconfigured)&&void 0!==l&&l,Ge=null!==(i=null==t?void 0:t.allow_edit)&&void 0!==i?i:[];function Ke(e){return!De.fleet.allSettings||!!We&&!Ge.includes(e)}const qe=(0,u.Gez)(null!==(o=null==t?void 0:t.name)&&void 0!==o?o:"",Jl,Ke("name")),Ve=(0,u.Gez)(null!==(r=null==t?void 0:t.type)&&void 0!==r?r:"elasticsearch",void 0,Ke("type")),$e=(0,u.Gez)(null!==(d=null==t?void 0:t.config_yaml)&&void 0!==d?d:"",Xl,Ke("config_yaml")),Ye=(0,u.MbH)(null!==(c=null==t?void 0:t.is_default)&&void 0!==c&&c,Ke("is_default")||(null==t?void 0:t.is_default)),Qe=(0,u.MbH)(null!==(g=null==t?void 0:t.is_default_monitoring)&&void 0!==g&&g,Ke("is_default_monitoring")||(null==t?void 0:t.is_default_monitoring)),Xe=(0,u.Gez)(null!==(p=null==t?void 0:t.ca_trusted_fingerprint)&&void 0!==p?p:"",ai,Ke("ca_trusted_fingerprint")),Je=null==Ue?void 0:Ue.isServerlessEnabled,Ze=!Je||null!=t&&t.hosts?(null==t?void 0:t.hosts)||[]:(null==a?void 0:a.hosts)||[],et=Je||Ke("hosts"),tt=(0,u.U6y)("esHostsComboxBox",Ze,Yl,et),at=(0,u.Gez)(null!==(m=null==t?void 0:t.preset)&&void 0!==m?m:(0,Al.lX)(null!==(x=null==t?void 0:t.config_yaml)&&void 0!==x?x:"",Ls.Hh),(()=>{}),Ke("preset")),st=(0,u.Gez)(null!==(h=null==t?void 0:t.service_token)&&void 0!==h?h:"",si,Ke("service_token")),nt=(0,u.YZM)(null!==(E=null==t||null===(y=t.secrets)||void 0===y?void 0:y.service_token)&&void 0!==E?E:"",ni,Ke("service_token")),lt=(0,u.MbH)(null!==(k=null==t?void 0:t.sync_integrations)&&void 0!==k&&k,Ke("sync_integrations")),it=(0,u.Gez)(null!==(v=null==t?void 0:t.kibana_api_key)&&void 0!==v?v:"",lt.value?li:void 0,Ke("kibana_api_key")),ot=(0,u.Gez)(null!==(j=null==t?void 0:t.kibana_url)&&void 0!==j?j:"",(e=>function(e,t){try{if(t&&!e)return[f.i18n.translate("xpack.fleet.settings.outputForm.urlRequiredError",{defaultMessage:"URL is required"})];if(!e)return;{const t=new URL(e);if(!["http:","https:"].includes(t.protocol))return[f.i18n.translate("xpack.fleet.settings.outputForm.invalidProtocolError",{defaultMessage:"Invalid protocol"})]}}catch(e){return[f.i18n.translate("xpack.fleet.settings.outputForm.invalidURLError",{defaultMessage:"Invalid URL"})]}}(e,lt.value)),Ke("kibana_url")),rt=(0,u.MbH)(null!==(b=null==t?void 0:t.sync_uninstalled_integrations)&&void 0!==b&&b,Ke("sync_uninstalled_integrations")),ut=null!=t&&t.config_yaml?(0,Ls.Hh)(null==t?void 0:t.config_yaml):{},dt=!(null!=ut&&ut.shipper)||!1===(null==ut||null===(S=ut.shipper)||void 0===S?void 0:S.enabled),ct=(0,u.MbH)(null!==(F=null==t||null===(M=t.shipper)||void 0===M?void 0:M.disk_queue_enabled)&&void 0!==F&&F),gt=(0,u.Gez)(null!==(I=null==t||null===(T=t.shipper)||void 0===T?void 0:T.disk_queue_path)&&void 0!==I?I:"",void 0,null!==(w=!ct.value)&&void 0!==w&&w),pt=(0,u.hp)(null!==(C=null==t||null===(A=t.shipper)||void 0===A?void 0:A.disk_queue_max_size)&&void 0!==C?C:4096,void 0,null!==(P=!ct.value)&&void 0!==P&&P),mt=(0,u.MbH)(null!==(_=null==t||null===(L=t.shipper)||void 0===L?void 0:L.disk_queue_encryption_enabled)&&void 0!==_&&_,null!==(D=!ct.value)&&void 0!==D&&D),ft=(0,u.MbH)(null!==(O=null==t||null===(B=t.shipper)||void 0===B?void 0:B.disk_queue_enabled)&&void 0!==O&&O),xt=(0,u.MbH)(null!==(N=null==t||null===(U=t.shipper)||void 0===U?void 0:U.disk_queue_compression_enabled)&&void 0!==N&&N),ht=Array.from(Array(10).keys()).slice(1).map((e=>({value:`${e}`,text:`Level ${e}`}))),Et=(0,u.aOf)(ht,null!==(H=`${null==t||null===(W=t.shipper)||void 0===W?void 0:W.compression_level}`)&&void 0!==H?H:ht[0].value,null!==(G=!xt.value)&&void 0!==G&&G),yt=(0,u.hp)((null==t||null===(K=t.shipper)||void 0===K?void 0:K.mem_queue_events)||void 0),kt=(0,u.hp)((null==t||null===(q=t.shipper)||void 0===q?void 0:q.queue_flush_timeout)||void 0),vt=(0,u.hp)((null==t||null===(V=t.shipper)||void 0===V?void 0:V.max_batch_bytes)||void 0),jt=Ke("ssl"),bt=(0,u.MbH)("logstash"!==(null==t?void 0:t.type)||Boolean(null==t?void 0:t.ssl),jt),St=(0,u.U6y)("logstashHostsComboxBox",null!==($=null==t?void 0:t.hosts)&&void 0!==$?$:[],Ql,Ke("hosts")),Ft=(0,u.U6y)("sslCertificateAuthoritiesComboxBox",null!==(Y=null==t||null===(Q=t.ssl)||void 0===Q?void 0:Q.certificate_authorities)&&void 0!==Y?Y:[],void 0,jt),Mt=(0,u.Gez)(null!==(X=null==t||null===(J=t.ssl)||void 0===J?void 0:J.certificate)&&void 0!==X?X:"","logstash"===(null==t?void 0:t.type)&&bt.value?ii:void 0,jt),It=(0,u.Gez)(null!==(Z=null==t||null===(ee=t.ssl)||void 0===ee?void 0:ee.key)&&void 0!==Z?Z:"","logstash"===(null==t?void 0:t.type)&&bt.value?oi:void 0,jt),Tt=(0,u.YZM)(null==t||null===(ae=t.secrets)||void 0===ae||null===(se=ae.ssl)||void 0===se?void 0:se.key,"logstash"===(null==t?void 0:t.type)&&bt.value?ri:void 0,jt),wt=(0,u.Gez)(null!==(ne=null==t?void 0:t.proxy_id)&&void 0!==ne?ne:"",(()=>{}),Ke("proxy_id")),Ct=t,At=(0,u.Gez)(null!==(le=null==Ct?void 0:Ct.version)&&void 0!==le?le:"1.0.0",void 0,Ke("version")),Pt=(0,u.U6y)("kafkaHostsComboBox",null!==(ie=null==t?void 0:t.hosts)&&void 0!==ie?ie:[],$l,Ke("hosts")),_t=(0,u.RIP)(null!==(oe=null==Ct?void 0:Ct.auth_type)&&void 0!==oe?oe:te.NB8.None,Ke("auth_type")),Lt=(0,u.RIP)(null!==(re=null==Ct?void 0:Ct.connection_type)&&void 0!==re?re:te.zPI.Plaintext,Ke("connection_type")),Dt=(0,u.Gez)(null!==(ue=null==Ct?void 0:Ct.username)&&void 0!==ue?ue:void 0,_t.value===te.NB8.Userpass?Zl:void 0,Ke("username")),Ot=(0,u.Gez)(null!==(de=null==Ct?void 0:Ct.password)&&void 0!==de?de:void 0,_t.value===te.NB8.Userpass?ei:void 0,Ke("password")),Rt=(0,u.YZM)(null==Ct||null===(ce=Ct.secrets)||void 0===ce?void 0:ce.password,_t.value===te.NB8.Userpass?ti:void 0,Ke("password")),Bt=(0,u.U6y)("kafkaSslCertificateAuthoritiesComboBox",null!==(ge=null==Ct||null===(pe=Ct.ssl)||void 0===pe?void 0:pe.certificate_authorities)&&void 0!==ge?ge:[],void 0,jt),zt=(0,u.Gez)(null==Ct||null===(me=Ct.ssl)||void 0===me?void 0:me.certificate,_t.value===te.NB8.Ssl?ii:void 0,jt),Nt=(0,u.Gez)(null==Ct||null===(fe=Ct.ssl)||void 0===fe?void 0:fe.key,_t.value===te.NB8.Ssl?oi:void 0,jt),Ut=(0,u.YZM)(null==Ct||null===(xe=Ct.secrets)||void 0===xe||null===(he=xe.ssl)||void 0===he?void 0:he.key,_t.value===te.NB8.Ssl?ri:void 0,jt),Ht=(0,u.Gez)(null!==(Ee=null==Ct||null===(ye=Ct.ssl)||void 0===ye?void 0:ye.verification_mode)&&void 0!==Ee?Ee:te.i36.Full,void 0,jt),Wt=(0,u.RIP)(null!==(ke=null==Ct||null===(ve=Ct.sasl)||void 0===ve?void 0:ve.mechanism)&&void 0!==ke?ke:te.N9h.Plain,Ke("sasl")),Gt=(0,u.RIP)(null!==(je=null==Ct?void 0:Ct.partition)&&void 0!==je?je:te.BwZ.Random,Ke("partition")),Kt=(0,u.Gez)(null!=Ct&&null!==(be=Ct.random)&&void 0!==be&&be.group_events?`${Ct.random.group_events}`:"1",Gt.value===te.BwZ.Random?gi:void 0,Ke("partition")),qt=(0,u.Gez)(null==Ct||null===(Se=Ct.hash)||void 0===Se?void 0:Se.hash,void 0,Ke("partition")),Vt=(0,u.Gez)(null!=Ct&&null!==(Fe=Ct.round_robin)&&void 0!==Fe&&Fe.group_events?`${Ct.round_robin.group_events}`:"1",Gt.value===te.BwZ.RoundRobin?gi:void 0,Ke("partition")),$t=(0,u.RIP)(null!=Ct&&Ct.topic&&null!=Ct&&null!==(Me=Ct.topic)&&void 0!==Me&&Me.includes("%{[")?te.LXo.Dynamic:te.LXo.Static,Ke("topic")),Yt=(0,u.Gez)(null!=(Qt=Ct)&&null!==(Xt=Qt.topic)&&void 0!==Xt&&Xt.includes("%{[")?"":(null==Qt?void 0:Qt.topic)||"",$t.value===te.LXo.Static?ui:void 0,Ke("topic"));var Qt,Xt;const Jt=(0,u.whI)("kafkaDynamicTopicComboBox",function(e){var t;if(null==e||!e.topic||null!=e&&e.topic&&(null===(t=e.topic)||void 0===t||!t.includes("%{[")))return[];const a=e.topic.match(/(%\{\[)(\S*)(\]\})/),s=null!=a&&a.length?a[2]:"";return[{label:s,value:s}]}(Ct),$t.value===te.LXo.Dynamic?di:void 0,Ke("topic")),Zt=(0,u.kt3)("kafkaHeadersComboBox",null!==(Ie=null==Ct?void 0:Ct.headers)&&void 0!==Ie?Ie:[{key:"",value:""}],pi,Ke("headers")),ea=(0,u.Gez)(null!==(Te=null==Ct?void 0:Ct.client_id)&&void 0!==Te?Te:"Elastic",ci,Ke("client_id")),ta=(0,u.MbH)(!(null==Ct||!Ct.compression||Ct.compression===te.jZS.None),Ke("compression")),aa=(0,u.Gez)(`${null!==(we=null==Ct?void 0:Ct.compression_level)&&void 0!==we?we:4}`,void 0,Ke("compression_level")),sa=(0,u.Gez)(null!=Ct&&Ct.compression&&Ct.compression!==te.jZS.None?Ct.compression:te.jZS.Gzip,void 0,Ke("compression")),na=(0,u.Gez)(`${null!==(Ce=null==Ct?void 0:Ct.timeout)&&void 0!==Ce?Ce:30}`,void 0,Ke("broker_timeout")),la=(0,u.Gez)(`${null!==(Ae=null==Ct?void 0:Ct.broker_timeout)&&void 0!==Ae?Ae:30}`,void 0,Ke("timeout")),ia=(0,u.Gez)(`${null!==(Pe=null==Ct?void 0:Ct.required_acks)&&void 0!==Pe?Pe:te.NAW.Commit}`,void 0,Ke("required_acks")),oa=(0,u.Gez)(null==Ct?void 0:Ct.key,void 0,Ke("key")),ra=(0,u.MbH)(null!==(_e=null==t?void 0:t.write_to_logs_streams)&&void 0!==_e&&_e,!1),ua=Ve.value===te.gf.Logstash,da=Ve.value===te.gf.Kafka,ca=Ve.value===te.gf.RemoteElasticsearch,ga={nameInput:qe,typeInput:Ve,elasticsearchUrlInput:tt,diskQueueEnabledInput:ct,diskQueuePathInput:gt,diskQueueEncryptionEnabled:mt,diskQueueMaxSizeInput:pt,diskQueueCompressionEnabled:xt,compressionLevelInput:Et,logstashEnableSSLInput:bt,logstashHostsInput:St,presetInput:at,additionalYamlConfigInput:$e,defaultOutputInput:Ye,defaultMonitoringOutputInput:Qe,caTrustedFingerprintInput:Xe,serviceTokenInput:st,serviceTokenSecretInput:nt,kibanaAPIKeyInput:it,syncIntegrationsInput:lt,kibanaURLInput:ot,syncUninstalledIntegrationsInput:rt,sslCertificateInput:Mt,sslKeyInput:It,sslKeySecretInput:Tt,sslCertificateAuthoritiesInput:Ft,proxyIdInput:wt,loadBalanceEnabledInput:ft,memQueueEvents:yt,queueFlushTimeout:kt,maxBatchBytes:vt,kafkaVersionInput:At,kafkaHostsInput:Pt,kafkaVerificationModeInput:Ht,kafkaAuthMethodInput:_t,kafkaConnectionTypeInput:Lt,kafkaAuthUsernameInput:Dt,kafkaAuthPasswordInput:Ot,kafkaAuthPasswordSecretInput:Rt,kafkaSaslMechanismInput:Wt,kafkaPartitionTypeInput:Gt,kafkaPartitionTypeRandomInput:Kt,kafkaPartitionTypeHashInput:qt,kafkaPartitionTypeRoundRobinInput:Vt,kafkaHeadersInput:Zt,kafkaClientIdInput:ea,kafkaCompressionInput:ta,kafkaCompressionLevelInput:aa,kafkaCompressionCodecInput:sa,kafkaBrokerTimeoutInput:na,kafkaBrokerReachabilityTimeoutInput:la,kafkaBrokerAckReliabilityInput:ia,kafkaKeyInput:oa,kafkaSslCertificateAuthoritiesInput:Bt,kafkaSslCertificateInput:zt,kafkaSslKeyInput:Nt,kafkaSslKeySecretInput:Ut,kafkaTopicsInput:$t,kafkaStaticTopicInput:Yt,kafkaDynamicTopicInput:Jt,writeToStreams:ra},pa=Object.values(ga).some((e=>e.hasChanged)),ma=(0,s.useCallback)((()=>{const e=qe.validate(),t=tt.validate(),a=Pt.validate(),s=Dt.validate(),n=Ot.validate(),l=Rt.validate(),i=ea.validate(),o=zt.validate(),r=Nt.validate(),u=Ut.validate(),d=Zt.validate(),c=St.validate(),g=$e.validate(),p=Xe.validate(),m=st.validate(),f=nt.validate(),x=it.validate(),h=ot.validate(),E=Mt.validate(),y=It.validate(),k=Tt.validate(),v=gt.validate(),j=Kt.validate(),b=Vt.validate(),S=Yt.validate(),F=Jt.validate(),M=Nt.value?r:u,I=Ot.value?n:l;return ua?c&&g&&e&&E&&(y||k):da?e&&a&&o&&M&&s&&I&&d&&g&&i&&j&&b&&S&&F:ca?t&&g&&e&&(st.value&&m||nt.value&&f)&&(!lt.value&&h||lt.value&&it.value&&x&&h):t&&g&&e&&p&&v}),[qe,tt,Pt,Dt,Ot,Rt,ea,zt,Nt,Ut,Zt,St,$e,Xe,st,nt,it,lt,ot,Mt,It,Tt,gt,Kt,Vt,Yt,Jt,ua,da,ca]),fa=(0,s.useCallback)((async()=>{try{if(!ma())return;ze(!0);let a={};dt||(a={shipper:{mem_queue_events:yt.value?Number(yt.value):null,queue_flush_timeout:kt.value?Number(kt.value):null,max_batch_bytes:vt.value?Number(vt.value):null}}),!dt&&Oe&&(a={...a,shipper:{disk_queue_enabled:ct.value,disk_queue_path:ct.value&&gt.value?gt.value:"",disk_queue_max_size:ct.value&&pt.value?pt.value:null,disk_queue_encryption_enabled:ct.value&&mt.value,disk_queue_compression_enabled:xt.value,compression_level:xt.value?Number(Et.value):null,loadbalance:ft.value}});const s=""!==wt.value?wt.value:null,n=(()=>{const e=e=>{if(void 0!==e){const t=parseInt(e,10);if(!isNaN(t))return t}};switch(Ve.value){case te.gf.Kafka:const n=Bt.value.filter((e=>""!==e)).length,l=function(e){const t={};return!e.kafkaSslKeyInput.value&&e.kafkaSslKeySecretInput.value&&(t.ssl={key:e.kafkaSslKeySecretInput.value}),!e.kafkaAuthPasswordInput.value&&e.kafkaAuthPasswordSecretInput.value&&(t.password=e.kafkaAuthPasswordSecretInput.value),Object.keys(t).length?t:null}({kafkaSslKeyInput:Nt,kafkaSslKeySecretInput:Ut,kafkaAuthPasswordInput:Ot,kafkaAuthPasswordSecretInput:Rt});return{name:qe.value,type:te.gf.Kafka,hosts:Pt.value,is_default:Ye.value,is_default_monitoring:Qe.value,config_yaml:$e.value,...Lt.value!==te.zPI.Plaintext||_t.value!==te.NB8.None?{ssl:{...n?{certificate_authorities:Bt.value.filter((e=>""!==e))}:{},..._t.value===te.NB8.Ssl?{certificate:zt.value,key:Nt.value}:{},verification_mode:Ht.value}}:{},proxy_id:s,client_id:ea.value||void 0,version:At.value,...oa.value?{key:oa.value}:{},compression:ta.value?sa.value:te.jZS.None,...ta.value&&sa.value===te.jZS.Gzip?{compression_level:e(aa.value)}:{},auth_type:_t.value,..._t.value===te.NB8.None?{connection_type:Lt.value}:{},..._t.value===te.NB8.Userpass&&Dt.value?{username:Dt.value}:{},..._t.value===te.NB8.Userpass&&Ot.value?{password:Ot.value}:{},..._t.value===te.NB8.Userpass&&Wt.value?{sasl:{mechanism:Wt.value}}:{},partition:Gt.value,...Gt.value===te.BwZ.Random&&Kt.value?{random:{group_events:e(Kt.value)}}:{},...Gt.value===te.BwZ.RoundRobin&&Vt.value?{round_robin:{group_events:e(Vt.value)}}:{},...Gt.value===te.BwZ.Hash&&qt.value?{hash:{hash:qt.value}}:{},...$t.value===te.LXo.Static&&Yt.value?{topic:Yt.value}:$t.value===te.LXo.Dynamic&&Jt.value?{topic:`%{[${Jt.value}]}`}:{},headers:Zt.value,timeout:e(na.value),broker_timeout:e(la.value),required_acks:e(ia.value),...a,...l?{secrets:l}:{}};case te.gf.Logstash:return{name:qe.value,type:te.gf.Logstash,hosts:St.value,is_default:Ye.value,is_default_monitoring:Qe.value,config_yaml:$e.value,ssl:bt.value?{certificate:Mt.value,key:It.value||void 0,certificate_authorities:Ft.value.filter((e=>""!==e))}:null,...!It.value&&Tt.value&&{secrets:{ssl:bt.value?{key:Tt.value}:void 0}},proxy_id:s,...a};case te.gf.RemoteElasticsearch:let i;var t;return!st.value&&nt.value&&(i={service_token:nt.value}),!It.value&&Tt.value&&(i={...null!==(t=i)&&void 0!==t?t:{},ssl:{key:Tt.value}}),{name:qe.value,type:te.gf.RemoteElasticsearch,hosts:tt.value,is_default:Ye.value,is_default_monitoring:Qe.value,preset:at.value,config_yaml:$e.value,service_token:st.value||void 0,kibana_api_key:it.value||void 0,...i?{secrets:i}:{},sync_integrations:lt.value,kibana_url:ot.value||null,sync_uninstalled_integrations:rt.value,proxy_id:s,write_to_logs_streams:ra.value,...a,ssl:{certificate:Mt.value,key:It.value||void 0,certificate_authorities:Ft.value.filter((e=>""!==e))}};case te.gf.Elasticsearch:default:return{name:qe.value,type:te.gf.Elasticsearch,hosts:tt.value,is_default:Ye.value,is_default_monitoring:Qe.value,preset:at.value,config_yaml:$e.value,ca_trusted_fingerprint:Xe.value,proxy_id:s,write_to_logs_streams:ra.value,...a,ssl:{certificate:Mt.value,key:It.value||void 0,certificate_authorities:Ft.value.filter((e=>""!==e))},...!It.value&&Tt.value&&{secrets:{ssl:{key:Tt.value}}}}}})();if(t){if(!await async function(e,t){const{agentCount:a,agentPolicyCount:s}=await cl(e).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));return t((0,R.jsx)(mi,null),(0,R.jsx)(fi,{agentCount:a,agentPolicyCount:s,output:e}))}(t,He))return void ze(!1);const e=await(0,u.xEL)(t.id,n);if(e.error)throw e.error}else{const e=await(0,u.S6i)(n);if(e.error)throw e.error}e(),ze(!1)}catch(e){ze(!1),Ne.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.outputForm.errorToastTitle",{defaultMessage:"Error while saving output"})})}}),[ma,dt,Oe,wt.value,t,e,yt.value,kt.value,vt.value,ct.value,gt.value,pt.value,mt.value,xt.value,Et.value,ft.value,Ve.value,Bt.value,Nt,Ut,Ot,Rt,qe.value,Pt.value,Ye.value,Qe.value,$e.value,Lt.value,_t.value,zt.value,Ht.value,ea.value,At.value,oa.value,ta.value,sa.value,aa.value,Dt.value,Wt.value,Gt.value,Kt.value,Vt.value,qt.value,$t.value,Yt.value,Jt.value,Zt.value,na.value,la.value,ia.value,bt.value,St.value,Mt.value,It.value,Ft.value,Tt.value,tt.value,at.value,st.value,nt.value,it.value,lt.value,rt.value,ot.value,Xe.value,ra.value,He,Ne.toasts]);return{inputs:ga,submit:fa,isLoading:Be,hasEncryptedSavedObjectConfigured:Re,isShipperEnabled:!dt,isDisabled:Be||t&&!pa||ua&&!Re}}(t,a,e),o=i.inputs,{docLinks:r,cloud:c}=(0,u.WeA)(),p=(0,u.YI3)(),x=!(null==c||!c.isServerlessEnabled),[h,E]=(0,s.useState)("disabled");void 0!==p.isSecretsStorageEnabled&&"disabled"===h&&E(p.isSecretsStorageEnabled);const y=e=>{"disabled"!==h&&E(e)},k=!0===h,v=(0,s.useMemo)((()=>l.map((e=>({value:e.id,label:e.name})))),[l]),j=o.typeInput.value===te.gf.RemoteElasticsearch,b=o.typeInput.value===te.gf.Elasticsearch,S=!!o.typeInput.value&&(0,Al.$N)(o.typeInput.value),F=!(null!=c&&c.isServerlessEnabled),I=[{value:te.gf.Elasticsearch,text:"Elasticsearch"},...F?[{value:te.gf.RemoteElasticsearch,text:"Remote Elasticsearch"}]:[],{value:te.gf.Logstash,text:"Logstash"},{value:te.gf.Kafka,text:"Kafka"}],T=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(g.EuiFlyout,{onClose:t,maxWidth:M.MW,"aria-labelledby":T},(0,R.jsx)(g.EuiFlyoutHeader,{hasBorder:!0},(0,R.jsx)(g.EuiTitle,{size:"m"},(0,R.jsx)("h2",{id:T},a?(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.editTitle",defaultMessage:"Edit output"}):(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.createTitle",defaultMessage:"Add new output"})))),(0,R.jsx)(g.EuiFlyoutBody,null,(null==a?void 0:a.is_preconfigured)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiCallOut,{announceOnMount:!0,iconType:"lock",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutTitle",defaultMessage:"This output is managed outside of Fleet"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutDescription",defaultMessage:"Most actions related to this output are unavailable. Refer to your kibana config for more detail."})),(0,R.jsx)(g.EuiSpacer,{size:"m"})),(0,R.jsx)(g.EuiForm,null,(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.nameInputLabel",defaultMessage:"Name"})},o.nameInput.formRowProps),(0,R.jsx)(g.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.nameInput",fullWidth:!0},o.nameInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}))),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.typeInputLabel",defaultMessage:"Type"}))},(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.typeInput"},o.typeInput.props,{options:I})),b||j?(0,R.jsx)(n().Fragment,null,x?null:(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(g.EuiCallOut,{announceOnMount:!0,"data-test-subj":`settingsOutputsFlyout.${o.typeInput.value}OutputTypeCallout`,title:(()=>{switch(o.typeInput.value){default:case te.gf.Elasticsearch:return f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esOutputTypeCallout",{defaultMessage:"This output type does not support connectivity to a remote Elasticsearch cluster, please use the Remote Elasticsearch type for that."});case te.gf.RemoteElasticsearch:return f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESOutputTypeCallout",{defaultMessage:"Remote Elasticsearch output does not support connectivity to a serverless project."})}})(),iconType:"alert",color:"warning",size:"s",heading:"p"})),j?(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiText,{size:"s"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.remoteESTypeText",defaultMessage:"Enter your output hosts, service token for your remote cluster, and any advanced YAML configuration. Learn more about how to use these parameters in {doc}.",values:{doc:(0,R.jsx)(g.EuiLink,{href:r.links.fleet.remoteESOoutput,target:"_blank"},f.i18n.translate("xpack.fleet.settings.editOutputFlyout.docLabel",{defaultMessage:"our documentation"}))}}))):null):null)),(e=>{switch(e){case te.gf.Logstash:return(0,R.jsx)(Si,{inputs:o,useSecretsStorage:k,onToggleSecretStorage:y,hasEncryptedSavedObjectConfigured:i.hasEncryptedSavedObjectConfigured});case te.gf.Kafka:return(0,R.jsx)(Ul,{inputs:o,useSecretsStorage:k,onToggleSecretStorage:y});case te.gf.RemoteElasticsearch:return(0,R.jsx)(hi,{inputs:o,useSecretsStorage:k,onToggleSecretStorage:y});case te.gf.Elasticsearch:default:return(0,R.jsx)(Fi,{inputs:o,useSecretsStorage:k,onToggleSecretStorage:y})}})(o.typeInput.value),j?null:(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.proxyIdLabel",defaultMessage:"Proxy"})},(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.proxyIdInput"},o.proxyIdInput.props,{onChange:e=>{var t,a;return o.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==o.proxyIdInput.value?v.filter((e=>e.value===o.proxyIdInput.value)):[],options:v,singleSelection:{asPlainText:!0},isDisabled:o.proxyIdInput.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})})),(0,R.jsx)(g.EuiSpacer,{size:"xs"}),(0,R.jsx)(ll,null))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.defaultOutputInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({},o.defaultOutputInput.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.defaultOutputSwitchLabel",defaultMessage:"Make this output the default for {boldAgentIntegrations}.",values:{boldAgentIntegrations:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.agentIntegrationsBold",defaultMessage:"agent integrations"}))}})}))),(0,R.jsx)(g.EuiFormRow,(0,d.default)({fullWidth:!0},o.defaultMonitoringOutputInput.formRowProps),(0,R.jsx)(g.EuiSwitch,(0,d.default)({},o.defaultMonitoringOutputInput.props,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.defaultMontoringOutputSwitchLabel",defaultMessage:"Make this output the default for {boldAgentMonitoring}.",values:{boldAgentMonitoring:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.agentMonitoringBold",defaultMessage:"agent monitoring"}))}})}))),S&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"l"}),(0,R.jsx)(g.EuiFormRow,{fullWidth:!0,label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningLabel",defaultMessage:"Performance tuning"}),helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningHelpText",defaultMessage:"Performance tuning presets are curated output settings for common use cases. You can also select {custom} to specify your own settings in the Advanced YAML Configuration box below. For a detailed list of settings configured by each preset, see {link}.",values:{custom:(0,R.jsx)("strong",null,"Custom"),link:(0,R.jsx)(g.EuiLink,{href:r.links.fleet.performancePresets,external:!0,target:"_blank"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningHelpTextLink",defaultMessage:"our documentation"}))}})},(0,R.jsx)(g.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.presetInput"},o.presetInput.props,{onChange:e=>o.presetInput.setValue(e.target.value),disabled:o.presetInput.props.disabled||(0,Al.o8)(o.additionalYamlConfigInput.value,Ls.Hh),options:[{value:"balanced",text:"Balanced"},{value:"custom",text:"Custom"},{value:"throughput",text:"Throughput"},{value:"scale",text:"Scale"},{value:"latency",text:"Latency"}]})))),(b||j)&&(0,R.jsx)(g.EuiFormRow,{helpText:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.writeToStreamsHelpText",defaultMessage:"When enabled, adds logs and logs.* to the output streams configuration in the agent policy."})},(0,R.jsx)(g.EuiSwitch,{label:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.writeToStreamsLabel",defaultMessage:"Write to logs streams"}),checked:o.writeToStreams.value,onChange:e=>o.writeToStreams.setValue(e.target.checked)})),S&&(0,Al.o8)(o.additionalYamlConfigInput.value,Ls.Hh)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{announceOnMount:!0,color:"warning",iconType:"alert",size:"s",title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarning",defaultMessage:'Performance tuning preset must be "Custom" due to presence of reserved key in advanced YAML configuration'})},(0,R.jsx)(g.EuiAccordion,{id:"performanceTuningMustBeCustomWarningDetails",buttonContent:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarningDetails",defaultMessage:"Show reserved keys"})},(0,R.jsx)("ul",null,te.uhU.map((e=>(0,R.jsx)("li",{key:e},(0,R.jsx)(g.EuiCode,null,e)))))))),(0,R.jsx)(g.EuiSpacer,{size:"l"}),(0,R.jsx)(g.EuiFormRow,(0,d.default)({label:(0,R.jsx)(g.EuiLink,{href:r.links.fleet.esSettings,external:!0,target:"_blank"},f.i18n.translate("xpack.fleet.settings.editOutputFlyout.yamlConfigInputLabel",{defaultMessage:"Advanced YAML configuration"}))},o.additionalYamlConfigInput.formRowProps,{fullWidth:!0}),(0,R.jsx)(ql,{value:o.additionalYamlConfigInput.value,onChange:e=>{(0,Al.o8)(e,Ls.Hh)&&o.presetInput.setValue("custom"),o.additionalYamlConfigInput.setValue(e)},disabled:o.additionalYamlConfigInput.props.disabled,placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.yamlConfigInputPlaceholder",{defaultMessage:"# YAML settings here will be added to the output section of each agent policy."})})),(0,R.jsx)(xi,{enabled:i.isShipperEnabled,inputs:o})),null!=a&&a.id&&"remote_elasticsearch"===a.type?(0,R.jsx)(Pn,{output:a}):null),(0,R.jsx)(g.EuiFlyoutFooter,null,(0,R.jsx)(g.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButtonEmpty,{onClick:t,flush:"left"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{fill:!0,isLoading:i.isLoading,isDisabled:i.isDisabled,onClick:i.submit,"data-test-subj":"saveApplySettingsBtn"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},Ii=(0,tl.$H)((()=>{var e,t,a,n,l,i,d,c,p;(0,u.ifo)("settings");const m=(0,o.useHistory)(),x=(0,u.Wdf)(),{outputs:h,fleetServerHosts:E,downloadSources:y,proxies:k}={outputs:(0,u.Eiq)(),fleetServerHosts:(0,u.OVZ)(),downloadSources:(0,u.SFz)(),proxies:(0,u.qyb)()},v=null===(e=h.data)||void 0===e?void 0:e.items.filter((e=>!e.is_internal)),j=null===(t=E.data)||void 0===t?void 0:t.items.filter((e=>!e.is_internal)),{deleteOutput:b}=function(e){const{confirm:t}=(0,tl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteOutput:(0,s.useCallback)((async s=>{try{const{agentCount:a,agentPolicyCount:n}=await cl(s).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));if(!await t((0,R.jsx)(gl,null),(0,R.jsx)(pl,{output:s,agentCount:a,agentPolicyCount:n}),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteOutputs.confirmButtonLabel",{defaultMessage:"Delete and deploy"})}))return;const l=await(0,u.pE1)(s.id);if(l.error)throw l.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteOutputs.errorToastTitle",{defaultMessage:"Error deleting output"})})}}),[t,a.toasts,e])}}(h.resendRequest),{deleteDownloadSource:S}=function(e){const{confirm:t}=(0,tl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteDownloadSource:(0,s.useCallback)((async s=>{try{const{agentCount:a,agentPolicyCount:n}=await El(s).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));if(!await t((0,R.jsx)(bl,null),(0,R.jsx)(Sl,{"data-test-subj":"editDownloadSourcesDeleteModal.confirmModalText",downloadSource:s,agentCount:a,agentPolicyCount:n}),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteDownloadSource.confirmButtonLabel",{defaultMessage:"Delete and deploy"})}))return;const l=await(0,u.taj)(s.id);if(l.error)throw l.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteDownloadSource.errorToastTitle",{defaultMessage:"Error deleting agent binary source."})})}}),[t,a.toasts,e])}}(y.resendRequest),{deleteFleetServerHost:T}=function(e){const{confirm:t}=(0,tl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteFleetServerHost:(0,s.useCallback)((async s=>{try{if(!await t((0,R.jsx)(ml,null),(0,R.jsx)(fl,null),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteFleetServerHosts.confirmButtonLabel",{defaultMessage:"Delete and deploy changes"})}))return;const a=await(0,u.D7A)(s.id);if(a.error)throw a.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteFleetServerHosts.errorToastTitle",{defaultMessage:"Error deleting Fleet Server hosts"})})}}),[t,a.toasts,e])}}(E.resendRequest),{deleteFleetProxy:w}=function(e){const{confirm:t}=(0,tl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteFleetProxy:(0,s.useCallback)((async s=>{try{if(!await t((0,R.jsx)(ul,null),(0,R.jsx)(dl,null),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteFleetProxy.confirmButtonLabel",{defaultMessage:"Delete and deploy changes"})}))return;const a=await(0,u.mwZ)(s.id);if(a.error)throw a.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteFleetProxy.errorToastTitle",{defaultMessage:"Error deleting proxy"})})}}),[t,a.toasts,e])}}(k.resendRequest),C=h.resendRequest,A=y.resendRequest,P=E.resendRequest,_=k.resendRequest,L=(0,s.useCallback)((()=>{x.closeFleetServerFlyout(),C(),A(),P(),_(),m.replace(M.tn.settings()[1])}),[x,C,A,P,_,m]),{cloud:D}=(0,u.WeA)(),O=null==D?void 0:D.isServerlessEnabled;return h.isLoading&&h.isInitialRequest||!v||E.isLoading&&E.isInitialRequest||!j||y.isLoading&&y.isInitialRequest||null===(a=y.data)||void 0===a||!a.items||k.isLoading&&k.isInitialRequest||null===(n=k.data)||void 0===n||!n.items?(0,R.jsx)(I.iW,{section:"settings"},(0,R.jsx)(F.Rh,null)):(0,R.jsx)(I.iW,{section:"settings"},(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.settings_edit_fleet_server_hosts},(e=>{var t,a;const s=j.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.itemId)===t.id}));return s?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(rl,{proxies:null!==(t=null===(a=k.data)||void 0===a?void 0:a.items)&&void 0!==t?t:[],onClose:L,fleetServerHost:s})):(0,R.jsx)(o.Redirect,{to:M.X5.settings})})),(0,R.jsx)(r.Route,{path:M.X5.settings_create_fleet_server_hosts},(0,R.jsx)(g.EuiPortal,null,O?(0,R.jsx)(rl,{proxies:null!==(l=null===(i=k.data)||void 0===i?void 0:i.items)&&void 0!==l?l:[],onClose:L,defaultFleetServerHost:null===(d=E.data)||void 0===d?void 0:d.items.find((e=>e.id===te.Z24))}):(0,R.jsx)(F.Jh,{onClose:L}))),(0,R.jsx)(r.Route,{path:M.X5.settings_create_outputs},(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Mi,{proxies:k.data.items,onClose:L,defaultOutput:O?null===(c=h.data)||void 0===c?void 0:c.items.find((e=>e.id===te.VE)):void 0}))),(0,R.jsx)(r.Route,{path:M.X5.settings_create_fleet_proxy},(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Cl,{onClose:L}))),(0,R.jsx)(r.Route,{path:M.X5.settings_edit_fleet_proxy},(e=>{var t;const a=null===(t=k.data)||void 0===t?void 0:t.items.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.itemId)===t.id}));return a?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Cl,{onClose:L,fleetProxy:a})):(0,R.jsx)(o.Redirect,{to:M.X5.settings})})),(0,R.jsx)(r.Route,{path:M.X5.settings_edit_outputs},(e=>{var t,a,s;const n=v.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.outputId)===t.id}));return n?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(Mi,{proxies:null!==(t=null===(a=k.data)||void 0===a?void 0:a.items)&&void 0!==t?t:[],onClose:L,output:n,defaultOutput:O?null===(s=h.data)||void 0===s?void 0:s.items.find((e=>e.id===te.VE)):void 0})):(0,R.jsx)(o.Redirect,{to:M.X5.settings})})),(0,R.jsx)(r.Route,{path:M.X5.settings_create_download_sources},(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(jl,{onClose:L,proxies:(null==k||null===(p=k.data)||void 0===p?void 0:p.items)||[]}))),(0,R.jsx)(r.Route,{path:M.X5.settings_edit_download_sources},(e=>{var t,a;const s=null===(t=y.data)||void 0===t?void 0:t.items.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.downloadSourceId)===t.id}));return s?(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(jl,{onClose:L,downloadSource:s,proxies:(null==k||null===(a=k.data)||void 0===a?void 0:a.items)||[]})):(0,R.jsx)(o.Redirect,{to:M.X5.settings})}))),(0,R.jsx)(el,{deleteFleetProxy:w,proxies:k.data.items,outputs:v,fleetServerHosts:j,deleteOutput:b,deleteFleetServerHost:T,downloadSources:y.data.items,deleteDownloadSource:S}))})),Ti=({value:e})=>(0,R.jsx)(Hl.CodeEditor,{isCopyable:!0,languageId:"",height:"600px",width:"100%",options:{minimap:{enabled:!1},scrollBeyondLastLine:!1,readOnly:!0,tabSize:2,lineNumbers:"off",lineNumbersMinChars:0,glyphMargin:!1,lineDecorationsWidth:0,overviewRulerBorder:!1},value:e}),wi=async()=>{const e=await(0,u.cnO)({full:!0,perPage:100,sortOrder:"asc"});if(e.error)throw new Error(e.error.message);return e};var Ci=a(10885);const Ai=async()=>{var e;const t=await(0,u.OQl)({prerelease:!0});if(t.error)throw new Error(t.error.message);return null===(e=t.data)||void 0===e?void 0:e.items.filter((({status:e})=>"installed"===e))},Pi=({name:e,setName:t,type:a,setNamesStatus:n})=>{const{data:l,status:i}=(0,x.useQuery)(["debug-saved-object-names",a],(()=>(async e=>{var t;const a=await(0,u.w$b)({method:"post",path:T.xw.getSavedObjectNamesPath(),body:{type:e},version:te.BoD.internal.v1});if(a.error)throw new Error(a.error.message);return null===(t=a.data)||void 0===t?void 0:t.aggregations.names.buckets})(a)),{refetchOnWindowFocus:!1});(0,s.useEffect)((()=>{n(i)}),[i,n]);const o=(null!=l?l:[]).map((e=>({label:e.key,value:e.key}))),r=o.find((t=>t.value===e)),d=r?[r]:[];return(0,R.jsx)(g.EuiComboBox,{prepend:"Name","aria-label":f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel",{defaultMessage:"Select a Saved Object"}),placeholder:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel",{defaultMessage:"Select a Saved Object"}),fullWidth:!0,options:o,singleSelection:{asPlainText:!0},selectedOptions:d,isLoading:"loading"===i,onChange:e=>{e.length?t(e[0].value):t(void 0)}})},_i=async()=>{var e,t;const a=`${M.mm}.is_preconfigured:true`,s=await(0,u.cnO)({kuery:a,perPage:100,full:!0});if(s.error)throw new Error(s.error.message);return null!==(e=null===(t=s.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[]},Li=async()=>{var e,t;const a=await(0,u.W1E)();if(a.error)throw new Error(a.error.message);return null!==(e=null===(t=a.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[]},Di=new x.QueryClient,Oi=[{title:f.i18n.translate("xpack.fleet.debug.HealthCheckStatus.title",{defaultMessage:"Health Check Status"}),id:"healthCheckStatus",component:(0,R.jsx)((()=>{var e;const[t,a]=(0,s.useState)(),{data:l}=(0,u.OVZ)(),i=(0,s.useMemo)((()=>{var e;return null!==(e=null==l?void 0:l.items)&&void 0!==e?e:[]}),[null==l?void 0:l.items]);(0,s.useEffect)((()=>{const e=i.find((e=>!0===e.is_default));e&&a(e)}),[i]);const o=(0,s.useMemo)((()=>(null==t?void 0:t.id)||""),[null==t?void 0:t.id]),[r,d]=(0,s.useState)(),[c,p]=(0,s.useState)(),{data:h}=(0,x.useQuery)(["fleetServerHealth",o],(()=>(0,u.RUT)({id:o})),{refetchInterval:1e4,enabled:!!o});(0,s.useEffect)((()=>{d(null==h?void 0:h.data),null!=h&&h.error&&p(h.error)}),[h]);const E=(0,s.useMemo)((()=>[...i.map((e=>({inputDisplay:`${e.name} (${e.host_urls[0]})`,value:e.id})))]),[i]);return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.description",defaultMessage:"Select the host used to enroll Fleet Server. The connection is refreshed every {interval}s.",values:{interval:10}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,R.jsx)(g.EuiSuperSelect,{fullWidth:!0,"data-test-subj":"fleetDebug.fleetServerHostsSelect","aria-label":f.i18n.translate("xpack.fleet.debug.healthCheckPanel.fleetServerHostsSelectAriaLabel",{defaultMessage:"Fleet Server hosts"}),prepend:(0,R.jsx)(g.EuiText,{size:"relative",color:""},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.fleetServerHostsLabel",defaultMessage:"Fleet Server Hosts"})),onChange:e=>{d(void 0),a(i.find((t=>t.id===e)))},valueOfSelected:null==t?void 0:t.id,options:E})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},null!=r&&r.status&&o===(null==r?void 0:r.host_id)?(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center"},(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.status",defaultMessage:"Status:"})),(0,R.jsx)(g.EuiFlexItem,null,(e=>{if(!e)return null;let t;switch(e){case"HEALTHY":t="success";break;case"UNHEALTHY":t="warning";break;default:t="subdued"}return(0,R.jsx)(g.EuiHealth,{color:t},e)})(null==r?void 0:r.status))):null)),c&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},null!==(e=null==c?void 0:c.message)&&void 0!==e?e:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.fetchError",defaultMessage:"Message: {errorMessage}",values:{errorMessage:null==c?void 0:c.message}}))))}),null)},{title:f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.title",{defaultMessage:"Agent Policy Debugger"}),id:"agentPolicyDebugger",component:(0,R.jsx)((()=>{var e,t;const{getHref:a}=(0,u.iEg)(),[l,i]=(0,s.useState)(),{data:o,status:r}=(0,x.useQuery)(["debug-agent-policies"],wi),d=null!==(e=null==o||null===(t=o.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[],c=d.map((e=>({label:`${e.name} - ${e.id}`,value:e.id}))),p=l?[c.find((e=>e.value===l))]:[],h=d.find((e=>e.id===l)),E=()=>{i(void 0),Di.invalidateQueries(["debug-agent-policies"])};return"error"===r?(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.fetchError",defaultMessage:"Error fetching Agent Policies"})):(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.description",defaultMessage:"Search for an Agent Policy using its name or {codeId} value. Use the code block below to diagnose any potential issues with the policy's configuration.",values:{codeId:(0,R.jsx)(g.EuiCode,null,"id")}}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,R.jsx)(g.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.selectLabel",{defaultMessage:"Select an Agent Policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.selectLabel",{defaultMessage:"Select an Agent Policy"}),fullWidth:!0,options:c,singleSelection:{asPlainText:!0},selectedOptions:p,isLoading:"loading"===r,onChange:e=>{e.length?i(e[0].value):i(void 0)}})),l&&(0,R.jsx)(C.wq,{agentPolicy:h,hasFleetServer:(0,z.ob)(h)},(e=>(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"danger",onClick:()=>e(l,E)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.policyForm.deletePolicyActionText",defaultMessage:"Delete policy"}))))))),l&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiLink,{target:"_blank",href:a("policy_details",{policyId:l})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.viewAgentPolicyLink",defaultMessage:"View Agent Policy in Fleet UI"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ti,{value:JSON.stringify(h,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.title",{defaultMessage:"Integration Debugger"}),id:"integrationDebugger",component:(0,R.jsx)((()=>{var e,t,a,l,i;const{http:o,notifications:r}=(0,u.WeA)(),{getHref:d}=(0,u.iEg)(),[c,p]=(0,s.useState)(),[h,E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(!1),v=(0,x.useQuery)(["debug-integrations"],Ai),j=(0,g.useGeneratedHtmlId)(),b=(0,x.useMutation)((async e=>{const t=await(0,u.Jip)({pkgName:e.name,pkgVersion:e.version},{force:!0});if(t.error)throw r.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.uninstall.error",{defaultMessage:"Error uninstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:t.error.message}),k(!1),new Error(t.error.message);return r.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.integrationDebugger.uninstall.success",{defaultMessage:"Successfully uninstalled {integrationTitle}",values:{integrationTitle:e.title}})),p(void 0),k(!1),Di.invalidateQueries(["debug-integrations"]),t.data})),S=(0,x.useMutation)((async e=>{const t=await(0,u.Jip)({pkgName:e.name,pkgVersion:e.version},{force:!0});if(t.error)throw r.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.error",{defaultMessage:"Error reinstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:t.error.message}),E(!1),new Error(t.error.message);const a=await(0,u.Q8y)(e.name,e.version);if(a.error)throw r.toasts.addError(new Error(a.error.message),{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.error",{defaultMessage:"Error reinstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:a.error.message}),E(!1),new Error(a.error.message);return r.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.success",{defaultMessage:"Successfully reinstalled {integrationTitle}",values:{integrationTitle:e.title}})),p(void 0),E(!1),Di.invalidateQueries(["debug-integrations"]),a.data}));if("error"===v.status)return(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.fetchError",defaultMessage:"Error fetching installed Integrations"}));const F=null!==(e=null===(t=v.data)||void 0===t?void 0:t.map((e=>({label:e.name,value:e.id,icon:(0,Ci.d)(e,o.basePath)}))))&&void 0!==e?e:[],M=c?[F.find((e=>e.value===c))]:[],I=null===(a=v.data)||void 0===a?void 0:a.find((e=>e.id===c));return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.description",defaultMessage:"Use this tool to uninstall or reinstall installed integrations."})),(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.reinstallationDescription",defaultMessage:"Reinstalling an integration will uninstall and then immediately install it again. This can be useful in restoring broken or malformed integration installations when a user hasn't done much customization."}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,R.jsx)(g.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.integrationDebugger.selectLabel",{defaultMessage:"Select an Integration"}),placeholder:f.i18n.translate("xpack.fleet.debug.integrationDebugger.selectLabel",{defaultMessage:"Select an Integration"}),fullWidth:!0,options:F,singleSelection:{asPlainText:!0},selectedOptions:M,isDisabled:"loading"===v.status,prepend:M.length>0?(0,R.jsx)(g.EuiButtonEmpty,null,(0,R.jsx)(g.EuiIcon,{type:null!==(l=null===(i=M[0])||void 0===i?void 0:i.icon)&&void 0!==l?l:"fleetApp"})):void 0,renderOption:(e,t,a)=>(0,R.jsx)("span",{className:a},(0,R.jsx)(g.EuiIcon,{type:e.icon})," ",(0,R.jsx)(g.EuiHighlight,{search:t},e.label)),onChange:e=>{e.length?p(e[0].value):p(void 0)}})),I&&(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{color:"primary",onClick:()=>E(!0)},"Reinstall")),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)(g.EuiButton,{color:"danger",onClick:()=>k(!0)},"Uninstall")),h&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":j,title:`Reinstall ${I.title}`,titleProps:{id:j},onCancel:()=>E(!1),onConfirm:()=>S.mutate(I),isLoading:S.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.cancelReinstall",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.confirmReinstall",{defaultMessage:"Reinstall"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.reinstallModal",defaultMessage:"Are you sure you want to reinstall {integrationTitle}?",values:{integrationTitle:I.title}})),y&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":j,title:`Uninstall ${I.title}`,titleProps:{id:j},onCancel:()=>k(!1),onConfirm:()=>b.mutate(I),isLoading:b.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.cancelUninstall",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.confirmUninstall",{defaultMessage:"Uninstall"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.uninstallModal",defaultMessage:"Are you sure you want to uninstall {integrationTitle}?",values:{integrationTitle:I.title}})))),I&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiLink,{target:"_blank",href:d("integration_details_overview",{pkgkey:(0,z.Ku)({name:I.name,version:I.version})})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.viewIntegrationLink",defaultMessage:"View integration settings in Integrations UI"}))))}),null)},{title:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.title",{defaultMessage:"Saved Object Debugger"}),id:"savedObjectDebugger",component:(0,R.jsx)((()=>{const e=[{value:`${te.mm9}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.agentPolicyLabel",{defaultMessage:"Agent policy"})},{value:`${te.RNf}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.packagePolicyLabel",{defaultMessage:"Integration policy"})},{value:`${te.Lmx}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.outputLabel",{defaultMessage:"Output"})},{value:`${te.fAG}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.packageLabel",{defaultMessage:"Packages"})},{value:`${te.y_r}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.downloadSourceLabel",{defaultMessage:"Download Sources"})},{value:`${te.twQ}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.fleetServerHostLabel",{defaultMessage:"Fleet Server Hosts"})}],[t,a]=(0,s.useState)(e[0].value),[l,i]=(0,s.useState)(),[o,r]=(0,s.useState)(),{data:d,status:c}=(0,x.useQuery)(["debug-saved-objects",t,l],(()=>(async(e,t)=>{var a;if(!e||!t)return[];const s=await(0,u.w$b)({method:"post",path:T.xw.getSavedObjectsPath(),body:{type:e,name:t},version:te.BoD.internal.v1});if(s.error)throw new Error(s.error.message);return null===(a=s.data)||void 0===a?void 0:a.saved_objects})(t,l)));return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.savedObjectDebugger.description",defaultMessage:"Search for Fleet-related saved objects by selecting a type and name. Use the code block below to diagnose any potential issues."}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 300px;\n          "},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiSelect,{prepend:"Type",id:"soType",options:e,value:t,onChange:e=>(e=>{a(e.target.value),i(void 0)})(e),"aria-label":f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectTypeLabel",{defaultMessage:"Select saved object type"})}))),(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(Pi,{name:l,setName:i,type:t,setNamesStatus:r})))),d&&("error"===c||"error"===o)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.savedObjectDebugger.fetchError",defaultMessage:"Error fetching Saved Objects"}))),(d||"loading"===c)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ti,{value:JSON.stringify(d,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.title",{defaultMessage:"Fleet Index Debugger"}),id:"fleetIndexDebugger",component:(0,R.jsx)((()=>{var e,t,a,l;const i=[{label:be.AGENTS_INDEX,value:be.AGENTS_INDEX},{label:be.AGENT_ACTIONS_INDEX,value:be.AGENT_ACTIONS_INDEX},{label:M.Al,value:M.Al}],[o,r]=(0,s.useState)(),{data:d,status:c}=(0,x.useQuery)(["debug-indices",o],(()=>(async e=>e?await(0,u.w$b)({method:"post",path:T.xw.getIndexPath(),body:{index:e},version:be.API_VERSIONS.internal.v1}):null)(o)),{retry:!1}),p=o?[i.find((e=>e.value===o))]:[];return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.fleetIndexDebugger.description",defaultMessage:"Search for the contents of Fleet indices. Use the code block below to diagnose any potential issues. "}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,null,(0,R.jsx)(g.EuiFormRow,null,(0,R.jsx)(g.EuiComboBox,{prepend:"Index","aria-label":f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.selectLabel",{defaultMessage:"Select an index"}),placeholder:f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.selectLabel",{defaultMessage:"Select an index"}),fullWidth:!0,options:i,singleSelection:{asPlainText:!0},selectedOptions:p,isLoading:"loading"===c,onChange:e=>{e.length?r(e[0].value):r(void 0)}})))),(null==d?void 0:d.error)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{title:"Error",color:"danger"},null!==(e=null==d||null===(t=d.error)||void 0===t||null===(a=t.error)||void 0===a?void 0:a.reason)&&void 0!==e?e:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.fleetIndexDebugger.fetchError",defaultMessage:"Error fetching index data"}))),d&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ti,{value:JSON.stringify(null===(l=d.data)||void 0===l?void 0:l.hits,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.title",{defaultMessage:"Preconfiguration Debugger"}),id:"preconfigurationDebugger",component:(0,R.jsx)((()=>{var e,t,a,l;const{getHref:i}=(0,u.iEg)(),{notifications:o}=(0,u.WeA)(),[r,d]=(0,s.useState)(),[c,p]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!1),y=(0,x.useQuery)(["debug-preconfigured-policies"],_i),k=null!==(e=null===(t=y.data)||void 0===t?void 0:t.map((e=>({label:e.name,value:e.id}))))&&void 0!==e?e:[],v=r?[k.find((({value:e})=>e===r))]:[],j=null===(a=y.data)||void 0===a?void 0:a.find((e=>e.id===r)),b=(0,x.useMutation)((async e=>{const t=await(0,u.W$e)(e);if(t.error)throw o.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetError",{defaultMessage:"Error resetting policy"}),toastMessage:t.error.message}),new Error(t.error.message);return o.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetSuccess",{defaultMessage:"Successfully reset policy"})),Di.invalidateQueries(["debug-preconfigured-policies"]),d(void 0),p(!1),t.data})),S=(0,x.useMutation)((async()=>{const e=await(0,u.Vg9)();if(e.error)throw o.toasts.addError(e.error,{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllError",{defaultMessage:"Error resetting policies"}),toastMessage:e.error.message}),new Error(e.error.message);return o.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllSuccess",{defaultMessage:"Successfully reset policies"})),Di.invalidateQueries(["debug-preconfigured-policies"]),d(void 0),E(!1),e.data})),F=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.description",defaultMessage:"This tool can be used to reset preconfigured policies that are managed via {codeKibanaYml}. This includes Fleet's default policies that may exist in cloud environments.",values:{codeKibanaYml:(0,R.jsx)(g.EuiCode,null,"kibana.yml")}})),(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetInstructions",defaultMessage:'You may reset a single preconfigured policy or use the "Reset all" button to reset all preconfigured policies at once.'}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,R.jsx)(g.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.selectLabel",{defaultMessage:"Select a preconfigured policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.selectLabel",{defaultMessage:"Select a preconfigured policy"}),fullWidth:!0,options:k,singleSelection:{asPlainText:!0},selectedOptions:v,onChange:e=>{e.length?d(e[0].value):d(void 0)}})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"warning",isDisabled:!r,onClick:()=>p(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetButton",defaultMessage:"Reset"})))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"danger",isDisabled:!(null!==(l=y.data)&&void 0!==l&&l.length),onClick:()=>E(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetAllButton",defaultMessage:"Reset all"}))))),c&&j&&r&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":F,title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalTitle",{defaultMessage:"Reset {policyName}",values:{policyName:j.name}}),titleProps:{id:F},onCancel:()=>p(!1),onConfirm:()=>b.mutate(r),isLoading:b.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalCancel",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalConfirm",{defaultMessage:"Reset"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetModalBody",defaultMessage:"Are you sure you want to reset {policyName}?",values:{policyName:j.name}})),h&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":F,title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalTitle",{defaultMessage:"Reset all preconfigured policies"}),titleProps:{id:F},onCancel:()=>E(!1),onConfirm:()=>S.mutate(),isLoading:S.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalCancel",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalConfirm",{defaultMessage:"Reset all"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetAllModalBody",defaultMessage:"Are you sure you want to reset all preconfigured policies?"})),r&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiLink,{target:"_blank",href:i("policy_details",{policyId:r})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.viewAgentPolicyLink",defaultMessage:"View Agent Policy in Fleet UI"})),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ti,{value:JSON.stringify(j,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.title",{defaultMessage:"Orphaned Integration Policy Debugger"}),id:"orphanedIntegrationPolicyDebugger",component:(0,R.jsx)((()=>{var e;const{notifications:t}=(0,u.WeA)(),[a,l]=(0,s.useState)(),[i,o]=(0,s.useState)(!1),[r,d]=(0,s.useState)(!1),{data:c}=(0,x.useQuery)(["debug-orphaned-policies"],Li),p=null!==(e=null==c?void 0:c.map((e=>({label:e.name,value:e.id}))))&&void 0!==e?e:[],h=a?[p.find((({value:e})=>e===a))]:[],E=null==c?void 0:c.find((e=>e.id===a)),y=(0,x.useMutation)((async e=>{const a=await(0,u.Ot1)({packagePolicyIds:[e],force:!0});if(a.error)throw t.toasts.addError(a.error,{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteError",{defaultMessage:"Error deleting policy"}),toastMessage:a.error.message}),new Error(a.error.message);return t.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteSuccess",{defaultMessage:"Successfully deleted orphaned policy"})),Di.invalidateQueries(["debug-orphaned-policies"]),l(void 0),o(!1),a.data})),k=(0,x.useMutation)((async()=>{const e=await(0,u.Ot1)({packagePolicyIds:null==c?void 0:c.map((e=>e.id)),force:!0});if(e.error)throw t.toasts.addError(e.error,{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllError",{defaultMessage:"Error deleting orphaned policies"}),toastMessage:e.error.message}),new Error(e.error.message);return t.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllSuccess",{defaultMessage:"Successfully deleted all orphaned policies"})),Di.invalidateQueries(["debug-orphaned-policies"]),l(void 0),d(!1),e.data})),v=(0,g.useGeneratedHtmlId)();return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.description",defaultMessage:'This tool can be used to delete "orphaned" integration policies that have been unlinked from their parent agent policy objects'})),(0,R.jsx)("p",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteOptions",defaultMessage:'You may delete a single orphaned integration policy or use the "Delete all" button to delete all orphaned integration policies at once.'}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiFlexGroup,null,(0,R.jsx)(g.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,R.jsx)(g.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel",{defaultMessage:"Select an orphaned integration policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel",{defaultMessage:"Select an orphaned integration policy"}),fullWidth:!0,options:p,singleSelection:{asPlainText:!0},selectedOptions:h,onChange:e=>{e.length?l(e[0].value):l(void 0)}})),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"warning",isDisabled:!a,onClick:()=>o(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteButton",defaultMessage:"Delete"})))),(0,R.jsx)(g.EuiFlexItem,{grow:!1},(0,R.jsx)("div",null,(0,R.jsx)(g.EuiButton,{color:"danger",isDisabled:!(null!=c&&c.length),onClick:()=>d(!0)},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllButton",defaultMessage:"Delete all"}))))),i&&E&&a&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":v,title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalTitle",{defaultMessage:"Delete {policyName}",values:{policyName:E.name}}),titleProps:{id:v},onCancel:()=>o(!1),onConfirm:()=>y.mutate(a),isLoading:y.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDelete",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDelete",{defaultMessage:"Delete"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalBody",defaultMessage:"Are you sure you want to delete {policyName}?",values:{policyName:E.name}})),r&&(0,R.jsx)(g.EuiConfirmModal,{"aria-labelledby":v,title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalTitle",{defaultMessage:"Delete all orphaned integration policies"}),titleProps:{id:v},onCancel:()=>d(!1),onConfirm:()=>k.mutate(),isLoading:k.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDeleteAll",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDeleteAll",{defaultMessage:"Delete all"})},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalBody",defaultMessage:"Are you sure you want to delete all orphaned integration policies?"})),a&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(Ti,{value:JSON.stringify(E,null,2)})))}),null)}],Ri=({isInitialized:e,setupError:t})=>{const{chrome:a}=(0,u.WeA)(),{getHref:s}=(0,u.iEg)();return a.docTitle.change(["Debug","Fleet"]),(0,R.jsx)(x.QueryClientProvider,{client:Di},(0,R.jsx)(g.EuiPage,{paddingSize:"xl"},(0,R.jsx)(g.EuiPageBody,{panelled:!0},(0,R.jsx)(g.EuiPageSection,null,(0,R.jsx)(g.EuiPageHeader,{pageTitle:f.i18n.translate("xpack.fleet.debug.pageTitle",{defaultMessage:"Fleet Debugging Dashboard"}),iconType:"wrench"}),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiCallOut,{color:"danger",iconType:"warning",title:"Danger zone"},(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.description",defaultMessage:"This page provides an interface for directly managing Fleet's underlying data and diagnosing issues. Be aware that these debugging tools can be {strongDestructive} in nature and can result in {strongLossOfData}. Please proceed with caution.",values:{strongDestructive:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.destructive",defaultMessage:"destructive"})),strongLossOfData:(0,R.jsx)("strong",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.lossOfData",defaultMessage:"loss of data"}))}}))),!e&&(null==t?void 0:t.message)&&(0,R.jsx)(n().Fragment,null,(0,R.jsx)(g.EuiSpacer,{size:"s"}),(0,R.jsx)(g.EuiCallOut,{color:"danger",iconType:"warning",title:"Setup error"},(0,R.jsx)(g.EuiText,{grow:!1},(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.initializationError.description",defaultMessage:"{message}. You can use this page to debug the error.",values:{message:null==t?void 0:t.message}}))))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiPageSection,null,Oi.map((({title:e,id:t,component:a})=>(0,R.jsx)("div",{key:t},(0,R.jsx)(g.EuiAccordion,{id:t,initialIsOpen:!0,buttonContent:(0,R.jsx)(g.EuiTitle,{size:"l"},(0,R.jsx)("h2",null,e))},(0,R.jsx)(g.EuiSpacer,{size:"m"}),a),(0,R.jsx)(g.EuiHorizontalRule,null)))),(0,R.jsx)(g.EuiTitle,{size:"l"},(0,R.jsx)("h2",null,(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.debug.usefulLinks.title",defaultMessage:"Useful links"}))),(0,R.jsx)(g.EuiSpacer,{size:"m"}),(0,R.jsx)(g.EuiListGroup,{listItems:[{label:f.i18n.translate("xpack.fleet.debug.usefulLinks.viewAgents",{defaultMessage:"View Agents in Fleet UI"}),href:s("agent_list"),iconType:"agentApp",target:"_blank"},{label:f.i18n.translate("xpack.fleet.debug.usefulLinks.troubleshootingGuide",{defaultMessage:"Troubleshooting Guide"}),href:"https://www.elastic.co/guide/en/fleet/current/fleet-troubleshooting.html",iconType:"popout",target:"_blank"}]})))),(0,R.jsx)(h.ReactQueryDevtools,{initialIsOpen:!1}))},Bi=new x.QueryClient({defaultOptions:{queries:{networkMode:"always"},mutations:{networkMode:"always"}}}),zi=(0,s.memo)((({children:e})=>{(0,u.ifo)("base");const t=(0,u.WeA)(),{notifications:a}=t,l=(0,u.iO7)(),i=l.fleet.readEnrollmentTokens||l.fleet.readAgents||l.fleet.readAgentPolicies||l.fleet.readSettings,r=l.integrations.all,[d,c]=(0,s.useState)(!1),[g,p]=(0,s.useState)(),[x,h]=(0,s.useState)(!1),[E,y]=(0,s.useState)(null),k=!!(0,o.useRouteMatch)(M.X5.add_integration_to_policy),v=!!(0,o.useRouteMatch)(M.X5.debug);return(0,s.useEffect)((()=>{(async()=>{c(!1),p(void 0),h(!1),y(null);try{var e;c(!0);const l=await(0,u.nXS)();if(c(!1),null!==(e=l.data)&&void 0!==e&&e.success){try{var t,s;const e=await(0,u.i0)();e.error&&y(e.error),null!==(t=e.data)&&void 0!==t&&null!==(s=t.nonFatalErrors)&&void 0!==s&&s.length&&a.toasts.addError(e.data.nonFatalErrors[0],{title:f.i18n.translate("xpack.fleet.setup.uiPreconfigurationErrorTitle",{defaultMessage:"Configuration error"})}),i||p("MISSING_PRIVILEGES"),!r&&k&&p("MISSING_PRIVILEGES")}catch(e){y(e)}h(!0)}else{var n;p((null===(n=l.data)||void 0===n?void 0:n.error)||"REQUEST_ERROR")}}catch(e){p("REQUEST_ERROR")}})()}),[a.toasts,i,r,k]),d||g?(0,R.jsx)(S.x,{isAddIntegrationsPath:k},d?(0,R.jsx)(F.Rh,null):(0,R.jsx)(S.L,{callingApplication:"Fleet",error:g})):v?(0,R.jsx)(Ri,{setupError:E,isInitialized:x}):!x||E?(0,R.jsx)(S.x,{isAddIntegrationsPath:k},E?(0,R.jsx)(F.$D,{title:(0,R.jsx)(m.FormattedMessage,{id:"xpack.fleet.initializationErrorMessageTitle",defaultMessage:"Unable to initialize Fleet"}),error:E}):(0,R.jsx)(F.uq,null)):(0,R.jsx)(n().Fragment,null,e)})),Ni=(0,s.memo)((({children:e,startServices:t,config:a,history:s,kibanaVersion:n,extensions:l,routerHistory:i,fleetStatus:o})=>{const g=(0,c.A)(t.theme.theme$,t.theme.getTheme()).darkMode;return(0,R.jsx)(p.KibanaRenderContextProvider,(0,d.default)({},t,{theme:t.theme,modify:{breakpoint:{xxl:1600}}}),(0,R.jsx)(k.V,{coreStart:{application:t.application}},(0,R.jsx)(y.KibanaContextProvider,{services:{...t}},(0,R.jsx)(u.QOw.Provider,{value:a},(0,R.jsx)(u.g4O.Provider,{value:n},(0,R.jsx)(v.EuiThemeProvider,{darkMode:g},(0,R.jsx)(x.QueryClientProvider,{client:Bi},(0,R.jsx)(h.ReactQueryDevtools,{initialIsOpen:!1}),(0,R.jsx)(u.K8T.Provider,{value:l},(0,R.jsx)(u.aOH,{defaultFleetStatus:o},(0,R.jsx)(b.M,null,(0,R.jsx)(r.Router,{history:s},(0,R.jsx)(j.hn1,{startServices:t},(0,R.jsx)(u.iGT,null,e)))))))))))))})),Ui=(0,s.memo)((({setHeaderActionMenu:e,isReadOnly:t})=>{const a=(0,u.WeA)(),{euiTheme:s}=(0,g.useEuiTheme)(),l=n().useMemo((()=>(0,E.css)("color:",s.colors.textParagraph,";","")),[s]),{TopNavMenu:i}=a.navigation.ui,o=[];return t&&o.push({label:f.i18n.translate("xpack.fleet.appNavigation.readOnlyBtn",{defaultMessage:"Read-only"}),disableButton:!0,className:l,iconType:"glasses",tooltip:f.i18n.translate("xpack.fleet.appNavigation.readOnlyTooltip",{defaultMessage:"You can view most Fleet settings, but your current privileges don't allow you to perform all actions."}),run:()=>{}}),o.push({label:f.i18n.translate("xpack.fleet.appNavigation.giveFeedbackButton",{defaultMessage:"Give feedback"}),iconType:"popout",run:()=>window.open("https://ela.st/fleet-feedback")}),(0,R.jsx)(i,{appName:f.i18n.translate("xpack.fleet.appTitle",{defaultMessage:"Fleet"}),config:o,setMenuMountPoint:e})})),Hi=({children:e,setHeaderActionMenu:t,isReadOnly:a})=>(0,R.jsx)(n().Fragment,null,(0,R.jsx)(Ui,{setHeaderActionMenu:t,isReadOnly:a}),e),Wi=(0,s.memo)((({setHeaderActionMenu:e})=>{var t;const a=(0,u.Wdf)(),s=(0,u.YI3)(),l=(0,u.iO7)();return(0,R.jsx)(n().Fragment,null,(0,R.jsx)(r.Routes,null,(0,R.jsx)(r.Route,{path:M.X5.agents,key:M.X5.agents},l.fleet.readAgents?(0,R.jsx)(Hi,{setHeaderActionMenu:e,isReadOnly:!l.fleet.allAgents},(0,R.jsx)(ts,null)):(0,R.jsx)(Hi,{setHeaderActionMenu:e},(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents Read"})))),(0,R.jsx)(r.Route,{path:M.X5.policies},l.fleet.readAgentPolicies?(0,R.jsx)(Hi,{setHeaderActionMenu:e,isReadOnly:!l.fleet.allAgentPolicies},(0,R.jsx)(he,null)):(0,R.jsx)(Hi,{setHeaderActionMenu:e},(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Agent policies Read"})))),(0,R.jsx)(r.Route,{path:M.X5.enrollment_tokens},l.fleet.allAgents?(0,R.jsx)(Hi,{setHeaderActionMenu:e},(0,R.jsx)(pn,null)):(0,R.jsx)(Hi,{setHeaderActionMenu:e},(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents All"})))),(0,R.jsx)(r.Route,{path:M.X5.uninstall_tokens},l.fleet.allAgents?(0,R.jsx)(Hi,{setHeaderActionMenu:e},(0,R.jsx)(In,null)):(0,R.jsx)(Hi,{setHeaderActionMenu:e},(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents All"})))),(0,R.jsx)(r.Route,{path:M.X5.data_streams},(0,R.jsx)(Hi,{setHeaderActionMenu:e},(0,R.jsx)(ve,null))),(0,R.jsx)(r.Route,{path:M.X5.settings},l.fleet.readSettings?(0,R.jsx)(Hi,{setHeaderActionMenu:e,isReadOnly:!l.fleet.allSettings},(0,R.jsx)(Ii,null)):(0,R.jsx)(S.x,{isAddIntegrationsPath:!1},(0,R.jsx)(Hi,{setHeaderActionMenu:e},(0,R.jsx)(S.L,{callingApplication:"Fleet",error:"MISSING_PRIVILEGES",requiredFleetRole:"Settings Read"})))),(0,R.jsx)(r.Route,{path:M.X5.add_integration_to_policy},(0,R.jsx)(on,null)),(0,R.jsx)(r.Route,{render:({location:e})=>{if(!(""===e.pathname&&e.hash.length>0)){const e=l.fleet.readAgents?M.X5.agents:l.fleet.readAgentPolicies?M.X5.policies:M.X5.settings;return(0,R.jsx)(o.Redirect,{to:e})}const t=e.hash.replace(/^#(\/fleet)?/,"");return(0,R.jsx)(o.Redirect,{to:{...e,pathname:t,hash:void 0}})}})),a.isEnrollmentFlyoutOpen&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.rt,{defaultMode:!s.isReady||null!==(t=s.missingRequirements)&&void 0!==t&&t.includes("fleet_server")?"standalone":"managed",isIntegrationFlow:!0,onClose:()=>a.closeEnrollmentFlyout()})),a.isFleetServerFlyoutOpen&&(0,R.jsx)(g.EuiPortal,null,(0,R.jsx)(F.Jh,{onClose:()=>a.closeFleetServerFlyout()})))})),Gi=({startServices:e,config:t,history:a,kibanaVersion:s,extensions:n,setHeaderActionMenu:l})=>(0,R.jsx)(Ni,{startServices:e,config:t,history:a,kibanaVersion:s,extensions:n},(0,R.jsx)(zi,null,(0,R.jsx)(Wi,{setHeaderActionMenu:l})));function Ki(e,{element:t,history:a,setHeaderActionMenu:s},n,l,o){return i().render((0,R.jsx)(Gi,{startServices:e,config:n,history:a,kibanaVersion:l,extensions:o,setHeaderActionMenu:s}),t),()=>{i().unmountComponentAtNode(t)}}const qi=e=>{e.chrome.docTitle.reset(),e.chrome.setBreadcrumbs([]),u.Fjq.stop()}}}]);