"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetTagsResponseSchema = exports.GetTagsRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _filter_utils = require("../../routes/utils/filter_utils");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetTagsRequestSchema = exports.GetTagsRequestSchema = {
  query: _configSchema.schema.object({
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: value => {
        const validationObj = (0, _filter_utils.validateKuery)(value, [_constants.AGENTS_PREFIX], _constants.AGENT_MAPPINGS, true);
        if (validationObj !== null && validationObj !== void 0 && validationObj.error) {
          return validationObj === null || validationObj === void 0 ? void 0 : validationObj.error;
        }
      }
    })),
    showInactive: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const GetTagsResponseSchema = exports.GetTagsResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 10000
  })
});